/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.measure.Calibration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DescriptionStringCoder {
    private DescriptionStringCoder() {
    }

    public static String encode(ImagePlus imp) {
        FileInfo fi = imp.getFileInfo();
        StringBuffer sb = new StringBuffer(100);
        sb.append("ImageJ=1.33m\n");
        if (fi.nImages > 1) {
            sb.append("images=" + fi.nImages + "\n");
        }
        if (fi.unit != null) {
            sb.append("unit=" + fi.unit + "\n");
        }
        if (fi.valueUnit != null) {
            sb.append("cf=" + fi.calibrationFunction + "\n");
            if (fi.coefficients != null) {
                for (int i = 0; i < fi.coefficients.length; ++i) {
                    sb.append("c" + i + "=" + fi.coefficients[i] + "\n");
                }
            }
            sb.append("vunit=" + fi.valueUnit + "\n");
        }
        if (fi.nImages > 1) {
            if (fi.pixelDepth != 0.0 && fi.pixelDepth != 1.0) {
                sb.append("spacing=" + fi.pixelDepth + "\n");
            }
            if (fi.frameInterval != 0.0) {
                double fps = 1.0 / fi.frameInterval;
                if ((double)((int)fps) == fps) {
                    sb.append("fps=" + (int)fps + "\n");
                } else {
                    sb.append("fps=" + fps + "\n");
                }
            }
        }
        sb.append("");
        return sb.toString();
    }

    public static void decode(String description, ImagePlus imp) throws Exception {
        Double n_ci;
        int i;
        if (description == null || !description.startsWith("ImageJ")) {
            return;
        }
        Properties props = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(description.getBytes());
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception reading ByteArrayInputStream, this should never happen. Format error?");
        }
        finally {
            ((InputStream)is).close();
        }
        FileInfo fi = new FileInfo();
        fi.unit = props.getProperty("unit", "");
        Integer n_cf = DescriptionStringCoder.getInteger(props, "cf");
        if (n_cf != null) {
            fi.calibrationFunction = n_cf;
        }
        double[] c = new double[5];
        int coefficientsCount = 0;
        for (i = 0; i < 5 && (n_ci = DescriptionStringCoder.getDouble(props, "c" + i)) != null; ++i) {
            c[i] = n_ci;
            ++coefficientsCount;
        }
        if (coefficientsCount >= 2) {
            fi.coefficients = new double[coefficientsCount];
            for (i = 0; i < coefficientsCount; ++i) {
                fi.coefficients[i] = c[i];
            }
        }
        fi.valueUnit = props.getProperty("vunit");
        Calibration calib = imp.getCalibration();
        if (calib == null) {
            calib = new Calibration(imp);
        }
        calib.setFunction(fi.calibrationFunction, fi.coefficients, fi.valueUnit);
        calib.setUnit(fi.unit);
        if (fi.nImages > 1) {
            Double n_fps;
            Double n_spacing = DescriptionStringCoder.getDouble(props, "spacing");
            if (n_spacing != null && n_spacing != 0.0) {
                calib.pixelDepth = n_spacing;
            }
            if ((n_fps = DescriptionStringCoder.getDouble(props, "fps")) != null && n_fps != 0.0) {
                calib.frameInterval = 1.0 / n_fps;
            }
        }
        imp.setCalibration(calib);
    }

    private static Double getDouble(Properties props, String key) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Integer getInteger(Properties props, String key) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

