/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImagePageSelectionDialog
extends JDialog {
    private int numPages = 1;
    private int[] pageIndex = null;
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTextField pageIncrementTF = new JTextField();
    private JTextField lastPageTF = new JTextField();
    private JTextField firstPageTF = new JTextField();
    private JTextField numPagesTF = new JTextField();
    private JPanel panel1 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel pageIncrementLabel = new JLabel();
    private JLabel lastPageLabel = new JLabel();
    private JLabel firstPageLabel = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private JPanel jPanel2 = new JPanel();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();

    public ImagePageSelectionDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle r = this.getBounds();
            r.x = d.width / 2 - r.width / 2;
            r.y = d.height / 2 - r.height / 2;
            this.setBounds(r);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ImagePageSelectionDialog() {
        this((Frame)null, "", true);
    }

    public void setNumPages(int numPages) {
        if (numPages < 1) {
            throw new RuntimeException("Number of pages cannot be less then 1 (got " + numPages + ").");
        }
        this.numPages = numPages;
    }

    public int getNumPages() {
        return this.numPages;
    }

    public int[] getPageIndex() {
        int[] r;
        if (this.pageIndex != null) {
            r = new int[this.pageIndex.length];
            System.arraycopy(this.pageIndex, 0, r, 0, this.pageIndex.length);
        } else {
            r = null;
        }
        return r;
    }

    void jbInit() throws Exception {
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImagePageSelectionDialog.this.okButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImagePageSelectionDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.jLabel1.setText("Number of Pages");
        this.firstPageLabel.setText("First Page");
        this.lastPageLabel.setText("Last Page");
        this.pageIncrementLabel.setText("Page Increment");
        this.panel1.setLayout(this.gridBagLayout1);
        this.numPagesTF.setHorizontalAlignment(0);
        this.numPagesTF.setColumns(5);
        this.numPagesTF.setText("1");
        this.numPagesTF.setEditable(false);
        this.firstPageTF.setText("1");
        this.firstPageTF.setColumns(5);
        this.firstPageTF.setHorizontalAlignment(0);
        this.lastPageTF.setText("1");
        this.lastPageTF.setColumns(5);
        this.lastPageTF.setHorizontalAlignment(0);
        this.pageIncrementTF.setText("1");
        this.pageIncrementTF.setColumns(5);
        this.pageIncrementTF.setHorizontalAlignment(0);
        this.jPanel1.setLayout(this.borderLayout1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ImagePageSelectionDialog.this.this_componentShown(e);
            }
        });
        this.setTitle("Page Selection");
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.panel1.add((Component)this.numPagesTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.firstPageLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.panel1.add((Component)this.firstPageTF, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.lastPageLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.panel1.add((Component)this.lastPageTF, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.pageIncrementLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.panel1.add((Component)this.pageIncrementTF, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.okButton, null);
        this.jPanel2.add((Component)this.cancelButton, null);
    }

    void okButton_actionPerformed(ActionEvent e) {
        int pageIncrement;
        int lastPage;
        int firstPage;
        try {
            firstPage = this.parseInt(this.firstPageTF.getText(), this.firstPageLabel.getText(), 1, this.numPages);
            lastPage = this.parseInt(this.lastPageTF.getText(), this.lastPageLabel.getText(), firstPage, this.numPages);
            pageIncrement = this.parseInt(this.pageIncrementTF.getText(), this.pageIncrementLabel.getText(), 1, this.numPages);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return;
        }
        int indexSize = 1 + (lastPage - firstPage) / pageIncrement;
        if (indexSize < 1) {
            this.pageIndex = null;
        } else {
            if (this.pageIndex == null || this.pageIndex.length != indexSize) {
                this.pageIndex = new int[indexSize];
            }
            for (int i = 0; i < indexSize; ++i) {
                this.pageIndex[i] = firstPage - 1 + i * pageIncrement;
            }
        }
        this.setVisible(false);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.pageIndex = null;
        this.setVisible(false);
    }

    void this_componentShown(ComponentEvent e) {
        this.numPagesTF.setText("" + this.numPages);
        this.firstPageTF.setText("1");
        this.lastPageTF.setText("" + this.numPages);
        this.pageIncrementTF.setText("1");
    }

    private int parseInt(String intString, String name, int min, int max) throws Exception {
        int r;
        try {
            r = Integer.parseInt(intString);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Error parsing " + name + ". Value of '" + intString + "' can not be parsed as integer");
        }
        if (r < min || r > max) {
            throw new Exception("Value of " + name + " cannot be smaller than " + min + " or larger than " + max + " (got " + r + ").");
        }
        return r;
    }
}

