/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class JaiioUtil {
    private JaiioUtil() {
    }

    public static boolean isBinary(ImageProcessor ip) {
        int mapSize;
        ColorModel cm = ip.getColorModel();
        return cm instanceof IndexColorModel && (mapSize = ((IndexColorModel)cm).getMapSize()) == 2;
    }

    public static void centerOnScreen(Window window, boolean packFrame) {
        if (packFrame) {
            window.pack();
        } else {
            window.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = window.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
}

