/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.ij.jaiio.EncoderParamDialog;
import net.sf.ij.jaiio.JAIFileChooserFactory;
import net.sf.ij.jaiio.JAIFileFilter;
import net.sf.ij.jaiio.JAIWriter;
import net.sf.ij.jaiio.JaiioUtil;
import non_com.media.jai.codec.ImageEncodeParam;

public class ImageIOSaveAsPlugin
implements PlugIn {
    public static final String PNG = "png";
    public static final String PNM = "pnm";
    public static final String TIFF = "tiff";
    public static final String JPEG = "jpeg";
    public static final String MACRO_OPTION_FILENAME = "ImageIOSaveAs.fileName";
    public static final String MACRO_OPTION_CODECNAME = "ImageIOSaveAs.codecName";
    private static final String TITLE = "ImageIO Save As";
    private static JFileChooser jaiChooser;
    private EncoderParamDialog paramDialog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String arg) {
        IJ.showStatus((String)"Starting \"ImageIO Save As\" plugin...");
        try {
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp == null) {
                IJ.showMessage((String)TITLE, (String)"No images are open.");
                return;
            }
            String fileName = null;
            String codecName = null;
            ImageEncodeParam encodeParam = null;
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                codecName = Macro.getValue((String)macroOptions, (String)MACRO_OPTION_CODECNAME, null);
                fileName = Macro.getValue((String)macroOptions, (String)MACRO_OPTION_FILENAME, null);
                if (codecName == null) {
                    IJ.showMessage((String)TITLE, (String)"Macro option 'ImageIOSaveAs.codecName' is missing");
                    Macro.abort();
                    return;
                }
                if (fileName == null) {
                    IJ.showMessage((String)TITLE, (String)"Macro option 'ImageIOSaveAs.fileName' is missing");
                    Macro.abort();
                    return;
                }
            } else {
                codecName = arg.equalsIgnoreCase(JPEG) ? JPEG : (arg.equalsIgnoreCase(PNG) ? PNG : (arg.equalsIgnoreCase(PNM) ? PNM : (arg.equalsIgnoreCase(TIFF) ? TIFF : null)));
                if (codecName == null) {
                    if (jaiChooser == null) {
                        jaiChooser = JAIFileChooserFactory.createJAISaveChooser();
                        jaiChooser.setCurrentDirectory(new File(OpenDialog.getDefaultDirectory()));
                    }
                    File file = new File(imp.getTitle());
                    jaiChooser.setSelectedFile(file);
                    if (jaiChooser.showSaveDialog(null) != 0) {
                        Macro.abort();
                        return;
                    }
                    FileFilter fileFilter = jaiChooser.getFileFilter();
                    if (fileFilter instanceof JAIFileFilter) {
                        JAIFileFilter jaiFileFilter = (JAIFileFilter)fileFilter;
                        codecName = jaiFileFilter.getCodecName();
                        Recorder.recordOption((String)MACRO_OPTION_CODECNAME, (String)codecName);
                    }
                    if (codecName == null) {
                        IJ.showMessage((String)TITLE, (String)"File format not selected. File not saved.");
                        Macro.abort();
                        return;
                    }
                    file = jaiChooser.getSelectedFile();
                    if (file.getName().indexOf(".") < 0) {
                        file = new File(file.getParent(), file.getName() + "." + this.getFileExtension(codecName));
                    }
                    fileName = file.getAbsolutePath();
                } else if (fileName == null) {
                    SaveDialog saveDialog = new SaveDialog("Save As " + codecName + "...", imp.getTitle(), "." + this.getFileExtension(codecName));
                    String saveDialogFileName = saveDialog.getFileName();
                    if (saveDialogFileName == null) {
                        Macro.abort();
                        return;
                    }
                    fileName = saveDialog.getDirectory() != null ? saveDialog.getDirectory() + File.separator + saveDialogFileName : saveDialogFileName;
                }
                Recorder.recordOption((String)MACRO_OPTION_CODECNAME, (String)codecName);
                Recorder.recordOption((String)MACRO_OPTION_FILENAME, (String)fileName);
                if (codecName.equalsIgnoreCase(TIFF)) {
                    if (this.paramDialog == null) {
                        this.paramDialog = new EncoderParamDialog();
                    }
                    JaiioUtil.centerOnScreen(this.paramDialog, false);
                    this.paramDialog.show();
                    if (!this.paramDialog.isAccepted()) {
                        Macro.abort();
                        IJ.showMessage((String)TITLE, (String)"Option dialog cancelled, image not saved.");
                        return;
                    }
                    boolean isBinary = imp.getType() != 3 && JaiioUtil.isBinary(imp.getProcessor());
                    encodeParam = this.paramDialog.getImageEncodeParam(isBinary);
                }
            }
            try {
                IJ.showStatus((String)("Writing image as " + codecName.toUpperCase() + " to " + fileName));
                ImageIOSaveAsPlugin.write(imp, fileName, codecName, encodeParam);
            }
            catch (IOException e) {
                e.printStackTrace();
                Macro.abort();
                String msg = "Error writing file: " + fileName + ".\n\n";
                msg = msg + (e.getMessage() == null ? e.toString() : e.getMessage());
                IJ.showMessage((String)TITLE, (String)msg);
            }
        }
        finally {
            IJ.showStatus((String)"");
        }
    }

    private static void write(ImagePlus imp, String fileName, String codecName, ImageEncodeParam encodeParam) throws IOException, FileNotFoundException {
        JAIWriter jaiWriter = new JAIWriter();
        jaiWriter.setFormatName(codecName);
        jaiWriter.setImageEncodeParam(encodeParam);
        jaiWriter.write(fileName, imp);
    }

    private String getFileExtension(String codecName) {
        if (codecName.compareToIgnoreCase(TIFF) == 0) {
            return "tif";
        }
        if (codecName.compareToIgnoreCase(JPEG) == 0) {
            return "jpg";
        }
        return codecName.toLowerCase();
    }
}

