/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.ArrayList;

public class RemoveOldPlugins
implements PlugIn {
    private ArrayList foundComponents;
    private static final String CAPTION = "Uninstall Obsolete JAI ImageIO Plugins";
    private static final String CANCELLED_MESSAGE = "Operation canceled, no changes made to installation.";
    private static final String[] ROOT_FILES = new String[]{"Readme - JAI Image IO.txt", "Changes - JAI Image IO.txt", "ij-jai-imageio.jar", "JAI Image IO"};
    private static final String SUBDIR = "JAI Image IO";
    private static final String[] SUBDIR_FILES = new String[]{"JAI_Reader.class", "JAI_Reader_with_Preview.class", "JAI_Writer.class", "JarClassLoader.class", "JarPluginProxy.class"};

    public void run(String string) {
        String[] list;
        boolean ok = IJ.showMessageWithCancel((String)CAPTION, (String)"This plugin will attempt to find and uninstall obsolete JAI Image IO plugins.\nTo proceed with uninstall press OK.");
        if (!ok) {
            IJ.showMessage((String)CAPTION, (String)CANCELLED_MESSAGE);
            return;
        }
        IJ.showStatus((String)"Searching for obsolete components.");
        this.foundComponents = new ArrayList();
        String pluginsDir = Menus.getPlugInsPath();
        for (int i = 0; i < ROOT_FILES.length; ++i) {
            this.lookFor(pluginsDir, ROOT_FILES[i]);
        }
        File subdir = new File(pluginsDir, SUBDIR);
        if (subdir.exists() && subdir.isDirectory()) {
            for (int i = 0; i < SUBDIR_FILES.length; ++i) {
                this.lookFor(subdir.getPath(), SUBDIR_FILES[i]);
            }
        }
        if (this.foundComponents.size() == 0) {
            IJ.showMessage((String)CAPTION, (String)"Obsolete installation not found.");
            return;
        }
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append("Following files will be uninstalled: \n");
        for (int i = 0; i < this.foundComponents.size(); ++i) {
            File file = (File)this.foundComponents.get(i);
            messageBuffer.append(file.getAbsolutePath() + "\n");
        }
        ok = IJ.showMessageWithCancel((String)CAPTION, (String)messageBuffer.toString());
        if (!ok) {
            IJ.showMessage((String)CAPTION, (String)CANCELLED_MESSAGE);
            return;
        }
        StringBuffer errorBuffer = new StringBuffer();
        for (int i = 0; i < this.foundComponents.size(); ++i) {
            File file = (File)this.foundComponents.get(i);
            if (file.delete()) continue;
            errorBuffer.append(file.getAbsolutePath() + "\n");
        }
        if ((subdir.exists() || subdir.isDirectory()) && (list = subdir.list()) != null && list.length == 0 && !subdir.delete()) {
            errorBuffer.append(subdir.getAbsolutePath() + "\n");
        }
        if (errorBuffer.length() > 0) {
            IJ.showMessage((String)CAPTION, (String)("Unable to uninstall following files:\n" + errorBuffer.toString() + "Restart ImageJ to complete uninstall."));
        } else {
            IJ.showMessage((String)CAPTION, (String)"Uninstall completed successfully.\nPlease restart ImageJ.");
        }
    }

    private void lookFor(String dir, String fileName) {
        File file = new File(dir, fileName);
        if (file.exists() && !file.isDirectory()) {
            this.foundComponents.add(file);
        }
    }
}

