/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import non_com.media.jai.codec.BMPEncodeParam;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoderImpl;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.SeekableOutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream output;
    private int version;
    private boolean isCompressed;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;

    public BMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        this.output = outputStream;
        BMPEncodeParam bMPEncodeParam = imageEncodeParam == null ? new BMPEncodeParam() : (BMPEncodeParam)imageEncodeParam;
        this.version = bMPEncodeParam.getVersion();
        this.isCompressed = bMPEncodeParam.isCompressed();
        if (this.isCompressed && !(outputStream instanceof SeekableOutputStream)) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder6"));
        }
        this.isTopDown = bMPEncodeParam.isTopDown();
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = renderedImage.getMinX();
        int n5 = renderedImage.getMinY();
        this.w = renderedImage.getWidth();
        this.h = renderedImage.getHeight();
        int n6 = 24;
        boolean bl = false;
        int n7 = 0;
        IndexColorModel indexColorModel = null;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n8 = sampleModel.getNumBands();
        ColorModel colorModel = renderedImage.getColorModel();
        if (n8 != 1 && n8 != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder1"));
        }
        int[] nArray = sampleModel.getSampleSize();
        if (nArray[0] > 8) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder2"));
        }
        for (n3 = 1; n3 < nArray.length; ++n3) {
            if (nArray[n3] == nArray[0]) continue;
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder3"));
        }
        n3 = sampleModel.getTransferType();
        if (n3 == 1 || n3 == 2 || n3 == 3 || n3 == 4 || n3 == 5) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder0"));
        }
        int n9 = this.w * n8;
        int n10 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl = true;
            indexColorModel = (IndexColorModel)colorModel;
            n7 = indexColorModel.getMapSize();
            if (n7 <= 2) {
                n6 = 1;
                n9 = (int)Math.ceil((double)this.w / 8.0);
            } else if (n7 <= 16) {
                n6 = 4;
                n9 = (int)Math.ceil((double)this.w / 2.0);
            } else if (n7 <= 256) {
                n6 = 8;
            } else {
                n6 = 24;
                bl = false;
                n7 = 0;
                n9 = this.w * 3;
            }
            if (bl) {
                byArray = new byte[n7];
                byArray2 = new byte[n7];
                byArray3 = new byte[n7];
                byArray4 = new byte[n7];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n8 == 1) {
            bl = true;
            n7 = 256;
            n6 = nArray[0];
            n9 = (int)Math.ceil((double)(this.w * n6) / 8.0);
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            for (n2 = 0; n2 < 256; ++n2) {
                byArray[n2] = (byte)n2;
                byArray2[n2] = (byte)n2;
                byArray3[n2] = (byte)n2;
                byArray4[n2] = (byte)n2;
            }
        }
        n2 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = n7;
        int n18 = 0;
        int n19 = n9 % 4;
        if (n19 != 0) {
            n18 = 4 - n19;
        }
        switch (this.version) {
            case 0: {
                n11 = 26 + n7 * 3;
                n12 = 12;
                n13 = (n9 + n18) * this.h;
                n2 = n13 + n11;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
            case 1: {
                if (this.isCompressed && n6 == 8) {
                    n10 = 1;
                } else if (this.isCompressed && n6 == 4) {
                    n10 = 2;
                }
                n11 = 54 + n7 * 4;
                n13 = (n9 + n18) * this.h;
                n2 = n13 + n11;
                n12 = 40;
                break;
            }
            case 2: {
                n12 = 108;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
        }
        this.writeFileHeader(n2, n11);
        this.writeInfoHeader(n12, n6);
        this.writeDWord(n10);
        this.writeDWord(n13);
        this.writeDWord(n14);
        this.writeDWord(n15);
        this.writeDWord(n16);
        this.writeDWord(n17);
        if (bl) {
            switch (this.version) {
                case 0: {
                    for (n = 0; n < n7; ++n) {
                        this.output.write(byArray3[n]);
                        this.output.write(byArray2[n]);
                        this.output.write(byArray[n]);
                    }
                    break;
                }
                default: {
                    for (n = 0; n < n7; ++n) {
                        this.output.write(byArray3[n]);
                        this.output.write(byArray2[n]);
                        this.output.write(byArray[n]);
                        this.output.write(byArray4[n]);
                    }
                }
            }
        }
        n = this.w * n8;
        int[] nArray2 = new int[8 * n];
        byte[] byArray5 = new byte[n9];
        if (!this.isTopDown) {
            int n20 = n5 + this.h;
            for (int i = n20 - 1; i >= n5; i -= 8) {
                int n21 = Math.min(8, i - n5 + 1);
                Raster raster = renderedImage.getData(new Rectangle(n4, i - n21 + 1, this.w, n21));
                raster.getPixels(n4, i - n21 + 1, this.w, n21, nArray2);
                int n22 = 0;
                int n23 = n * n21 - 1;
                for (int j = 0; j < n21; ++j) {
                    n22 = n23 - (j + 1) * n + 1;
                    this.writePixels(n22, n, n6, nArray2, byArray5, n18, n8, indexColorModel);
                }
            }
        } else {
            int n24 = n5 + this.h;
            for (int i = n5; i < n24; i += 8) {
                int n25 = Math.min(8, n24 - i);
                Raster raster = renderedImage.getData(new Rectangle(n4, i, this.w, n25));
                raster.getPixels(n4, i, this.w, n25, nArray2);
                int n26 = 0;
                for (int j = 0; j < n25; ++j) {
                    this.writePixels(n26, n, n6, nArray2, byArray5, n18, n8, indexColorModel);
                }
            }
        }
        if (this.isCompressed && (n6 == 4 || n6 == 8)) {
            this.output.write(0);
            this.output.write(1);
            this.incCompImageSize(2);
            n13 = this.compImageSize;
            n2 = this.compImageSize + n11;
            this.writeSize(n2, 2);
            this.writeSize(n13, 34);
        }
    }

    public void writeWord(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
    }

    public void writeDWord(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
        this.output.write((n & 0xFF0000) >> 16);
        this.output.write((n & 0xFF000000) >> 24);
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private void writePixels(int n, int n2, int n3, int[] nArray, byte[] byArray, int n4, int n5, IndexColorModel indexColorModel) throws IOException {
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 1: {
                int n8;
                for (n8 = 0; n8 < n2 / 8; ++n8) {
                    byArray[n7++] = (byte)(nArray[n++] << 7 | nArray[n++] << 6 | nArray[n++] << 5 | nArray[n++] << 4 | nArray[n++] << 3 | nArray[n++] << 2 | nArray[n++] << 1 | nArray[n++]);
                }
                if (n2 % 8 > 0) {
                    n6 = 0;
                    for (n8 = 0; n8 < n2 % 8; ++n8) {
                        n6 |= nArray[n++] << 7 - n8;
                    }
                    byArray[n7++] = (byte)n6;
                }
                this.output.write(byArray, 0, (n2 + 7) / 8);
                break;
            }
            case 4: {
                if (this.isCompressed) {
                    byte[] byArray2 = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        byArray2[i] = (byte)nArray[n++];
                    }
                    this.encodeRLE4(byArray2, n2);
                    break;
                }
                for (int i = 0; i < n2 / 2; ++i) {
                    n6 = nArray[n++] << 4 | nArray[n++];
                    byArray[n7++] = (byte)n6;
                }
                if (n2 % 2 == 1) {
                    n6 = nArray[n] << 4;
                    byArray[n7++] = (byte)n6;
                }
                this.output.write(byArray, 0, (n2 + 1) / 2);
                break;
            }
            case 8: {
                if (this.isCompressed) {
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = (byte)nArray[n++];
                    }
                    this.encodeRLE8(byArray, n2);
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    byArray[i] = (byte)nArray[n++];
                }
                this.output.write(byArray, 0, n2);
                break;
            }
            case 24: {
                if (n5 == 3) {
                    for (int i = 0; i < n2; i += 3) {
                        byArray[n7++] = (byte)nArray[n + 2];
                        byArray[n7++] = (byte)nArray[n + 1];
                        byArray[n7++] = (byte)nArray[n];
                        n += 3;
                    }
                    this.output.write(byArray, 0, n2);
                    break;
                }
                int n9 = indexColorModel.getMapSize();
                byte[] byArray3 = new byte[n9];
                byte[] byArray4 = new byte[n9];
                byte[] byArray5 = new byte[n9];
                indexColorModel.getReds(byArray3);
                indexColorModel.getGreens(byArray4);
                indexColorModel.getBlues(byArray5);
                for (int i = 0; i < n2; ++i) {
                    int n10 = nArray[n];
                    byArray[n7++] = byArray5[n10];
                    byArray[n7++] = byArray4[n10];
                    byArray[n7++] = byArray5[n10];
                    ++n;
                }
                this.output.write(byArray, 0, n2 * 3);
            }
        }
        if (!this.isCompressed || n3 != 8 && n3 != 4) {
            for (n7 = 0; n7 < n4; ++n7) {
                this.output.write(0);
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n) throws IOException {
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n4];
        byte[] byArray2 = new byte[256];
        while (n4 < n - 1) {
            int n5;
            if ((by2 = byArray[++n4]) == by) {
                if (n3 >= 3) {
                    this.output.write(0);
                    this.output.write(n3);
                    this.incCompImageSize(2);
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.output.write(byArray2[n5]);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n3)) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.output.write(1);
                        this.output.write(byArray2[n5]);
                        this.incCompImageSize(2);
                    }
                }
                n3 = -1;
                if (++n2 == 256) {
                    this.output.write(n2 - 1);
                    this.output.write(by);
                    this.incCompImageSize(2);
                    n2 = 1;
                }
            } else {
                if (n2 > 1) {
                    this.output.write(n2);
                    this.output.write(by);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                } else if (n3 < 254) {
                    byArray2[++n3] = by2;
                } else {
                    this.output.write(0);
                    this.output.write(n3 + 1);
                    this.incCompImageSize(2);
                    for (n5 = 0; n5 <= n3; ++n5) {
                        this.output.write(byArray2[n5]);
                        this.incCompImageSize(1);
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by2;
                n2 = 1;
            }
            if (n4 != n - 1) continue;
            if (n3 == -1) {
                this.output.write(n2);
                this.output.write(by);
                this.incCompImageSize(2);
                n2 = 1;
            } else if (n3 >= 2) {
                this.output.write(0);
                this.output.write(n3 + 1);
                this.incCompImageSize(2);
                for (n5 = 0; n5 <= n3; ++n5) {
                    this.output.write(byArray2[n5]);
                    this.incCompImageSize(1);
                }
                if (!this.isEven(n3 + 1)) {
                    this.output.write(0);
                    this.incCompImageSize(1);
                }
            } else if (n3 > -1) {
                for (n5 = 0; n5 <= n3; ++n5) {
                    this.output.write(1);
                    this.output.write(byArray2[n5]);
                    this.incCompImageSize(2);
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n) throws IOException {
        int n2 = 2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n4];
        by2 = byArray[++n4];
        while (n4 < n - 2) {
            int n7;
            by3 = byArray[++n4];
            by4 = byArray[++n4];
            if (by3 == by) {
                if (n3 >= 4) {
                    this.output.write(0);
                    this.output.write(n3 - 1);
                    this.incCompImageSize(2);
                    for (n7 = 0; n7 < n3 - 2; n7 += 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.output.write((byte)n5);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n3 - 1)) {
                        n6 = byArray2[n3 - 2] << 4 | 0;
                        this.output.write(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 - 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else if (n3 > -1) {
                    this.output.write(2);
                    n5 = byArray2[0] << 4 | byArray2[1];
                    this.output.write(n5);
                    this.incCompImageSize(2);
                }
                n3 = -1;
                if (by4 == by2) {
                    if ((n2 += 2) == 256) {
                        this.output.write(n2 - 1);
                        n5 = by << 4 | by2;
                        this.output.write(n5);
                        this.incCompImageSize(2);
                        n2 = 2;
                        if (n4 < n - 1) {
                            by = by2;
                            by2 = byArray[++n4];
                        } else {
                            this.output.write(1);
                            n7 = by2 << 4 | 0;
                            this.output.write(n7);
                            this.incCompImageSize(2);
                            n2 = -1;
                        }
                    }
                } else {
                    n5 = by << 4 | by2;
                    this.output.write(++n2);
                    this.output.write(n5);
                    this.incCompImageSize(2);
                    n2 = 2;
                    by = by4;
                    if (n4 < n - 1) {
                        by2 = byArray[++n4];
                    } else {
                        this.output.write(1);
                        n7 = by4 << 4 | 0;
                        this.output.write(n7);
                        this.incCompImageSize(2);
                        n2 = -1;
                    }
                }
            } else {
                if (n2 > 2) {
                    n5 = by << 4 | by2;
                    this.output.write(n2);
                    this.output.write(n5);
                    this.incCompImageSize(2);
                } else if (n3 < 0) {
                    byArray2[++n3] = by;
                    byArray2[++n3] = by2;
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else if (n3 < 253) {
                    byArray2[++n3] = by3;
                    byArray2[++n3] = by4;
                } else {
                    this.output.write(0);
                    this.output.write(n3 + 1);
                    this.incCompImageSize(2);
                    for (n7 = 0; n7 < n3; n7 += 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.output.write((byte)n5);
                        this.incCompImageSize(1);
                    }
                    this.output.write(0);
                    this.incCompImageSize(1);
                    n3 = -1;
                }
                by = by3;
                by2 = by4;
                n2 = 2;
            }
            if (n4 < n - 2) continue;
            if (n3 == -1 && n2 >= 2) {
                if (n4 == n - 2) {
                    if (byArray[++n4] == by) {
                        n5 = by << 4 | by2;
                        this.output.write(++n2);
                        this.output.write(n5);
                        this.incCompImageSize(2);
                    } else {
                        n5 = by << 4 | by2;
                        this.output.write(n2);
                        this.output.write(n5);
                        this.output.write(1);
                        n5 = byArray[n4] << 4 | 0;
                        this.output.write(n5);
                        n7 = byArray[n4] << 4 | 0;
                        this.incCompImageSize(4);
                    }
                } else {
                    this.output.write(n2);
                    n5 = by << 4 | by2;
                    this.output.write(n5);
                    this.incCompImageSize(2);
                }
            } else if (n3 > -1) {
                if (n4 == n - 2) {
                    byArray2[++n3] = byArray[++n4];
                }
                if (n3 >= 2) {
                    this.output.write(0);
                    this.output.write(n3 + 1);
                    this.incCompImageSize(2);
                    for (n7 = 0; n7 < n3; n7 += 2) {
                        n5 = byArray2[n7] << 4 | byArray2[n7 + 1];
                        this.output.write((byte)n5);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n3 + 1)) {
                        n6 = byArray2[n3] << 4 | 0;
                        this.output.write(n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n3 + 1) / 2))) {
                        this.output.write(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n3) {
                        case 0: {
                            this.output.write(1);
                            n7 = byArray2[0] << 4 | 0;
                            this.output.write(n7);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.output.write(2);
                            n5 = byArray2[0] << 4 | byArray2[1];
                            this.output.write(n5);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.output.write(0);
            this.output.write(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n) {
        this.compImageSize += n;
    }

    private void writeFileHeader(int n, int n2) throws IOException {
        this.output.write(66);
        this.output.write(77);
        this.writeDWord(n);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.writeDWord(n2);
    }

    private void writeInfoHeader(int n, int n2) throws IOException {
        this.writeDWord(n);
        this.writeDWord(this.w);
        this.writeDWord(this.h);
        this.writeWord(1);
        this.writeWord(n2);
    }

    private void writeSize(int n, int n2) throws IOException {
        ((SeekableOutputStream)this.output).seek(n2);
        this.writeDWord(n);
    }
}

