/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.SeekableStream;
import non_com.media.jai.codec.TempFileCleanupThread;

public final class FileCacheSeekableStream
extends SeekableStream {
    private static TempFileCleanupThread cleanupThread = null;
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 1024;
    private byte[] buf = new byte[this.bufLen];
    private long length = 0L;
    private long pointer = 0L;
    private boolean foundEOF = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public FileCacheSeekableStream(InputStream inputStream) throws IOException {
        this.stream = inputStream;
        this.cacheFile = File.createTempFile("jai-FCSS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
        if (cleanupThread != null) {
            cleanupThread.addFile(this.cacheFile);
        }
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException(JaiI18N.getString("FileCacheSeekableStream0"));
        }
        this.pointer = l;
    }

    public int read() throws IOException {
        long l = this.pointer + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            this.cache.seek(this.pointer++);
            return this.cache.read();
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)n2);
        if ((n2 = (int)Math.min((long)n2, l - this.pointer)) > 0) {
            this.cache.seek(this.pointer);
            this.cache.readFully(byArray, n, n2);
            this.pointer += (long)n2;
            return n2;
        }
        return -1;
    }

    public void close() throws IOException {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        if (cleanupThread != null) {
            cleanupThread.removeFile(this.cacheFile);
        }
    }

    private long readUntil(long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l2 = l - this.length;
        this.cache.seek(this.length);
        while (l2 > 0L) {
            int n = this.stream.read(this.buf, 0, (int)Math.min(l2, (long)this.bufLen));
            if (n == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n);
            this.cache.write(this.buf, 0, n);
            l2 -= (long)n;
            this.length += (long)n;
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Method method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = FileCacheSeekableStream.class$("java.lang.Runtime")) : class$java$lang$Runtime).getDeclaredMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = FileCacheSeekableStream.class$("java.lang.Thread")) : class$java$lang$Thread);
            cleanupThread = new TempFileCleanupThread();
            method.invoke((Object)Runtime.getRuntime(), cleanupThread);
        }
        catch (Exception exception) {
            cleanupThread = null;
        }
    }
}

