/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.ImageDecodeParam;
import non_com.media.jai.codec.ImageDecoder;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoder;
import non_com.media.jai.codec.PNGDecodeParam;
import non_com.media.jai.codec.PNGEncodeParam;
import non_com.media.jai.codec.PNGImageDecoder;
import non_com.media.jai.codec.PNGImageEncoder;
import non_com.media.jai.codec.SeekableStream;

public final class PNGCodec
extends ImageCodec {
    static /* synthetic */ Class class$non_com$media$jai$codec$PNGEncodeParam;
    static /* synthetic */ Class class$non_com$media$jai$codec$PNGDecodeParam;

    public String getFormatName() {
        return "png";
    }

    public Class getEncodeParamClass() {
        return class$non_com$media$jai$codec$PNGEncodeParam == null ? (class$non_com$media$jai$codec$PNGEncodeParam = PNGCodec.class$("non_com.media.jai.codec.PNGEncodeParam")) : class$non_com$media$jai$codec$PNGEncodeParam;
    }

    public Class getDecodeParamClass() {
        return class$non_com$media$jai$codec$PNGDecodeParam == null ? (class$non_com$media$jai$codec$PNGDecodeParam = PNGCodec.class$("non_com.media.jai.codec.PNGDecodeParam")) : class$non_com$media$jai$codec$PNGDecodeParam;
    }

    public int getNumHeaderBytes() {
        return 8;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        int n;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getTransferType();
        if (n2 == 4 || n2 == 5) {
            return false;
        }
        int[] nArray = sampleModel.getSampleSize();
        int n3 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] == n3) continue;
            return false;
        }
        if (n3 < 1 || n3 > 16) {
            return false;
        }
        n = sampleModel.getNumBands();
        if (n < 1 || n > 4) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel && (n != 1 || n3 > 8)) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (imageEncodeParam instanceof PNGEncodeParam) {
                if (colorModel instanceof IndexColorModel ? !(imageEncodeParam instanceof PNGEncodeParam.Palette) : (n < 3 ? !(imageEncodeParam instanceof PNGEncodeParam.Gray) : !(imageEncodeParam instanceof PNGEncodeParam.RGB))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNGEncodeParam pNGEncodeParam = null;
        if (imageEncodeParam != null) {
            pNGEncodeParam = (PNGEncodeParam)imageEncodeParam;
        }
        return new PNGImageEncoder(outputStream, pNGEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder(inputStream, pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)new FileInputStream(file), pNGDecodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        PNGDecodeParam pNGDecodeParam = null;
        if (imageDecodeParam != null) {
            pNGDecodeParam = (PNGDecodeParam)imageDecodeParam;
        }
        return new PNGImageDecoder((InputStream)seekableStream, pNGDecodeParam);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

