/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.io.IOException;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.SectorStreamSegmentMapper;
import non_com.media.jai.codec.SeekableStream;
import non_com.media.jai.codec.StreamSegment;
import non_com.media.jai.codec.StreamSegmentMapper;
import non_com.media.jai.codec.StreamSegmentMapperImpl;

public class SegmentedSeekableStream
extends SeekableStream {
    private SeekableStream stream;
    private StreamSegmentMapper mapper;
    private long pointer = 0L;
    private boolean canSeekBackwards;
    private StreamSegment streamSegment = new StreamSegment();

    public SegmentedSeekableStream(SeekableStream seekableStream, StreamSegmentMapper streamSegmentMapper, boolean bl) {
        this.stream = seekableStream;
        this.mapper = streamSegmentMapper;
        this.canSeekBackwards = bl;
        if (bl && !seekableStream.canSeekBackwards()) {
            throw new IllegalArgumentException(JaiI18N.getString("SegmentedSeekableStream0"));
        }
    }

    public SegmentedSeekableStream(SeekableStream seekableStream, long[] lArray, int[] nArray, boolean bl) {
        this(seekableStream, new StreamSegmentMapperImpl(lArray, nArray), bl);
    }

    public SegmentedSeekableStream(SeekableStream seekableStream, long[] lArray, int n, int n2, boolean bl) {
        this(seekableStream, new SectorStreamSegmentMapper(lArray, n, n2), bl);
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public boolean canSeekBackwards() {
        return this.canSeekBackwards;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException();
        }
        this.pointer = l;
    }

    public int read() throws IOException {
        this.mapper.getStreamSegment(this.pointer, 1, this.streamSegment);
        this.stream.seek(this.streamSegment.getStartPos());
        int n = this.stream.read();
        ++this.pointer;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.mapper.getStreamSegment(this.pointer, n2, this.streamSegment);
        this.stream.seek(this.streamSegment.getStartPos());
        int n3 = this.stream.read(byArray, n, this.streamSegment.getSegmentLength());
        this.pointer += (long)n3;
        return n3;
    }
}

