/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import non_com.media.jai.codec.ByteArraySeekableStream;
import non_com.media.jai.codec.FPXUtils;
import non_com.media.jai.codec.FileSeekableStream;
import non_com.media.jai.codec.PropertySet;
import non_com.media.jai.codec.SSDirectoryEntry;
import non_com.media.jai.codec.SeekableStream;
import non_com.media.jai.codec.SegmentedSeekableStream;

public class StructuredStorage {
    private static final long FAT_ENDOFCHAIN = 0xFFFFFFFEL;
    private static final long FAT_FREESECT = 0xFFFFFFFFL;
    SeekableStream file;
    long cwdIndex = -1L;
    private int sectorShift;
    private int miniSectorShift;
    private long csectFat;
    private long sectDirStart;
    private long miniSectorCutoff;
    private long sectMiniFatStart;
    private long csectMiniFat;
    private long sectDifStart;
    private long csectDif;
    private long[] sectFat;
    private long[] MINIFAT;
    private SSDirectoryEntry[] DIR;
    private SeekableStream miniStream;
    private SeekableStream FATStream;

    public StructuredStorage(SeekableStream seekableStream) throws IOException {
        this.file = seekableStream;
        this.getHeader();
        this.getFat();
        this.getMiniFat();
        this.getDirectory();
        this.getMiniStream();
    }

    public static void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            FileSeekableStream fileSeekableStream = new FileSeekableStream(randomAccessFile);
            StructuredStorage structuredStorage = new StructuredStorage(fileSeekableStream);
            structuredStorage.changeDirectoryToRoot();
            byte[] byArray = structuredStorage.getStreamAsBytes("\u0005SummaryInformation");
            PropertySet propertySet = new PropertySet(new ByteArraySeekableStream(byArray));
            byte[] byArray2 = propertySet.getBlob(17);
            System.out.print("BM");
            int n = byArray2.length - 8 + 14 + 40;
            System.out.print((char)(n & 0xFF));
            System.out.print((char)(n >> 8 & 0xFF));
            System.out.print((char)(n >> 16 & 0xFF));
            System.out.print((char)(n >> 24 & 0xFF));
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('6');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            for (int i = 8; i < byArray2.length; ++i) {
                System.out.print((char)(byArray2[i] & 0xFF));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] getStreamAsBytes(String string) throws IOException {
        long l = this.getStreamIndex(string);
        if (l == -1L) {
            return null;
        }
        int n = this.getLength(l);
        byte[] byArray = new byte[n];
        if ((long)n > this.miniSectorCutoff) {
            int n2 = this.getSectorSize();
            int n3 = (n + n2 - 1) / n2;
            long l2 = this.getStartSector(l);
            int n4 = 0;
            for (int i = 0; i < n3 - 1; ++i) {
                this.readSector(l2, byArray, n4, n2);
                n4 += n2;
                l2 = this.getFATSector(l2);
                if (l2 == 0xFFFFFFFEL) break;
            }
            this.readSector(l2, byArray, n4, n - n4);
        } else {
            int n5 = this.getMiniSectorSize();
            int n6 = (n + n5 - 1) / n5;
            long l3 = this.getStartSector(l);
            int n7 = 0;
            for (int i = 0; i < n6 - 1; ++i) {
                long l4 = this.getOffsetOfMiniSector(l3);
                this.readMiniSector(l3, byArray, n7, n5);
                n7 += n5;
                l3 = this.getMiniFATSector(l3);
            }
            this.readMiniSector(l3, byArray, n7, n - n7);
        }
        return byArray;
    }

    public SeekableStream getStream(String string) throws IOException {
        long l = this.getStreamIndex(string);
        if (l == -1L) {
            return null;
        }
        int n = this.getLength(l);
        if ((long)n > this.miniSectorCutoff) {
            int n2 = this.getSectorSize();
            int n3 = (n + n2 - 1) / n2;
            long[] lArray = new long[n3];
            long l2 = this.getStartSector(l);
            for (int i = 0; i < n3 - 1; ++i) {
                lArray[i] = this.getOffsetOfSector(l2);
                if ((l2 = this.getFATSector(l2)) == 0xFFFFFFFEL) break;
            }
            lArray[n3 - 1] = this.getOffsetOfSector(l2);
            return new SegmentedSeekableStream(this.file, lArray, n2, n, true);
        }
        int n4 = this.getMiniSectorSize();
        int n5 = (n + n4 - 1) / n4;
        long[] lArray = new long[n5];
        long l3 = this.getStartSector(l);
        for (int i = 0; i < n5 - 1; ++i) {
            lArray[i] = this.getOffsetOfMiniSector(l3);
            l3 = this.getMiniFATSector(l3);
        }
        lArray[n5 - 1] = this.getOffsetOfMiniSector(l3);
        return new SegmentedSeekableStream(this.miniStream, lArray, n4, n, true);
    }

    public void changeDirectoryToRoot() {
        this.cwdIndex = this.getDirectoryEntry(0L).getSIDChild();
    }

    public boolean changeDirectory(String string) {
        long l = this.searchDirectory(string, this.cwdIndex);
        if (l != -1L) {
            this.cwdIndex = this.getDirectoryEntry(l).getSIDChild();
            return true;
        }
        return false;
    }

    private void getHeader() throws IOException {
        this.file.seek(30L);
        this.sectorShift = this.file.readUnsignedShortLE();
        this.file.seek(32L);
        this.miniSectorShift = this.file.readUnsignedShortLE();
        this.file.seek(44L);
        this.csectFat = this.file.readUnsignedIntLE();
        this.file.seek(48L);
        this.sectDirStart = this.file.readUnsignedIntLE();
        this.file.seek(56L);
        this.miniSectorCutoff = this.file.readUnsignedIntLE();
        this.file.seek(60L);
        this.sectMiniFatStart = this.file.readUnsignedIntLE();
        this.file.seek(64L);
        this.csectMiniFat = this.file.readUnsignedIntLE();
        this.file.seek(68L);
        this.sectDifStart = this.file.readUnsignedIntLE();
        this.file.seek(72L);
        this.csectDif = this.file.readUnsignedIntLE();
        this.sectFat = new long[109];
        this.file.seek(76L);
        for (int i = 0; i < 109; ++i) {
            this.sectFat[i] = this.file.readUnsignedIntLE();
        }
    }

    private void getFat() throws IOException {
        long l;
        int n = this.getSectorSize();
        int n2 = n / 4;
        int n3 = n / 4 - 1;
        int n4 = (int)(this.csectFat + this.csectDif * (long)n3);
        long[] lArray = new long[n4];
        int n5 = 0;
        for (int i = 0; i < 109 && (l = this.sectFat[i]) != 0xFFFFFFFFL; ++i) {
            lArray[n5++] = this.getOffsetOfSector(this.sectFat[i]);
        }
        if (this.csectDif > 0L) {
            long l2 = this.sectDifStart;
            byte[] byArray = new byte[n];
            int n6 = 0;
            while ((long)n6 < this.csectDif) {
                this.readSector(l2, byArray, 0);
                for (int i = 0; i < n3; ++i) {
                    int n7 = FPXUtils.getIntLE(byArray, 4 * i);
                    lArray[n5++] = this.getOffsetOfSector(n7);
                }
                l2 = FPXUtils.getIntLE(byArray, n - 4);
                ++n6;
            }
        }
        this.FATStream = new SegmentedSeekableStream(this.file, lArray, n, n4 * n, true);
    }

    private void getMiniFat() throws IOException {
        int n = this.getSectorSize();
        int n2 = n / 4;
        int n3 = 0;
        this.MINIFAT = new long[(int)(this.csectMiniFat * (long)n2)];
        long l = this.sectMiniFatStart;
        byte[] byArray = new byte[n];
        while (l != 0xFFFFFFFEL) {
            this.readSector(l, byArray, 0);
            for (int i = 0; i < n2; ++i) {
                this.MINIFAT[n3++] = FPXUtils.getIntLE(byArray, 4 * i);
            }
            l = this.getFATSector(l);
        }
    }

    private void getDirectory() throws IOException {
        int n = this.getSectorSize();
        long l = this.sectDirStart;
        int n2 = 0;
        while (l != 0xFFFFFFFEL) {
            l = this.getFATSector(l);
            ++n2;
        }
        int n3 = 4 * n2;
        this.DIR = new SSDirectoryEntry[n3];
        l = this.sectDirStart;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while (l != 0xFFFFFFFEL) {
            this.readSector(l, byArray, 0);
            int n5 = 0;
            for (int i = 0; i < 4; ++i) {
                short s = FPXUtils.getShortLE(byArray, n5 + 64);
                String string = FPXUtils.getString(byArray, n5 + 0, s);
                long l2 = FPXUtils.getUnsignedIntLE(byArray, n5 + 68);
                long l3 = FPXUtils.getUnsignedIntLE(byArray, n5 + 72);
                long l4 = FPXUtils.getUnsignedIntLE(byArray, n5 + 76);
                long l5 = FPXUtils.getUnsignedIntLE(byArray, n5 + 116);
                long l6 = FPXUtils.getUnsignedIntLE(byArray, n5 + 120);
                this.DIR[n4] = new SSDirectoryEntry(n4, string, l6, l5, l2, l3, l4);
                ++n4;
                n5 += 128;
            }
            l = this.getFATSector(l);
        }
    }

    private void getMiniStream() throws IOException {
        int n = this.getLength(0L);
        int n2 = this.getSectorSize();
        int n3 = (n + n2 - 1) / n2;
        long[] lArray = new long[n3];
        long l = this.getStartSector(0L);
        for (int i = 0; i < n3 - 1; ++i) {
            lArray[i] = this.getOffsetOfSector(l);
            if ((l = this.getFATSector(l)) == 0xFFFFFFFEL) break;
        }
        lArray[n3 - 1] = this.getOffsetOfSector(l);
        this.miniStream = new SegmentedSeekableStream(this.file, lArray, n2, n, true);
    }

    private int getSectorSize() {
        return 1 << this.sectorShift;
    }

    private long getOffsetOfSector(long l) {
        return l * (long)this.getSectorSize() + 512L;
    }

    private int getMiniSectorSize() {
        return 1 << this.miniSectorShift;
    }

    private long getOffsetOfMiniSector(long l) {
        return l * (long)this.getMiniSectorSize();
    }

    private SSDirectoryEntry getDirectoryEntry(long l) {
        return this.DIR[(int)l];
    }

    private long getStartSector(long l) {
        return this.DIR[(int)l].getStartSector();
    }

    private int getLength(long l) {
        return (int)this.DIR[(int)l].getSize();
    }

    private long getFATSector(long l) throws IOException {
        this.FATStream.seek(4L * l);
        return this.FATStream.readUnsignedIntLE();
    }

    private long getMiniFATSector(long l) {
        return this.MINIFAT[(int)l];
    }

    private int getCurrentIndex() {
        return -1;
    }

    private int getIndex(String string, int n) {
        return -1;
    }

    private long getStreamIndex(String string) {
        long l = this.cwdIndex;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                l = this.getDirectoryEntry(l).getSIDChild();
            } else {
                bl = false;
            }
            l = this.searchDirectory(string2, l);
        }
        return l;
    }

    private void readMiniSector(long l, byte[] byArray, int n, int n2) throws IOException {
        this.miniStream.seek(this.getOffsetOfMiniSector(l));
        this.miniStream.read(byArray, n, n2);
    }

    private void readMiniSector(long l, byte[] byArray, int n) throws IOException {
        this.readMiniSector(l, byArray, n, this.getMiniSectorSize());
    }

    private void readSector(long l, byte[] byArray, int n, int n2) throws IOException {
        this.file.seek(this.getOffsetOfSector(l));
        this.file.read(byArray, n, n2);
    }

    private void readSector(long l, byte[] byArray, int n) throws IOException {
        this.readSector(l, byArray, n, this.getSectorSize());
    }

    private long searchDirectory(String string, long l) {
        if (l == 0xFFFFFFFFL) {
            return -1L;
        }
        SSDirectoryEntry sSDirectoryEntry = this.getDirectoryEntry(l);
        if (string.equals(sSDirectoryEntry.getName())) {
            return l;
        }
        long l2 = this.searchDirectory(string, sSDirectoryEntry.getSIDLeftSibling());
        if (l2 != -1L) {
            return l2;
        }
        long l3 = this.searchDirectory(string, sSDirectoryEntry.getSIDRightSibling());
        if (l3 != -1L) {
            return l3;
        }
        return -1L;
    }
}

