/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import non_com.media.jai.DataBufferFloat;
import non_com.media.jai.FloatDoubleColorModel;
import non_com.media.jai.RasterFactory;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.SeekableStream;
import non_com.media.jai.codec.SimpleRenderedImage;
import non_com.media.jai.codec.TIFFDecodeParam;
import non_com.media.jai.codec.TIFFDirectory;
import non_com.media.jai.codec.TIFFFaxDecoder;
import non_com.media.jai.codec.TIFFField;
import non_com.media.jai.codec.TIFFLZWDecoder;

public class TIFFImage
extends SimpleRenderedImage {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    JPEGDecodeParam decodeParam = null;
    boolean colorConvertJPEG = false;
    Inflater inflater = null;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero = false;
    int dataType;
    boolean decodePaletteAsShorts;
    private boolean isTiled;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;
    static /* synthetic */ Class array$I;

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n) throws IOException {
        int n2;
        Object object;
        Object object2;
        TIFFField tIFFField;
        int n3;
        TIFFField tIFFField2;
        int n4;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n);
        this.properties.put("tiff_directory", tIFFDirectory);
        TIFFField tIFFField3 = tIFFDirectory.getField(277);
        int n5 = tIFFField3 == null ? 1 : (int)tIFFField3.getAsLong(0);
        TIFFField tIFFField4 = tIFFDirectory.getField(284);
        if (tIFFField4 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField4.getAsChars();
        }
        if (cArray[0] != '\u0001' && n5 != 1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage0"));
        }
        TIFFField tIFFField5 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField5 != null) {
            cArray4 = tIFFField5.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            for (int i = 1; i < cArray4.length; ++i) {
                if (cArray4[i] == cArray4[0]) continue;
                throw new RuntimeException(JaiI18N.getString("TIFFImage1"));
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField6 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField6 != null) {
            cArray5 = tIFFField6.getAsChars();
            for (n4 = 1; n4 < cArray5.length; ++n4) {
                if (cArray5[n4] == cArray5[0]) continue;
                throw new RuntimeException(JaiI18N.getString("TIFFImage2"));
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n4 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n4 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n4 = 1;
                break;
            }
            case 32: {
                this.dataType = cArray5[0] == '\u0003' ? 4 : 3;
                n4 = 1;
            }
        }
        if (n4 == 0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage3"));
        }
        TIFFField tIFFField7 = tIFFDirectory.getField(259);
        this.compression = tIFFField7 == null ? 1 : tIFFField7.getAsInt(0);
        TIFFField tIFFField8 = this.getField(tIFFDirectory, 262, "Photometric Interpretation");
        int n6 = (int)tIFFField8.getAsLong(0);
        this.imageType = -1;
        switch (n6) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n5 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n5 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n5 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n5 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n5 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n5 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n5 != true || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n5 != true) break;
                this.imageType = 0;
                break;
            }
            case 6: {
                if (this.compression == 7 && this.sampleSize == 8 && n5 == 3) {
                    this.colorConvertJPEG = tIFFDecodeParam.getJPEGDecompressYCbCrToRGB();
                    this.imageType = this.colorConvertJPEG ? 5 : 8;
                    break;
                }
                tIFFField2 = tIFFDirectory.getField(530);
                if (tIFFField2 != null) {
                    this.chromaSubH = tIFFField2.getAsInt(0);
                    this.chromaSubV = tIFFField2.getAsInt(1);
                } else {
                    this.chromaSubV = 2;
                    this.chromaSubH = 2;
                }
                if (this.chromaSubH * this.chromaSubV == 1) {
                    this.imageType = 8;
                    break;
                }
                if (this.sampleSize != 8 || n5 != 3) break;
                this.imageType = 7;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage4"));
        }
        this.minY = 0;
        this.minX = 0;
        this.width = (int)this.getField(tIFFDirectory, 256, "Image Width").getAsLong(0);
        this.height = (int)this.getField(tIFFDirectory, 257, "Image Length").getAsLong(0);
        this.numBands = n5;
        tIFFField2 = tIFFDirectory.getField(338);
        int n7 = n3 = tIFFField2 == null ? 0 : (int)tIFFField2.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.isTiled = true;
            this.tileWidth = (int)this.getField(tIFFDirectory, 322, "Tile Width").getAsLong(0);
            this.tileHeight = (int)this.getField(tIFFDirectory, 323, "Tile Length").getAsLong(0);
            this.tileOffsets = this.getField(tIFFDirectory, 324, "Tile Offsets").getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(this.getField(tIFFDirectory, 325, "Tile Byte Counts"));
        } else {
            this.isTiled = false;
            this.tileWidth = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : this.width;
            tIFFField = tIFFDirectory.getField(278);
            if (tIFFField == null) {
                this.tileHeight = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : this.height;
            } else {
                long l = tIFFField.getAsLong(0);
                long l2 = 1L;
                this.tileHeight = l == (l2 = (l2 << 32) - 1L) || l > (long)this.height ? this.height : (int)l;
            }
            object2 = this.getField(tIFFDirectory, 273, "Strip Offsets");
            this.tileOffsets = this.getFieldAsLongs((TIFFField)object2);
            object = tIFFDirectory.getField(279);
            if (object == null) {
                if (this.compression == 1) {
                    int n8 = (this.sampleSize + 7) / 8 * this.numBands * this.width * this.height;
                    n2 = (this.sampleSize + 7) / 8 * this.numBands * this.width * this.tileHeight;
                    int n9 = 0;
                    this.tileByteCounts = new long[this.tileOffsets.length];
                    for (int i = 0; i < this.tileOffsets.length; ++i) {
                        this.tileByteCounts[i] = Math.min(n8 - n9, n2);
                        n9 += n2;
                    }
                } else {
                    object = this.getField(tIFFDirectory, 279, "Strip Byte Counts");
                }
            } else {
                this.tileByteCounts = this.getFieldAsLongs((TIFFField)object);
            }
            int n10 = this.width * this.height * this.numBands * ((this.sampleSize + 7) / 8);
            if (this.tileByteCounts.length == 1 && this.compression == 1 && this.tileByteCounts[0] > (long)n10) {
                this.tileByteCounts[0] = n10;
            }
        }
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage7"));
                }
                if (this.compression == 3) {
                    object2 = tIFFDirectory.getField(292);
                    this.tiffT4Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    object2 = tIFFDirectory.getField(293);
                    this.tiffT6Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, this.tileWidth, this.tileHeight);
                break;
            }
            case 5: {
                object2 = tIFFDirectory.getField(317);
                if (object2 == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = ((TIFFField)object2).getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage8"));
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(this.sampleSize + JaiI18N.getString("TIFFImage9"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(this.tileWidth, this.predictor, n5);
                break;
            }
            case 6: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage15"));
            }
            case 7: {
                if (!(this.sampleSize == 8 && (this.imageType == 2 && n5 == 1 || this.imageType == 4 && n5 == 1 || this.imageType == 5 && n5 == 3))) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage16"));
                }
                if (!tIFFDirectory.isTagPresent(347)) break;
                object = tIFFDirectory.getField(347);
                byte[] byArray = ((TIFFField)object).getAsBytes();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                jPEGImageDecoder.decodeAsRaster();
                this.decodeParam = jPEGImageDecoder.getJPEGDecodeParam();
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImage10"));
            }
        }
        switch (this.imageType) {
            case 0: 
            case 1: {
                this.sampleModel = new MultiPixelPackedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.sampleSize);
                if (this.imageType == 0) {
                    object2 = new byte[]{(byte)(this.isWhiteZero ? 255 : 0), (byte)(this.isWhiteZero ? 0 : 255)};
                    this.colorModel = new IndexColorModel(1, 2, (byte[])object2, (byte[])object2, (byte[])object2);
                    break;
                }
                this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, !this.isWhiteZero);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                int n11;
                object2 = new int[this.numBands];
                if (this.compression == 7) {
                    for (n11 = 0; n11 < this.numBands; ++n11) {
                        object2[n11] = this.numBands - 1 - n11;
                    }
                } else {
                    for (n11 = 0; n11 < this.numBands; ++n11) {
                        object2[n11] = n11;
                    }
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object2);
                if (this.imageType == 2 || this.imageType == 5) {
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                n11 = 1;
                if (n3 == 1) {
                    n11 = 3;
                } else if (n3 == 2) {
                    n11 = 2;
                }
                this.colorModel = this.createAlphaComponentColorModel(this.dataType, this.numBands, n3 == 1, n11);
                break;
            }
            case 7: 
            case 8: {
                object = new int[this.numBands];
                for (int i = 0; i < this.numBands; ++i) {
                    object[i] = i;
                }
                this.sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, (int[])object);
                this.colorModel = null;
                break;
            }
            case 4: {
                TIFFField tIFFField9 = this.getField(tIFFDirectory, 320, "Colormap");
                this.colormap = tIFFField9.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands);
                    this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(1, this.tileWidth, this.tileHeight, this.numBands);
                }
                n2 = this.colormap.length / 3;
                byte[] byArray = new byte[n2];
                byte[] byArray2 = new byte[n2];
                byte[] byArray3 = new byte[n2];
                int n12 = n2;
                int n13 = n2 * 2;
                if (this.dataType == 2) {
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[i]);
                        byArray2[i] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n12 + i]);
                        byArray3[i] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n13 + i]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[i] & 0xFFFF);
                        byArray2[i] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n12 + i] & 0xFFFF);
                        byArray3[i] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n13 + i] & 0xFFFF);
                    }
                }
                this.colorModel = new IndexColorModel(this.sampleSize, n2, byArray, byArray2, byArray3);
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage4");
            }
        }
    }

    private static final Raster decodeJPEG(byte[] byArray, JPEGDecodeParam jPEGDecodeParam, boolean bl, int n, int n2) {
        Raster raster;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = jPEGDecodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream) : JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream, (JPEGDecodeParam)jPEGDecodeParam);
        try {
            raster = bl ? jPEGImageDecoder.decodeAsBufferedImage().getWritableTile(0, 0) : jPEGImageDecoder.decodeAsRaster();
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        return raster.createTranslatedChild(n, n2);
    }

    private static final SampleModel createPixelInterleavedSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        SampleModel sampleModel = null;
        if (n == 4) {
            try {
                Class<?> clazz = Class.forName("non_com.media.jai.RasterFactory");
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, array$I == null ? (array$I = TIFFImage.class$("[I")) : array$I};
                Method method = clazz.getMethod("createPixelInterleavedSampleModel", classArray);
                Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), nArray};
                sampleModel = (SampleModel)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n != 4 || sampleModel == null) {
            sampleModel = RasterFactory.createPixelInterleavedSampleModel(n, n2, n3, n4, n5, nArray);
        }
        return sampleModel;
    }

    public TIFFDirectory getPrivateIFD(long l) throws IOException {
        return new TIFFDirectory(this.stream, l, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Raster getTile(int n, int n2) {
        byte[] byArray;
        Object object;
        if (n < 0 || n >= this.tilesX || n2 < 0 || n2 >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("TIFFImage12"));
        }
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        DataBuffer dataBuffer = this.sampleModel.createDataBuffer();
        int n3 = this.sampleModel.getDataType();
        if (n3 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else if (n3 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n3 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        } else if (n3 == 3) {
            nArray = ((DataBufferInt)dataBuffer).getData();
        } else if (n3 == 4) {
            if (dataBuffer instanceof DataBufferFloat) {
                fArray = ((DataBufferFloat)dataBuffer).getData();
            } else {
                try {
                    object = dataBuffer.getClass().getMethod("getData", null);
                    fArray = (float[])((Method)object).invoke((Object)dataBuffer, null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage18"));
                }
            }
        }
        object = RasterFactory.createWritableRaster(this.sampleModel, dataBuffer, new Point(this.tileXToX(n), this.tileYToY(n2)));
        long l = 0L;
        try {
            l = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n2 * this.tilesX + n]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        int n4 = (int)this.tileByteCounts[n2 * this.tilesX + n];
        Rectangle rectangle = new Rectangle(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = this.isTiled ? rectangle : rectangle.intersection(this.getBounds());
        int n5 = rectangle2.width * rectangle2.height * this.numBands;
        Object object2 = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n4] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n6 = rectangle2.width % 8 == 0 ? rectangle2.width / 8 * rectangle2.height : (rectangle2.width / 8 + 1) * rectangle2.height;
                    this.decodePackbits(byArray, n6, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 2) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decode1D(byArray2, byArray, 0, rectangle2.height);
                } else if (this.compression == 3) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decode2D(byArray2, byArray, 0, rectangle2.height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decoder.decodeT6(byArray2, byArray, 0, rectangle2.height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
            }
        }
        if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] sArray2 = null;
                    int n7 = n5 / 3;
                    int n8 = n7 * 2;
                    try {
                        byte[] byArray3;
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.decodePackbits(byArray, n8, byArray3);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.lzwDecoder.decode(byArray, byArray3, rectangle2.height);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray3 = new byte[n8];
                            this.inflate(byArray, byArray3);
                            sArray2 = new short[n7];
                            this.interpretBytesAsShorts(byArray3, sArray2, n7);
                        } else if (this.compression == 1) {
                            sArray2 = new short[n4 / 2];
                            this.readShorts(n4 / 2, sArray2);
                        }
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                    }
                    if (n3 == 1) {
                        int n9 = 0;
                        int n10 = this.colormap.length / 3;
                        int n11 = n10 * 2;
                        for (int i = 0; i < n7; ++i) {
                            int n12 = sArray2[i] & 0xFFFF;
                            char c = this.colormap[n12 + n11];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            c = this.colormap[n12 + n10];
                            sArray[n9++] = (short)(c & 0xFFFF);
                            c = this.colormap[n12];
                            sArray[n9++] = (short)(c & 0xFFFF);
                        }
                        return object;
                    } else {
                        if (n3 != 2) return object;
                        int n13 = 0;
                        int n14 = this.colormap.length / 3;
                        int n15 = n14 * 2;
                        for (int i = 0; i < n7; ++i) {
                            int n16 = sArray2[i] & 0xFFFF;
                            char c = this.colormap[n16 + n15];
                            sArray[n13++] = (short)c;
                            c = this.colormap[n16 + n14];
                            sArray[n13++] = (short)c;
                            c = this.colormap[n16];
                            sArray[n13++] = (short)c;
                        }
                    }
                    return object;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        int n17 = n5 * 2;
                        byte[] byArray4 = new byte[n17];
                        this.decodePackbits(byArray, n17, byArray4);
                        this.interpretBytesAsShorts(byArray4, sArray, n5);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        byte[] byArray5 = new byte[n5 * 2];
                        this.lzwDecoder.decode(byArray, byArray5, rectangle2.height);
                        this.interpretBytesAsShorts(byArray5, sArray, n5);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        byte[] byArray6 = new byte[n5 * 2];
                        this.inflate(byArray, byArray6);
                        this.interpretBytesAsShorts(byArray6, sArray, n5);
                    } else if (this.compression == 1) {
                        this.readShorts(n4 / 2, sArray);
                    }
                    this.stream.seek(l);
                    return object;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                }
            }
            if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    int n18;
                    byte[] byArray7 = null;
                    int n19 = n5 / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n19];
                            this.decodePackbits(byArray, n19, byArray7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n19];
                            this.lzwDecoder.decode(byArray, byArray7, rectangle2.height);
                        } else if (this.compression == 7) {
                            this.stream.readFully(byArray, 0, n4);
                            Raster raster = TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object).getMinX(), ((Raster)object).getMinY());
                            int[] nArray2 = new int[n19];
                            raster.getPixels(((Raster)object).getMinX(), ((Raster)object).getMinY(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), nArray2);
                            byArray7 = new byte[n19];
                            for (n18 = 0; n18 < n19; ++n18) {
                                byArray7[n18] = (byte)nArray2[n18];
                            }
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n4);
                            byArray7 = new byte[n19];
                            this.inflate(byArray, byArray7);
                        } else if (this.compression == 1) {
                            byArray7 = new byte[n4];
                            this.stream.readFully(byArray7, 0, n4);
                        }
                        this.stream.seek(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                    }
                    int n20 = 0;
                    int n21 = this.colormap.length / 3;
                    int n22 = n21 * 2;
                    for (int i = 0; i < n19; ++i) {
                        n18 = byArray7[i] & 0xFF;
                        char c = this.colormap[n18 + n22];
                        sArray[n20++] = (short)(c & 0xFFFF);
                        c = this.colormap[n18 + n21];
                        sArray[n20++] = (short)(c & 0xFFFF);
                        c = this.colormap[n18];
                        sArray[n20++] = (short)(c & 0xFFFF);
                    }
                    return object;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n4);
                        this.decodePackbits(byArray, n5, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n4);
                        this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                    } else if (this.compression == 7) {
                        this.stream.readFully(byArray, 0, n4);
                        ((WritableRaster)object).setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object).getMinX(), ((Raster)object).getMinY()));
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n4);
                        this.inflate(byArray, byArray2);
                    } else if (this.compression == 1) {
                        this.stream.readFully(byArray2, 0, n4);
                    }
                    this.stream.seek(l);
                    return object;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                }
            }
            if (this.sampleSize != 4) return object;
            int n23 = rectangle2.width % 2 == 0 ? 0 : 1;
            int n24 = (rectangle2.width / 2 + n23) * rectangle2.height;
            if (this.decodePaletteAsShorts) {
                int n25;
                int n26;
                byte[] byArray8 = null;
                try {
                    this.stream.readFully(byArray, 0, n4);
                    this.stream.seek(l);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
                }
                if (this.compression == 32773) {
                    byArray8 = new byte[n24];
                    this.decodePackbits(byArray, n24, byArray8);
                } else if (this.compression == 5) {
                    byArray8 = new byte[n24];
                    this.lzwDecoder.decode(byArray, byArray8, rectangle2.height);
                } else if (this.compression == 32946) {
                    byArray8 = new byte[n24];
                    this.inflate(byArray, byArray8);
                } else if (this.compression == 1) {
                    byArray8 = byArray;
                }
                int n27 = n5 / 3;
                byArray = new byte[n27];
                int n28 = 0;
                int n29 = 0;
                for (n26 = 0; n26 < rectangle2.height; ++n26) {
                    for (n25 = 0; n25 < rectangle2.width / 2; ++n25) {
                        byArray[n29++] = (byte)((byArray8[n28] & 0xF0) >> 4);
                        byArray[n29++] = (byte)(byArray8[n28++] & 0xF);
                    }
                    if (n23 != 1) continue;
                    byArray[n29++] = (byte)((byArray8[n28++] & 0xF0) >> 4);
                }
                n26 = this.colormap.length / 3;
                n25 = n26 * 2;
                int n30 = 0;
                for (int i = 0; i < n27; ++i) {
                    int n31 = byArray[i] & 0xFF;
                    char c = this.colormap[n31 + n25];
                    sArray[n30++] = (short)(c & 0xFFFF);
                    c = this.colormap[n31 + n26];
                    sArray[n30++] = (short)(c & 0xFFFF);
                    c = this.colormap[n31];
                    sArray[n30++] = (short)(c & 0xFFFF);
                }
                return object;
            }
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decodePackbits(byArray, n24, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
            }
        }
        if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n32 = rectangle2.width % 8 == 0 ? rectangle2.width / 2 * rectangle2.height : (rectangle2.width / 2 + 1) * rectangle2.height;
                    this.decodePackbits(byArray, n32, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                } else {
                    this.stream.readFully(byArray2, 0, n4);
                }
                this.stream.seek(l);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
            }
        }
        try {
            byte[] byArray9;
            if (this.sampleSize == 8) {
                if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n4);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle2.height);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    this.decodePackbits(byArray, n5, byArray2);
                } else if (this.compression == 7) {
                    this.stream.readFully(byArray, 0, n4);
                    ((WritableRaster)object).setRect(TIFFImage.decodeJPEG(byArray, this.decodeParam, this.colorConvertJPEG, ((Raster)object).getMinX(), ((Raster)object).getMinY()));
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    this.inflate(byArray, byArray2);
                }
            } else if (this.sampleSize == 16) {
                if (this.compression == 1) {
                    this.readShorts(n4 / 2, sArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray10 = new byte[n5 * 2];
                    this.lzwDecoder.decode(byArray, byArray10, rectangle2.height);
                    this.interpretBytesAsShorts(byArray10, sArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n33 = n5 * 2;
                    byArray9 = new byte[n33];
                    this.decodePackbits(byArray, n33, byArray9);
                    this.interpretBytesAsShorts(byArray9, sArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray11 = new byte[n5 * 2];
                    this.inflate(byArray, byArray11);
                    this.interpretBytesAsShorts(byArray11, sArray, n5);
                }
            } else if (this.sampleSize == 32 && n3 == 3) {
                if (this.compression == 1) {
                    this.readInts(n4 / 4, nArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray12 = new byte[n5 * 4];
                    this.lzwDecoder.decode(byArray, byArray12, rectangle2.height);
                    this.interpretBytesAsInts(byArray12, nArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n34 = n5 * 4;
                    byArray9 = new byte[n34];
                    this.decodePackbits(byArray, n34, byArray9);
                    this.interpretBytesAsInts(byArray9, nArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray13 = new byte[n5 * 4];
                    this.inflate(byArray, byArray13);
                    this.interpretBytesAsInts(byArray13, nArray, n5);
                }
            } else if (this.sampleSize == 32 && n3 == 4) {
                if (this.compression == 1) {
                    this.readFloats(n4 / 4, fArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray14 = new byte[n5 * 4];
                    this.lzwDecoder.decode(byArray, byArray14, rectangle2.height);
                    this.interpretBytesAsFloats(byArray14, fArray, n5);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n4);
                    int n35 = n5 * 4;
                    byArray9 = new byte[n35];
                    this.decodePackbits(byArray, n35, byArray9);
                    this.interpretBytesAsFloats(byArray9, fArray, n5);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n4);
                    byte[] byArray15 = new byte[n5 * 4];
                    this.inflate(byArray, byArray15);
                    this.interpretBytesAsFloats(byArray15, fArray, n5);
                }
            }
            this.stream.seek(l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        switch (this.imageType) {
            case 2: 
            case 3: {
                if (!this.isWhiteZero) return object;
                if (n3 == 0 && !(this.colorModel instanceof IndexColorModel)) {
                    for (int i = 0; i < byArray2.length; i += this.numBands) {
                        byArray2[i] = (byte)(255 - byArray2[i]);
                    }
                    return object;
                } else if (n3 == 1) {
                    int n36 = 65535;
                    for (int i = 0; i < sArray.length; i += this.numBands) {
                        sArray[i] = (short)(n36 - sArray[i]);
                    }
                    return object;
                } else if (n3 == 2) {
                    for (int i = 0; i < sArray.length; i += this.numBands) {
                        sArray[i] = ~sArray[i];
                    }
                    return object;
                } else {
                    if (n3 != 3) return object;
                    long l2 = -1L;
                    for (int i = 0; i < nArray.length; i += this.numBands) {
                        nArray[i] = (int)(l2 - (long)nArray[i]);
                    }
                }
                return object;
            }
            case 7: {
                int n37 = this.chromaSubH * this.chromaSubV;
                int n38 = rectangle2.width / this.chromaSubH;
                int n39 = rectangle2.height / this.chromaSubV;
                byte[] byArray16 = new byte[n38 * n39 * (n37 + 2)];
                System.arraycopy(byArray2, 0, byArray16, 0, byArray16.length);
                int n40 = n37 * 3;
                int[] nArray3 = new int[n40];
                int n41 = 0;
                int n42 = n37;
                int n43 = n42 + 1;
                int n44 = rectangle2.y;
                for (int i = 0; i < n39; ++i) {
                    int n45 = rectangle2.x;
                    for (int j = 0; j < n38; ++j) {
                        int n46 = byArray16[n41 + n42];
                        int n47 = byArray16[n41 + n43];
                        int n48 = 0;
                        while (n48 < n40) {
                            nArray3[n48++] = byArray16[n41++];
                            nArray3[n48++] = n46;
                            nArray3[n48++] = n47;
                        }
                        n41 += 2;
                        ((WritableRaster)object).setPixels(n45, n44, this.chromaSubH, this.chromaSubV, nArray3);
                        n45 += this.chromaSubH;
                    }
                    n44 += this.chromaSubV;
                }
                return object;
            }
        }
        return object;
    }

    private final long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = cArray[i] & 0xFFFF;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return lArray;
    }

    private TIFFField getField(TIFFDirectory tIFFDirectory, int n, String string) {
        TIFFField tIFFField = tIFFDirectory.getField(n);
        if (tIFFField == null) {
            MessageFormat messageFormat = new MessageFormat(JaiI18N.getString("TIFFImage5"));
            messageFormat.setLocale(Locale.getDefault());
            throw new RuntimeException(messageFormat.format(new Object[]{string}));
        }
        return tIFFField;
    }

    private final void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage17") + ": " + dataFormatException.getMessage());
        }
        this.inflater.reset();
    }

    private void readShorts(int n, short[] sArray) {
        int n2 = 2 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        this.interpretBytesAsShorts(byArray, sArray, n);
    }

    private void readInts(int n, int[] nArray) {
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        this.interpretBytesAsInts(byArray, nArray, n);
    }

    private void readFloats(int n, float[] fArray) {
        int n2 = 4 * n;
        byte[] byArray = new byte[n2];
        try {
            this.stream.readFully(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage13"));
        }
        this.interpretBytesAsFloats(byArray, fArray, n);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            for (int i = 0; i < n; ++i) {
                int n3 = byArray[n2++] & 0xFF;
                int n4 = byArray[n2++] & 0xFF;
                sArray[i] = (short)((n3 << 8) + n4);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n5 = byArray[n2++] & 0xFF;
                int n6 = byArray[n2++] & 0xFF;
                sArray[i] = (short)((n6 << 8) + n5);
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
            }
        }
    }

    private void interpretBytesAsFloats(byte[] byArray, float[] fArray, int n) {
        int n2 = 0;
        if (this.isBigEndian) {
            for (int i = 0; i < n; ++i) {
                int n3 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                fArray[i] = Float.intBitsToFloat(n3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4 = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
                fArray[i] = Float.intBitsToFloat(n4);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] decodePackbits(byte[] byArray, int n, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[n];
        }
        int n2 = 0;
        int n3 = 0;
        try {
            block2: while (n3 < n) {
                int n4;
                byte by;
                if ((by = byArray[n2++]) >= 0 && by <= 127) {
                    n4 = 0;
                    while (true) {
                        if (n4 >= by + 1) continue block2;
                        byArray2[n3++] = byArray[n2++];
                        ++n4;
                    }
                }
                if (by <= -1 && by >= -127) {
                    byte by2 = byArray[n2++];
                    n4 = 0;
                    while (true) {
                        if (n4 >= -by + 1) continue block2;
                        byArray2[n3++] = by2;
                        ++n4;
                    }
                }
                ++n2;
            }
            return byArray2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException(JaiI18N.getString("TIFFImage14"));
        }
    }

    private ComponentColorModel createAlphaComponentColorModel(int n, int n2, boolean bl, int n3) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n2) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n == 4) {
            componentColorModel = new FloatDoubleColorModel(colorSpace, true, bl, n3, n);
        } else {
            int n4 = 0;
            switch (n) {
                case 0: {
                    n4 = 8;
                    break;
                }
                case 1: 
                case 2: {
                    n4 = 16;
                    break;
                }
                case 3: {
                    n4 = 32;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n4;
            }
            componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl, n3, n);
        }
        return componentColorModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

