/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Plot {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int DOT = 6;
    public static final int LINE = 2;
    public static final int X_NUMBERS = 1;
    public static final int Y_NUMBERS = 2;
    public static final int X_TICKS = 4;
    public static final int Y_TICKS = 8;
    public static final int X_GRID = 16;
    public static final int Y_GRID = 32;
    public static final int X_FORCE2GRID = 64;
    public static final int Y_FORCE2GRID = 128;
    public static final int DEFAULT_FLAGS = 51;
    public static final int LEFT_MARGIN = 60;
    public static final int RIGHT_MARGIN = 18;
    public static final int TOP_MARGIN = 15;
    public static final int BOTTOM_MARGIN = 40;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final int MAX_INTERVALS = 12;
    private static final int MIN_X_GRIDWIDTH = 60;
    private static final int MIN_Y_GRIDWIDTH = 40;
    private static final int TICK_LENGTH = 3;
    private final Color gridColor = new Color(0xC0C0C0);
    private int frameWidth;
    private int frameHeight;
    Rectangle frame = null;
    float[] xValues;
    float[] yValues;
    float[] errorBars;
    int nPoints;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    private double xScale;
    private double yScale;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private int flags;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private int lineWidth = 1;
    private int markSize = 5;
    private ImageProcessor ip;
    private String title;
    private boolean initialized;
    private boolean plotDrawn;
    private int plotWidth = PlotWindow.plotWidth;
    private int plotHeight = PlotWindow.plotHeight;
    private boolean multiplePlots;
    private boolean drawPending;
    ArrayList storedData;

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, int flags) {
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.flags = flags;
        this.storedData = new ArrayList();
        if (xValues == null || yValues == null) {
            xValues = new float[1];
            yValues = new float[1];
            xValues[0] = -1.0f;
            yValues[0] = -1.0f;
        } else {
            this.storeData(xValues, yValues);
        }
        this.xValues = xValues;
        this.yValues = yValues;
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
        this.drawPending = true;
    }

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, 51);
    }

    public Plot(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, int flags) {
        this(title, xLabel, yLabel, xValues != null ? Tools.toFloat(xValues) : null, yValues != null ? Tools.toFloat(yValues) : null, flags);
    }

    public Plot(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, xValues != null ? Tools.toFloat(xValues) : null, yValues != null ? Tools.toFloat(yValues) : null, 51);
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.fixedYScale = true;
        if (this.initialized) {
            this.ip.setColor(Color.white);
            this.ip.resetRoi();
            this.ip.fill();
            this.ip.setColor(Color.black);
            this.setScaleAndDrawAxisLabels();
        }
    }

    public void setSize(int width, int height) {
        if (!this.initialized && width > 98 && height > 75) {
            this.plotWidth = width - 60 - 18;
            this.plotHeight = height - 15 - 40;
        }
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.setup();
        switch (shape) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.ip.setClipRect(this.frame);
                for (int i = 0; i < x.length; ++i) {
                    int xt = 60 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    int yt = 15 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                    this.drawShape(shape, xt, yt, this.markSize);
                }
                this.ip.setClipRect(null);
                break;
            }
            case 2: {
                int[] xts = new int[x.length];
                int[] yts = new int[y.length];
                for (int i = 0; i < x.length; ++i) {
                    xts[i] = 60 + (int)(((double)x[i] - this.xMin) * this.xScale);
                    yts[i] = 15 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
                }
                this.drawPolyline(this.ip, xts, yts, x.length, true);
            }
        }
        this.multiplePlots = true;
        if (this.xValues.length == 1) {
            this.xValues = x;
            this.yValues = y;
            this.nPoints = x.length;
            this.drawPending = false;
        }
        this.storeData(x, y);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    void drawShape(int shape, int x, int y, int size) {
        int xbase = x - size / 2;
        int ybase = y - size / 2;
        switch (shape) {
            case 1: {
                this.ip.drawLine(xbase, ybase, xbase + size, ybase + size);
                this.ip.drawLine(xbase + size, ybase, xbase, ybase + size);
                break;
            }
            case 3: {
                this.ip.drawLine(xbase, ybase, xbase + size, ybase);
                this.ip.drawLine(xbase + size, ybase, xbase + size, ybase + size);
                this.ip.drawLine(xbase + size, ybase + size, xbase, ybase + size);
                this.ip.drawLine(xbase, ybase + size, xbase, ybase);
                break;
            }
            case 4: {
                this.ip.drawLine(x, ybase, xbase + size, ybase + size);
                this.ip.drawLine(xbase + size, ybase + size, xbase, ybase + size);
                this.ip.drawLine(xbase, ybase + size, x, ybase);
                break;
            }
            case 5: {
                this.ip.drawLine(xbase, y, xbase + size, y);
                this.ip.drawLine(x, ybase, x, ybase + size);
                break;
            }
            case 6: {
                this.ip.drawDot(x, y);
                break;
            }
            default: {
                this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
                this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
                this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
                this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
            }
        }
    }

    public void addErrorBars(float[] errorBars) {
        if (errorBars.length != this.nPoints) {
            throw new IllegalArgumentException("errorBars.length != npoints");
        }
        this.errorBars = errorBars;
    }

    public void addErrorBars(double[] errorBars) {
        this.addErrorBars(Tools.toFloat(errorBars));
    }

    public void addLabel(double x, double y, String label) {
        this.setup();
        int xt = 60 + (int)(x * (double)this.frameWidth);
        int yt = 15 + (int)(y * (double)this.frameHeight);
        this.ip.drawString(label, xt, yt);
    }

    public void setJustification(int justification) {
        this.setup();
        this.ip.setJustification(justification);
    }

    public void setColor(Color c) {
        this.setup();
        if (!(this.ip instanceof ColorProcessor)) {
            this.ip = this.ip.convertToRGB();
            this.ip.setLineWidth(this.lineWidth);
            this.ip.setFont(this.font);
            this.ip.setAntialiasedText(true);
        }
        this.ip.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        this.setup();
        this.ip.setLineWidth(lineWidth);
        this.lineWidth = lineWidth;
        this.markSize = lineWidth == 1 ? 5 : 7;
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.setup();
        int ix1 = 60 + (int)Math.round((x1 - this.xMin) * this.xScale);
        int iy1 = 15 + this.frameHeight - (int)Math.round((y1 - this.yMin) * this.yScale);
        int ix2 = 60 + (int)Math.round((x2 - this.xMin) * this.xScale);
        int iy2 = 15 + this.frameHeight - (int)Math.round((y2 - this.yMin) * this.yScale);
        this.ip.drawLine(ix1, iy1, ix2, iy2);
    }

    public void changeFont(Font font) {
        this.setup();
        this.ip.setFont(font);
        this.font = font;
    }

    void setup() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.createImage();
        this.ip.setColor(Color.black);
        if (this.lineWidth > 3) {
            this.lineWidth = 3;
        }
        this.ip.setLineWidth(this.lineWidth);
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = this.plotWidth;
            this.frameHeight = this.plotHeight;
        }
        this.frame = new Rectangle(60, 15, this.frameWidth, this.frameHeight);
        this.setScaleAndDrawAxisLabels();
    }

    void setScaleAndDrawAxisLabels() {
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
        if (PlotWindow.noGridLines) {
            this.drawAxisLabels();
        } else {
            this.drawTicksEtc();
        }
    }

    void drawAxisLabels() {
        int digits = this.getDigits(this.yMin, this.yMax);
        String s = IJ.d2s(this.yMax, digits);
        int sw = this.ip.getStringWidth(s);
        if (sw + 4 > 60) {
            this.ip.drawString(s, 4, 11);
        } else {
            this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4, 25);
        }
        s = IJ.d2s(this.yMin, digits);
        sw = this.ip.getStringWidth(s);
        if (sw + 4 > 60) {
            this.ip.drawString(s, 4, 15 + this.frame.height);
        } else {
            this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4, 15 + this.frame.height);
        }
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 60;
        int y = 15 + this.frame.height + fm.getAscent() + 6;
        digits = this.getDigits(this.xMin, this.xMax);
        this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
        s = IJ.d2s(this.xMax, digits);
        this.ip.drawString(s, x + this.frame.width - this.ip.getStringWidth(s) + 6, y);
        this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 3);
        this.drawYLabel(this.yLabel, 56, 15, this.frame.height, fm);
    }

    void drawTicksEtc() {
        String s;
        double v;
        int i;
        int digits;
        int fontAscent = this.ip.getFontMetrics().getAscent();
        int fontMaxAscent = this.ip.getFontMetrics().getMaxAscent();
        if ((this.flags & 0x15) != 0) {
            int i2;
            int i1;
            double step = Math.abs((double)Math.max(this.frame.width / 12, 60) / this.xScale);
            step = this.niceNumber(step);
            if ((this.flags & 0x40) != 0) {
                i1 = (int)Math.floor(Math.min(this.xMin, this.xMax) / step + 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.xMin, this.xMax) / step - 1.0E-10);
                this.xMin = (double)i1 * step;
                this.xMax = (double)i2 * step;
                this.xScale = (double)this.frame.width / (this.xMax - this.xMin);
            } else {
                i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
            }
            digits = -((int)Math.floor(Math.log(step) / Math.log(10.0) + 1.0E-6));
            if (digits < 0) {
                digits = 0;
            }
            if (digits > 5) {
                digits = -3;
            }
            int y1 = 15;
            int y2 = 15 + this.frame.height;
            int yNumbers = y2 + fontAscent + 7;
            for (i = 0; i <= i2 - i1; ++i) {
                v = (double)(i + i1) * step;
                int x = (int)Math.round((v - this.xMin) * this.xScale) + 60;
                if ((this.flags & 0x10) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(x, y1, x, y2);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 4) != 0) {
                    this.ip.drawLine(x, y1, x, y1 + 3);
                    this.ip.drawLine(x, y2, x, y2 - 3);
                }
                if ((this.flags & 1) == 0) continue;
                s = IJ.d2s(v, digits);
                this.ip.drawString(s, x - this.ip.getStringWidth(s) / 2, yNumbers);
            }
        }
        int maxNumWidth = 0;
        if ((this.flags & 0x2A) != 0) {
            int i2;
            int i1;
            double step = Math.abs((double)Math.max(this.frame.width / 12, 40) / this.yScale);
            step = this.niceNumber(step);
            if ((this.flags & 0x40) != 0) {
                i1 = (int)Math.floor(Math.min(this.yMin, this.yMax) / step + 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.yMin, this.yMax) / step - 1.0E-10);
                this.yMin = (double)i1 * step;
                this.yMax = (double)i2 * step;
                this.yScale = (double)this.frame.height / (this.yMax - this.yMin);
            } else {
                i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
            }
            int digits2 = -((int)Math.floor(Math.log(step) / Math.log(10.0) + 1.0E-6));
            if (digits2 < 0) {
                digits2 = 0;
            }
            if (digits2 > 5) {
                digits2 = -3;
            }
            int x1 = 60;
            int x2 = 60 + this.frame.width;
            for (i = 0; i <= i2 - i1; ++i) {
                v = (double)(i + i1) * step;
                int y = 15 + this.frame.height - (int)Math.round((v - this.yMin) * this.yScale);
                if ((this.flags & 0x20) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(x1, y, x2, y);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 8) != 0) {
                    this.ip.drawLine(x1, y, x1 + 3, y);
                    this.ip.drawLine(x2, y, x2 - 3, y);
                }
                if ((this.flags & 2) == 0) continue;
                s = IJ.d2s(v, digits2);
                int w = this.ip.getStringWidth(s);
                if (w > maxNumWidth) {
                    maxNumWidth = w;
                }
                this.ip.drawString(s, 60 - w - 4, y + fontMaxAscent / 2 + 1);
            }
        }
        if ((this.flags & 2) == 0) {
            int digits3 = this.getDigits(this.yMin, this.yMax);
            String s2 = IJ.d2s(this.yMax, digits3);
            int sw = this.ip.getStringWidth(s2);
            if (sw + 4 > 60) {
                this.ip.drawString(s2, 4, 11);
            } else {
                this.ip.drawString(s2, 60 - this.ip.getStringWidth(s2) - 4, 25);
            }
            s2 = IJ.d2s(this.yMin, digits3);
            sw = this.ip.getStringWidth(s2);
            if (sw + 4 > 60) {
                this.ip.drawString(s2, 4, 15 + this.frame.height);
            } else {
                this.ip.drawString(s2, 60 - this.ip.getStringWidth(s2) - 4, 15 + this.frame.height);
            }
        }
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 60;
        int y = 15 + this.frame.height + fm.getAscent() + 6;
        if ((this.flags & 1) == 0) {
            digits = this.getDigits(this.xMin, this.xMax);
            this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
            String s3 = IJ.d2s(this.xMax, digits);
            this.ip.drawString(s3, x + this.frame.width - this.ip.getStringWidth(s3) + 6, y);
        } else {
            y += fm.getAscent();
        }
        this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 6);
        this.drawYLabel(this.yLabel, 60 - maxNumWidth - 4, 15, this.frame.height, fm);
    }

    double niceNumber(double v) {
        double base = Math.pow(10.0, Math.floor(Math.log(v) / Math.log(10.0) - 1.0E-6));
        if (v > 5.0000001 * base) {
            return 10.0 * base;
        }
        if (v > 2.0000001 * base) {
            return 5.0 * base;
        }
        return 2.0 * base;
    }

    void createImage() {
        if (this.ip != null) {
            return;
        }
        int width = this.plotWidth + 60 + 18;
        int height = this.plotHeight + 15 + 40;
        byte[] pixels = new byte[width * height];
        for (int i = 0; i < width * height; ++i) {
            pixels[i] = -1;
        }
        this.ip = new ByteProcessor(width, height, pixels, null);
    }

    int getDigits(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 1;
        if (n < 10.0) {
            digits = 2;
        }
        if (n < 0.01) {
            digits = 3;
        }
        if (n < 0.001) {
            digits = 4;
        }
        if (n < 1.0E-4) {
            digits = -3;
        }
        return digits;
    }

    public void draw() {
        if (this.plotDrawn) {
            return;
        }
        this.plotDrawn = true;
        this.createImage();
        this.setup();
        if (this.drawPending) {
            int i;
            int[] xpoints = new int[this.nPoints];
            int[] ypoints = new int[this.nPoints];
            for (i = 0; i < this.nPoints; ++i) {
                xpoints[i] = 60 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
                ypoints[i] = 15 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin) * this.yScale);
            }
            this.drawPolyline(this.ip, xpoints, ypoints, this.nPoints, true);
            if (this.errorBars != null) {
                xpoints = new int[2];
                ypoints = new int[2];
                for (i = 0; i < this.nPoints; ++i) {
                    xpoints[0] = xpoints[1] = 60 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
                    ypoints[0] = 15 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin - (double)this.errorBars[i]) * this.yScale);
                    ypoints[1] = 15 + this.frame.height - (int)(((double)this.yValues[i] - this.yMin + (double)this.errorBars[i]) * this.yScale);
                    this.drawPolyline(this.ip, xpoints, ypoints, 2, false);
                }
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        if (this.lineWidth > 5) {
            this.ip.setLineWidth(5);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        this.ip.setLineWidth(this.lineWidth);
    }

    void drawPolyline(ImageProcessor ip, int[] x, int[] y, int n, boolean clip) {
        if (clip) {
            ip.setClipRect(this.frame);
        }
        ip.moveTo(x[0], y[0]);
        for (int i = 0; i < n; ++i) {
            ip.lineTo(x[i], y[i]);
        }
        if (clip) {
            ip.setClipRect(null);
        }
    }

    void drawYLabel(String yLabel, int x, int y, int height, FontMetrics fm) {
        if (yLabel.equals("")) {
            return;
        }
        int w = fm.stringWidth(yLabel) + 5;
        int h = fm.getHeight() + 5;
        ImageProcessor label = new ByteProcessor(w, h);
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(this.font);
        label.setAntialiasedText(true);
        int descent = fm.getDescent();
        label.drawString(yLabel, 0, h - descent);
        label = label.rotateLeft();
        int y2 = y + (height - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = Math.max(x - h, 0);
        this.ip.insert(label, x2, y2);
    }

    ImageProcessor getBlankProcessor() {
        this.createImage();
        return this.ip;
    }

    String getCoordinates(int x, int y) {
        String text = "";
        if (!this.frame.contains(x, y)) {
            return text;
        }
        if (this.fixedYScale || this.multiplePlots) {
            double xv = (double)(x - 60) / this.xScale + this.xMin;
            double yv = (double)(15 + this.frameHeight - y) / this.yScale + this.yMin;
            text = "X=" + IJ.d2s(xv, this.getDigits(xv, xv)) + ", Y=" + IJ.d2s(yv, this.getDigits(yv, yv));
        } else {
            int index = (int)((double)(x - this.frame.x) / ((double)this.frame.width / (double)this.nPoints));
            if (index > 0 && index < this.nPoints) {
                double xv = this.xValues[index];
                double yv = this.yValues[index];
                text = "X=" + IJ.d2s(xv, this.getDigits(xv, xv)) + ", Y=" + IJ.d2s(yv, this.getDigits(yv, yv));
            }
        }
        return text;
    }

    public ImageProcessor getProcessor() {
        this.draw();
        return this.ip;
    }

    public ImagePlus getImagePlus() {
        this.draw();
        ImagePlus img = new ImagePlus(this.title, this.ip);
        Calibration cal = img.getCalibration();
        cal.xOrigin = 60.0;
        cal.yOrigin = (double)(15 + this.frameHeight) + this.yMin * this.yScale;
        cal.pixelWidth = 1.0 / this.xScale;
        cal.pixelHeight = 1.0 / this.yScale;
        cal.setInvertY(true);
        return img;
    }

    public PlotWindow show() {
        this.draw();
        if (Prefs.useInvertingLut && this.ip instanceof ByteProcessor && !Interpreter.isBatchMode() && IJ.getInstance() != null) {
            this.ip.invertLut();
            this.ip.invert();
        }
        if (IJ.macroRunning() && IJ.getInstance() == null || Interpreter.isBatchMode()) {
            ImagePlus imp = new ImagePlus(this.title, this.ip);
            WindowManager.setTempCurrentImage(imp);
            imp.setProperty("XValues", this.xValues);
            imp.setProperty("YValues", this.yValues);
            Interpreter.addBatchModeImage(imp);
            return null;
        }
        ImageWindow.centerNextImage();
        return new PlotWindow(this);
    }

    private void storeData(float[] xvalues, float[] yvalues) {
        this.storedData.add(xvalues);
        this.storedData.add(yvalues);
    }
}

