/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.macro.Interpreter;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SaveDialog {
    private String dir;
    private String name;
    private String title;
    private String ext;

    public SaveDialog(String title, String defaultName, String extension) {
        this.title = title;
        this.ext = extension;
        if (this.isMacro()) {
            return;
        }
        String defaultDir = OpenDialog.getDefaultDirectory();
        defaultName = SaveDialog.setExtension(defaultName, extension);
        if (Prefs.useJFileChooser) {
            this.jSave(title, defaultDir, defaultName);
        } else {
            this.save(title, defaultDir, defaultName);
        }
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    public SaveDialog(String title, String defaultDir, String defaultName, String extension) {
        this.title = title;
        this.ext = extension;
        if (this.isMacro()) {
            return;
        }
        defaultName = SaveDialog.setExtension(defaultName, extension);
        if (Prefs.useJFileChooser) {
            this.jSave(title, defaultDir, defaultName);
        } else {
            this.save(title, defaultDir, defaultName);
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    boolean isMacro() {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            String path = Macro.getValue(macroOptions, this.title, null);
            if (path == null) {
                path = Macro.getValue(macroOptions, "path", null);
            }
            if (path != null && path.indexOf(".") == -1 && !new File(path).exists()) {
                Interpreter interp;
                String path2;
                if (path.startsWith("&")) {
                    path = path.substring(1);
                }
                String string = path2 = (interp = Interpreter.getInstance()) != null ? interp.getStringVariable(path) : null;
                if (path2 != null) {
                    path = path2;
                }
            }
            if (path != null) {
                Opener o = new Opener();
                this.dir = o.getDir(path);
                this.name = o.getName(path);
                return true;
            }
        }
        return false;
    }

    public static String setExtension(String name, String extension) {
        if (name == null || extension == null || extension.length() == 0) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        name = dotIndex >= 0 && name.length() - dotIndex <= 5 ? (dotIndex + 1 < name.length() && Character.isDigit(name.charAt(dotIndex + 1)) ? name + extension : name.substring(0, dotIndex) + extension) : name + extension;
        return name;
    }

    void jSave(String title, String defaultDir, String defaultName) {
        Java2.setSystemLookAndFeel();
        if (EventQueue.isDispatchThread()) {
            this.jSaveDispatchThread(title, defaultDir, defaultName);
        } else {
            this.jSaveInvokeAndWait(title, defaultDir, defaultName);
        }
    }

    void jSaveDispatchThread(String title, String defaultDir, String defaultName) {
        int ret;
        int returnVal;
        File f;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        if (defaultDir != null && (f = new File(defaultDir)) != null) {
            fc.setCurrentDirectory(f);
        }
        if (defaultName != null) {
            fc.setSelectedFile(new File(defaultName));
        }
        if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File f2 = fc.getSelectedFile();
        if (f2.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
            f2 = null;
        }
        if (f2 == null) {
            Macro.abort();
        } else {
            this.dir = fc.getCurrentDirectory().getPath() + File.separator;
            this.name = fc.getName(f2);
            if (this.name != null && this.name.indexOf(".") == -1) {
                this.name = SaveDialog.setExtension(this.name, this.ext);
            }
        }
    }

    void jSaveInvokeAndWait(final String title, final String defaultDir, final String defaultName) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    int ret;
                    int returnVal;
                    File f;
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(title);
                    if (defaultDir != null && (f = new File(defaultDir)) != null) {
                        fc.setCurrentDirectory(f);
                    }
                    if (defaultName != null) {
                        fc.setSelectedFile(new File(defaultName));
                    }
                    if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
                        Macro.abort();
                        return;
                    }
                    File f2 = fc.getSelectedFile();
                    if (f2.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
                        f2 = null;
                    }
                    if (f2 == null) {
                        Macro.abort();
                    } else {
                        SaveDialog.this.dir = fc.getCurrentDirectory().getPath() + File.separator;
                        SaveDialog.this.name = fc.getName(f2);
                        if (SaveDialog.this.name != null && SaveDialog.this.name.indexOf(".") == -1) {
                            SaveDialog.this.name = SaveDialog.setExtension(SaveDialog.this.name, SaveDialog.this.ext);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void save(String title, String defaultDir, String defaultName) {
        ImageJ ij = IJ.getInstance();
        Frame parent = ij != null ? ij : new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            fd.setFile(defaultName);
        }
        if (defaultDir != null) {
            fd.setDirectory(defaultDir);
        }
        fd.show();
        this.name = fd.getFile();
        if (this.name != null && this.name.indexOf(".") == -1) {
            this.name = SaveDialog.setExtension(this.name, this.ext);
        }
        this.dir = fd.getDirectory();
        if (this.name == null) {
            Macro.abort();
        }
        fd.dispose();
        if (ij == null) {
            parent.dispose();
        }
    }

    public String getDirectory() {
        OpenDialog.setLastDirectory(this.dir);
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record) {
            Recorder.recordPath(this.title, this.dir + this.name);
        }
        OpenDialog.setLastName(this.name);
        return this.name;
    }
}

