/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.Prefs;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TiffEncoder {
    static final int HDR_SIZE = 8;
    static final int MAP_SIZE = 768;
    static final int BPS_DATA_SIZE = 6;
    static final int SCALE_DATA_SIZE = 16;
    private FileInfo fi;
    private int bitsPerSample;
    private int photoInterp;
    private int samplesPerPixel;
    private int nEntries;
    private int ifdSize;
    private long imageOffset;
    private int imageSize;
    private long stackSize;
    private byte[] description;
    private int metaDataSize;
    private int nMetaDataTypes;
    private int nMetaDataEntries;
    private int nSliceLabels;
    private int extraMetaDataEntries;
    private int scaleSize;
    private boolean littleEndian = Prefs.intelByteOrder;
    private byte[] buffer = new byte[8];

    public TiffEncoder(FileInfo fi) {
        this.fi = fi;
        fi.intelByteOrder = this.littleEndian;
        this.bitsPerSample = 8;
        this.samplesPerPixel = 1;
        this.nEntries = 9;
        int bytesPerPixel = 1;
        int bpsSize = 0;
        int colorMapSize = 0;
        switch (fi.fileType) {
            case 0: {
                this.photoInterp = fi.whiteIsZero ? 0 : 1;
                break;
            }
            case 1: 
            case 2: {
                this.bitsPerSample = 16;
                this.photoInterp = fi.whiteIsZero ? 0 : 1;
                bytesPerPixel = 2;
                break;
            }
            case 4: {
                this.bitsPerSample = 32;
                this.photoInterp = fi.whiteIsZero ? 0 : 1;
                bytesPerPixel = 4;
                break;
            }
            case 6: {
                this.photoInterp = 2;
                this.samplesPerPixel = 3;
                bytesPerPixel = 3;
                bpsSize = 6;
                break;
            }
            case 12: {
                this.bitsPerSample = 16;
                this.photoInterp = 2;
                this.samplesPerPixel = 3;
                bytesPerPixel = 6;
                fi.nImages /= 3;
                bpsSize = 6;
                break;
            }
            case 5: {
                this.photoInterp = 3;
                this.nEntries = 10;
                colorMapSize = 1536;
                break;
            }
            default: {
                this.photoInterp = 0;
            }
        }
        if (fi.unit != null && fi.pixelWidth != 0.0 && fi.pixelHeight != 0.0) {
            this.nEntries += 3;
        }
        if (fi.fileType == 4) {
            ++this.nEntries;
        }
        this.makeDescriptionString();
        if (this.description != null) {
            ++this.nEntries;
        }
        this.imageSize = fi.width * fi.height * bytesPerPixel;
        this.stackSize = (long)this.imageSize * (long)fi.nImages;
        this.metaDataSize = this.getMetaDataSize();
        if (this.metaDataSize > 0) {
            this.nEntries += 2;
        }
        this.ifdSize = 2 + this.nEntries * 12 + 4;
        int descriptionSize = this.description != null ? this.description.length : 0;
        this.scaleSize = fi.unit != null && fi.pixelWidth != 0.0 && fi.pixelHeight != 0.0 ? 16 : 0;
        this.imageOffset = 8 + this.ifdSize + bpsSize + descriptionSize + this.scaleSize + colorMapSize + this.nMetaDataEntries * 4 + this.metaDataSize;
        fi.offset = (int)this.imageOffset;
    }

    public void write(OutputStream out) throws IOException {
        this.writeHeader(out);
        long nextIFD = 0L;
        if (this.fi.nImages > 1) {
            nextIFD = this.imageOffset + this.stackSize;
        }
        if (nextIFD + (long)(this.fi.nImages * this.ifdSize) >= 0xFFFFFFFFL) {
            nextIFD = 0L;
        }
        this.writeIFD(out, (int)this.imageOffset, (int)nextIFD);
        if (this.fi.fileType == 6 || this.fi.fileType == 12) {
            this.writeBitsPerPixel(out);
        }
        if (this.description != null) {
            this.writeDescription(out);
        }
        if (this.scaleSize > 0) {
            this.writeScale(out);
        }
        if (this.fi.fileType == 5) {
            this.writeColorMap(out);
        }
        if (this.metaDataSize > 0) {
            this.writeMetaData(out);
        }
        new ImageWriter(this.fi).write(out);
        if (nextIFD > 0L) {
            int ifdSize2 = this.ifdSize;
            if (this.metaDataSize > 0) {
                this.metaDataSize = 0;
                this.nEntries -= 2;
                ifdSize2 -= 24;
            }
            for (int i = 2; i <= this.fi.nImages; ++i) {
                nextIFD = i == this.fi.nImages ? 0L : (nextIFD += (long)ifdSize2);
                this.imageOffset += (long)this.imageSize;
                this.writeIFD(out, (int)this.imageOffset, (int)nextIFD);
            }
        }
    }

    public void write(DataOutputStream out) throws IOException {
        this.write((OutputStream)out);
    }

    int getMetaDataSize() {
        int i;
        this.nSliceLabels = 0;
        this.nMetaDataEntries = 0;
        int size = 0;
        int nTypes = 0;
        if (this.fi.info != null && this.fi.info.length() > 0) {
            this.nMetaDataEntries = 1;
            size = this.fi.info.length() * 2;
            ++nTypes;
        }
        if (this.fi.sliceLabels != null) {
            int i2;
            int max = Math.min(this.fi.sliceLabels.length, this.fi.nImages);
            boolean isNonNullLabel = false;
            for (i2 = 0; i2 < max; ++i2) {
                if (this.fi.sliceLabels[i2] == null || this.fi.sliceLabels[i2].length() <= 0) continue;
                isNonNullLabel = true;
                break;
            }
            if (isNonNullLabel) {
                for (i2 = 0; i2 < max; ++i2) {
                    ++this.nSliceLabels;
                    if (this.fi.sliceLabels[i2] == null) continue;
                    size += this.fi.sliceLabels[i2].length() * 2;
                }
                if (this.nSliceLabels > 0) {
                    ++nTypes;
                }
                this.nMetaDataEntries += this.nSliceLabels;
            }
        }
        if (this.fi.displayRanges != null) {
            ++this.nMetaDataEntries;
            size += this.fi.displayRanges.length * 8;
            ++nTypes;
        }
        if (this.fi.channelLuts != null) {
            for (i = 0; i < this.fi.channelLuts.length; ++i) {
                if (this.fi.channelLuts[i] == null) continue;
                size += this.fi.channelLuts[i].length;
            }
            ++nTypes;
            this.nMetaDataEntries += this.fi.channelLuts.length;
        }
        if (this.fi.roi != null) {
            ++this.nMetaDataEntries;
            size += this.fi.roi.length;
            ++nTypes;
        }
        if (this.fi.overlay != null) {
            for (i = 0; i < this.fi.overlay.length; ++i) {
                if (this.fi.overlay[i] == null) continue;
                size += this.fi.overlay[i].length;
            }
            ++nTypes;
            this.nMetaDataEntries += this.fi.overlay.length;
        }
        if (this.fi.metaDataTypes != null && this.fi.metaData != null && this.fi.metaData[0] != null && this.fi.metaDataTypes.length == this.fi.metaData.length) {
            this.extraMetaDataEntries = this.fi.metaData.length;
            nTypes += this.extraMetaDataEntries;
            this.nMetaDataEntries += this.extraMetaDataEntries;
            for (i = 0; i < this.extraMetaDataEntries; ++i) {
                if (this.fi.metaData[i] == null) continue;
                size += this.fi.metaData[i].length;
            }
        }
        if (this.nMetaDataEntries > 0) {
            ++this.nMetaDataEntries;
        }
        int hdrSize = 4 + nTypes * 8;
        if (size > 0) {
            size += hdrSize;
        }
        this.nMetaDataTypes = nTypes;
        return size;
    }

    void writeHeader(OutputStream out) throws IOException {
        byte[] hdr = new byte[8];
        if (this.littleEndian) {
            hdr[0] = 73;
            hdr[1] = 73;
            hdr[2] = 42;
            hdr[3] = 0;
            hdr[4] = 8;
            hdr[5] = 0;
            hdr[6] = 0;
            hdr[7] = 0;
        } else {
            hdr[0] = 77;
            hdr[1] = 77;
            hdr[2] = 0;
            hdr[3] = 42;
            hdr[4] = 0;
            hdr[5] = 0;
            hdr[6] = 0;
            hdr[7] = 8;
        }
        out.write(hdr);
    }

    void writeEntry(OutputStream out, int tag, int fieldType, int count, int value) throws IOException {
        this.writeShort(out, tag);
        this.writeShort(out, fieldType);
        this.writeInt(out, count);
        if (count == 1 && fieldType == 3) {
            this.writeShort(out, value);
            this.writeShort(out, 0);
        } else {
            this.writeInt(out, value);
        }
    }

    void writeIFD(OutputStream out, int imageOffset, int nextIFD) throws IOException {
        int tagDataOffset = 8 + this.ifdSize;
        this.writeShort(out, this.nEntries);
        this.writeEntry(out, 254, 4, 1, 0);
        this.writeEntry(out, 256, 4, 1, this.fi.width);
        this.writeEntry(out, 257, 4, 1, this.fi.height);
        if (this.fi.fileType == 6 || this.fi.fileType == 12) {
            this.writeEntry(out, 258, 3, 3, tagDataOffset);
            tagDataOffset += 6;
        } else {
            this.writeEntry(out, 258, 3, 1, this.bitsPerSample);
        }
        this.writeEntry(out, 262, 3, 1, this.photoInterp);
        if (this.description != null) {
            this.writeEntry(out, 270, 2, this.description.length, tagDataOffset);
            tagDataOffset += this.description.length;
        }
        this.writeEntry(out, 273, 4, 1, imageOffset);
        this.writeEntry(out, 277, 3, 1, this.samplesPerPixel);
        this.writeEntry(out, 278, 3, 1, this.fi.height);
        this.writeEntry(out, 279, 4, 1, this.imageSize);
        if (this.fi.unit != null && this.fi.pixelWidth != 0.0 && this.fi.pixelHeight != 0.0) {
            this.writeEntry(out, 282, 5, 1, tagDataOffset);
            this.writeEntry(out, 283, 5, 1, tagDataOffset + 8);
            tagDataOffset += 16;
            int unit = 1;
            if (this.fi.unit.equals("inch")) {
                unit = 2;
            } else if (this.fi.unit.equals("cm")) {
                unit = 3;
            }
            this.writeEntry(out, 296, 3, 1, unit);
        }
        if (this.fi.fileType == 4) {
            int format = 3;
            this.writeEntry(out, 339, 3, 1, format);
        }
        if (this.fi.fileType == 5) {
            this.writeEntry(out, 320, 3, 768, tagDataOffset);
            tagDataOffset += 1536;
        }
        if (this.metaDataSize > 0) {
            this.writeEntry(out, 50838, 4, this.nMetaDataEntries, tagDataOffset);
            this.writeEntry(out, 50839, 1, this.metaDataSize, tagDataOffset + 4 * this.nMetaDataEntries);
            tagDataOffset += this.nMetaDataEntries * 4 + this.metaDataSize;
        }
        this.writeInt(out, nextIFD);
    }

    void writeBitsPerPixel(OutputStream out) throws IOException {
        int bitsPerPixel = this.fi.fileType == 12 ? 16 : 8;
        this.writeShort(out, bitsPerPixel);
        this.writeShort(out, bitsPerPixel);
        this.writeShort(out, bitsPerPixel);
    }

    void writeScale(OutputStream out) throws IOException {
        double xscale = 1.0 / this.fi.pixelWidth;
        double yscale = 1.0 / this.fi.pixelHeight;
        double scale = 1000000.0;
        if (xscale > 1000.0) {
            scale = 1000.0;
        }
        this.writeInt(out, (int)(xscale * scale));
        this.writeInt(out, (int)scale);
        this.writeInt(out, (int)(yscale * scale));
        this.writeInt(out, (int)scale);
    }

    void writeDescription(OutputStream out) throws IOException {
        out.write(this.description, 0, this.description.length);
    }

    void writeColorMap(OutputStream out) throws IOException {
        byte[] colorTable16 = new byte[1536];
        int j = this.littleEndian ? 1 : 0;
        for (int i = 0; i < this.fi.lutSize; ++i) {
            colorTable16[j] = this.fi.reds[i];
            colorTable16[512 + j] = this.fi.greens[i];
            colorTable16[1024 + j] = this.fi.blues[i];
            j += 2;
        }
        out.write(colorTable16);
    }

    void writeMetaData(OutputStream out) throws IOException {
        int i;
        this.writeInt(out, 4 + this.nMetaDataTypes * 8);
        if (this.fi.info != null && this.fi.info.length() > 0) {
            this.writeInt(out, this.fi.info.length() * 2);
        }
        for (i = 0; i < this.nSliceLabels; ++i) {
            if (this.fi.sliceLabels[i] == null) {
                this.writeInt(out, 0);
                continue;
            }
            this.writeInt(out, this.fi.sliceLabels[i].length() * 2);
        }
        if (this.fi.displayRanges != null) {
            this.writeInt(out, this.fi.displayRanges.length * 8);
        }
        if (this.fi.channelLuts != null) {
            for (i = 0; i < this.fi.channelLuts.length; ++i) {
                this.writeInt(out, this.fi.channelLuts[i].length);
            }
        }
        if (this.fi.roi != null) {
            this.writeInt(out, this.fi.roi.length);
        }
        if (this.fi.overlay != null) {
            for (i = 0; i < this.fi.overlay.length; ++i) {
                this.writeInt(out, this.fi.overlay[i].length);
            }
        }
        for (i = 0; i < this.extraMetaDataEntries; ++i) {
            this.writeInt(out, this.fi.metaData[i].length);
        }
        this.writeInt(out, 0x494A494A);
        if (this.fi.info != null) {
            this.writeInt(out, 1768842863);
            this.writeInt(out, 1);
        }
        if (this.nSliceLabels > 0) {
            this.writeInt(out, 1818321516);
            this.writeInt(out, this.nSliceLabels);
        }
        if (this.fi.displayRanges != null) {
            this.writeInt(out, 1918987879);
            this.writeInt(out, 1);
        }
        if (this.fi.channelLuts != null) {
            this.writeInt(out, 1819636851);
            this.writeInt(out, this.fi.channelLuts.length);
        }
        if (this.fi.roi != null) {
            this.writeInt(out, 1919904032);
            this.writeInt(out, 1);
        }
        if (this.fi.overlay != null) {
            this.writeInt(out, 1870030194);
            this.writeInt(out, this.fi.overlay.length);
        }
        for (i = 0; i < this.extraMetaDataEntries; ++i) {
            this.writeInt(out, this.fi.metaDataTypes[i]);
            this.writeInt(out, 1);
        }
        if (this.fi.info != null) {
            this.writeChars(out, this.fi.info);
        }
        for (i = 0; i < this.nSliceLabels; ++i) {
            if (this.fi.sliceLabels[i] == null) continue;
            this.writeChars(out, this.fi.sliceLabels[i]);
        }
        if (this.fi.displayRanges != null) {
            for (i = 0; i < this.fi.displayRanges.length; ++i) {
                this.writeDouble(out, this.fi.displayRanges[i]);
            }
        }
        if (this.fi.channelLuts != null) {
            for (i = 0; i < this.fi.channelLuts.length; ++i) {
                out.write(this.fi.channelLuts[i]);
            }
        }
        if (this.fi.roi != null) {
            out.write(this.fi.roi);
        }
        if (this.fi.overlay != null) {
            for (i = 0; i < this.fi.overlay.length; ++i) {
                out.write(this.fi.overlay[i]);
            }
        }
        for (i = 0; i < this.extraMetaDataEntries; ++i) {
            out.write(this.fi.metaData[i]);
        }
    }

    void makeDescriptionString() {
        if (this.fi.description != null) {
            if (this.fi.description.charAt(this.fi.description.length() - 1) != '\u0000') {
                this.fi.description = this.fi.description + " ";
            }
            this.description = this.fi.description.getBytes();
            this.description[this.description.length - 1] = 0;
        } else {
            this.description = null;
        }
    }

    final void writeShort(OutputStream out, int v) throws IOException {
        if (this.littleEndian) {
            out.write(v & 0xFF);
            out.write(v >>> 8 & 0xFF);
        } else {
            out.write(v >>> 8 & 0xFF);
            out.write(v & 0xFF);
        }
    }

    final void writeInt(OutputStream out, int v) throws IOException {
        if (this.littleEndian) {
            out.write(v & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 24 & 0xFF);
        } else {
            out.write(v >>> 24 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v & 0xFF);
        }
    }

    final void writeLong(OutputStream out, long v) throws IOException {
        if (this.littleEndian) {
            this.buffer[7] = (byte)(v >>> 56);
            this.buffer[6] = (byte)(v >>> 48);
            this.buffer[5] = (byte)(v >>> 40);
            this.buffer[4] = (byte)(v >>> 32);
            this.buffer[3] = (byte)(v >>> 24);
            this.buffer[2] = (byte)(v >>> 16);
            this.buffer[1] = (byte)(v >>> 8);
            this.buffer[0] = (byte)v;
            out.write(this.buffer, 0, 8);
        } else {
            this.buffer[0] = (byte)(v >>> 56);
            this.buffer[1] = (byte)(v >>> 48);
            this.buffer[2] = (byte)(v >>> 40);
            this.buffer[3] = (byte)(v >>> 32);
            this.buffer[4] = (byte)(v >>> 24);
            this.buffer[5] = (byte)(v >>> 16);
            this.buffer[6] = (byte)(v >>> 8);
            this.buffer[7] = (byte)v;
            out.write(this.buffer, 0, 8);
        }
    }

    final void writeDouble(OutputStream out, double v) throws IOException {
        this.writeLong(out, Double.doubleToLongBits(v));
    }

    final void writeChars(OutputStream out, String s) throws IOException {
        int len = s.length();
        if (this.littleEndian) {
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                out.write(v & 0xFF);
                out.write(v >>> 8 & 0xFF);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                out.write(v >>> 8 & 0xFF);
                out.write(v & 0xFF);
            }
        }
    }
}

