/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.text.MaskFormatter;
import org.rhwlab.acetree.ControlCallback;
import org.rhwlab.utils.SpringUtilities;

public class InputCtrl
extends JPanel
implements ActionListener {
    private JFormattedTextField iTimeField;
    private JTextField iNameField;
    private ControlCallback iCC;
    static final int GAP = 10;
    public static final int WIDTH = 200;
    public static final int HEIGHT = 100;

    public InputCtrl(ControlCallback cc) {
        this.iCC = cc;
        this.createPanes();
    }

    private void createPanes() {
        JPanel p = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                Dimension pref = this.getPreferredSize();
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
        p.setLayout(new BoxLayout(p, 3));
        Border paneEdge = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        Border blackline = BorderFactory.createLineBorder(Color.black);
        this.setBorder(blackline);
        p.add(this.createEntryFields());
        p.add(this.createButtons());
        this.add(p);
    }

    protected JComponent createEntryFields() {
        JPanel panel = new JPanel(new SpringLayout());
        String[] labelStrings = new String[]{"image time: ", "index/cell name: "};
        JLabel[] labels = new JLabel[labelStrings.length];
        JComponent[] fields = new JComponent[labelStrings.length];
        int fieldNum = 0;
        MaskFormatter mf = this.createFormatter("####");
        this.iTimeField = new JFormattedTextField(mf);
        this.iTimeField.setFocusLostBehavior(3);
        this.iNameField = new JTextField();
        this.iNameField.setColumns(15);
        fields[fieldNum++] = this.iTimeField;
        fields[fieldNum++] = this.iNameField;
        for (int i = 0; i < labelStrings.length; ++i) {
            labels[i] = new JLabel(labelStrings[i], 11);
            labels[i].setLabelFor(fields[i]);
            panel.add(labels[i]);
            panel.add(fields[i]);
        }
        SpringUtilities.makeCompactGrid(panel, labelStrings.length, 2, 10, 10, 10, 5);
        return panel;
    }

    protected MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
            System.exit(-1);
        }
        return formatter;
    }

    protected JComponent createButtons() {
        JPanel panel = new JPanel(new FlowLayout(4));
        panel.setMinimumSize(new Dimension(200, 100));
        JButton button = new JButton("Get cell");
        button.addActionListener(this);
        panel.add(button);
        button = new JButton("Clear");
        button.addActionListener(this);
        button.setActionCommand("clear");
        panel.add(button);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return panel;
    }

    public void getIt() {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(this.iTimeField.getText());
        v.add(this.iNameField.getText());
        this.iCC.controlCallback(v);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("clear".equals(e.getActionCommand())) {
            this.iTimeField.setValue(null);
            this.iNameField.setText("");
        } else {
            this.getIt();
        }
    }

    public Component getTimeField() {
        return this.iTimeField;
    }

    public Component getNameField() {
        return this.iNameField;
    }

    public static void main(String[] args) {
    }
}

