/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.util.Hashtable;
import java.util.Vector;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;

public class NucUtils {
    private static Hashtable anteriorDaughter;
    private static Hashtable parent;
    private static double cZPixRes;
    private static final String[] posteriorD;
    private static final String[] anteriorD;
    private static final String[] parentN;
    private static final int PLANE = 3;
    private static final int DIA = 5;
    private static final int CELLNAME = 4;
    private static final int DEAD = -1;
    public static final String XYRES = "xy_res";
    public static final String ZRES = "z_res";
    public static final String TIMEEND = "time_end";
    public static final String PLANEEND = "plane_end";
    public static final String CS = ", ";
    public static final float HALFROUND = 0.5f;

    public static double getZPixRes() {
        return cZPixRes;
    }

    public static void setZPixRes(double zpixres) {
        cZPixRes = zpixres;
    }

    public static double nucDiameter(Nucleus n, double imgPlane) {
        if (n == null) {
            return -1.0;
        }
        double r = -0.5;
        double cellPlane = n.z;
        double R = (double)n.size / 2.0;
        double y = (cellPlane - imgPlane) * cZPixRes / R;
        double r2 = 1.0 - y * y;
        if (r2 >= 0.0) {
            r = Math.sqrt(r2) * R;
        }
        return 2.0 * r;
    }

    public static boolean hasCircle(Nucleus n, double imgPlane) {
        return NucUtils.nucDiameter(n, imgPlane) > 0.0;
    }

    public static int distance(Nucleus n1, Nucleus n2) {
        int z1 = (int)Math.round((double)n1.z * cZPixRes);
        int z2 = (int)Math.round((double)n2.z * cZPixRes);
        int dz = z1 - z2;
        int dx = n1.x - n2.x;
        int dy = n1.y - n2.y;
        int d = dx * dx + dy * dy + dz * dz;
        double dd = Math.sqrt(d);
        return (int)Math.round(dd);
    }

    public static Nucleus meanPos(Nucleus n1, Nucleus n2) {
        int x = (n1.x + n2.x) / 2;
        int y = (n1.y + n2.y) / 2;
        double z = (n1.z + n2.z) / 2.0f;
        Nucleus n = new Nucleus();
        n.x = x;
        n.y = y;
        n.z = (float)z;
        return n;
    }

    public static String makeHashKey(int index, Nucleus n) {
        return String.valueOf(index * 1000 + n.index);
    }

    public static Nucleus getCurrentCellData(Vector nucData, String cellName) {
        Nucleus r = null;
        boolean found = false;
        for (int j = 0; j < nucData.size(); ++j) {
            Nucleus n = (Nucleus)nucData.elementAt(j);
            if (!n.identity.equals(cellName)) continue;
            found = true;
            r = n;
            break;
        }
        return r;
    }

    public static Nucleus getCurrentCellNucleus(Vector nucData, Cell cell) {
        Nucleus r = null;
        if (cell == null) {
            return r;
        }
        boolean found = false;
        String hashKey = cell.getHashKey();
        if (hashKey == null) {
            return r;
        }
        for (int j = 0; j < nucData.size(); ++j) {
            Nucleus n = (Nucleus)nucData.elementAt(j);
            if (n.status < 0 || n.hashKey == null || !n.hashKey.equals(hashKey)) continue;
            found = true;
            r = n;
            break;
        }
        return r;
    }

    public static Nucleus getParent(Vector nucData0, Vector nucData1, String daughterName) {
        Nucleus n = null;
        Nucleus n2 = null;
        for (int j = 0; j < nucData1.size(); ++j) {
            n2 = (Nucleus)nucData1.elementAt(j);
            if (n2.identity.equals(daughterName)) break;
        }
        try {
            n = (Nucleus)nucData0.elementAt(n2.predecessor - 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        return n;
    }

    public static Nucleus getParent(Vector nucData, String daughterName) {
        Nucleus n = null;
        Nucleus n2 = null;
        for (int j = 0; j < nucData.size(); ++j) {
            n2 = (Nucleus)nucData.elementAt(j);
            if (n2.identity.length() == 0 || !NucUtils.isParent(n2.identity, daughterName)) continue;
            n = n2;
            break;
        }
        return n;
    }

    private static boolean isParent(String parentName, String daughterName) {
        String s;
        if (parent == null) {
            NucUtils.initializeHashtables();
        }
        if ((s = (String)parent.get(daughterName)) != null) {
            return s.equals(parentName);
        }
        int k = daughterName.indexOf(parentName);
        return k == 0;
    }

    private static boolean isDaughter(String daughterName, String parentName) {
        String p;
        if (parent == null) {
            NucUtils.initializeHashtables();
        }
        if ((p = (String)parent.get(daughterName)) != null) {
            return p.equals(parentName);
        }
        if (daughterName.length() != parentName.length() + 1) {
            return false;
        }
        return daughterName.indexOf(parentName) != -1;
    }

    private static boolean isAnteriorDaughter(String daughterName) {
        if (parent == null) {
            NucUtils.initializeHashtables();
        }
        if (anteriorDaughter.containsKey(daughterName)) {
            return true;
        }
        char x = daughterName.charAt(daughterName.length() - 1);
        return x == 'a' || x == 'd' || x == 'l';
    }

    private static void initializeHashtables() {
        int i;
        anteriorDaughter = new Hashtable();
        for (i = 0; i < anteriorD.length; ++i) {
            anteriorDaughter.put(anteriorD[i], anteriorD[i]);
        }
        parent = new Hashtable();
        for (i = 0; i < parentN.length; ++i) {
            parent.put(anteriorD[i], parentN[i]);
        }
        for (i = 0; i < parentN.length; ++i) {
            parent.put(posteriorD[i], parentN[i]);
        }
    }

    public static int countLiveCells(Vector nucData) {
        int k = 0;
        for (int j = 0; j < nucData.size(); ++j) {
            Nucleus n = (Nucleus)nucData.elementAt(j);
            if (n.status == -1) continue;
            ++k;
        }
        return k;
    }

    public static String[] getCurrentCellData(Vector nucData, String cellName, String x) {
        String[] sa = null;
        boolean found = false;
        int j = nucData.size();
        for (int i = 0; i < j; ++i) {
            sa = (String[])nucData.elementAt(i);
            if (!sa[4].equals(cellName)) continue;
            found = true;
            break;
        }
        if (found) {
            return sa;
        }
        return null;
    }

    public static void main(String[] args) {
    }

    static {
        posteriorD = new String[]{"P1", "P2", "P3", "P4", "Z3", "E"};
        anteriorD = new String[]{"AB", "EMS", "C", "D", "Z2", "MS"};
        parentN = new String[]{"P0", "P1", "P2", "P3", "P4", "EMS"};
    }
}

