/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.acetree;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.dbaccess.DBAccess;
import org.rhwlab.dbaccess.EmbryoXML;
import org.rhwlab.snight.Config;

public class OpenFromDB
extends JDialog
implements ActionListener {
    AceTree iAceTree;
    JTextField iSeries;
    JButton iOpen;
    private JRadioButton iNewCanonical;
    private JRadioButton iManual;
    private JRadioButton iTraditional;
    private JRadioButton iNew;
    private int iNamingMethod;
    private JCheckBox iEditedPts;
    private static final String STANDARD = "Standard";
    private static final String NEWCANONICAL = "New canonical";
    private static final String MANUAL = "Manual";

    public OpenFromDB(AceTree acetree) {
        OpenFromDB.println("OpenFromDB, DBAccess.cDBLocation=" + DBAccess.cDBLocation);
        this.iAceTree = acetree;
        this.setTitle("Open from DB");
        this.setDefaultCloseOperation(2);
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iSeries = new JTextField(30);
        p.add(this.iSeries);
        this.iOpen = new JButton("open");
        p.add(this.iOpen);
        this.iOpen.addActionListener(this);
        this.iNamingMethod = Config.cDefaultNaming;
        this.addIdentityChoices(p);
        this.addDBChoices(p);
        this.addEditedPointsCheckbox(p);
        this.setVisible(true);
        this.pack();
    }

    private void addIdentityChoices(JPanel mp) {
        this.iNewCanonical = new JRadioButton(NEWCANONICAL);
        this.iManual = new JRadioButton(MANUAL);
        ButtonGroup bg = new ButtonGroup();
        JPanel rp = new JPanel();
        Border blackline = BorderFactory.createLineBorder(Color.black);
        rp.setBorder(blackline);
        rp.setLayout(new GridLayout(0, 1));
        bg.add(this.iNewCanonical);
        bg.add(this.iManual);
        this.iNewCanonical.setSelected(this.iNamingMethod == 3);
        this.iManual.setSelected(this.iNamingMethod == 2);
        rp.add(new JLabel("Identification mode"));
        rp.add(this.iNewCanonical);
        rp.add(this.iManual);
        mp.add(rp);
    }

    private void addDBChoices(JPanel mp) {
        this.iTraditional = new JRadioButton("traditional");
        this.iNew = new JRadioButton("new");
        ButtonGroup bg = new ButtonGroup();
        JPanel rp = new JPanel();
        Border blackline = BorderFactory.createLineBorder(Color.black);
        rp.setBorder(blackline);
        rp.setLayout(new GridLayout(0, 1));
        bg.add(this.iTraditional);
        bg.add(this.iNew);
        this.iNew.setSelected(true);
        OpenFromDB.println("addDBChoices, " + DBAccess.cDBLocation);
        rp.add(new JLabel("Database"));
        rp.add(this.iTraditional);
        rp.add(this.iNew);
        mp.add(rp);
    }

    private void addEditedPointsCheckbox(JPanel mp) {
        this.iEditedPts = new JCheckBox("Use edited timepoints only");
        this.iEditedPts.setSelected(false);
        JPanel rp = new JPanel();
        Border blackline = BorderFactory.createLineBorder(Color.black);
        rp.setBorder(blackline);
        rp.setLayout(new GridLayout(0, 1));
        rp.add(this.iEditedPts);
        mp.add(rp);
    }

    void handleRadioButtons() {
        DBAccess.cDBLocation = this.iTraditional.isSelected() ? "/nfs/waterston/embryoDBnew" : "/nfs/waterston/embryoDB";
        Config.cDefaultNaming = this.iManual.isSelected() ? 2 : 3;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iOpen) {
            this.handleRadioButtons();
            String sr = "";
            String s = this.iSeries.getText();
            File f = new File(s);
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                    sr = br.readLine();
                    while (sr != null && sr.length() > 2) {
                        boolean first = true;
                        if (sr.indexOf("#") != 0) {
                            String[] sa = sr.split(" ");
                            sr = sa[0];
                            System.out.println("\n\n***series: " + sr);
                            try {
                                EmbryoXML exml = new EmbryoXML(sr);
                                String annots = exml.iRecord[8];
                                String atconfig = exml.iRecord[9];
                                String editedPts = exml.iRecord[11];
                                String configFile = annots + "/dats/" + atconfig;
                                this.iAceTree.setConfigFileName(configFile);
                                Config config = Config.createConfigFromXMLFile(configFile);
                                if (this.iEditedPts.isSelected()) {
                                    config.setEndingIndex(Integer.parseInt(editedPts));
                                }
                                this.iAceTree.bringUpSeriesData(config);
                                if (first) {
                                    this.iAceTree.bringUpSeriesUI(configFile);
                                    first = false;
                                }
                            }
                            catch (FileNotFoundException fnfe) {
                                fnfe.printStackTrace();
                            }
                        }
                        sr = br.readLine();
                    }
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                try {
                    EmbryoXML exml = new EmbryoXML(s);
                    String annots = exml.iRecord[8];
                    String atconfig = exml.iRecord[9];
                    String configFile = annots + "/dats/" + atconfig;
                    Config config = new Config(configFile);
                    if (this.iEditedPts.isSelected()) {
                        String editedPts = exml.iRecord[11];
                        config.setEndingIndex(Integer.parseInt(editedPts));
                    }
                    this.iAceTree.setConfigFileName(configFile);
                    this.iAceTree.bringUpSeriesUI(config);
                    this.dispose();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
            }
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent e, boolean bogus) {
        Object o = e.getSource();
        if (o == this.iOpen) {
            this.handleRadioButtons();
            String sr = "";
            String s = this.iSeries.getText();
            File f = new File(s);
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                    sr = br.readLine();
                    while (sr != null && sr.length() > 2) {
                        boolean first = true;
                        if (sr.indexOf("#") != 0) {
                            String[] sa = sr.split(" ");
                            sr = sa[0];
                            System.out.println("\n\n***series: " + sr);
                            try {
                                EmbryoXML exml = new EmbryoXML(sr);
                                String annots = exml.iRecord[8];
                                String atconfig = exml.iRecord[9];
                                String configFile = annots + "/dats/" + atconfig;
                                this.iAceTree.setConfigFileName(configFile);
                                this.iAceTree.bringUpSeriesData(configFile);
                                if (first) {
                                    this.iAceTree.bringUpSeriesUI(configFile);
                                    first = false;
                                }
                            }
                            catch (FileNotFoundException fnfe) {
                                fnfe.printStackTrace();
                            }
                        }
                        sr = br.readLine();
                    }
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                try {
                    EmbryoXML exml = new EmbryoXML(s);
                    String annots = exml.iRecord[8];
                    String atconfig = exml.iRecord[9];
                    String configFile = annots + "/dats/" + atconfig;
                    this.iAceTree.setConfigFileName(configFile);
                    this.iAceTree.bringUpSeriesUI(configFile);
                    this.dispose();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
            }
            this.dispose();
        }
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

