/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.io.FileSaver;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.AuxImageWindowXY;
import org.rhwlab.image.AuxImageWindowXZ;
import org.rhwlab.image.AuxImageWindowYZ;
import org.rhwlab.image.ZipImage;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;
import org.rhwlab.utils.Log;

public class Analysis10
extends Log {
    private JTextField iTextField;
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private static final String CLEAR = "Clear";
    private static final String TEST1 = "One";
    private static final String TEST2 = "All";
    private static final String TEST3 = "Test3";
    public static final Color[] COLOR = new Color[]{Color.RED, new Color(140, 70, 255), Color.GREEN, Color.YELLOW, Color.CYAN, Color.MAGENTA, Color.PINK, Color.LIGHT_GRAY, Color.WHITE};
    public static final int[] WIDTHS = new int[]{1, 2, 3};
    private static final String CS = ", ";

    public Analysis10(String title) {
        super(title);
        this.showMe();
        this.buildOutToolBar();
        this.initialize();
    }

    private void test1() {
        Analysis10.println("test1 entered");
        String s = this.iTextField.getText();
        String[] sa = s.split(CS);
        int time = Integer.parseInt(sa[0]);
        int x = Integer.parseInt(sa[1]);
        ImagePlus iplus = this.getOneXZ(time, x);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = String.valueOf(time) + "@" + x;
        new AuxImageWindowYZ(s2, iproc, this.iAceTree, x);
    }

    private void test1(boolean bogus) {
        Analysis10.println("test1 entered");
        String s = this.iTextField.getText();
        String[] sa = s.split(CS);
        int time = Integer.parseInt(sa[0]);
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        for (int i = 1; i <= planeEnd; ++i) {
            this.saveOneXY(time, i);
        }
    }

    private void test2() {
        Analysis10.println("test2 entered");
        String s = this.iTextField.getText();
        String[] sa = s.split(CS);
        int time = Integer.parseInt(sa[0]);
        int x = 0;
        ImageProcessor ip = this.getImageFromSecondPlane(time, 15);
        ImageProcessor ipG = this.getImage(time, 15);
        int y = 0;
        String ss = time + "_" + y;
        ImagePlus iplus = new ImagePlus(ss, ip);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = String.valueOf(time) + "@" + x;
        new AuxImageWindowXY(s2, ipG, iproc, this.iAceTree, x);
    }

    private ImageProcessor getImageFromSecondPlane(int time, int plane) {
        String imageFile = org.rhwlab.image.ImageWindow.cZipTifFilePath;
        imageFile = imageFile + "/" + org.rhwlab.image.ImageWindow.cTifPrefixR;
        imageFile = imageFile + this.iAceTree.makeImageName(time, plane);
        ImageProcessor ip = this.getRedData(imageFile);
        return ip;
    }

    private void test2(boolean bogus) {
        Analysis10.println("test2 entered");
        String s = this.iTextField.getText();
        String[] sa = s.split(CS);
        int time = Integer.parseInt(sa[0]);
        for (int x = 100; x < 610; x += 10) {
            this.saveOneXZ(time, x);
        }
    }

    private void test3() {
        Analysis10.println("test3 entered");
        String s = this.iTextField.getText();
        String[] sa = s.split(CS);
        int time = Integer.parseInt(sa[0]);
        int x = Integer.parseInt(sa[1]);
        ImagePlus iplus = this.getOneYZ(time, x);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = String.valueOf(time) + "@" + x;
        new AuxImageWindowXZ(s2, iproc, this.iAceTree, x);
    }

    private void test3(boolean bogus) {
        Analysis10.println("test3 entered");
        String s = this.iTextField.getText();
        String[] sa = s.split(CS);
        int time = Integer.parseInt(sa[0]);
        int x = Integer.parseInt(sa[1]);
        ImagePlus iplus = this.getOneXZ(time, x);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = String.valueOf(time) + "@" + x;
        new AuxImageWindowYZ(s2, iproc, this.iAceTree, x);
    }

    protected void showCentroids(int time, int x, ImageProcessor iproc) {
        double zPixRes = 11.0;
        Vector v = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(time - 1);
        iproc.setColor(COLOR[1]);
        iproc.setLineWidth(WIDTHS[1]);
        Object p = null;
        Enumeration e = v.elements();
        String currentCellName = this.iAceTree.getCurrentCell().getName();
        while (e.hasMoreElements()) {
            double u;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0 || !((u = this.nucDiameter(n, x)) > 0.0)) continue;
            int xx = (int)((double)n.z * zPixRes);
            iproc.setColor(COLOR[1]);
            iproc.drawPolygon(EUtils.pCircle(xx, n.y, (int)(u / 2.0)));
        }
    }

    public double nucDiameter(Nucleus n, double x) {
        if (n == null) {
            return -1.0;
        }
        double zPixRes = 11.0;
        double r = -0.5;
        double cellPlane = n.x;
        double R = (double)n.size / 2.0;
        double y = (cellPlane - x) / R;
        double r2 = 1.0 - y * y;
        if (r2 >= 0.0) {
            r = Math.sqrt(r2) * R;
        }
        return 2.0 * r;
    }

    private ImagePlus getOneXZ(int time, int x) {
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(11 * planeEnd - 1, org.rhwlab.image.ImageWindow.cImageHeight);
        for (int m = 1; m <= planeEnd; ++m) {
            ImageProcessor ip = this.getImage(time, m);
            for (int i = 0; i < ip.getHeight(); ++i) {
                int p = ip.getPixel(x, i);
                for (int k = 0; k < 11; ++k) {
                    bp.putPixel(k + m * 11, i, p);
                }
            }
        }
        String s = time + "_" + x;
        ImagePlus iplus = new ImagePlus(s, bp);
        return iplus;
    }

    private ImagePlus getOneYZ(int time, int y) {
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(org.rhwlab.image.ImageWindow.cImageWidth, 11 * planeEnd - 1);
        for (int m = 1; m <= planeEnd; ++m) {
            ImageProcessor ip = this.getImage(time, m);
            for (int i = 0; i < ip.getWidth(); ++i) {
                int p = ip.getPixel(i, y);
                for (int k = 0; k < 11; ++k) {
                    bp.putPixel(i, k + m * 11, p);
                }
            }
        }
        String s = time + "_" + y;
        ImagePlus iplus = new ImagePlus(s, bp);
        return iplus;
    }

    private void saveOneXY(int time, int plane) {
        ImageProcessor ip = this.getImage(time, plane);
        FileSaver fs = new FileSaver(new ImagePlus("", ip));
        String s = time + "_" + EUtils.makePaddedInt(plane);
        fs.saveAsGif("/home/biowolp/0tmp/breadthImages/gif/" + s + ".gif");
        Analysis10.println("/home/biowolp/0tmp/breadthImages/gif/" + s + ".gif");
    }

    private void saveOneXZ(int time, int x) {
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(11 * planeEnd - 1, org.rhwlab.image.ImageWindow.cImageHeight);
        for (int m = 1; m <= planeEnd; ++m) {
            ImageProcessor ip = this.getImage(time, m);
            for (int i = 0; i < ip.getHeight(); ++i) {
                int p = ip.getPixel(x, i);
                for (int k = 0; k < 11; ++k) {
                    bp.putPixel(k + m * 11, i, p);
                }
            }
        }
        FileSaver fs = new FileSaver(new ImagePlus("", bp));
        String s = time + "_" + x;
        fs.saveAsGif("/home/biowolp/0tmp/depthImages/gif/" + s + ".gif");
        Analysis10.println("/home/biowolp/0tmp/depthImages/" + s + ".gif");
    }

    private ImageProcessor getImage(int time, int plane) {
        String imageFile = org.rhwlab.image.ImageWindow.cZipTifFilePath;
        imageFile = imageFile + "/" + org.rhwlab.image.ImageWindow.cTifPrefix;
        imageFile = imageFile + this.iAceTree.makeImageName(time, plane);
        ImageProcessor ip = this.getRedData(imageFile);
        return ip;
    }

    private int[] processImage(int time, int plane) {
        String imageFile = org.rhwlab.image.ImageWindow.cZipTifFilePath;
        imageFile = imageFile + "/" + org.rhwlab.image.ImageWindow.cTifPrefix;
        imageFile = imageFile + this.iAceTree.makeImageName(time, plane);
        ImageProcessor ipRed = this.getRedData(imageFile);
        Analysis10.println("processImage: " + ipRed);
        ImagePlus iplus = new ImagePlus("testing", ipRed);
        int height = iplus.getHeight();
        Analysis10.println("processImage height=" + height);
        ImageWindow imgWin = new ImageWindow(iplus);
        return null;
    }

    private ImageProcessor getRedData(String greenName) {
        if (org.rhwlab.image.ImageWindow.cUseZip == 2) {
            return this.getRedZipData(greenName);
        }
        ImagePlus ip = null;
        try {
            FileInputStream fis = new FileInputStream(greenName);
            byte[] ba = org.rhwlab.image.ImageWindow.readByteArray(fis);
            ip = org.rhwlab.image.ImageWindow.openTiff(new ByteArrayInputStream(ba), false);
            fis.close();
            if (org.rhwlab.image.ImageWindow.imagewindowUseStack == 1) {
                int markerChannel = 1;
                ip = org.rhwlab.image.ImageWindow.splitImage(ip, markerChannel);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    private ImageProcessor getRedZipData(String redName) {
        ZipImage zipImage = new ZipImage(redName);
        int k1 = redName.lastIndexOf("/") + 1;
        String ss = redName.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ZipEntry ze = null;
        if (zipImage != null) {
            ze = zipImage.getZipEntry(ss + ".tif");
        }
        ImagePlus ip = null;
        ip = zipImage.readData(ze, true);
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(TEST3)) {
            this.test3();
        } else if (s.equals(CLEAR)) {
            this.append("clear");
            this.iText.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("time:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("1, 260");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
    }

    private void buildOutToolBar2() {
        JToolBar iToolBar2 = new JToolBar();
        iToolBar2.setMaximumSize(new Dimension(500, 20));
        iToolBar2.add(new JLabel("time:"));
        JTextField iTextField2 = new JTextField();
        iTextField2.setColumns(15);
        iTextField2.setText("1, 260");
        iToolBar2.add(iTextField2);
        JButton jb = null;
        jb = new JButton(CLEAR);
        iToolBar2.add(jb);
        jb = new JButton(TEST1);
        iToolBar2.add(jb);
        jb = new JButton(TEST2);
        iToolBar2.add(jb);
        jb = new JButton(TEST3);
        iToolBar2.add(jb);
        JPanel jp = new JPanel();
        jp.add(iToolBar2);
        this.add(jp);
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

