/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.AuxImageWindowXZ;
import org.rhwlab.image.AuxImageWindowYZ;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.ZipImage;
import org.rhwlab.snight.NucleiMgr;

public class Analysis11
extends JPanel
implements ActionListener {
    JFrame iFrame;
    JSpinner iTime;
    JSpinner iXYLocation;
    JButton iXZView;
    JButton iYZView;
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    String iImageName;
    private static final String CS = ", ";

    public Analysis11(String s) {
        this.setPreferredSize(new Dimension(300, 200));
        this.setLayout(new BoxLayout(this, 1));
        this.iFrame = new JFrame();
        this.makeUI();
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.showMe();
    }

    private void makeUI() {
        this.setLayout(new GridLayout(0, 1));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        JPanel p = new JPanel();
        p.add(new JLabel("time:"));
        SpinnerNumberModel model = new SpinnerNumberModel(100, 1, 200, 1);
        this.iTime = new JSpinner(model);
        p.add(this.iTime);
        p.setBorder(blackline);
        this.add(p);
        p = new JPanel();
        p.add(new JLabel("x or y loc:"));
        model = new SpinnerNumberModel(250, 10, 700, 10);
        this.iXYLocation = new JSpinner(model);
        p.add(this.iXYLocation);
        p.setBorder(blackline);
        this.add(p);
        this.iYZView = new JButton("YZ View");
        this.iYZView.addActionListener(this);
        this.add(this.iYZView);
        this.iXZView = new JButton("XZ View");
        this.iXZView.addActionListener(this);
        this.add(this.iXZView);
    }

    private void yzView(int time, int x) {
        ImagePlus iplus = this.getOneYZ(time, x);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = this.iImageName + " @ x = " + x;
        new AuxImageWindowYZ(s2, iproc, this.iAceTree, x);
    }

    private void xzView(int time, int y) {
        ImagePlus iplus = this.getOneXZ(time, y);
        ImageProcessor iproc = iplus.getProcessor();
        String s2 = this.iImageName + " @ y=" + y;
        new AuxImageWindowXZ(s2, iproc, this.iAceTree, y);
    }

    private ImagePlus getOneYZ(int time, int x) {
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(11 * planeEnd - 1, ImageWindow.cImageHeight);
        for (int m = 1; m <= planeEnd; ++m) {
            ImageProcessor ip = this.getImage(time, m);
            for (int i = 0; i < ip.getHeight(); ++i) {
                int p = ip.getPixel(x, i);
                for (int k = 0; k < 11; ++k) {
                    bp.putPixel(k + m * 11, i, p);
                }
            }
        }
        String s = time + "_" + x;
        ImagePlus iplus = new ImagePlus(s, bp);
        return iplus;
    }

    private ImagePlus getOneXZ(int time, int y) {
        int planeEnd = this.iNucleiMgr.getPlaneEnd();
        ByteProcessor bp = new ByteProcessor(ImageWindow.cImageWidth, 11 * planeEnd - 1);
        for (int m = 1; m <= planeEnd; ++m) {
            ImageProcessor ip = this.getImage(time, m);
            for (int i = 0; i < ip.getWidth(); ++i) {
                int p = ip.getPixel(i, y);
                for (int k = 0; k < 11; ++k) {
                    bp.putPixel(i, k + m * 11, p);
                }
            }
        }
        String s = time + "_" + y;
        ImagePlus iplus = new ImagePlus(s, bp);
        return iplus;
    }

    private ImageProcessor getImage(int time, int plane) {
        String imageFile = ImageWindow.cZipTifFilePath;
        imageFile = imageFile + "/" + ImageWindow.cTifPrefix;
        imageFile = imageFile + this.iAceTree.makeImageName(time, plane);
        int k = imageFile.lastIndexOf("/");
        String s = imageFile.substring(k + 1);
        k = s.lastIndexOf("-");
        this.iImageName = s = s.substring(0, k);
        ImageProcessor ip = this.getRedData(imageFile);
        return ip;
    }

    private ImageProcessor getRedData(String greenName) {
        if (ImageWindow.cUseZip == 2) {
            return this.getRedZipData(greenName);
        }
        ImagePlus ip = null;
        try {
            FileInputStream fis = new FileInputStream(greenName);
            byte[] ba = ImageWindow.readByteArray(fis);
            ip = ImageWindow.openTiff(new ByteArrayInputStream(ba), false);
            fis.close();
            if (ImageWindow.imagewindowUseStack == 1) {
                int markerChannel = 1;
                ip = ImageWindow.splitImage(ip, markerChannel);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    private ImageProcessor getRedZipData(String redName) {
        ZipImage zipImage = new ZipImage(redName);
        int k1 = redName.lastIndexOf("/") + 1;
        String ss = redName.substring(k1);
        int k2 = ss.indexOf(".");
        ss = ss.substring(0, k2);
        ZipEntry ze = null;
        if (zipImage != null) {
            ze = zipImage.getZipEntry(ss + ".tif");
        }
        ImagePlus ip = null;
        ip = zipImage.readData(ze, true);
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    public void showMe() {
        this.iFrame.setTitle("ImageViews");
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setLocationRelativeTo(this.iAceTree);
        this.iFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int time = (Integer)this.iTime.getValue();
        int xy = (Integer)this.iXYLocation.getValue();
        Analysis11.println("actionPerformed: " + time + CS + xy);
        Object o = e.getSource();
        if (o == this.iYZView) {
            this.yzView(time, xy);
        } else if (o == this.iXZView) {
            this.xzView(time, xy);
        }
    }

    public static void main(String[] args) {
        new Analysis11("");
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

