/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;
import org.rhwlab.utils.ConfigFileList;

public class Analysis5
extends JPanel
implements ActionListener,
ListSelectionListener,
Comparator {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private JFrame iFrame;
    protected JToolBar iToolBar;
    protected JMenuBar iMenuBar;
    private String iTitle;
    private JFileChooser iFC;
    private JTextField iTextField;
    private JList iCellList;
    private DefaultListModel iListModel;
    private boolean iNamesAvailable;
    private JScrollPane iScrollPane;
    private int iSampleIndex;
    private ConfigFileList iConfigFileList;
    private Vector iConfigFiles;
    private Vector iNucleiMgrs;
    private Vector iConfigsAvailable;
    private DefaultComboBoxModel iModel;
    private JComboBox iCombo;
    private Hashtable iNucleiMgrHash;
    private int iDepthP0;
    private Vector iLines;
    private Vector iNames;
    private Vector iCellLines;
    private int iKlast;
    private int iTime;
    private Font iFont;
    private String iCellName;
    private int iTest;
    private static final double TOL = 0.7;
    private static final double FACTOR = 0.5;
    String[] shelp = new String[]{"#test1: makes a queryable list of cell deaths", "#test2: makes two queryable lists showing nearby cells at adjacent times", "#test3: makes a queryable list of cells near current cell at next time"};
    private static final String MOVETO = " m";
    private static final String LINETO = " l";
    private static final String RLINETO = " r";
    private static final String NEWPATH = "n";
    private static final String COLOR = " c";
    private static final String CLOSEPATH = "cp";
    private static final String FILL = "fill";
    private static final String STROKE = "s";
    private static final String SHOW = " show";
    private static final String COMMENT = " %";
    private static final String SP = " ";
    private static final String LEFT = "(";
    private static final String RITE = ")";
    private static final int TOP = 700;
    private static final int OFFSET = 100;
    private static final int DELTAY = 5;
    private static final int DELTAT = 1;
    private static final int YINC = 20;
    private static final int YOFFSET = 500;
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Test1";
    private static final String TEST2 = "Test2";
    private static final String TEST3 = "Test3";
    private static final String TEST4 = "Test4";
    private static final String TEST5 = "Test5";
    private static final String HELP = "Help";
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");

    public Analysis5(String title) {
        this.setPreferredSize(new Dimension(700, 300));
        this.setLayout(new BoxLayout(this, 1));
        this.iFont = new Font("roman", 0, 16);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        this.add(this.iToolBar);
        this.iConfigsAvailable = new Vector();
        this.iModel = new DefaultComboBoxModel(this.iConfigsAvailable);
        this.buildOutToolBar();
        this.buildList();
        this.iNucleiMgrs = new Vector();
        this.iNucleiMgrHash = new Hashtable();
        this.initialize();
        this.iSampleIndex = 0;
        this.iFrame = new JFrame(this.iTitle);
        this.iFC = new JFileChooser(".");
        this.showMe();
        this.help();
    }

    private void test1() {
        this.iNamesAvailable = false;
        this.iTest = 1;
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        t2 = Integer.parseInt(this.iTextField.getText());
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells that died and the time");
        for (int i = t1; i < t2; ++i) {
            Vector nuclei = (Vector)this.nuclei_record.get(i - 1);
            for (int j = 0; j < nuclei.size(); ++j) {
                Nucleus n = (Nucleus)nuclei.get(j);
                if (n.status < 1 || n.successor1 >= 0 || n.successor2 >= 0) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(n.identity);
                sb.append(CS + i);
                this.iListModel.addElement(sb.toString());
            }
        }
        this.iNamesAvailable = true;
    }

    private void test3() {
        Analysis5.println("test3, the movie");
        this.iNamesAvailable = false;
        this.iTest = 1;
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells that died and the time");
        Vector<String> bigJumps = new Vector<String>();
        int checkCount = 0;
        Cell P = (Cell)this.iCellsByName.get("P");
        Enumeration<TreeNode> e = P.children();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            Enumeration<TreeNode> poe = c.preorderEnumeration();
            while (poe.hasMoreElements()) {
                int time;
                Cell cc = (Cell)poe.nextElement();
                int baseTime = cc.getTime();
                Vector v = cc.getCellData();
                int size = v.size();
                if (size <= 1) continue;
                Vector<Integer> jumps = new Vector<Integer>();
                int sizeSum = 0;
                String name = cc.getName();
                CellData cd0 = (CellData)v.get(0);
                sizeSum += cd0.iNucleus.size;
                for (int i = 1; i < size; ++i) {
                    CellData cd1 = (CellData)v.get(i);
                    jumps.add(new Integer(this.jump(cd0, cd1)));
                    sizeSum += cd1.iNucleus.size;
                    cd0 = cd1;
                }
                int maxTime = Integer.parseInt(this.iTextField.getText());
                int stdSize = sizeSum / size;
                for (int i = 0; i < jumps.size() && (time = baseTime + i) <= maxTime; ++i) {
                    double x = ((Integer)jumps.get(i)).intValue();
                    double xf = x / (double)stdSize;
                    if (!(xf > 0.7)) continue;
                    String s = name + CS + time + CS + DF2.format(xf);
                    bigJumps.add(s);
                    ++checkCount;
                }
            }
            Collections.sort(bigJumps, this);
            for (int i = 0; i < bigJumps.size(); ++i) {
                String s = (String)bigJumps.get(i);
                this.iListModel.addElement(s);
            }
        }
        this.iNamesAvailable = true;
    }

    private int jump(CellData cd0, CellData cd1) {
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Nucleus n0 = cd0.iNucleus;
        Nucleus n1 = cd1.iNucleus;
        int x = n0.x;
        int y = n0.y;
        int z = (int)(zPixRes * (double)n0.z);
        int zz = (int)(zPixRes * (double)n1.z);
        int dx = n1.x - x;
        int dy = n1.y - y;
        int dz = zz - z;
        int d2 = dx * dx + dy * dy + dz * dz;
        d2 = (int)Math.round(Math.sqrt(d2));
        return d2;
    }

    public int compare(Object arg0, Object arg1) {
        double d1;
        int rtn = 1;
        String[] sa = ((String)arg0).split(CS);
        double d0 = Double.parseDouble(sa[2]);
        if (d0 > (d1 = Double.parseDouble((sa = ((String)arg1).split(CS))[2]))) {
            rtn = -1;
        }
        return rtn;
    }

    private void test3X() {
        this.iNamesAvailable = false;
        this.iTest = 3;
        this.iCellName = this.iAceTree.getCurrentCell().getName();
        this.iTime = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)this.nuclei_record.get(this.iTime - 1);
        Vector nuclei2 = (Vector)this.nuclei_record.get(this.iTime);
        Nucleus nn = NucUtils.getCurrentCellData(nuclei, this.iCellName);
        double zPixRes = this.iNucleiMgr.getZPixRes();
        int x = nn.x;
        int y = nn.y;
        int z = (int)(zPixRes * (double)nn.z);
        Vector<D> v = new Vector<D>();
        int k = 0;
        for (int i = 0; i < nuclei2.size(); ++i) {
            Nucleus n = (Nucleus)nuclei2.get(i);
            if (n.identity.length() <= 0) continue;
            ++k;
            int zz = (int)(zPixRes * (double)n.z);
            int dx = n.x - x;
            int dy = n.y - y;
            int dz = zz - z;
            int d2 = dx * dx + dy * dy + dz * dz;
            d2 = (int)Math.round(Math.sqrt(d2));
            D u = new D(n.identity, d2, n.x, n.y, n.z, n, k, this.iTime + 1);
            v.add(u);
        }
        Collections.sort(v, new D());
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        imgWin.clearAnnotations();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells at time " + (this.iTime + 1) + " near " + this.iCellName + " at time " + this.iTime);
        int u = Math.min(v.size(), 10);
        for (int i = 0; i < u; ++i) {
            D dd = (D)v.get(i);
            imgWin.addAnnotation(dd.id, dd.x, dd.y);
            StringBuffer sb = new StringBuffer();
            sb.append(dd.id);
            sb.append(CS + dd.d);
            sb.append(CS + (this.iTime + 1));
            this.iListModel.addElement(sb.toString());
        }
        imgWin.refreshDisplay(null);
        this.iNamesAvailable = true;
    }

    private void test2() {
        int d2;
        int dz;
        int dy;
        int dx;
        int zz;
        Nucleus n;
        int i;
        this.iTest = 2;
        this.iNamesAvailable = false;
        this.iCellName = this.iAceTree.getCurrentCell().getName();
        this.iTime = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        Vector nuclei = (Vector)this.nuclei_record.get(this.iTime - 1);
        Vector nuclei2 = null;
        if (this.iTime > 1) {
            nuclei2 = (Vector)this.nuclei_record.get(this.iTime - 2);
        }
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Nucleus nn = NucUtils.getCurrentCellData(nuclei, this.iCellName);
        int x1 = nn.x;
        int y1 = nn.y;
        int z1 = (int)(zPixRes * (double)nn.z);
        Vector<D> v = new Vector<D>();
        Vector<D> v2 = new Vector<D>();
        int k = 0;
        D u = null;
        for (i = 0; i < nuclei.size(); ++i) {
            n = (Nucleus)nuclei.get(i);
            if (n.identity.length() <= 0) continue;
            ++k;
            zz = (int)(zPixRes * (double)n.z);
            dx = n.x - x1;
            dy = n.y - y1;
            dz = zz - z1;
            d2 = dx * dx + dy * dy + dz * dz;
            d2 = (int)Math.round(Math.sqrt(d2));
            u = new D(n.identity, d2, n.x, n.y, n.z, n, k, this.iTime);
            v.add(u);
        }
        if (nuclei2 != null) {
            for (i = 0; i < nuclei2.size(); ++i) {
                n = (Nucleus)nuclei2.get(i);
                if (n.identity.length() <= 0) continue;
                ++k;
                zz = (int)(zPixRes * (double)n.z);
                dx = n.x - x1;
                dy = n.y - y1;
                dz = zz - z1;
                d2 = dx * dx + dy * dy + dz * dz;
                d2 = (int)Math.round(Math.sqrt(d2));
                u = new D(n.identity, d2, n.x, n.y, n.z, n, k, this.iTime - 1);
                v2.add(u);
            }
        }
        Collections.sort(v, new D());
        if (nuclei2 != null) {
            Collections.sort(v2, new D());
        }
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        imgWin.clearAnnotations();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows: index, name, distance, time, plane");
        this.iListModel.addElement("#nuclei at time " + this.iTime + " near " + this.iCellName + " at time " + this.iTime);
        this.addItems(v, imgWin);
        if (nuclei2 != null) {
            this.iListModel.addElement("#nuclei at time " + (this.iTime - 1) + " near " + this.iCellName + " at time " + this.iTime);
            this.addItems(v2, imgWin);
            imgWin.refreshDisplay(null);
        }
        this.iNamesAvailable = true;
    }

    private void test4() {
        Analysis5.println("test4 clicked");
        this.iNamesAvailable = false;
        this.iTest = 4;
        this.iTime = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
        double zPixRes = this.iNucleiMgr.getZPixRes();
        Vector nuclei = (Vector)this.nuclei_record.get(this.iTime - 1);
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus n1 = (Nucleus)nuclei.get(i);
            if (n1.status <= 0) continue;
            int margin = (int)Math.round((double)n1.size * 0.5);
            for (int j = 0; j < nuclei.size(); ++j) {
                int zd;
                int yd;
                int xd;
                if (j == i) continue;
                Nucleus n2 = (Nucleus)nuclei.get(j);
                if (n2.status <= 0 || (xd = Math.abs(n1.x - n2.x)) > margin || (yd = Math.abs(n1.y - n2.y)) > margin || (zd = (int)Math.round(zPixRes * (double)Math.abs(n1.z - n2.z))) > margin) continue;
                int d = (int)Math.round(Math.sqrt(xd * xd + yd * yd + zd * zd));
                StringBuffer sb = new StringBuffer();
                sb.append(d);
                sb.append(CS + n1.identity);
                sb.append(CS + n2.identity);
                sb.append(CS + n1.x + CS + n1.y + CS + n1.z);
                sb.append(CS + n2.x + CS + n2.y + CS + n2.z);
                this.iListModel.addElement(sb.toString());
            }
        }
        this.iNamesAvailable = true;
    }

    private void addItems(Vector vv, ImageWindow imgWin) {
        int last = Math.min(vv.size(), 10);
        for (int i = 0; i < last; ++i) {
            D dd = (D)vv.get(i);
            imgWin.addAnnotation(dd.id, dd.x, dd.y);
            StringBuffer sb = new StringBuffer();
            sb.append(i);
            sb.append(CS + dd.id);
            sb.append(CS + dd.d);
            sb.append(CS + dd.time);
            sb.append(CS + dd.n.z);
            this.iListModel.addElement(sb.toString());
        }
    }

    private void help() {
        for (int i = 0; i < this.shelp.length; ++i) {
            this.iListModel.addElement(this.shelp[i]);
        }
    }

    private String getConfigFileInfo(String longName) {
        String s = longName.substring(longName.lastIndexOf(47) + 1);
        s = s.substring(0, s.indexOf(46));
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (e.getSource() == this.iCombo) {
            String newSelection = (String)this.iCombo.getSelectedItem();
            this.iAceTree.restoreTree(newSelection);
        } else if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(TEST3)) {
            this.test3();
        } else if (!s.equals(TEST4)) {
            if (s.equals(HELP)) {
                this.help();
            } else if (s.equals(CLEAR)) {
                this.iNamesAvailable = false;
                this.iListModel.clear();
                this.help();
            } else if (s.equals("jComboBoxChanged")) {
                // empty if block
            }
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("maxTime:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("249");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
        jb = new JButton(HELP);
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    protected void addComboBox(JComboBox jcb) {
        jcb.addActionListener(this);
        this.iToolBar.add(jcb);
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setCellRenderer(new CellRenderer());
        this.iCellList.setSelectionMode(0);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setVisibleRowCount(5);
        this.iScrollPane = new JScrollPane(this.iCellList);
        this.add(this.iScrollPane);
    }

    public void showMe() {
        this.iFrame.setTitle("Deaths and Adjacencies Dialog");
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            if (this.iTest == 2) {
                name = sa[1];
                this.iTime = Integer.parseInt(sa[3]);
            } else if (this.iTest == 1) {
                name = sa[0];
                this.iTime = Integer.parseInt(sa[1]);
            } else if (this.iTest == 3) {
                name = sa[0];
                this.iTime = Integer.parseInt(sa[2]);
            } else if (this.iTest == 4) {
                name = sa[1];
            }
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    private String getTrulySelectedCellName() {
        if (!this.iNamesAvailable) {
            return null;
        }
        int index = this.iCellList.getSelectedIndex();
        int k = Math.max(index, 1);
        String s = (String)this.iListModel.elementAt(index);
        String[] sa = s.split(CS);
        String name = sa[0];
        return name;
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = (String)value;
            this.setText(s);
            this.setFont(Analysis5.this.iFont);
            if (Analysis5.this.iCellName != null && s.indexOf(Analysis5.this.iCellName) >= 0) {
                this.setFont(Analysis5.this.iFont.deriveFont(1));
            }
            return this;
        }
    }

    private class D
    implements Comparator {
        String id;
        int d;
        int x;
        int y;
        float z;
        Nucleus n;
        int k;
        int time;

        public D() {
        }

        public D(String s, int dd, int xx, int yy, float zz, Nucleus nn, int kk, int t) {
            this.id = s;
            this.d = dd;
            this.x = xx;
            this.y = yy;
            this.z = zz;
            this.n = nn;
            this.k = kk;
            this.time = t;
        }

        public int compare(Object o1, Object o2) {
            D d1 = (D)o1;
            D d2 = (D)o2;
            int rtn = 0;
            if (d1.d < d2.d) {
                rtn = -1;
            } else if (d1.d > d2.d) {
                rtn = 1;
            }
            return rtn;
        }
    }
}

