/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.Dimension;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Line;
import org.rhwlab.utils.Log;

public class Analysis6
extends Log {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Hashtable iNucleiMgrHash;
    Line iLine;
    private double iXA;
    private double iYA;
    private double iZA;
    private JTextField iTextField;
    private Hashtable iNamingHash;
    private Hashtable iCompletedCellsHash;
    private char iTag;
    private int iSampleIndex;
    private String iKeyCell;
    private String iStartingCell;
    private int iBreakout;
    private Hashtable[] iArrayOfHashes;
    private Hashtable iCurrentHash;
    private Hashtable iAvgsHash;
    private String iTemplate;
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Test1";
    private static final String TEST2 = "Test2";
    private static final String TEST3 = "Test3";
    private static final String TEST4 = "Test4";
    private static final String TEST5 = "Test5";

    public Analysis6(String title) {
        super(title);
        this.showMe();
        this.buildOutToolBar();
        this.initialize();
        this.iSampleIndex = 0;
        this.iText.setFont(new Font("courier", 0, 12));
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("prefix:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("ABal");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
        jb = new JButton(TEST3);
        this.addToolBarButton(jb);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
        this.iNucleiMgrHash = this.iAceTree.getNucleiMgrHash();
    }

    private void test4() {
        this.append("test4 entered");
    }

    private void test3() {
        this.append("test3 entered");
    }

    private PlotData getSizeVsTime() {
        this.initialize();
        this.iTemplate = this.iTextField.getText();
        NucleiMgr nucMgr = this.iNucleiMgr;
        int first = nucMgr.getConfig().iStartingIndex;
        int last = nucMgr.getConfig().iEndingIndex;
        double[] xValues = new double[last - first + 1];
        double[] yValues = new double[last - first + 1];
        Vector nuclei = (Vector)this.nuclei_record.elementAt(first);
        for (int i = first; i <= last; ++i) {
            int k = this.getSize(nuclei);
            String s = this.iTemplate + ", " + i + ", " + k;
            this.append(s);
            xValues[i - 1] = i;
            yValues[i - 1] = k;
            nuclei = (Vector)this.nuclei_record.elementAt(i);
        }
        return new PlotData(xValues, yValues);
    }

    private int getSize(Vector nuclei) {
        int rtn = -1;
        Nucleus[] dau = new Nucleus[2];
        int k = 0;
        Enumeration e = nuclei.elements();
        while (e.hasMoreElements()) {
            Nucleus n = (Nucleus)e.nextElement();
            String name = n.identity;
            if (name.indexOf(this.iTemplate) < 0) continue;
            if (name.equals(this.iTemplate)) {
                rtn = n.size;
                break;
            }
            dau[k++] = n;
            if (k <= 1) continue;
            break;
        }
        int m = 1;
        if (k > 0) {
            if (dau[0].identity.compareTo(dau[1].identity) < 0) {
                m = 0;
            }
            rtn = dau[m].size;
            this.iTemplate = dau[m].identity;
        }
        return rtn;
    }

    private PlotData getCellCountVsTime() {
        this.initialize();
        NucleiMgr nucMgr = this.iNucleiMgr;
        int first = nucMgr.getConfig().iStartingIndex;
        int last = nucMgr.getConfig().iEndingIndex;
        double[] xValues = new double[last - first + 1];
        double[] yValues = new double[last - first + 1];
        Vector nuclei = (Vector)this.nuclei_record.elementAt(first);
        for (int i = first; i < last; ++i) {
            int k = this.countNuclei(nuclei);
            String s = i + ", " + k;
            this.append(s);
            xValues[i - 1] = i;
            yValues[i - 1] = k;
            nuclei = (Vector)this.nuclei_record.elementAt(i);
        }
        double[] xx = new double[last - first];
        System.arraycopy(xValues, 0, xx, 0, last - first);
        double[] yy = new double[last - first];
        System.arraycopy(yValues, 0, yy, 0, last - first);
        return new PlotData(xx, yy);
    }

    private int countNuclei(Vector nuclei) {
        int k = 0;
        Enumeration e = nuclei.elements();
        while (e.hasMoreElements()) {
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 1 || n.identity.indexOf("polar") >= 0) continue;
            ++k;
        }
        return k;
    }

    public static void main(String[] args) {
    }

    private class PlotData {
        public double[] yValues;
        public double[] xValues;

        public PlotData(double[] x, double[] y) {
            this.xValues = x;
            this.yValues = y;
        }

        public void showMe() {
        }
    }
}

