/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.tree.CellData;
import org.rhwlab.utils.HeatMap;
import org.rhwlab.utils.HeatMapFrame;
import org.rhwlab.utils.HeatMapPanel;
import org.rhwlab.utils.Log;

public class Analysis9
extends Log
implements Comparator {
    private JTextField iTextField1;
    private JTextField iTextField2;
    private JTextField iTextField3;
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    Font[] iFont;
    boolean iPrintHeader;
    private static final String CLEAR = "Clear";
    private static final String TEST1 = "One";
    private static final String TEST2 = "All";
    private static final String TEST3 = "Test3";

    public Analysis9(String title) {
        super(title);
        this.showMe();
        this.buildOutToolBar();
        this.initialize();
        this.iPrintHeader = true;
    }

    private void test1() {
        this.initialize();
        int first = Integer.parseInt(this.iTextField1.getText());
        int last = Integer.parseInt(this.iTextField2.getText());
        Vector nuclei = (Vector)this.nuclei_record.elementAt(last - 1);
        Collections.sort(nuclei, this);
        String founder = this.iTextField3.getText();
        boolean total = false;
        Vector all = new Vector();
        Vector<String> allFounders = new Vector<String>();
        for (int j = 0; j < nuclei.size(); ++j) {
            Nucleus n = (Nucleus)nuclei.elementAt(j);
            if (n.status == -1 || n.identity.indexOf(founder) != 0) continue;
            Vector one = new Vector();
            this.processLeaf(n.identity, first, last, this.iPrintHeader, one);
            all.add(one);
            allFounders.add(n.identity);
            this.iPrintHeader = false;
        }
        this.showAsHeatMap(all, allFounders, founder);
    }

    private void showAsHeatMap(Vector all, Vector allFounders, String baseFounder) {
        int rows = allFounders.size();
        int cols = ((Vector)all.elementAt(0)).size();
        int[][] data = new int[rows][cols];
        String[] labels = new String[rows];
        for (int i = 0; i < all.size(); ++i) {
            Vector one = (Vector)all.elementAt(i);
            for (int j = 0; j < one.size(); ++j) {
                CellData cd = (CellData)one.elementAt(j);
                data[i][j] = cd.iNucleus.rweight;
            }
            labels[i] = (String)allFounders.elementAt(i);
        }
        HeatMap hm = new HeatMap(data, labels, 25000, 100000);
        HeatMapPanel hmp = new HeatMapPanel(hm, 400, 200);
        HeatMapFrame hmf = new HeatMapFrame(baseFounder, hm, 400, 200, 1);
    }

    private void evaluateAll(Vector all) {
        System.out.println("evaluateAll entered");
        for (int i = 0; i < all.size(); ++i) {
            System.out.println("evaluateAll: " + i);
            Vector one = (Vector)all.elementAt(i);
            for (int j = 0; j < one.size(); ++j) {
                CellData cd = (CellData)one.elementAt(j);
                System.out.println("evaluateAll: " + i + ", " + j + ", " + cd.iNucleus.rweight);
            }
        }
    }

    private void test2() {
        this.initialize();
        int first = Integer.parseInt(this.iTextField1.getText());
        int last = Integer.parseInt(this.iTextField2.getText());
        Vector nuclei = (Vector)this.nuclei_record.elementAt(last - 1);
        Collections.sort(nuclei, this);
        int total = 0;
        for (int j = 0; j < nuclei.size(); ++j) {
            Nucleus n = (Nucleus)nuclei.elementAt(j);
            if (n.status == -1) continue;
            this.processLeaf(n.identity, first, last, total++ == 0, null);
        }
    }

    private void processLeaf(String founder, int start, int end, boolean showHeader, Vector clone) {
        Cell c = (Cell)this.iCellsByName.get(founder);
        if (c == null) {
            this.append("BAD ANALYSIS9 PARAMETERS");
            return;
        }
        Vector v = c.getAllCellData(start, end);
        int[] length = new int[1];
        String s = this.getContents(v, length);
        if (showHeader) {
            String header = founder;
            for (int i = start; i < start + length[0]; ++i) {
                header = header + "\t" + i;
            }
            this.append(header);
        }
        this.append(founder + s);
        clone.addAll(v);
    }

    private String getContents(Vector v, int[] length) {
        int k;
        length[0] = k = v.size();
        String s = "";
        for (int i = 0; i < k; ++i) {
            Object o = v.elementAt(i);
            s = s + "\t" + (((CellData)o).iNucleus.rweight - 35000);
        }
        return s;
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(CLEAR)) {
            this.append("clear");
            this.iText.setText("");
            this.iPrintHeader = true;
        } else {
            super.actionPerformed(e);
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setPreferredSize(new Dimension(500, 40));
        this.iToolBar.add(new JLabel("time:"));
        this.iTextField1 = new JTextField();
        this.iTextField1.setColumns(15);
        this.iTextField1.setText("1");
        this.iToolBar.add(this.iTextField1);
        this.iTextField2 = new JTextField();
        this.iTextField2.setColumns(15);
        this.iTextField2.setText("100");
        this.iToolBar.add(this.iTextField2);
        this.iTextField3 = new JTextField();
        this.iTextField3.setColumns(15);
        this.iTextField3.setText("MS");
        this.iToolBar.add(this.iTextField3);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
    }

    public int compare(Object o1, Object o2) {
        Nucleus n1 = (Nucleus)o1;
        Nucleus n2 = (Nucleus)o2;
        return n1.identity.compareTo(n2.identity);
    }
}

