/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.analyze.RedBkgComp2;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class RedBkgComp
extends JDialog
implements ActionListener,
Runnable {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    double iKMedium;
    double iKLarge;
    JTextField iStartText;
    JTextField iEndText;
    JTextField iKLargeText;
    JTextField iKMediumText;
    JButton iRun;
    JButton iStop;
    JTextArea iText;
    JScrollPane iPane;
    JCheckBox iFeedback;
    RedBkgComp2 iRedBkgComp2;
    private static final String NL = "\n";
    private static final String CS = ", ";
    private static final DecimalFormat DF1 = new DecimalFormat("####.##");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public RedBkgComp() {
        super((Frame)AceTree.getAceTree(null).getMainFrame(), false);
        this.initialize();
        JFrame owner = this.iAceTree.getMainFrame();
        this.setTitle("Background corrected red expression");
        int width = 400;
        int height = 100;
        JPanel all = new JPanel();
        all.setLayout(new BoxLayout(all, 3));
        this.iStartText = new JTextField("205", 10);
        this.iEndText = new JTextField("207", 10);
        this.iKLargeText = new JTextField("2.0", 10);
        this.iKMediumText = new JTextField("1.5", 10);
        Border blackBorder = BorderFactory.createLineBorder(Color.black);
        JPanel lp = new JPanel();
        JPanel mp = new JPanel();
        mp.setPreferredSize(new Dimension(400, height));
        mp.setLayout(new GridLayout(4, 2));
        lp.setBorder(blackBorder);
        lp.add(new JLabel("Start time"));
        mp.add(lp);
        mp.add(this.iStartText);
        lp = new JPanel();
        lp.setBorder(blackBorder);
        lp.add(new JLabel("End time"));
        mp.add(lp);
        mp.add(this.iEndText);
        lp = new JPanel();
        lp.setBorder(blackBorder);
        lp.add(new JLabel("KLarge"));
        mp.add(lp);
        mp.add(this.iKLargeText);
        lp = new JPanel();
        lp.setBorder(blackBorder);
        lp.add(new JLabel("KMedium"));
        mp.add(lp);
        mp.add(this.iKMediumText);
        all.add(mp);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0));
        this.iRun = new JButton("Run");
        this.iRun.addActionListener(this);
        this.iStop = new JButton("Stop");
        this.iStop.addActionListener(this);
        buttons.add(this.iRun);
        buttons.add(this.iStop);
        all.add(buttons);
        JPanel fp = new JPanel();
        fp.setBorder(blackBorder);
        this.iFeedback = new JCheckBox("Send results here ");
        fp.add(this.iFeedback);
        all.add(fp);
        this.iText = new JTextArea(4, 50);
        this.iText.setMargin(new Insets(5, 5, 5, 5));
        this.iText.setEditable(false);
        this.iText.setFont(new Font("Monospaced", 0, 12));
        this.iPane = new JScrollPane(this.iText);
        this.iPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        all.add(this.iPane);
        Container cp = this.getContentPane();
        cp.add(all);
        this.setLocationRelativeTo(owner);
        this.pack();
        this.setVisible(true);
        this.setModal(false);
        this.iRedBkgComp2 = new RedBkgComp2(true);
    }

    void getRed() {
        int start = Integer.parseInt(this.iStartText.getText());
        int end = Integer.parseInt(this.iEndText.getText());
        double kMedium = Double.parseDouble(this.iKMediumText.getText());
        double kLarge = Double.parseDouble(this.iKLargeText.getText());
        boolean sendResults = this.iFeedback.isSelected();
        this.iRedBkgComp2.setParameters(start, end, kMedium, kLarge, this, sendResults);
        new Thread(this).start();
    }

    void stopIt() {
        RedBkgComp.println("actionPerformed, request stop");
        this.append("requesting stop at end of current time point");
        this.iRedBkgComp2.stopRequested();
    }

    @Override
    public void run() {
        this.iRedBkgComp2.test1();
    }

    public void append(String s) {
        this.iText.append(s + NL);
        this.iText.setCaretPosition(this.iText.getDocument().getLength());
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    public static void main(String[] args) {
        new RedBkgComp();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iRun) {
            this.getRed();
        }
        if (o == this.iStop) {
            this.stopIt();
        }
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String fmt1(double x) {
        return DF1.format(x);
    }
}

