/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.analyze;

import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.analyze.RedBkgComp;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;
import org.rhwlab.utils.Log;

public class RedBkgComp2
extends Log {
    JTextField iTextField;
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    double iKMedium;
    double iKLarge;
    int iStartTime;
    int iEndTime;
    RedBkgComp iRedBkgComp;
    boolean iStopRequested;
    boolean iFeedbackRequested;
    Vector iFeedbackVector;
    Vector iKeys;
    private static final String CLEAR = "Clear";
    private static final String TEST1 = "One";
    private static final String TEST2 = "All";
    private static final String TEST3 = "Test3";
    private static final String CS = ", ";
    private static final DecimalFormat DF1 = new DecimalFormat("####.##");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public RedBkgComp2() {
        super("Red Background Compensation");
        this.showMe();
        this.initialize();
        this.buildOutToolBar();
        RedBkgComp2.println("RedBkgComp2, ");
        this.iKMedium = 1.5;
        this.iKLarge = 2.0;
    }

    public RedBkgComp2(boolean noUI) {
        super("Red Background Compensation");
        this.initialize();
        this.iKMedium = 1.5;
        this.iKLarge = 2.0;
        RedBkgComp2.println("RedBkgComp2, no ui");
    }

    public void setParameters(int start, int end, double kMedium, double kLarge, RedBkgComp redBkgComp, boolean feedbackRequested) {
        this.iStartTime = start;
        this.iEndTime = end;
        this.iKMedium = kMedium;
        this.iKLarge = kLarge;
        this.iRedBkgComp = redBkgComp;
        this.iStopRequested = false;
        this.iFeedbackRequested = feedbackRequested;
        if (this.iFeedbackRequested) {
            this.iFeedbackVector = new Vector();
        }
    }

    public void stopRequested() {
        this.iStopRequested = true;
    }

    public void test1() {
        this.iRedBkgComp.append("beginning..");
        long startTime = System.currentTimeMillis();
        for (int time = this.iStartTime; time <= this.iEndTime; ++time) {
            Vector<Hashtable> hashPlanes = new Vector<Hashtable>();
            for (int plane = 1; plane <= this.iNucleiMgr.getPlaneEnd(); ++plane) {
                Hashtable h = this.createHashForPlane(time, plane);
                hashPlanes.add(h);
            }
            this.processHashPlanes(time, hashPlanes);
            if (this.iFeedbackRequested) {
                Collections.sort(this.iFeedbackVector);
                for (int i = 0; i < this.iFeedbackVector.size(); ++i) {
                    this.iRedBkgComp.append((String)this.iFeedbackVector.get(i));
                }
            }
            if (!this.iStopRequested) continue;
            this.iStopRequested = false;
            this.iRedBkgComp.append("at time=" + time + ", stopped at user request");
            break;
        }
        long endTime = System.currentTimeMillis();
        String s = "run elapsed millisec, " + (endTime - startTime);
        this.iRedBkgComp.append(s);
    }

    public void processHashPlanes(int time, Vector hashPlanes) {
        Vector nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        Vector circles = new Vector();
        this.iKeys = new Vector();
        Nucleus n = null;
        Hashtable<String, Totals> totals = new Hashtable<String, Totals>();
        this.iKeys = new Vector();
        Enumeration e = nuclei.elements();
        for (int j = 0; j < nuclei.size(); ++j) {
            double fri;
            n = (Nucleus)nuclei.elementAt(j);
            if (n.status == -1) continue;
            Totals t = new Totals();
            t.name = n.identity;
            this.iKeys.add(n.identity);
            for (int i = 0; i < hashPlanes.size(); ++i) {
                Hashtable h = (Hashtable)hashPlanes.get(i);
                Centroid c = (Centroid)h.get(n.identity);
                if (c == null) continue;
                t.nuclearRed += c.nuclearRed;
                t.nuclearArea += c.nuclearArea;
                t.annulusRed += c.annulusRed;
                t.annulusArea += c.annulusArea;
            }
            double bri = 1000.0 * t.annulusRed / t.annulusArea;
            t.fri = fri = 1000.0 * t.nuclearRed / t.nuclearArea;
            t.bri = bri;
            totals.put(n.identity, t);
            n.rweight = (int)Math.round(fri - bri);
            n.rsum = (int)Math.round(t.nuclearArea);
            n.rcount = (int)Math.round(bri);
            if (!this.iFeedbackRequested) continue;
            String s = n.identity + CS + n.rweight + CS + n.rcount + CS + n.rsum + CS + time;
            this.iFeedbackVector.add(s);
        }
    }

    public Hashtable createHashForPlane(int time, int plane) {
        Vector nuclei = (Vector)this.nuclei_record.elementAt(time - 1);
        Vector circles = new Vector();
        this.iKeys = new Vector();
        Nucleus n = null;
        Enumeration e = nuclei.elements();
        Hashtable<String, Centroid> h = new Hashtable<String, Centroid>();
        for (int j = 0; j < nuclei.size(); ++j) {
            double dl;
            n = (Nucleus)nuclei.elementAt(j);
            if (n.status == -1 || !((dl = this.nucDiameter(n, plane, (double)n.size * this.iKLarge)) > 0.0)) continue;
            Centroid c = new Centroid();
            c.index = j + 1;
            c.time = time;
            c.plane = plane;
            c.x = n.x;
            c.y = n.y;
            c.d = this.nucDiameter(n, plane, n.size);
            c.dl = dl;
            c.dm = this.nucDiameter(n, plane, (double)n.size * this.iKMedium);
            c.name = n.identity;
            c.weight = n.weight;
            c.n = n;
            h.put(n.identity, c);
            this.iKeys.add(n.identity);
        }
        this.process(h, time, plane);
        Collections.sort(this.iKeys);
        return h;
    }

    public void process(Hashtable h, int time, int plane) {
        String imageFile = ImageWindow.cZipTifFilePath;
        imageFile = imageFile + "/" + ImageWindow.cTifPrefixR;
        ImageProcessor ipData = this.getRedData(imageFile = imageFile + this.iAceTree.makeImageName(time, plane));
        if (ipData == null) {
            return;
        }
        ImagePlus iplus = new ImagePlus(this.iTitle, ipData);
        ImageProcessor ipCopy = this.getRedData(imageFile);
        ImagePlus iplus2 = new ImagePlus(this.iTitle, ipCopy);
        ByteProcessor ipTemplate = new ByteProcessor(ipData.getWidth(), ipData.getHeight());
        ipTemplate.setValue(255.0);
        ipTemplate.fill();
        ImagePlus iplus3 = new ImagePlus(this.iTitle, ipTemplate);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            Polygon middle;
            String key = (String)e.nextElement();
            Centroid c = (Centroid)h.get(key);
            int r = (int)Math.round(c.dm / 2.0);
            c.middle = middle = EUtils.pCircle(c.x, c.y, r);
            ipCopy.setValue(0.0);
            ipCopy.fillPolygon(middle);
            ipTemplate.setValue(0.0);
            ipTemplate.fillPolygon(middle);
        }
        for (int i = 0; i < this.iKeys.size(); ++i) {
            String key = (String)this.iKeys.get(i);
            Centroid c = (Centroid)h.get(key);
            this.getInfo(ipData, ipCopy, ipTemplate, c);
        }
    }

    private void getInfo(ImageProcessor ipData, ImageProcessor ipCopy, ImageProcessor ipTemplate, Centroid c) {
        int rad = (int)Math.round(c.d / 2.0);
        Polygon inner = EUtils.pCircle(c.x, c.y, rad);
        rad = (int)Math.round(c.dl / 2.0);
        Polygon outer = EUtils.pCircle(c.x, c.y, rad);
        Rectangle r = outer.getBounds();
        double templateArea = 0.0;
        double backgroundRed = 0.0;
        double backgroundRedCount = 0.0;
        double nucleusRed = 0.0;
        double nucleusRedCount = 0.0;
        for (int y = r.y; y < r.y + r.height; ++y) {
            for (int x = r.x; x <= r.x + r.width; ++x) {
                int p;
                if (outer.contains(x, y)) {
                    p = ipTemplate.getPixel(x, y);
                    templateArea += (double)p;
                    p = ipCopy.getPixel(x, y);
                    backgroundRed += (double)p;
                    backgroundRedCount += 1.0;
                }
                if (!inner.contains(x, y)) continue;
                p = ipData.getPixel(x, y);
                nucleusRed += (double)p;
                nucleusRedCount += 1.0;
            }
        }
        c.nuclearRed = nucleusRed;
        c.nuclearArea = nucleusRedCount;
        c.annulusRed = backgroundRed;
        c.annulusArea = templateArea / 255.0;
        c.outer = outer;
        c.inner = inner;
    }

    private void showInfo(ImageProcessor ipCopy, ImageProcessor ipTemplate, Centroid c) {
        ipTemplate.setValue(0.0);
        ipTemplate.drawPolygon(c.outer);
        ipCopy.setValue(255.0);
        ipCopy.drawPolygon(c.middle);
        ipCopy.drawPolygon(c.outer);
        double templateArea = c.annulusArea;
    }

    private double[] processStuff(ImageProcessor ipData, ImageProcessor ipCopy, ImageProcessor ipTemplate, Centroid c) {
        double[] rtn = new double[3];
        double kSmall = 1.5;
        double kLarge = 2.0;
        int rn = (int)Math.round(c.d / 2.0);
        int rs = (int)Math.round(kSmall * c.d / 2.0);
        int rl = (int)Math.round(kLarge * c.d / 2.0);
        Polygon pn = EUtils.pCircle(c.x, c.y, rn);
        Polygon ps = EUtils.pCircle(c.x, c.y, rs);
        Polygon pl = EUtils.pCircle(c.x, c.y, rl);
        return rtn;
    }

    private void zeroExpandedCentroid(ImageProcessor ip, Centroid c, double factor) {
        int r = (int)Math.round(factor * c.d / 2.0);
        ip.setValue(0.0);
        ip.fillPolygon(EUtils.pCircle(c.x, c.y, r));
    }

    private double estimateArea(ImageProcessor ip, int cx, int cy, int rl, String name) {
        double area = 0.0;
        OvalRoi oRoi = new OvalRoi(cx - rl, cy - rl, 2 * rl, 2 * rl);
        Rectangle r = oRoi.getBounds();
        for (int y = r.y; y < r.y + r.height; ++y) {
            for (int x = r.x; x <= r.x + r.width; ++x) {
                if (!oRoi.contains(x, y)) continue;
                int p = ip.getPixel(x, y);
                if (name.equals("Epla")) {
                    RedBkgComp2.println("estimateArea, " + p);
                }
                area += (double)p;
            }
        }
        return area / 100.0;
    }

    private void zeroCircle(ImageProcessor ip, int cx, int cy, int d) {
        OvalRoi oRoi = new OvalRoi(cx - d / 2, cy - d / 2, d, d);
        Rectangle r = oRoi.getBounds();
        int width = ip.getWidth();
        for (int y = r.y; y < r.y + r.height; ++y) {
            for (int x = r.x; x <= r.x + r.width; ++x) {
                if (!oRoi.contains(x, y)) continue;
                ip.putPixel(x, y, 0);
            }
        }
    }

    private void zeroPolygonRoi(ImageProcessor ip, Polygon p) {
        ip.setRoi(new PolygonRoi(p, 2));
        ip.setValue(0.0);
        ip.fill();
    }

    private ImageProcessor getRedData(String greenName) {
        RedBkgComp2.println("getRedData, " + greenName);
        ImagePlus ip = null;
        try {
            FileInputStream fis = new FileInputStream(greenName);
            byte[] ba = ImageWindow.readByteArray(fis);
            ip = ImageWindow.openTiff(new ByteArrayInputStream(ba), false);
            fis.close();
            if (ImageWindow.imagewindowUseStack == 1) {
                int markerChannel = 1;
                ip = ImageWindow.splitImage(ip, markerChannel);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (ip != null) {
            return ip.getProcessor();
        }
        return null;
    }

    public void test2() {
        RedBkgComp2.println("test2, ");
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.test1();
        } else if (s.equals(TEST2)) {
            this.test2();
        } else if (s.equals(CLEAR)) {
            this.append("clear");
            this.iText.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("time:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(15);
        this.iTextField.setText("175");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton(TEST2);
        this.addToolBarButton(jb);
    }

    public double nucDiameter(Nucleus n, double imgPlane, double dx) {
        if (n == null) {
            return -1.0;
        }
        double r = -0.5;
        double cellPlane = n.z;
        double R = dx / 2.0;
        double y = (cellPlane - imgPlane) * this.iNucleiMgr.getZPixRes() / R;
        double r2 = 1.0 - y * y;
        if (r2 >= 0.0) {
            r = Math.sqrt(r2) * R;
        }
        return 2.0 * r;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String fmt1(double x) {
        return DF1.format(x);
    }

    private class Centroid
    implements Comparator {
        public int time;
        public int plane;
        public int index;
        public int x;
        public int y;
        public double d;
        public String name;
        public int weight;
        public Nucleus n;
        public int rsum;
        public int rcount;
        public double dl;
        public double dm;
        public Polygon inner;
        public Polygon middle;
        public Polygon outer;
        public double nuclearRed;
        public double nuclearArea;
        public double annulusRed;
        public double annulusArea;

        private Centroid() {
        }

        public String toString() {
            String s = String.valueOf(this.index);
            s = s + RedBkgComp2.CS + this.time;
            s = s + RedBkgComp2.CS + this.plane;
            s = s + RedBkgComp2.CS + this.x;
            s = s + RedBkgComp2.CS + this.y;
            s = s + RedBkgComp2.CS + this.d;
            s = s + RedBkgComp2.CS + this.name;
            s = s + RedBkgComp2.CS + this.weight;
            s = s + RedBkgComp2.CS + this.rsum;
            s = s + RedBkgComp2.CS + this.rcount;
            return s;
        }

        public int compare(Object o1, Object o2) {
            if (((Centroid)o1).plane < ((Centroid)o2).plane) {
                return -1;
            }
            if (((Centroid)o1).plane > ((Centroid)o2).plane) {
                return 1;
            }
            return 0;
        }
    }

    private class Totals {
        String name;
        double nuclearRed;
        double nuclearArea;
        double annulusRed;
        double annulusArea;
        double fri;
        double bri;

        private Totals() {
        }

        public String toString() {
            StringBuffer br = new StringBuffer("Totals, " + this.name);
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.fri - this.bri));
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.fri));
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.bri));
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.nuclearRed));
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.nuclearArea));
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.annulusRed));
            br.append(RedBkgComp2.CS + RedBkgComp2.fmt1(this.annulusArea));
            return br.toString();
        }
    }
}

