/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.dbaccess;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.rhwlab.dbaccess.EmbryoXML;
import org.rhwlab.manifest.ManifestX;

public class DBAccess {
    public static String cDBLocation;
    Vector iEmbryos;
    public static Hashtable iEmbryosHash;
    long iStartDate;
    int iLookedAt;
    private static long start;
    private static long inter;
    private static long now;
    private static long end;
    private static final String CS = ", ";
    private static final DecimalFormat DF0;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    public DBAccess(long startdate) {
        this.iStartDate = startdate;
        this.getEmbryos();
    }

    public Vector getEmbryosV() {
        return this.iEmbryos;
    }

    public void getEmbryos() {
        this.iEmbryos = new Vector();
        iEmbryosHash = new Hashtable();
        File f = new File(cDBLocation);
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            ++this.iLookedAt;
            String absPath = files[i].getAbsolutePath();
            EmbryoXML exml = new EmbryoXML(absPath, 0);
            if (!this.isOfInterest(exml)) continue;
            this.iEmbryos.add(exml);
            iEmbryosHash.put(exml.iRecord[0], exml);
        }
    }

    private boolean isOfInterest(EmbryoXML exml) {
        String status = exml.iRecord[15];
        if (status.equals("deleted")) {
            return false;
        }
        String date = exml.iRecord[1];
        long ldate = Long.parseLong(date);
        return ldate >= this.iStartDate;
    }

    public static void main(String[] args) {
        DBAccess.println("DBAccess.main, ");
        inter = start = System.currentTimeMillis();
        ManifestX.reportAndUpdateManifest();
        cDBLocation = ManifestX.getManifestValue("DBLocation");
        DBAccess.println("DBCheck.main, cDBLocation, " + cDBLocation);
        DBAccess dba = new DBAccess(20050101L);
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF1.format(d);
    }

    static {
        DF0 = new DecimalFormat("####");
        DF1 = new DecimalFormat("####.#");
        DF4 = new DecimalFormat("####.####");
    }
}

