/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.help;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.acetree.AceTree;

public class AceTreeHelp
extends JPanel {
    JFrame iFrame;
    String iFileName;

    public AceTreeHelp(String fileName) {
        this(fileName, 400, 500);
        this.iFileName = fileName;
    }

    public AceTreeHelp(String fileName, int width, int height) {
        this.setLayout(new BorderLayout());
        this.iFileName = fileName;
        JEditorPane editorPane = this.createEditorPane();
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setPreferredSize(new Dimension(width, height));
        editorScrollPane.setMinimumSize(new Dimension(width, height));
        this.add(editorScrollPane);
        int k = fileName.lastIndexOf("/") + 1;
        int m = fileName.lastIndexOf(".");
        String title = fileName.substring(k, m);
        this.iFrame = new JFrame(title);
        this.showMe();
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        URL url = null;
        if (this.iFileName.indexOf("http://") == 0) {
            try {
                url = new URL(this.iFileName);
            }
            catch (Exception e) {
                System.out.println("bad url: " + this.iFileName);
                return null;
            }
        } else {
            url = AceTree.class.getResource(this.iFileName);
        }
        if (url != null) {
            try {
                editorPane.setPage(url);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + url);
            }
        } else {
            System.err.println("Couldn't find html file: " + this.iFileName);
        }
        return editorPane;
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public static void main(String[] args) {
    }
}

