/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Raster;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ColorConstants;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;

public class Image3D
extends MouseAdapter
implements ActionListener,
Runnable {
    private PickCanvas iPickCanvas;
    private AceTree iAceTree;
    private NucleiMgr iNucleiMgr;
    public BranchGroup iBG;
    private JFrame iFrame;
    private SimpleUniverse iUniverse;
    private Canvas3D iCanvas;
    private String iTitle;
    boolean iNewConstruction;
    Thread iThread;
    boolean iSaveInProcess;
    static boolean iSaveImage;
    boolean fakeit1;
    boolean fakeit2;
    JTextField iAngle;
    JTextField iScale;
    JLabel iPick;
    private int iXA;
    private int iYA;
    private float iZA;
    private Transform3D iRotate;
    private TransformGroup iRotGroup;
    private Transform3D iTranslate = new Transform3D();
    protected Transform3D iCurrentTransform = new Transform3D();
    private TransformGroup iTranslateGroup;
    private Vector3d iTranslateVec = new Vector3d(0.0, 0.0, 0.0);
    private Matrix4d iMatrix = new Matrix4d();
    private double iZViewPos;
    private JPanel iImagePanel;
    private JPanel iControlPanel;
    private JTabbedPane iTabbedPane;
    public SublineageDisplayProperty[] iDispProps;
    private int iMinRed;
    private int iMaxRed;
    private boolean iUseExpression;
    private static final String CS = ", ";
    private static final String IMAGETYPE = "jpeg";
    private Color3f[] BACKGROUNDS = new Color3f[]{new Color3f(1.0f, 1.0f, 1.0f), new Color3f(0.3f, 0.3f, 0.3f), new Color3f(0.1f, 0.1f, 0.1f)};
    private static final int MINRED = 25000;
    private static final int MAXRED = 100000;
    private static final int SPECIAL = 1;

    public Image3D(AceTree aceTree, String title) {
        this.iAceTree = aceTree;
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iFrame = new JFrame(title);
        this.iTitle = title;
        this.iNewConstruction = true;
        this.iMinRed = 25000;
        this.iMaxRed = 100000;
        this.iUseExpression = false;
        this.iFrame.setDefaultCloseOperation(0);
        WinEventMgr wem = new WinEventMgr();
        this.iFrame.addWindowListener(wem);
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.iCanvas = new Canvas3D(config);
        this.iCanvas.setSize(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
        this.iUniverse = new SimpleUniverse(this.iCanvas);
        this.iUniverse.getViewingPlatform().setNominalViewingTransform();
        ViewingPlatform viewingPlatform = this.iUniverse.getViewingPlatform();
        this.iTranslateGroup = viewingPlatform.getViewPlatformTransform();
        this.iTranslateGroup.getTransform(this.iTranslate);
        this.iTranslate.get(this.iMatrix);
        this.iZViewPos = this.iMatrix.m23;
        this.iTranslate.set(this.iMatrix);
        this.iTranslateGroup.setTransform(this.iTranslate);
        this.iPick = new JLabel("pick");
        this.iImagePanel = new JPanel();
        this.iImagePanel.setLayout(new BorderLayout());
        this.iImagePanel.add((Component)this.makeToolBar(), "North");
        this.iImagePanel.add((Component)this.iCanvas, "Center");
        this.iImagePanel.add((Component)this.iPick, "South");
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.addTab("Image", null, this.iImagePanel, "View 3D image");
        Object dispProps = this.iAceTree.getDispProps3D();
        if (dispProps == null) {
            this.iAceTree.setDispProps3D(this.getDisplayProps());
        }
        this.iDispProps = (SublineageDisplayProperty[])this.iAceTree.getDispProps3D();
        PropertiesTab pt = new PropertiesTab(this);
        this.iControlPanel = pt.getPanel();
        this.iTabbedPane.addTab("Properties", null, this.iControlPanel, "Set color scheme");
        this.iFrame.getContentPane().add(this.iTabbedPane);
        this.iCanvas.addMouseListener((MouseListener)this);
        this.iFrame.pack();
        this.iFrame.show();
    }

    private void reportDispProps() {
        for (int i = 0; i < this.iDispProps.length; ++i) {
            System.out.println("dispProp: " + i + CS + this.iDispProps[i].iName + CS + this.iDispProps[i].iLineageNum);
        }
    }

    public void updateDisplayedTab() {
        this.iTabbedPane.setSelectedIndex(0);
        this.insertContent(this.iTitle);
    }

    private JToolBar makeToolBar() {
        JToolBar jtb = new JToolBar("");
        jtb.setLayout(new GridLayout(1, 10));
        JLabel jl = new JLabel("angle");
        jtb.add(jl);
        this.iAngle = new JTextField("0", 4);
        jtb.add(this.iAngle);
        JButton set = new JButton("set");
        set.addActionListener(this);
        jtb.add(set);
        JButton jbr = new JButton("rotateX");
        jbr.addActionListener(this);
        jtb.add(jbr);
        JButton jb = new JButton("scale");
        jb.addActionListener(this);
        jtb.add(jb);
        this.iScale = new JTextField("1.0", 7);
        jtb.add(this.iScale);
        jb = new JButton("SetScale");
        jb.addActionListener(this);
        jtb.add(jb);
        jbr = new JButton("rotateY");
        jbr.addActionListener(this);
        jtb.add(jbr);
        return jtb;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("set")) {
            Transform3D t3d = new Transform3D();
            t3d.rotX(Double.parseDouble(this.iAngle.getText()) * Math.PI / 180.0);
            double news = Double.parseDouble(this.iScale.getText());
            t3d.setScale(news);
            this.iRotate.set(t3d);
            this.iRotGroup.setTransform(this.iRotate);
        } else if (s.equals("rotateX")) {
            Transform3D t3d = new Transform3D();
            t3d.rotX(0.7853981633974483);
            this.iRotate.mul(t3d);
            this.iRotGroup.setTransform(this.iRotate);
            int angle = Integer.parseInt(this.iAngle.getText());
            angle += 45;
            this.iAngle.setText(String.valueOf(angle %= 360));
        } else if (s.equals("rotateY")) {
            Transform3D t3d = new Transform3D();
            t3d.rotY(1.5707963267948966);
            this.iRotate.mul(t3d);
            this.iRotGroup.setTransform(this.iRotate);
        } else if (s.equals("scale")) {
            Transform3D t3d = new Transform3D();
            t3d.set(1.1);
            this.iRotate.mul(t3d);
            this.iRotGroup.setTransform(this.iRotate);
            double sc = Double.parseDouble(this.iScale.getText());
            this.iScale.setText(String.valueOf(sc * 1.1));
        } else if (s.equals("SetScale")) {
            double news = Double.parseDouble(this.iScale.getText());
            this.iTranslateGroup.getTransform(this.iTranslate);
            this.iTranslate.get(this.iMatrix);
            this.iZViewPos = this.iMatrix.m23;
            this.iMatrix.m23 = news;
            this.iTranslate.set(this.iMatrix);
            this.iTranslateGroup.setTransform(this.iTranslate);
        }
    }

    public void insertContent(String title) {
        while (this.iSaveInProcess) {
        }
        this.iTitle = title;
        this.iFrame.setTitle(this.iTitle);
        if (this.iBG != null) {
            this.iBG.detach();
        }
        this.iBG = this.createSceneGraph();
        this.iUniverse.addBranchGraph(this.iBG);
        this.iPickCanvas = new PickCanvas(this.iCanvas, this.iBG);
        this.iPickCanvas.setMode(512);
        if (iSaveImage) {
            this.iThread = new Thread(this);
            this.iThread.start();
        }
    }

    public BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        root.setCapability(17);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f lColor1 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        Vector3f lDirect1 = new Vector3f(lPos1);
        lDirect1.negate();
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDirect1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)lgt1);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        root.addChild((Node)bg);
        TransformGroup objRotate = new TransformGroup();
        objRotate.setCapability(18);
        objRotate.setCapability(17);
        new Nuclei3D();
        this.iBG.compile();
        objRotate.addChild((Node)this.iBG);
        TransformGroup initRotGroup = new TransformGroup();
        Transform3D initRotate = new Transform3D();
        NucleiMgr nucMgr = this.iAceTree.getNucleiMgr();
        int ap = nucMgr.getParameters().apInit;
        int dv = nucMgr.getParameters().dvInit;
        int lr = nucMgr.getParameters().lrInit;
        if (ap == -1) {
            Transform3D apt = new Transform3D();
            apt.rotZ(Math.PI);
            initRotate.mul(apt);
            ap = -ap;
            dv = -dv;
        }
        if (dv == -1) {
            Transform3D dvt = new Transform3D();
            dvt.rotX(Math.PI);
            initRotate.mul(dvt);
            dv = -dv;
            lr = -lr;
        }
        initRotGroup.setTransform(initRotate);
        initRotGroup.addChild((Node)objRotate);
        if (this.iRotate == null) {
            this.iRotate = new Transform3D();
        }
        this.iRotGroup = new TransformGroup(this.iRotate);
        this.iRotGroup.setCapability(18);
        this.iRotGroup.addChild((Node)initRotGroup);
        root.addChild((Node)this.iRotGroup);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objRotate);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        root.addChild((Node)myMouseRotate);
        root.compile();
        return root;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.iPickCanvas.setShapeLocation(e);
        PickResult[] results = this.iPickCanvas.pickAll();
        String name = this.getPickedNucleusNames(results);
        this.iPick.setText("you picked: " + name);
    }

    private String getPickedNucleusNames(PickResult[] results) {
        String s = "none";
        Vector<String> v = new Vector<String>();
        if (results != null) {
            for (int i = results.length - 1; i >= 0; --i) {
                String pname;
                Primitive p = (Primitive)results[i].getNode(4);
                if (p == null || (pname = p.getClass().getName()).indexOf("NamedSphere") < 0) continue;
                s = ((NamedSphere)p).iName;
                v.add(0, s);
            }
        }
        if (v.size() == 0) {
            return "none";
        }
        Enumeration e = v.elements();
        s = "";
        while (e.hasMoreElements()) {
            if (s.length() > 0) {
                s = s + CS;
            }
            s = s + (String)e.nextElement();
        }
        return s;
    }

    private SublineageDisplayProperty[] getDisplayProps() {
        SublineageDisplayProperty[] dispProps = new SublineageDisplayProperty[]{new SublineageDisplayProperty("ABa", 0), new SublineageDisplayProperty("ABp", 1), new SublineageDisplayProperty("C", 5), new SublineageDisplayProperty("D", 6), new SublineageDisplayProperty("E", 2), new SublineageDisplayProperty("MS", 4), new SublineageDisplayProperty("P", 3), new SublineageDisplayProperty("polar", 7), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("other", 2), new SublineageDisplayProperty("background", 1)};
        return dispProps;
    }

    private int getLineageNumber(String name) {
        if (name.indexOf("Z") >= 0) {
            name = "P";
        }
        int num = this.iDispProps.length;
        for (int i = 0; i < this.iDispProps.length; ++i) {
            if (name.indexOf(this.iDispProps[i].iName) < 0) continue;
            num = this.iDispProps[i].iLineageNum;
            break;
        }
        return num;
    }

    @Override
    public void run() {
        this.iSaveInProcess = true;
        int k = 1000;
        if (this.iNewConstruction) {
            k = 5000;
            this.iNewConstruction = false;
        }
        try {
            Thread.sleep(k);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.saveImage();
    }

    public static void setSaveImageState(boolean saveIt) {
        iSaveImage = saveIt;
    }

    public void saveImage() {
        String saveDir = this.iAceTree.iImgWin.getSaveImageDirectory();
        if (saveDir == null) {
            this.iAceTree.iImgWin.cancelSaveOperations();
            iSaveImage = false;
            return;
        }
        Rectangle screenRect = this.iFrame.getBounds();
        int topAdjust = 23;
        int y = screenRect.y;
        screenRect.y += topAdjust;
        int height = screenRect.height;
        screenRect.height -= topAdjust;
        String title = saveDir + "/";
        Robot robot = null;
        try {
            robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRect);
            title = title + this.iTitle + "." + IMAGETYPE;
            ImageIO.write((RenderedImage)image, IMAGETYPE, new File(title));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("file: " + title + " written");
        this.iSaveInProcess = false;
    }

    public BufferedImage getBufferedImage() {
        int width = (int)this.iCanvas.getSize().getWidth();
        int height = (int)this.iCanvas.getSize().getHeight();
        int cursorType = this.iCanvas.getCursor().getType();
        this.iCanvas.setCursor(new Cursor(3));
        GraphicsContext3D ctx = this.iCanvas.getGraphicsContext3D();
        Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, width, height, new ImageComponent2D(1, new BufferedImage(width, height, 1)), null);
        ctx.readRaster(ras);
        BufferedImage img = ras.getImage().getImage();
        this.iCanvas.setCursor(new Cursor(cursorType));
        return img;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Image3D.this.iFrame.dispose();
            Image3D.this.iAceTree.image3DOff();
        }
    }

    public class PropertiesTab
    implements ActionListener {
        JPanel iPanel;
        SublineageUI[] iSubUI;
        JTextField iMinRedField;
        JTextField iMaxRedField;
        JCheckBox iUseExprBox;
        Image3D iParent;
        private String[] COLORS = new String[]{"red", "blue", "green", "yellow", "cyan", "magenta", "pink", "gray", "white", "omit"};
        private String[] TRANSPROPS = new String[]{"omit", "transparent", "white"};
        private String[] GRAYDEPTH = new String[]{"white", "light gray    ", "dark gray"};
        private static final int WIDTH = 15;

        public PropertiesTab(Image3D parent) {
            this.iParent = parent;
            Border blackline = BorderFactory.createLineBorder(Color.black);
            this.iSubUI = new SublineageUI[Image3D.this.iDispProps.length];
            this.iPanel = new JPanel();
            this.iPanel.setLayout(new BorderLayout());
            this.iPanel.setBorder(blackline);
            JPanel lineagePanel = new JPanel();
            JPanel dummyPanel = new JPanel();
            JPanel topPart = new JPanel();
            topPart.setLayout(new GridLayout(1, 2));
            lineagePanel.setLayout(new GridLayout(0, 1));
            lineagePanel.setBorder(blackline);
            topPart.add(lineagePanel);
            topPart.add(dummyPanel);
            JPanel[] testPanel = new JPanel[Image3D.this.iDispProps.length];
            JPanel labelPanel = new JPanel();
            JLabel sublineage = new JLabel("sublineage");
            JLabel color = new JLabel("color");
            labelPanel.setLayout(new GridLayout(1, 2));
            labelPanel.add(sublineage);
            labelPanel.add(color);
            lineagePanel.add(labelPanel);
            for (int i = 0; i < Image3D.this.iDispProps.length; ++i) {
                this.iSubUI[i] = new SublineageUI(i);
                lineagePanel.add(this.iSubUI[i].iPanel);
            }
            lineagePanel.setMaximumSize(new Dimension(200, 200));
            this.iPanel.add((Component)topPart, "North");
            JPanel botPart = new JPanel();
            botPart.setLayout(new GridLayout(3, 1));
            this.iPanel.add((Component)botPart, "Center");
            JPanel filePanel = new JPanel();
            filePanel.setLayout(new GridLayout(1, 2));
            JButton load = new JButton("Load from file");
            JButton save = new JButton("Save to file");
            filePanel.add(load);
            filePanel.add(save);
            load.addActionListener(this);
            save.addActionListener(this);
            botPart.add(filePanel);
            JPanel jp = new JPanel(new FlowLayout());
            jp.setBorder(blackline);
            this.iMinRedField = new JTextField(String.valueOf(Image3D.this.iMinRed), 7);
            this.iMaxRedField = new JTextField(String.valueOf(Image3D.this.iMaxRed), 7);
            this.iUseExprBox = new JCheckBox("Use Expression", Image3D.this.iUseExpression);
            jp.add(this.iUseExprBox);
            jp.add(new JLabel("minRed"));
            jp.add(this.iMinRedField);
            jp.add(new JLabel("maxRed"));
            jp.add(this.iMaxRedField);
            botPart.add(jp);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(1, 3));
            JButton reset = new JButton("Reset");
            JButton apply = new JButton("Apply");
            JButton cancel = new JButton("Cancel");
            buttonPanel.add(apply);
            reset.addActionListener(this);
            apply.addActionListener(this);
            cancel.addActionListener(this);
            buttonPanel.add(reset);
            buttonPanel.add(apply);
            buttonPanel.add(cancel);
            botPart.add(buttonPanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Cancel")) {
                Image3D.this.updateDisplayedTab();
            } else if (command.equals("Reset")) {
                Image3D.this.iDispProps = Image3D.this.getDisplayProps();
                for (int i = 0; i < Image3D.this.iDispProps.length; ++i) {
                    this.iSubUI[i].iTF.setText(Image3D.this.iDispProps[i].iName);
                    this.iSubUI[i].iCB.setSelectedIndex(Image3D.this.iDispProps[i].iLineageNum);
                }
                Image3D.this.iMinRed = 25000;
                Image3D.this.iMaxRed = 100000;
                Image3D.this.iUseExpression = false;
            } else if (command.equals("Apply")) {
                for (int i = 0; i < Image3D.this.iDispProps.length; ++i) {
                    String name = this.iSubUI[i].iTF.getText();
                    if (name.length() == 0) {
                        name = "-";
                    }
                    int num = this.iSubUI[i].iCB.getSelectedIndex();
                    Image3D.this.iDispProps[i].iName = name;
                    Image3D.this.iDispProps[i].iLineageNum = num;
                }
                Image3D.this.iMinRed = Integer.parseInt(this.iMinRedField.getText());
                Image3D.this.iMaxRed = Integer.parseInt(this.iMaxRedField.getText());
                Image3D.this.iUseExpression = this.iUseExprBox.isSelected();
                Image3D.this.iAceTree.setDispProps3D(Image3D.this.iDispProps);
                Image3D.this.updateDisplayedTab();
            } else if (command.equals("Load from file")) {
                System.out.println("Load from file");
                this.loadFromFile();
            } else if (command.equals("Save to file")) {
                System.out.println("Save to file");
                this.saveToFile();
            }
        }

        private void saveToFile() {
            JFileChooser fileChooser = new JFileChooser(".");
            int returnVal = fileChooser.showSaveDialog(null);
            if (returnVal != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            System.out.println("saveToFile: " + file);
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(fileChooser.getSelectedFile()));
                for (int i = 0; i < Image3D.this.iDispProps.length - 2; ++i) {
                    ps.println(Image3D.this.iDispProps[i].iName + Image3D.CS + this.COLORS[Image3D.this.iDispProps[i].iLineageNum]);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }

        private void loadFromFile() {
            JFileChooser fileChooser = new JFileChooser(".");
            int returnVal = fileChooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            System.out.println("loadFromFile: " + file);
            try {
                FileInputStream fis = new FileInputStream(file);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String sr = br.readLine();
                for (int count = 0; sr != null && sr.length() > 2 && count < Image3D.this.iDispProps.length - 2; ++count) {
                    String[] sa = sr.split(",");
                    sa[0] = sa[0].trim();
                    sa[1] = sa[1].trim();
                    System.out.println("loadFromFile: " + sa[0] + Image3D.CS + sa[1]);
                    Image3D.this.iDispProps[count].iName = sa[0];
                    Image3D.this.iDispProps[count].iLineageNum = this.getColorNumber(sa[1]);
                    sr = br.readLine();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            for (int i = count; i < Image3D.this.iDispProps.length - 2; ++i) {
                Image3D.this.iDispProps[i].iName = "";
                Image3D.this.iDispProps[i].iLineageNum = 0;
            }
            this.update();
        }

        public int getColorNumber(String colorName) {
            int k = 0;
            for (int i = 0; i < this.COLORS.length; ++i) {
                if (!colorName.equals(this.COLORS[i])) continue;
                return i;
            }
            return k;
        }

        public void update() {
            for (int i = 0; i < Image3D.this.iDispProps.length - 2; ++i) {
                this.iSubUI[i].iTF.setText(Image3D.this.iDispProps[i].iName);
                this.iSubUI[i].iCB.setSelectedIndex(Image3D.this.iDispProps[i].iLineageNum);
            }
        }

        public JPanel getPanel() {
            return this.iPanel;
        }

        public class SublineageUI {
            public JPanel iPanel = new JPanel();
            public JTextField iTF;
            public JComboBox iCB;

            public SublineageUI(int i) {
                this.iPanel.setLayout(new GridLayout(1, 2));
                this.iTF = new JTextField(Image3D.this.iDispProps[i].iName, 15);
                String[] list = PropertiesTab.this.COLORS;
                if (i == Image3D.this.iDispProps.length - 2) {
                    list = PropertiesTab.this.TRANSPROPS;
                } else if (i == Image3D.this.iDispProps.length - 1) {
                    list = PropertiesTab.this.GRAYDEPTH;
                }
                this.iCB = new JComboBox<String>(list);
                this.iCB.setSelectedIndex(Image3D.this.iDispProps[i].iLineageNum);
                this.iPanel.add(this.iTF);
                this.iPanel.add(this.iCB);
                this.iPanel.setMaximumSize(new Dimension(200, 10));
            }
        }
    }

    public class SublineageDisplayProperty {
        public String iName;
        public int iLineageNum;

        public SublineageDisplayProperty(String name, int lineageNum) {
            this.iName = name;
            this.iLineageNum = lineageNum;
        }
    }

    public class NamedSphere
    extends Sphere {
        String iName;

        public NamedSphere(String name, float r, Appearance a) {
            super(r, a);
            this.iName = name;
        }
    }

    public class Axis {
        private BranchGroup axisBG;

        public Axis() {
            BranchGroup axisBG = Image3D.this.iBG;
            LineArray axisXLines = new LineArray(2, 1);
            axisBG.addChild((Node)new Shape3D((Geometry)axisXLines));
            axisXLines.setCoordinate(0, new Point3f(-1.0f, 0.0f, 0.0f));
            axisXLines.setCoordinate(1, new Point3f(1.0f, 0.0f, 0.0f));
            Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
            Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
            Color3f blue = new Color3f(0.0f, 0.0f, 1.0f);
            LineArray axisYLines = new LineArray(2, 5);
            axisBG.addChild((Node)new Shape3D((Geometry)axisYLines));
            axisYLines.setCoordinate(0, new Point3f(0.0f, -1.0f, 0.0f));
            axisYLines.setCoordinate(1, new Point3f(0.0f, 1.0f, 0.0f));
            axisYLines.setColor(0, green);
            axisYLines.setColor(1, blue);
            Point3f z1 = new Point3f(0.0f, 0.0f, -1.0f);
            Point3f z2 = new Point3f(0.0f, 0.0f, 1.0f);
            LineArray axisZLines = new LineArray(10, 5);
            axisBG.addChild((Node)new Shape3D((Geometry)axisZLines));
            axisZLines.setCoordinate(0, z1);
            axisZLines.setCoordinate(1, z2);
            axisZLines.setCoordinate(2, z2);
            axisZLines.setCoordinate(3, new Point3f(0.1f, 0.1f, 0.9f));
            axisZLines.setCoordinate(4, z2);
            axisZLines.setCoordinate(5, new Point3f(-0.1f, 0.1f, 0.9f));
            axisZLines.setCoordinate(6, z2);
            axisZLines.setCoordinate(7, new Point3f(0.1f, -0.1f, 0.9f));
            axisZLines.setCoordinate(8, z2);
            axisZLines.setCoordinate(9, new Point3f(-0.1f, -0.1f, 0.9f));
            Color3f[] colors = new Color3f[9];
            colors[0] = new Color3f(0.0f, 1.0f, 1.0f);
            for (int v = 0; v < 9; ++v) {
                colors[v] = red;
            }
            axisZLines.setColors(1, colors);
        }
    }

    public class Nuclei3D {
        private boolean iShowIt;

        public Nuclei3D() {
            AceTree a = Image3D.this.iAceTree;
            Image3D.this.iBG = new BranchGroup();
            Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
            Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
            Material m = new Material(eColor, eColor, sColor, sColor, 100.0f);
            m.setLightingEnable(true);
            Appearance app = new Appearance();
            app.setMaterial(m);
            this.addNuclei();
        }

        private Appearance setColor(Color3f color) {
            Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
            Color3f sColor = color;
            Material m = new Material(eColor, eColor, sColor, sColor, 100.0f);
            m.setLightingEnable(true);
            Appearance app = new Appearance();
            app.setMaterial(m);
            return app;
        }

        private Appearance getLineageColor(int k) {
            Appearance app = null;
            switch (k) {
                case 0: {
                    app = this.setColor(ColorConstants.red);
                    break;
                }
                case 1: {
                    app = this.setColor(ColorConstants.blue);
                    break;
                }
                case 2: {
                    app = this.setColor(ColorConstants.green);
                    break;
                }
                case 3: {
                    app = this.setColor(ColorConstants.yellow);
                    break;
                }
                case 4: {
                    app = this.setColor(ColorConstants.cyan);
                    break;
                }
                case 5: {
                    app = this.setColor(ColorConstants.magenta);
                    break;
                }
                case 6: {
                    app = this.setColor(ColorConstants.pink);
                    break;
                }
                case 7: {
                    app = this.setColor(ColorConstants.gray);
                    break;
                }
                case 8: {
                    app = this.setColor(ColorConstants.white);
                    break;
                }
                default: {
                    app = null;
                }
            }
            return app;
        }

        private Appearance getExpressionColor(Nucleus n) {
            Cell.setMinRed(Image3D.this.iMinRed);
            Cell.setMaxRed(Image3D.this.iMaxRed);
            int k = Cell.getDiscrete(n.rweight);
            Color color = Cell.getTheColor(k);
            Color3f c3f = new Color3f(color);
            Appearance app = this.setColor(c3f);
            return app;
        }

        private Vector copyNuclei(Vector nuclei) {
            Vector<Nucleus> newNuclei = new Vector<Nucleus>();
            Enumeration e = nuclei.elements();
            Nucleus n = null;
            while (e.hasMoreElements()) {
                n = (Nucleus)e.nextElement();
                newNuclei.add(n.copy());
            }
            Collections.sort(newNuclei, n);
            return newNuclei;
        }

        private void addNuclei() {
            int count = 0;
            boolean falsePos = false;
            boolean falseNeg = false;
            NucleiMgr nucleiMgr = Image3D.this.iAceTree.getNucleiMgr();
            int time = Image3D.this.iAceTree.getImageTime() + Image3D.this.iAceTree.getTimeInc();
            Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - 1);
            nuclei = this.copyNuclei(nuclei);
            this.getCenter(nuclei);
            Nucleus n = null;
            int width = ImageWindow.cImageWidth;
            int height = ImageWindow.cImageHeight;
            float scale = width / 2;
            float xoff = Image3D.this.iXA;
            float yoff = Image3D.this.iYA;
            float zoff = Image3D.this.iZA;
            for (int j = 0; j < nuclei.size(); ++j) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.status < 0) continue;
                float xf = ((float)n.x - xoff) / scale;
                float yf = ((float)n.y - yoff) / scale;
                yf = -yf;
                float z = (float)Image3D.this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
                z = -z;
                float rf = (float)(n.size / 2) / scale;
                Appearance app = new Appearance();
                TransparencyAttributes tran = new TransparencyAttributes(2, 1.0f);
                TransparencyAttributes tran2 = new TransparencyAttributes(2, 0.5f);
                tran.setTransparency(0.8f);
                int k = Image3D.this.getLineageNumber(n.identity);
                this.iShowIt = true;
                if (k < Image3D.this.iDispProps.length - 2) {
                    app = this.getLineageColor(k);
                } else {
                    int m = Image3D.this.iDispProps[Image3D.this.iDispProps.length - 2].iLineageNum;
                    switch (m) {
                        case 0: {
                            this.iShowIt = false;
                            break;
                        }
                        case 1: {
                            app.setTransparencyAttributes(tran);
                            break;
                        }
                        default: {
                            app = this.getLineageColor(8);
                        }
                    }
                }
                if (Image3D.this.iUseExpression) {
                    app = this.getExpressionColor(n);
                    if (n.rweight < Image3D.this.iMinRed) {
                        app = this.setColor(ColorConstants.white);
                        app.setTransparencyAttributes(tran);
                        this.iShowIt = true;
                    }
                } else if (Image3D.this.iDispProps[Image3D.this.iDispProps.length - 3].iName.indexOf("Special") == 0) {
                    app = this.special(n);
                }
                if (!this.iShowIt || app == null) continue;
                Image3D.this.iBG.addChild((Node)this.makeNamedSphere(n.identity, xf, yf, z, rf, app));
                if (app.getTransparencyAttributes() == tran) continue;
                ++count;
            }
        }

        private boolean inSCAList(Nucleus n) {
            String[] theList = new String[]{"ABaraaappaa", "ABalpaappa", "ABaraaappap", "ABaraaapaaa", "ABaraaappp", "MSaaaaaa", "ABalpaapppa", "ABprpapppp", "ABalpaapppp"};
            for (int i = 0; i < theList.length; ++i) {
                if (!n.identity.equals(theList[i])) continue;
                return true;
            }
            return false;
        }

        private Appearance special(Nucleus n) {
            Appearance appRest;
            TransparencyAttributes faint = new TransparencyAttributes(2, 0.8f);
            TransparencyAttributes invisible = new TransparencyAttributes(2, 1.0f);
            TransparencyAttributes solid = new TransparencyAttributes(2, 0.0f);
            Appearance app = null;
            String name = n.identity;
            app = appRest = null;
            this.iShowIt = true;
            if (name.indexOf("E") == 0) {
                app = this.setColor(ColorConstants.yellow);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("MSaa") == 0) {
                app = this.setColor(ColorConstants.magenta);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSaaaaaa") == 0 || name.indexOf("MSaappp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("MSpa") == 0) {
                app = this.setColor(ColorConstants.cyan);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSpapp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABalpaaa") == 0 || name.indexOf("ABalpaapa") == 0 || name.indexOf("ABalpapp") == 0) {
                app = this.setColor(ColorConstants.pink);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABaraaaa") == 0 || name.indexOf("ABaraaapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABaraaapaaa") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABaraap") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABarapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABarapapapa") == 0) {
                    app = appRest;
                }
            }
            if (app == appRest) {
                this.iShowIt = true;
                app = this.setColor(ColorConstants.white);
                app.setTransparencyAttributes(faint);
            }
            return app;
        }

        private Appearance special(Nucleus n, boolean bogus) {
            Appearance appRest;
            TransparencyAttributes faint = new TransparencyAttributes(2, 0.8f);
            TransparencyAttributes invisible = new TransparencyAttributes(2, 1.0f);
            TransparencyAttributes solid = new TransparencyAttributes(2, 0.0f);
            Appearance app = null;
            String name = n.identity;
            app = appRest = null;
            this.iShowIt = true;
            if (name.indexOf("E") == 0) {
                app = this.setColor(ColorConstants.green);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("MSaa") == 0) {
                app = this.setColor(ColorConstants.magenta);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSaaaaaa") == 0 || name.indexOf("MSaappp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("MSpa") == 0) {
                app = this.setColor(ColorConstants.cyan);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSpapp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABalpaaa") == 0 || name.indexOf("ABalpaapa") == 0 || name.indexOf("ABalpapp") == 0) {
                app = this.setColor(ColorConstants.red);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABaraaaa") == 0 || name.indexOf("ABaraaapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABaraaapaaa") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABaraap") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABarapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABarapapapa") == 0) {
                    app = appRest;
                }
            }
            if (app == appRest) {
                this.iShowIt = true;
                app = this.setColor(ColorConstants.white);
                app.setTransparencyAttributes(faint);
            }
            return app;
        }

        private void getCenter(Vector nuclei) {
            Image3D.this.iXA = 0;
            Image3D.this.iYA = 0;
            Image3D.this.iZA = 0.0f;
            int count = 0;
            Enumeration e = nuclei.elements();
            while (e.hasMoreElements()) {
                Nucleus n = (Nucleus)e.nextElement();
                if (n.status == -1) continue;
                Image3D.this.iXA += n.x;
                Image3D.this.iYA += n.y;
                Image3D.this.iZA += n.z;
                ++count;
            }
            Image3D.this.iXA /= count;
            Image3D.this.iYA /= count;
            Image3D.this.iZA /= count;
        }

        private TransformGroup makeNamedSphere(String name, float x, float y, float z, float r, Appearance a) {
            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(x, y, z));
            NamedSphere sph = new NamedSphere(name, r, a);
            TransformGroup tg = new TransformGroup(translate);
            tg.addChild((Node)sph);
            return tg;
        }

        private TransformGroup makeSphere(float x, float y, float z, float r, Appearance a) {
            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(x, y, z));
            Sphere sph = new Sphere(r, a);
            TransformGroup tg = new TransformGroup(translate);
            tg.addChild((Node)sph);
            return tg;
        }

        public BranchGroup getBG() {
            return Image3D.this.iBG;
        }
    }
}

