/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.PlayerControlAceAtlas;
import org.rhwlab.image.Image3DGeometryManager;
import org.rhwlab.image.Image3DOverlayGenerator;
import org.rhwlab.image.Image3DViewConfig;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.Indicator3D;
import org.rhwlab.image.NamedSphere;
import org.rhwlab.image.SublineageDisplayProperty;
import org.rhwlab.image.SublineageUI;
import org.rhwlab.image.Trans;
import org.rhwlab.snight.NucleiMgr;
import qdxml.DocHandler;
import qdxml.QDParser;

public class Image3D2
extends MouseAdapter
implements ActionListener,
Runnable,
DocHandler,
ChangeListener,
ItemListener {
    protected PickCanvas iPickCanvas;
    protected AceTree iAceTree;
    protected NucleiMgr iNucleiMgr;
    public BranchGroup iBG2;
    private Background iBackground;
    protected JFrame iFrame;
    protected SimpleUniverse iUniverse;
    protected Canvas3D iCanvas;
    protected Canvas3D iOfflineCanvas;
    protected SimpleUniverse iOfflineUniverse;
    private JPanel iColorControlPanel;
    private SublineageUI[] iSubUI;
    private JTextField iMinRedField;
    private JTextField iMaxRedField;
    private JCheckBox iUseExprBox;
    private JRadioButton iUseExprColors;
    private JCheckBox iShowNonExpressingChkBox;
    private JPanel trackingPanel;
    private JButton customTailColor;
    private JSlider opacitySlider;
    private JSlider timePts;
    private JSlider overlayMinXSlider;
    private JSlider overlayMinYSlider;
    private JSlider overlayMinZSlider;
    private JSlider overlayMaxXSlider;
    private JSlider overlayMaxYSlider;
    private JSlider overlayMaxZSlider;
    private JSlider overlaySubsampleSlider;
    private JCheckBox overlayRedChannel;
    private JCheckBox overlayGreenChannel;
    private JCheckBox overlayBlueChannel;
    private JCheckBox overlayAutoROI;
    private JButton showOverlay;
    private JButton showTails;
    protected String iTitle;
    boolean iNewConstruction;
    Thread iThread;
    boolean iSaveInProcess;
    static boolean iSaveImage;
    boolean fakeit1;
    boolean fakeit2;
    JTextField iAngle;
    JTextField iScale;
    JLabel iPick;
    private int iXA;
    protected int iYA;
    protected float iZA;
    protected Transform3D iRotate;
    protected TransformGroup iRotGroup;
    protected TransformGroup iTranslateGroup;
    protected Matrix4d iMatrix;
    protected JPanel iImagePanel;
    protected JTabbedPane iTabbedPane;
    protected JTextField iAngX;
    protected JTextField iAngXInc;
    protected JButton iXUp;
    protected JButton iXDn;
    protected JTextField iAngY;
    protected JTextField iAngYInc;
    protected JButton iYUp;
    protected JButton iYDn;
    protected JTextField iAngZ;
    protected JTextField iAngZInc;
    protected JButton iZUp;
    protected JButton iZDn;
    protected JTextField iPosIncr;
    protected JTextField iPos;
    protected JButton iPIn;
    protected JButton iPOut;
    protected JButton iRestore;
    protected JButton iUndoButton;
    protected Vector iUndo;
    protected JButton iSaveMovie;
    protected JButton iShowSisters;
    protected JButton iLoadButton;
    protected JButton iSaveButton;
    protected JButton iSaveImageButton;
    protected String iSaveImageAsDir;
    protected String iLastSaveAsName;
    protected String iSaveMovieDir;
    BranchGroup iBGT;
    Indicator3D iIndicator;
    private BranchGroup iNucBG;
    protected Image3DGeometryManager geometryManager;
    protected Image3DViewConfig viewConfig;
    private Image3DOverlayGenerator overlayGenerator;
    private static final String CS = ", ";
    private static final String IMAGETYPE = "jpeg";
    private Color3f[] BACKGROUNDS = new Color3f[]{new Color3f(1.0f, 1.0f, 1.0f), new Color3f(0.3f, 0.3f, 0.3f), new Color3f(0.1f, 0.1f, 0.1f)};
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    public Image3D2() {
    }

    public Image3D2(AceTree aceTree, String title) {
        this.iAceTree = aceTree;
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iTitle = title;
        this.viewConfig = Image3DViewConfig.getInstance();
        this.viewConfig.setTitle(this.iTitle);
        this.geometryManager = new Image3DGeometryManager(this);
        this.overlayGenerator = new Image3DOverlayGenerator(this);
        this.overlayGenerator.start();
        System.out.println("overlay generator now running");
        this.iFrame = new JFrame(title);
        this.iFrame.setDefaultCloseOperation(0);
        WinEventMgr wem = new WinEventMgr();
        this.iFrame.addWindowListener(wem);
        this.iNewConstruction = true;
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setSceneAntialiasing(2);
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        this.iCanvas = new Canvas3D(config);
        this.iCanvas.setSize(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
        this.iUniverse = new SimpleUniverse(this.iCanvas);
        this.iUniverse.getViewer().getView().setSceneAntialiasingEnable(false);
        this.iUniverse.getViewingPlatform().setNominalViewingTransform();
        this.iOfflineCanvas = new Canvas3D(config, true);
        this.iOfflineCanvas.setSize(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
        this.iOfflineUniverse = new SimpleUniverse(this.iOfflineCanvas);
        this.iOfflineUniverse.getViewingPlatform().setNominalViewingTransform();
        ViewingPlatform viewingPlatform = this.iUniverse.getViewingPlatform();
        this.iTranslateGroup = viewingPlatform.getViewPlatformTransform();
        this.iMatrix = new Matrix4d();
        Transform3D t3d = new Transform3D();
        this.iTranslateGroup.getTransform(t3d);
        this.buildOutImageUI();
        this.buildColorControlGUI();
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.addTab("Image", null, this.iImagePanel, "View 3D image");
        Object dispProps = this.iAceTree.getDispProps3D2();
        if (dispProps == null) {
            this.iAceTree.setDispProps3D2(this.viewConfig.getDispProps());
        }
        this.iTabbedPane.addTab("Color Controls", null, this.iColorControlPanel, "Set color scheme");
        URL imageURL = Image3D2.class.getResource("/images/icon2.gif");
        ImageIcon test = new ImageIcon(imageURL, "x");
        this.iFrame.setIconImage(test.getImage());
        this.iFrame.getContentPane().add(this.iTabbedPane);
        this.iCanvas.addMouseListener((MouseListener)this);
        this.iFrame.pack();
        this.iFrame.show();
        this.iUndo = new Vector();
        this.insertContent(this.iTitle);
        this.iSaveImageAsDir = "";
        this.iLastSaveAsName = "";
        this.setKeyboardActions();
    }

    public AceTree getAceTree() {
        return this.iAceTree;
    }

    protected void setKeyboardActions() {
        String actionKey = "";
        KeyStroke stroke = null;
        InputMap inputMap = null;
        ActionMap actionMap = null;
        String s = "LEFT";
        AbstractAction left = new AbstractAction("LEFT"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent awt = e;
                Image3D2.this.iAceTree.prevTime();
                Image3D2.this.iAceTree.updateDisplay();
            }
        };
        this.iTabbedPane.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.iTabbedPane.getActionMap().put(s, left);
        actionKey = "a_left";
        stroke = KeyStroke.getKeyStroke("typed a");
        inputMap = this.iTabbedPane.getInputMap(1);
        inputMap.put(stroke, actionKey);
        actionMap = this.iTabbedPane.getActionMap();
        actionMap.put(actionKey, left);
        s = "RIGHT";
        AbstractAction right = new AbstractAction(s){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Image3D2.this.iAceTree.nextTime()) {
                    Image3D2.this.iAceTree.updateDisplay();
                }
            }
        };
        this.iTabbedPane.getInputMap(1).put(KeyStroke.getKeyStroke(s), s);
        this.iTabbedPane.getActionMap().put(s, right);
        actionKey = "d_right";
        stroke = KeyStroke.getKeyStroke("typed d");
        inputMap = this.iTabbedPane.getInputMap(1);
        inputMap.put(stroke, actionKey);
        actionMap = this.iTabbedPane.getActionMap();
        actionMap.put(actionKey, right);
    }

    protected void buildOutImageUI() {
        this.iPick = new JLabel("pick");
        this.iImagePanel = new JPanel();
        this.iImagePanel.setLayout(new BorderLayout());
        this.iImagePanel.add((Component)this.iCanvas, "Center");
        JPanel secondPanel = new JPanel(new BorderLayout());
        JPanel belowScene = new JPanel(new GridLayout(0, 1));
        secondPanel.add((Component)belowScene, "North");
        belowScene.add(new PlayerControlAceAtlas(this.iAceTree));
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 3));
        JPanel rotatePanels = new JPanel();
        rotatePanels.setLayout(new GridLayout(0, 1));
        JPanel rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("angX"));
        this.iAngXInc = new JTextField("30", 5);
        this.iAngX = new JTextField("0", 10);
        this.iXUp = new JButton("up");
        this.iXDn = new JButton("down");
        rotatePanel.add(this.iAngXInc);
        rotatePanel.add(this.iAngX);
        rotatePanel.add(this.iXUp);
        rotatePanel.add(this.iXDn);
        this.iXUp.addActionListener(this);
        this.iXDn.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("angY"));
        this.iAngYInc = new JTextField("30", 5);
        this.iAngY = new JTextField("0", 10);
        this.iYUp = new JButton("up");
        this.iYDn = new JButton("down");
        rotatePanel.add(this.iAngYInc);
        rotatePanel.add(this.iAngY);
        rotatePanel.add(this.iYUp);
        rotatePanel.add(this.iYDn);
        this.iYUp.addActionListener(this);
        this.iYDn.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("angZ"));
        this.iAngZInc = new JTextField("30", 5);
        this.iAngZ = new JTextField("0", 10);
        this.iZUp = new JButton("up");
        this.iZDn = new JButton("down");
        rotatePanel.add(this.iAngZInc);
        rotatePanel.add(this.iAngZ);
        rotatePanel.add(this.iZUp);
        rotatePanel.add(this.iZDn);
        this.iZUp.addActionListener(this);
        this.iZDn.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("Pos"));
        Transform3D t3d = new Transform3D();
        this.iTranslateGroup.getTransform(t3d);
        t3d.get(this.iMatrix);
        this.iPosIncr = new JTextField("0.2", 5);
        this.iPos = new JTextField(Image3D2.fmt1(this.iMatrix.m23), 10);
        this.iPIn = new JButton("in");
        this.iPOut = new JButton("out");
        rotatePanel.add(this.iPosIncr);
        rotatePanel.add(this.iPos);
        rotatePanel.add(this.iPIn);
        rotatePanel.add(this.iPOut);
        this.iPIn.addActionListener(this);
        this.iPOut.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        this.iLoadButton = new JButton("Load Orientation");
        rotatePanel.add(this.iLoadButton);
        this.iLoadButton.addActionListener(this);
        this.iSaveButton = new JButton("Save Orientation");
        this.iSaveButton.addActionListener(this);
        rotatePanel.add(this.iSaveButton);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        this.iRestore = new JButton("Default Orientation");
        this.iRestore.addActionListener(this);
        rotatePanel.add(this.iRestore);
        this.iShowSisters = new JButton("Show Sisters");
        this.iShowSisters.addActionListener(this);
        this.showTails = new JButton("Show Tails");
        this.showTails.addActionListener(this);
        rotatePanel.add(this.showTails);
        rotatePanel.add(this.iShowSisters);
        this.showOverlay = new JButton("Show Overlay");
        this.showOverlay.addActionListener(this);
        rotatePanel.add(this.showOverlay);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        this.iSaveMovie = new JButton("Save Movie");
        rotatePanel.add(this.iSaveMovie);
        this.iSaveMovie.addActionListener(this);
        this.iSaveImageButton = new JButton("Save Still Image");
        rotatePanel.add(this.iSaveImageButton);
        this.iSaveImageButton.addActionListener(this);
        rotatePanel.add(this.iSaveImageButton);
        rotatePanels.add(rotatePanel);
        newPanel.add(rotatePanels);
        secondPanel.add((Component)newPanel, "West");
        this.iIndicator = new Indicator3D();
        this.iIndicator.setAlignmentY(0.5f);
        secondPanel.add((Component)this.iIndicator, "East");
        this.iImagePanel.add((Component)secondPanel, "South");
    }

    public void updateDisplayedTab() {
        this.iTabbedPane.setSelectedIndex(0);
        this.insertContent(this.iTitle);
    }

    private void applyTrans(double incr, char axis) {
        int angle = 0;
        Transform3D t3d = new Transform3D();
        switch (axis) {
            case 'x': {
                t3d.rotX(incr);
                this.iUndo.add(new Trans(t3d, incr, 'x'));
                angle = Integer.parseInt(this.iAngX.getText());
                angle = (int)((long)angle + Math.round(Math.toDegrees(incr)));
                this.iAngX.setText(String.valueOf(angle %= 360));
                break;
            }
            case 'y': {
                t3d.rotY(incr);
                this.iUndo.add(new Trans(t3d, incr, 'y'));
                angle = Integer.parseInt(this.iAngY.getText());
                angle = (int)((long)angle + Math.round(Math.toDegrees(incr)));
                this.iAngY.setText(String.valueOf(angle %= 360));
                break;
            }
            case 'z': {
                t3d.rotZ(incr);
                this.iUndo.add(new Trans(t3d, incr, 'z'));
                angle = Integer.parseInt(this.iAngZ.getText());
                angle = (int)((long)angle + Math.round(Math.toDegrees(incr)));
                this.iAngZ.setText(String.valueOf(angle %= 360));
            }
        }
        this.iIndicator.apply(t3d);
        this.iRotate.mul(t3d);
        this.iRotGroup.setTransform(this.iRotate);
    }

    protected void handleRotatePanel(Object o) {
        Matrix4d m4d;
        int angle = 0;
        Transform3D t3d = new Transform3D();
        double incrDeg = 30.0;
        double incr = Math.toRadians(incrDeg);
        if (o == this.iXUp || o == this.iXDn) {
            incrDeg = Integer.parseInt(this.iAngXInc.getText());
            incr = Math.toRadians(incrDeg);
            if (o == this.iXDn) {
                incr *= -1.0;
            }
            this.applyTrans(incr, 'x');
            return;
        }
        if (o == this.iYUp || o == this.iYDn) {
            incrDeg = Integer.parseInt(this.iAngYInc.getText());
            incr = Math.toRadians(incrDeg);
            if (o == this.iYDn) {
                incr *= -1.0;
            }
            this.applyTrans(incr, 'y');
            return;
        }
        if (o == this.iZUp || o == this.iZDn) {
            incrDeg = Integer.parseInt(this.iAngZInc.getText());
            incr = Math.toRadians(incrDeg);
            if (o == this.iZDn) {
                incr *= -1.0;
            }
            this.applyTrans(incr, 'z');
            return;
        }
        if (o == this.iPIn || o == this.iPOut) {
            double pos = Double.parseDouble(this.iPos.getText());
            double posInc = Double.parseDouble(this.iPosIncr.getText());
            if (o == this.iPIn) {
                posInc *= -1.0;
            }
            this.iPos.setText(Image3D2.fmt1(pos += posInc));
            this.iTranslateGroup.getTransform(t3d);
            m4d = new Matrix4d();
            t3d.get(m4d);
            Matrix4d mincr = new Matrix4d();
            mincr.m23 = posInc;
            m4d.add(mincr);
            t3d.set(m4d);
            this.iTranslateGroup.setTransform(t3d);
            t3d.set(mincr);
            this.iUndo.add(new Trans(new Transform3D(), posInc, 'p'));
        }
        if (o == this.iRestore) {
            this.iRotate.mulInverse(this.iRotate);
            this.iRotGroup.setTransform(this.iRotate);
            this.iUndo.clear();
            this.iIndicator.restore();
            this.iAngX.setText("0");
            this.iAngY.setText("0");
            this.iAngZ.setText("0");
            t3d.set(this.iMatrix);
            this.iTranslateGroup.setTransform(t3d);
            this.iPos.setText(Image3D2.fmt1(this.iMatrix.m23));
            return;
        }
        if (o == this.iUndoButton && this.iUndo.size() > 0) {
            Trans t = (Trans)this.iUndo.remove(this.iUndo.size() - 1);
            Transform3D t3 = t.getT3D();
            if (t3 != null) {
                double angInc = Math.toDegrees(t.getAngInc());
                switch (t.getAxis()) {
                    case 'x': {
                        angle = Integer.parseInt(this.iAngX.getText());
                        angle = (int)((double)angle - angInc);
                        this.iAngX.setText(String.valueOf(angle));
                        this.handleRotateUndo(t3);
                        break;
                    }
                    case 'y': {
                        angle = Integer.parseInt(this.iAngY.getText());
                        angle = (int)((double)angle - angInc);
                        this.iAngY.setText(String.valueOf(angle));
                        this.handleRotateUndo(t3);
                        break;
                    }
                    case 'z': {
                        angle = Integer.parseInt(this.iAngZ.getText());
                        angle = (int)((double)angle - angInc);
                        this.iAngZ.setText(String.valueOf(angle));
                        this.handleRotateUndo(t3);
                        break;
                    }
                    case 'p': {
                        this.iTranslateGroup.getTransform(t3d);
                        m4d = new Matrix4d();
                        t3d.get(m4d);
                        m4d.m23 -= t.getAngInc();
                        t3d.set(m4d);
                        this.iTranslateGroup.setTransform(t3d);
                        double pos = Double.parseDouble(this.iPos.getText());
                        this.iPos.setText(Image3D2.fmt1(pos -= t.getAngInc()));
                    }
                }
            }
            this.iRotGroup.setTransform(this.iRotate);
        }
    }

    private void handleRotateUndo(Transform3D t3) {
        t3.invert();
        this.iRotate.mul(t3);
        this.iIndicator.apply(t3);
    }

    protected void saveRotations() {
        File file = null;
        JFileChooser fileChooser = new JFileChooser(this.viewConfig.getCurrentRotDir());
        int returnVal = fileChooser.showSaveDialog(this.iAceTree);
        if (returnVal != 0) {
            System.out.println("Save command cancelled by user.");
            return;
        }
        file = fileChooser.getSelectedFile();
        this.viewConfig.setCurrentRotDir(file.getParent());
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            pw = new PrintWriter(fos, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.println();
        pw.println("<rotations>");
        for (int i = 0; i < this.iUndo.size(); ++i) {
            Trans t = (Trans)this.iUndo.get(i);
            StringBuffer sb = new StringBuffer();
            sb.append("<rotation ");
            sb.append("radians=\"" + t.getAngInc() + "\" ");
            sb.append("axis=\"" + t.getAxis() + "\"/>");
            pw.println(sb.toString());
        }
        pw.println("</rotations>");
    }

    protected void loadRotations() {
        File file = null;
        JFileChooser fileChooser = new JFileChooser(this.viewConfig.getCurrentRotDir());
        int returnVal = fileChooser.showOpenDialog(this.iAceTree);
        if (returnVal != 0) {
            System.out.println("Save command cancelled by user.");
            return;
        }
        file = fileChooser.getSelectedFile();
        this.viewConfig.setCurrentRotDir(file.getParent());
        try {
            FileReader fr = new FileReader(file);
            QDParser.parse(this, fr);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String tag, Hashtable h) throws Exception {
        if (tag.equals("rotation")) {
            String incrs = (String)h.get("radians");
            String axiss = (String)h.get("axis");
            double incr = Double.parseDouble(incrs);
            char axis = axiss.charAt(0);
            this.applyTrans(incr, axis);
        } else if (tag.equals("lineage")) {
            String name = (String)h.get("name");
            String color = (String)h.get("color");
            int lineageCount = this.viewConfig.getLineageCount();
            this.viewConfig.getDispProp(lineageCount).setName(name);
            this.viewConfig.getDispProp(lineageCount).setLineageNum(Image3DViewConfig.getColorIndex(color));
            this.viewConfig.setLineageCount(lineageCount++);
        }
    }

    private void saveMovie() {
        if (!iSaveImage) {
            System.out.println("in setting save");
            iSaveImage = true;
            if (!this.iAceTree.hasActiveImage3D2()) {
                System.out.println("no active image3d2");
                this.iAceTree.threeDview2();
            } else {
                String name = this.iAceTree.iImgWin.getTitle();
                name = name.substring(0, name.length() - 8);
                name = name.substring(4, name.length());
                String path = this.iAceTree.iImgWin.getSaveImageDirectory() + "/" + name + ".jpeg";
                this.offScreenRendering(path);
            }
            this.iSaveMovie.setText("Stop Save Movie");
        } else {
            System.out.println("in stopping save");
            iSaveImage = false;
            this.iSaveMovie.setText("Save Movie");
            int width = 700;
            int n = 500;
        }
        this.updateDisplayedTab();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object o = e.getSource();
        if (command.equals("Cancel Changes")) {
            this.updateDisplayedTab();
        } else if (command.equals("Reset Colors")) {
            this.viewConfig.propertiesReset();
        } else if (command.equals("Apply Changes")) {
            for (int i = 0; i < this.viewConfig.getNumDispProps(); ++i) {
                String name = this.iSubUI[i].getText();
                if (name.length() == 0) {
                    name = "-";
                }
                int lineageNum = this.iSubUI[i].getSelectedIndex();
                this.viewConfig.getDispProp(i).setName(name);
                this.viewConfig.getDispProp(i).setLineageNum(lineageNum);
            }
            this.viewConfig.setMinRed(Integer.parseInt(this.iMinRedField.getText()));
            this.viewConfig.setMaxRed(Integer.parseInt(this.iMinRedField.getText()));
            this.viewConfig.setUseExpression(this.iUseExprBox.isSelected());
            this.viewConfig.setUseExpressionColors(this.iUseExprColors.isSelected());
            this.viewConfig.setShowNonExpressing(this.iShowNonExpressingChkBox.isSelected());
            this.viewConfig.setUseOverlayAutoROI(this.overlayAutoROI.isSelected());
            this.viewConfig.setUseOverlayRedChannel(this.overlayRedChannel.isSelected());
            this.viewConfig.setUseOverlayGreenChannel(this.overlayGreenChannel.isSelected());
            this.viewConfig.setUseOverlayBlueChannel(this.overlayBlueChannel.isSelected());
            this.viewConfig.setOverlaySubsample(this.overlaySubsampleSlider.getValue());
            if (this.viewConfig.isOverlayXYZChanged()) {
                if (this.overlayMinXSlider.getValue() <= this.overlayMaxXSlider.getValue()) {
                    this.viewConfig.setOverlayMinX(this.overlayMinXSlider.getValue());
                    this.viewConfig.setOverlayMaxX(this.overlayMaxXSlider.getValue());
                } else {
                    this.overlayMinXSlider.setValue(0);
                    this.overlayMaxXSlider.setValue(512);
                }
                if (this.overlayMinYSlider.getValue() <= this.overlayMaxXSlider.getValue()) {
                    this.viewConfig.setOverlayMinY(this.overlayMinYSlider.getValue());
                    this.viewConfig.setOverlayMaxY(this.overlayMaxYSlider.getValue());
                } else {
                    this.overlayMinYSlider.setValue(0);
                    this.overlayMaxYSlider.setValue(512);
                }
                if (this.overlayMinZSlider.getValue() <= this.overlayMaxXSlider.getValue()) {
                    this.viewConfig.setOverlayMinZ(this.overlayMinZSlider.getValue());
                    this.viewConfig.setOverlayMaxZ(this.overlayMaxZSlider.getValue());
                } else {
                    this.overlayMinZSlider.setValue(0);
                    this.overlayMaxZSlider.setValue(30);
                }
            }
            this.viewConfig.setTailTimePoints(this.timePts.getValue());
            this.updateDisplayedTab();
        } else if (command.equals("Load Color Scheme")) {
            System.out.println("Load from file");
            this.loadFromFile();
        } else if (command.equals("Save Color Scheme")) {
            System.out.println("Save to file");
            this.saveToFile();
        }
        if (o == this.customTailColor) {
            Color c = this.viewConfig.getCustomTailColor();
            this.viewConfig.setCustomTailColor(JColorChooser.showDialog(this.iFrame, "Select a Custom Tail Color", c));
        }
        if (o == this.iXUp || o == this.iXDn || o == this.iYUp || o == this.iYDn || o == this.iZUp || o == this.iZDn || o == this.iPIn || o == this.iPOut || o == this.iRestore || o == this.iUndoButton) {
            this.handleRotatePanel(o);
            return;
        }
        if (o == this.iSaveMovie) {
            this.saveMovie();
        }
        if (o == this.iShowSisters) {
            if (this.viewConfig.areSistersVisible()) {
                this.viewConfig.setSistersVisible(false);
                this.iShowSisters.setText("Show Sisters");
            } else {
                this.viewConfig.setSistersVisible(true);
                this.iShowSisters.setText("Hide Sisters");
            }
            this.updateDisplayedTab();
        }
        if (o == this.showTails) {
            if (this.viewConfig.isShowingTails()) {
                this.viewConfig.setShowingTails(false);
                this.showTails.setText("Show Tails");
            } else {
                this.viewConfig.setShowingTails(true);
                this.showTails.setText("Hide Tails");
            }
            this.updateDisplayedTab();
        }
        if (o == this.showOverlay) {
            if (this.viewConfig.isShowingOverlay()) {
                this.viewConfig.setShowingOverlay(false);
                this.showOverlay.setText("Show Overlay");
            } else {
                this.viewConfig.setShowingOverlay(true);
                this.showOverlay.setText("Hide Overlay");
            }
            this.updateDisplayedTab();
        }
        if (o == this.iLoadButton) {
            this.loadRotations();
        } else if (o == this.iSaveButton) {
            this.saveRotations();
        } else if (o == this.iSaveImageButton) {
            this.saveImageAs();
        }
    }

    public synchronized void insertContent(String title) {
        if (title.equals("null")) {
            title = this.iTitle;
        }
        if (iSaveImage) {
            this.iUniverse.getViewer().getView().stopView();
            String path = this.iAceTree.iImgWin.getSaveImageDirectory() + "/" + title + "." + IMAGETYPE;
            this.offScreenRendering(path);
            this.iUniverse.getViewer().getView().startView();
        }
        while (this.iSaveInProcess) {
        }
        this.iTitle = title;
        this.viewConfig.setTitle(this.iTitle);
        this.iFrame.setTitle(this.iTitle);
        this.iUniverse.getViewer().getView().stopView();
        this.iBGT = this.createSceneGraph();
        if (this.iBGT == null) {
            this.iAceTree.getPlayerControl().stop();
            return;
        }
        Locale l = this.iUniverse.getLocale();
        this.iUniverse.addBranchGraph(this.iBGT);
        if (this.iBG2 != null) {
            this.iBG2.detach();
        }
        this.iUniverse.getViewer().getView().startView();
        this.iBG2 = this.iBGT;
        this.iPickCanvas = new PickCanvas(this.iCanvas, this.iBG2);
        this.iPickCanvas.setMode(512);
    }

    public void offScreenRendering(String path) {
        Image3D2.println("offScreenRendering, ");
        System.gc();
        int width = 700;
        int height = 500;
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = this.iOfflineCanvas;
        c.getScreen3D().setSize(width, height);
        c.getScreen3D().setPhysicalScreenWidth(2.8222222222222223E-4 * (double)width);
        c.getScreen3D().setPhysicalScreenHeight(2.8222222222222223E-4 * (double)height);
        if (this.iBG2 != null) {
            this.iBG2.detach();
        }
        this.iBG2 = this.createSceneGraph();
        if (this.iBG2 == null) {
            iSaveImage = false;
            this.iAceTree.getPlayerControl().stop();
            return;
        }
        SimpleUniverse su = this.iOfflineUniverse;
        su.addBranchGraph(this.iBG2);
        su.getViewingPlatform().setNominalViewingTransform();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D buffer = new ImageComponent2D(1, bImage);
        System.out.println("Rendering...");
        c.setOffScreenBuffer(buffer);
        c.renderOffScreenBuffer();
        c.waitForOffScreenRendering();
        bImage = c.getOffScreenBuffer().getImage();
        System.out.println("Saving..");
        try {
            DataOutputStream output = new DataOutputStream(new FileOutputStream(path));
            ImageIO.write((RenderedImage)bImage, "JPEG", output);
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iSaveInProcess = false;
        System.out.println(path);
    }

    public BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        root.setCapability(17);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f lColor1 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3d lPos1 = new Vector3d(0.0, 0.5, 2.0);
        Vector3f lDirect1 = new Vector3f(lPos1);
        lDirect1.negate();
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDirect1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)lgt1);
        int m = this.viewConfig.getDispProp(this.viewConfig.getNumDispProps() - 1).getLineageNum();
        switch (m) {
            case 0: {
                bgColor = new Color3f(0.7f, 0.7f, 0.7f);
                break;
            }
            case 1: {
                bgColor = new Color3f(0.3f, 0.3f, 0.3f);
                break;
            }
            default: {
                bgColor = new Color3f(0.1f, 0.1f, 0.1f);
            }
        }
        this.iBackground = new Background(bgColor);
        this.iBackground.setApplicationBounds((Bounds)bounds);
        root.addChild((Node)this.iBackground);
        TransformGroup objRotate = new TransformGroup();
        objRotate.setCapability(18);
        objRotate.setCapability(17);
        objRotate.setCapability(13);
        if (this.viewConfig.isShowingOverlay()) {
            System.out.println("Interrupting overlay generator...");
            this.overlayGenerator.interrupt();
        }
        this.iNucBG = this.geometryManager.createNuclearBranchGroup(this.iXA, this.iYA, this.iZA);
        if (this.geometryManager.empty()) {
            return null;
        }
        this.iNucBG.compile();
        objRotate.addChild((Node)this.iNucBG);
        TransformGroup initRotGroup = new TransformGroup();
        Transform3D initRotate = new Transform3D();
        NucleiMgr nucMgr = this.iAceTree.getNucleiMgr();
        int ap = nucMgr.getParameters().apInit;
        int dv = nucMgr.getParameters().dvInit;
        int lr = nucMgr.getParameters().lrInit;
        if (ap == -1) {
            Transform3D apt = new Transform3D();
            apt.rotZ(Math.PI);
            initRotate.mul(apt);
            ap = -ap;
            dv = -dv;
        }
        if (dv == -1) {
            Transform3D dvt = new Transform3D();
            dvt.rotX(Math.PI);
            initRotate.mul(dvt);
            dv = -dv;
            lr = -lr;
        }
        initRotGroup.setTransform(initRotate);
        initRotGroup.addChild((Node)objRotate);
        if (this.iRotate == null) {
            this.iRotate = new Transform3D();
        }
        this.iRotGroup = new TransformGroup(this.iRotate);
        this.iRotGroup.setCapability(18);
        this.iRotGroup.addChild((Node)initRotGroup);
        root.addChild((Node)this.iRotGroup);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objRotate);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        root.addChild((Node)myMouseRotate);
        root.compile();
        return root;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.iPickCanvas.setShapeLocation(e);
        PickResult[] results = this.iPickCanvas.pickAll();
        String name = this.getPickedNucleusNames(results);
        this.iPick.setText("you picked: " + name);
    }

    private String getPickedNucleusNames(PickResult[] results) {
        String s = "none";
        Vector<String> v = new Vector<String>();
        if (results != null) {
            for (int i = results.length - 1; i >= 0; --i) {
                String pname;
                Primitive p = (Primitive)results[i].getNode(4);
                if (p == null || (pname = p.getClass().getName()).indexOf("NamedSphere") < 0) continue;
                s = ((NamedSphere)p).getName();
                v.add(0, s);
            }
        }
        if (v.size() == 0) {
            return "none";
        }
        Enumeration e = v.elements();
        s = "";
        while (e.hasMoreElements()) {
            if (s.length() > 0) {
                s = s + CS;
            }
            s = s + (String)e.nextElement();
        }
        return s;
    }

    @Override
    public void run() {
        Image3D2.println("Image3D2.run, ");
        new Exception().printStackTrace();
        this.iSaveInProcess = true;
        int k = 1000;
        if (this.iNewConstruction) {
            k = 5000;
            this.iNewConstruction = false;
        }
        while (this.iSaveInProcess) {
            try {
                Thread.sleep(k);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public static void setSaveImageState(boolean saveIt) {
        iSaveImage = saveIt;
        Image3D2.println("Image3D2.setSaveImageState, ");
    }

    public void saveImageAs() {
        Image3D2.println("Image3D2.saveImageAs, ");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setPreferredSize(new Dimension(600, 400));
        fileChooser.setCurrentDirectory(new File(this.iSaveImageAsDir));
        fileChooser.setSelectedFile(new File(this.iLastSaveAsName));
        String path = "";
        int returnVal = fileChooser.showSaveDialog(this.iAceTree);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            path = file.getPath();
            this.iSaveImageAsDir = file.getParent();
            this.iLastSaveAsName = file.getName() + "x";
            String extension = ".jpeg";
            if (!path.substring(path.length() - extension.length()).toLowerCase().equals(extension)) {
                path = path + ".jpeg";
            }
            this.offScreenRendering(path);
        } else {
            System.out.println("Save command cancelled by user.");
        }
    }

    private void takeScreenshot(String path) {
        Rectangle screenRect = this.iFrame.getBounds();
        int topAdjust = 23;
        int y = screenRect.y;
        int height = screenRect.height;
        screenRect.y += topAdjust;
        screenRect.height -= topAdjust;
        Robot robot = null;
        try {
            robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRect);
            ImageIO.write((RenderedImage)image, IMAGETYPE, new File(path + "." + IMAGETYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iSaveInProcess = false;
        System.out.println("file: " + path + " written");
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    protected static String fmt1(double x) {
        return DF1.format(x);
    }

    @Override
    public void startDocument() throws Exception {
    }

    @Override
    public void endDocument() throws Exception {
    }

    @Override
    public void text(String str) throws Exception {
    }

    @Override
    public void endElement(String tag) throws Exception {
    }

    private void buildColorControlGUI() {
        Border blackline = BorderFactory.createLineBorder(Color.black);
        this.iColorControlPanel = new JPanel();
        this.iColorControlPanel.setBorder(blackline);
        this.iColorControlPanel.setLayout(new BoxLayout(this.iColorControlPanel, 2));
        JPanel lineagePanel = new JPanel();
        lineagePanel.setLayout(new GridLayout(0, 1));
        lineagePanel.setBorder(blackline);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(1, 2));
        JLabel sublineage = new JLabel("sublineage");
        JLabel color = new JLabel("color");
        labelPanel.add(sublineage);
        labelPanel.add(color);
        lineagePanel.add(new JLabel("Lineage Color Controls"));
        lineagePanel.add(new JLabel(" "));
        lineagePanel.add(labelPanel);
        JPanel dummyPanel = new JPanel();
        JPanel topPart = new JPanel();
        topPart.add(lineagePanel);
        this.iSubUI = new SublineageUI[this.viewConfig.getNumDispProps()];
        for (int i = 0; i < this.viewConfig.getNumDispProps(); ++i) {
            SublineageDisplayProperty tempDispProp = this.viewConfig.getDispProp(i);
            this.iSubUI[i] = new SublineageUI(tempDispProp);
            lineagePanel.add(this.iSubUI[i].getPanel());
        }
        lineagePanel.setMaximumSize(new Dimension(200, 200));
        this.iColorControlPanel.add(topPart);
        JPanel botPart = new JPanel();
        botPart.setLayout(new BoxLayout(botPart, 3));
        this.iColorControlPanel.add(botPart);
        this.trackingPanel = new JPanel();
        this.trackingPanel.setAlignmentX(0.5f);
        this.trackingPanel.setLayout(new BoxLayout(this.trackingPanel, 3));
        this.trackingPanel.setBorder(blackline);
        JPanel timePtSliderPanel = new JPanel();
        timePtSliderPanel.setLayout(new GridLayout(2, 1));
        JLabel timePtsLabel = new JLabel("Number of Time Points Tracked", 0);
        timePtsLabel.setAlignmentX(0.5f);
        this.timePts = new JSlider(0, 0, 20, 10);
        this.timePts.addChangeListener(this);
        this.timePts.setMajorTickSpacing(5);
        this.timePts.setMinorTickSpacing(1);
        this.timePts.setPaintTicks(true);
        this.timePts.setPaintLabels(true);
        this.timePts.setSnapToTicks(true);
        this.trackingPanel.add(timePtsLabel);
        this.trackingPanel.add(this.timePts);
        this.customTailColor = new JButton();
        this.customTailColor.setText("Track Color");
        this.customTailColor.setToolTipText("Click here to change color");
        this.customTailColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Image3DViewConfig cfr_ignored_0 = Image3D2.this.viewConfig;
                Image3D2.this.viewConfig.setCustomTailColor(JColorChooser.showDialog(Image3D2.this.iFrame, "Select a Custom Tail Color", Image3DViewConfig.DEFAULT_CUSTOM_TAIL_COLOR));
            }
        });
        this.trackingPanel.add(this.customTailColor);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 3));
        JButton load = new JButton("Load Color Scheme");
        JButton save = new JButton("Save Color Scheme");
        JButton reset = new JButton("Reset Colors");
        JButton apply = new JButton("Apply Changes");
        load.setAlignmentX(0.5f);
        save.setAlignmentX(0.5f);
        reset.setAlignmentX(0.5f);
        apply.setAlignmentX(0.5f);
        load.addActionListener(this);
        save.addActionListener(this);
        reset.addActionListener(this);
        apply.addActionListener(this);
        botPart.add(new JLabel(" "));
        filePanel.add(load);
        filePanel.add(save);
        filePanel.add(reset);
        filePanel.add(apply);
        botPart.add(filePanel);
        botPart.add(Box.createVerticalGlue());
        botPart.add(this.trackingPanel);
        botPart.add(Box.createVerticalGlue());
        JPanel outerOverlayPanel = new JPanel();
        outerOverlayPanel.setLayout(new BoxLayout(outerOverlayPanel, 1));
        outerOverlayPanel.setBorder(blackline);
        JLabel overlayLabel = new JLabel("Overlay Options", 0);
        JPanel overlayPanel = new JPanel();
        overlayPanel.setAlignmentX(0.5f);
        overlayPanel.setLayout(new GridLayout(1, 2));
        JLabel overlayMinXLabel = new JLabel("Overlay Min X", 0);
        overlayMinXLabel.setAlignmentX(0.5f);
        this.overlayMinXSlider = new JSlider(0, 0, 512, 0);
        this.overlayMinXSlider.addChangeListener(this);
        this.overlayMinXSlider.setMajorTickSpacing(128);
        this.overlayMinXSlider.setMinorTickSpacing(32);
        this.overlayMinXSlider.setPaintTicks(true);
        this.overlayMinXSlider.setPaintLabels(true);
        this.overlayMinXSlider.setSnapToTicks(true);
        JPanel overlayMinXPanel = new JPanel();
        overlayMinXPanel.setLayout(new BoxLayout(overlayMinXPanel, 1));
        overlayMinXPanel.add(overlayMinXLabel);
        overlayMinXPanel.add(this.overlayMinXSlider);
        JLabel overlayMaxXLabel = new JLabel("Overlay Max X", 0);
        overlayMaxXLabel.setAlignmentX(0.5f);
        this.overlayMaxXSlider = new JSlider(0, 0, 512, 512);
        this.overlayMaxXSlider.addChangeListener(this);
        this.overlayMaxXSlider.setMajorTickSpacing(128);
        this.overlayMaxXSlider.setMinorTickSpacing(32);
        this.overlayMaxXSlider.setPaintTicks(true);
        this.overlayMaxXSlider.setPaintLabels(true);
        this.overlayMaxXSlider.setSnapToTicks(true);
        JPanel overlayMaxXPanel = new JPanel();
        overlayMaxXPanel.setLayout(new BoxLayout(overlayMaxXPanel, 1));
        overlayMaxXPanel.add(overlayMaxXLabel);
        overlayMaxXPanel.add(this.overlayMaxXSlider);
        JLabel overlayMinYLabel = new JLabel("Overlay Min Y", 0);
        overlayMinYLabel.setAlignmentX(0.5f);
        this.overlayMinYSlider = new JSlider(0, 0, 512, 0);
        this.overlayMinYSlider.addChangeListener(this);
        this.overlayMinYSlider.setMajorTickSpacing(128);
        this.overlayMinYSlider.setMinorTickSpacing(32);
        this.overlayMinYSlider.setPaintTicks(true);
        this.overlayMinYSlider.setPaintLabels(true);
        this.overlayMinYSlider.setSnapToTicks(true);
        JPanel overlayMinYPanel = new JPanel();
        overlayMinYPanel.setLayout(new BoxLayout(overlayMinYPanel, 1));
        overlayMinYPanel.add(overlayMinYLabel);
        overlayMinYPanel.add(this.overlayMinYSlider);
        JLabel overlayMaxYLabel = new JLabel("Overlay Max Y", 0);
        overlayMaxYLabel.setAlignmentX(0.5f);
        this.overlayMaxYSlider = new JSlider(0, 0, 512, 512);
        this.overlayMaxYSlider.addChangeListener(this);
        this.overlayMaxYSlider.setMajorTickSpacing(128);
        this.overlayMaxYSlider.setMinorTickSpacing(32);
        this.overlayMaxYSlider.setPaintTicks(true);
        this.overlayMaxYSlider.setPaintLabels(true);
        this.overlayMaxYSlider.setSnapToTicks(true);
        JPanel overlayMaxYPanel = new JPanel();
        overlayMaxYPanel.setLayout(new BoxLayout(overlayMaxYPanel, 1));
        overlayMaxYPanel.add(overlayMaxYLabel);
        overlayMaxYPanel.add(this.overlayMaxYSlider);
        JLabel overlayMinZLabel = new JLabel("Overlay Min Z", 0);
        overlayMinZLabel.setAlignmentX(0.5f);
        this.overlayMinZSlider = new JSlider(0, 0, 30, 0);
        this.overlayMinZSlider.addChangeListener(this);
        this.overlayMinZSlider.setMajorTickSpacing(5);
        this.overlayMinZSlider.setMinorTickSpacing(1);
        this.overlayMinZSlider.setPaintTicks(true);
        this.overlayMinZSlider.setPaintLabels(true);
        this.overlayMinZSlider.setSnapToTicks(true);
        JPanel overlayMinZPanel = new JPanel();
        overlayMinZPanel.setLayout(new BoxLayout(overlayMinZPanel, 1));
        overlayMinZPanel.add(overlayMinZLabel);
        overlayMinZPanel.add(this.overlayMinZSlider);
        JLabel overlayMaxZLabel = new JLabel("Overlay Max Z", 0);
        overlayMaxZLabel.setAlignmentX(0.5f);
        this.overlayMaxZSlider = new JSlider(0, 0, 30, 30);
        this.overlayMaxZSlider.addChangeListener(this);
        this.overlayMaxZSlider.setMajorTickSpacing(5);
        this.overlayMaxZSlider.setMinorTickSpacing(1);
        this.overlayMaxZSlider.setPaintTicks(true);
        this.overlayMaxZSlider.setPaintLabels(true);
        this.overlayMaxZSlider.setSnapToTicks(true);
        JPanel overlayMaxZPanel = new JPanel();
        overlayMaxZPanel.setLayout(new BoxLayout(overlayMaxZPanel, 1));
        overlayMaxZPanel.add(overlayMaxZLabel);
        overlayMaxZPanel.add(this.overlayMaxZSlider);
        JPanel overlayMinPanel = new JPanel();
        overlayMinPanel.setLayout(new BoxLayout(overlayMinPanel, 1));
        overlayMinPanel.add(overlayMinXPanel);
        overlayMinPanel.add(overlayMinYPanel);
        overlayMinPanel.add(overlayMinZPanel);
        JPanel overlayMaxPanel = new JPanel();
        overlayMaxPanel.setLayout(new BoxLayout(overlayMaxPanel, 1));
        overlayMaxPanel.add(overlayMaxXPanel);
        overlayMaxPanel.add(overlayMaxYPanel);
        overlayMaxPanel.add(overlayMaxZPanel);
        overlayPanel.add(overlayMinPanel);
        overlayPanel.add(overlayMaxPanel);
        this.overlayAutoROI = new JCheckBox("Auto Overlay ROI", this.viewConfig.useOverlayAutoROI());
        this.overlayAutoROI.addItemListener(this);
        this.overlayRedChannel = new JCheckBox("Show Red Channel", this.viewConfig.useOverlayRedChannel());
        this.overlayRedChannel.addItemListener(this);
        this.overlayGreenChannel = new JCheckBox("Show Green Channel", this.viewConfig.useOverlayGreenChannel());
        this.overlayGreenChannel.addItemListener(this);
        this.overlayBlueChannel = new JCheckBox("Show Blue Channel", this.viewConfig.useOverlayBlueChannel());
        this.overlayBlueChannel.addItemListener(this);
        JPanel overlaySubsamplePanel = new JPanel();
        overlaySubsamplePanel.setLayout(new BoxLayout(overlaySubsamplePanel, 1));
        JLabel overlaySubsampleLabel = new JLabel("Subsample size: ", 0);
        this.overlaySubsampleSlider = new JSlider(0, 1, 9, 2);
        this.overlaySubsampleSlider.addChangeListener(this);
        this.overlaySubsampleSlider.setMajorTickSpacing(2);
        this.overlaySubsampleSlider.setMinorTickSpacing(1);
        this.overlaySubsampleSlider.setPaintTicks(true);
        this.overlaySubsampleSlider.setPaintLabels(true);
        this.overlaySubsampleSlider.setSnapToTicks(true);
        overlaySubsamplePanel.add(overlaySubsampleLabel);
        overlaySubsamplePanel.add(this.overlaySubsampleSlider);
        outerOverlayPanel.add(overlayLabel);
        outerOverlayPanel.add(overlayPanel);
        outerOverlayPanel.add(overlaySubsamplePanel);
        outerOverlayPanel.add(this.overlayAutoROI);
        outerOverlayPanel.add(this.overlayRedChannel);
        outerOverlayPanel.add(this.overlayGreenChannel);
        botPart.add(outerOverlayPanel);
        JPanel jp = new JPanel();
        jp.setAlignmentX(0.5f);
        jp.setLayout(new BoxLayout(jp, 3));
        jp.setBorder(blackline);
        this.iMinRedField = new JTextField(String.valueOf(this.viewConfig.getMinRed()), 7);
        this.iMaxRedField = new JTextField(String.valueOf(this.viewConfig.getMaxRed()), 7);
        this.iMaxRedField.setMaximumSize(new Dimension(150, 20));
        this.iMinRedField.setMaximumSize(new Dimension(150, 20));
        this.iUseExprBox = new JCheckBox("Use Expression", this.viewConfig.isUsingExpression());
        jp.add(new JLabel("Expression Color Controls"));
        jp.add(new JLabel(" "));
        jp.add(new JSeparator(0));
        jp.add(this.iUseExprBox);
        jp.add(new JLabel(" "));
        jp.add(new JSeparator(0));
        jp.add(new JLabel("Expression Range:"));
        jp.add(new JLabel(" "));
        jp.add(new JLabel("Min Expression (Black)"));
        jp.add(this.iMinRedField);
        jp.add(new JLabel("Max Expression (Red)"));
        jp.add(this.iMaxRedField);
        jp.add(new JLabel(" "));
        jp.add(new JSeparator(0));
        this.iUseExprColors = new JRadioButton("Expression Level");
        this.iUseExprColors.setSelected(true);
        JRadioButton lineage = new JRadioButton("Lineage Identity");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.iUseExprColors);
        bg.add(lineage);
        jp.add(new JLabel("Color Expressing Cells Via: "));
        jp.add(this.iUseExprColors);
        jp.add(lineage);
        jp.add(new JLabel(" "));
        jp.add(new JSeparator(0));
        this.iShowNonExpressingChkBox = new JCheckBox("Show non-expressing", this.viewConfig.isShowingNonExpressing());
        jp.add(this.iShowNonExpressingChkBox);
        botPart.add(Box.createVerticalGlue());
        botPart.add(jp);
    }

    private void saveToFile() {
        JFileChooser fileChooser = new JFileChooser(this.viewConfig.getCurrentRotDir());
        int returnVal = fileChooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.viewConfig.setCurrentRotDir(file.getParent());
        System.out.println("saveToFile: " + file);
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(fileChooser.getSelectedFile()), true);
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.println();
            pw.println("<lineages>");
            for (int i = 0; i < this.viewConfig.getNumDispProps() - 2; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append("<lineage ");
                sb.append("name=\"" + this.viewConfig.getDispProp(i).getName() + "\" ");
                sb.append("color=\"" + this.viewConfig.getDispProp(i).getColor() + "\"/>");
                pw.println(sb.toString());
            }
            pw.println("</lineages>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    private void loadFromFile() {
        JFileChooser fileChooser = new JFileChooser(this.viewConfig.getCurrentRotDir());
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.viewConfig.setCurrentRotDir(file.getParent());
        this.viewConfig.setLineageCount(0);
        try {
            FileReader fr = new FileReader(file);
            QDParser.parse(this, fr);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.viewConfig.getNumDispProps() - 2; ++i) {
            this.viewConfig.getDispProp(i).setName(" ");
            this.viewConfig.getDispProp(i).setLineageNum(0);
        }
        this.update();
    }

    public void update() {
        for (int i = 0; i < this.viewConfig.getNumDispProps() - 2; ++i) {
            this.iSubUI[i].setText(this.viewConfig.getDispProp(i).getName());
            this.iSubUI[i].setSelectedIndex(this.viewConfig.getDispProp(i).getLineageNum());
        }
    }

    public void enableTailComponents(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            this.enableTailComponents((Container)component, enable);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider o = (JSlider)e.getSource();
        if (o == this.overlayMinXSlider || o == this.overlayMinYSlider || o == this.overlayMinZSlider || o == this.overlayMaxXSlider || o == this.overlayMaxYSlider || o == this.overlayMaxZSlider || o == this.overlaySubsampleSlider) {
            this.viewConfig.setOverlayXYZChanged(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable o = e.getItemSelectable();
        if (o == this.overlayAutoROI) {
            if (e.getStateChange() == 1) {
                this.viewConfig.setUseOverlayAutoROI(this.overlayAutoROI.isSelected());
            } else {
                this.viewConfig.resetOverlayDefaults();
            }
        }
        if (o == this.overlayRedChannel || o == this.overlayGreenChannel || o == this.overlayBlueChannel) {
            this.viewConfig.setChangeOverlayChannel(true);
        }
    }

    public Image3DGeometryManager getGeoManager() {
        return this.geometryManager;
    }

    public Image3DViewConfig getViewConfig() {
        return this.viewConfig;
    }

    static {
        DF1 = new DecimalFormat("####.##");
        DF4 = new DecimalFormat("####.####");
    }

    public class WinEventMgr
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            Image3D2.this.iFrame.dispose();
            Image3D2.this.iAceTree.image3DOff();
        }
    }
}

