/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Raster;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ColorConstants;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.image.Indicator3D;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.Angle3;
import qdxml.DocHandler;
import qdxml.QDParser;

public class Image3D2Z
extends MouseAdapter
implements ActionListener,
Runnable,
DocHandler {
    private PickCanvas iPickCanvas;
    private AceTree iAceTree;
    private NucleiMgr iNucleiMgr;
    public BranchGroup iBG;
    private Background iBackground;
    private JFrame iFrame;
    private SimpleUniverse iUniverse;
    private Canvas3D iCanvas;
    private String iTitle;
    boolean iNewConstruction;
    Thread iThread;
    boolean iSaveInProcess;
    static boolean iSaveImage;
    boolean fakeit1;
    boolean fakeit2;
    JTextField iAngle;
    JTextField iScale;
    JLabel iPick;
    private int iXA;
    private int iYA;
    private float iZA;
    private Transform3D iRotate;
    private TransformGroup iRotGroup;
    private TransformGroup iTranslateGroup;
    private Matrix4d iMatrix;
    private JPanel iImagePanel;
    private JPanel iControlPanel;
    private JTabbedPane iTabbedPane;
    public SublineageDisplayProperty[] iDispProps2Z;
    public PropertiesTab3 iPT3;
    private int iMinRed;
    private int iMaxRed;
    private boolean iUseExpression;
    JTextField iAngX;
    JTextField iAngXInc;
    JButton iXUp;
    JButton iXDn;
    JTextField iAngY;
    JTextField iAngYInc;
    JButton iYUp;
    JButton iYDn;
    JTextField iAngZ;
    JTextField iAngZInc;
    JButton iZUp;
    JButton iZDn;
    JTextField iPosIncr;
    JTextField iPos;
    JButton iPIn;
    JButton iPOut;
    JButton iRestore;
    JButton iUndoButton;
    Vector iUndo;
    JButton iLoadButton;
    JButton iSaveButton;
    String iCurrentRotDir;
    int iLineageCount;
    JButton iSaveImageButton;
    String iSaveImageAsDir;
    String iLastSaveAsName;
    BranchGroup iBGT;
    Indicator3D iIndicator;
    private static final String CS = ", ";
    private static final String IMAGETYPE = "jpeg";
    private Color3f[] BACKGROUNDS = new Color3f[]{new Color3f(1.0f, 1.0f, 1.0f), new Color3f(0.3f, 0.3f, 0.3f), new Color3f(0.1f, 0.1f, 0.1f)};
    private static final int MINRED = 25000;
    private static final int MAXRED = 100000;
    private static final int SPECIAL = 1;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    public Image3D2Z(AceTree aceTree, String title) {
        this.iAceTree = aceTree;
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iFrame = new JFrame(title);
        this.iTitle = title;
        this.iNewConstruction = true;
        this.iMinRed = 25000;
        this.iMaxRed = 100000;
        this.iUseExpression = false;
        this.iFrame.setDefaultCloseOperation(0);
        WinEventMgr wem = new WinEventMgr();
        this.iFrame.addWindowListener(wem);
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.iCanvas = new Canvas3D(config);
        this.iCanvas.setSize(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
        this.iUniverse = new SimpleUniverse(this.iCanvas);
        this.iUniverse.getViewingPlatform().setNominalViewingTransform();
        ViewingPlatform viewingPlatform = this.iUniverse.getViewingPlatform();
        this.iTranslateGroup = viewingPlatform.getViewPlatformTransform();
        this.iMatrix = new Matrix4d();
        Transform3D t3d = new Transform3D();
        this.iTranslateGroup.getTransform(t3d);
        Matrix4d m4d = new Matrix4d();
        this.buildOutUI();
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.addTab("Image", null, this.iImagePanel, "View 3D image");
        Object dispProps = this.iAceTree.getDispProps3D2Z();
        if (dispProps == null) {
            this.iAceTree.setDispProps3D2Z(this.getDisplayProps());
        }
        this.iDispProps2Z = (SublineageDisplayProperty[])this.iAceTree.getDispProps3D2Z();
        this.iPT3 = new PropertiesTab3(this);
        this.iControlPanel = this.iPT3.getPanel();
        this.iTabbedPane.addTab("Properties", null, this.iControlPanel, "Set color scheme");
        this.iFrame.getContentPane().add(this.iTabbedPane);
        this.iCanvas.addMouseListener((MouseListener)this);
        this.iFrame.pack();
        this.iFrame.show();
        this.iUndo = new Vector();
        this.insertContent(this.iTitle);
        this.iSaveImageAsDir = "";
        this.iLastSaveAsName = "";
    }

    private void buildOutUI() {
        this.iPick = new JLabel("pick");
        this.iImagePanel = new JPanel();
        this.iImagePanel.setLayout(new BorderLayout());
        this.iImagePanel.add((Component)this.iCanvas, "Center");
        JPanel secondPanel = new JPanel(new BorderLayout());
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 3));
        JPanel rotatePanels = new JPanel();
        rotatePanels.setLayout(new GridLayout(0, 1));
        JPanel rotatePanel = new JPanel();
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(this.iPick);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("angX"));
        this.iAngXInc = new JTextField("30", 5);
        this.iAngX = new JTextField("0", 10);
        this.iXUp = new JButton("up");
        this.iXDn = new JButton("dn");
        rotatePanel.add(this.iAngXInc);
        rotatePanel.add(this.iAngX);
        rotatePanel.add(this.iXUp);
        rotatePanel.add(this.iXDn);
        this.iXUp.addActionListener(this);
        this.iXDn.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("angY"));
        this.iAngYInc = new JTextField("30", 5);
        this.iAngY = new JTextField("0", 10);
        this.iYUp = new JButton("up");
        this.iYDn = new JButton("dn");
        rotatePanel.add(this.iAngYInc);
        rotatePanel.add(this.iAngY);
        rotatePanel.add(this.iYUp);
        rotatePanel.add(this.iYDn);
        this.iYUp.addActionListener(this);
        this.iYDn.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("angZ"));
        this.iAngZInc = new JTextField("30", 5);
        this.iAngZ = new JTextField("0", 10);
        this.iZUp = new JButton("up");
        this.iZDn = new JButton("dn");
        rotatePanel.add(this.iAngZInc);
        rotatePanel.add(this.iAngZ);
        rotatePanel.add(this.iZUp);
        rotatePanel.add(this.iZDn);
        this.iZUp.addActionListener(this);
        this.iZDn.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        rotatePanel.add(new JLabel("Pos"));
        Transform3D t3d = new Transform3D();
        this.iTranslateGroup.getTransform(t3d);
        t3d.get(this.iMatrix);
        this.iPosIncr = new JTextField("0.2", 5);
        this.iPos = new JTextField(Image3D2Z.fmt1(this.iMatrix.m23), 10);
        this.iPIn = new JButton("in");
        this.iPOut = new JButton("out");
        rotatePanel.add(this.iPosIncr);
        rotatePanel.add(this.iPos);
        rotatePanel.add(this.iPIn);
        rotatePanel.add(this.iPOut);
        this.iPIn.addActionListener(this);
        this.iPOut.addActionListener(this);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        this.iRestore = new JButton("restore");
        rotatePanel.add(this.iRestore);
        this.iRestore.addActionListener(this);
        this.iUndoButton = new JButton("undo");
        this.iUndoButton.addActionListener(this);
        rotatePanel.add(this.iUndoButton);
        rotatePanels.add(rotatePanel);
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        this.iLoadButton = new JButton("load from file");
        rotatePanel.add(this.iLoadButton);
        this.iLoadButton.addActionListener(this);
        this.iSaveButton = new JButton("save to file");
        this.iSaveButton.addActionListener(this);
        rotatePanel.add(this.iSaveButton);
        rotatePanels.add(rotatePanel);
        this.iCurrentRotDir = ".";
        rotatePanel = new JPanel();
        rotatePanel.setLayout(new GridLayout(1, 0));
        this.iSaveImageButton = new JButton("saveImageAs");
        rotatePanel.add(this.iSaveImageButton);
        this.iSaveImageButton.addActionListener(this);
        rotatePanel.add(this.iSaveImageButton);
        rotatePanels.add(rotatePanel);
        newPanel.add(rotatePanels);
        secondPanel.add((Component)newPanel, "West");
        this.iIndicator = new Indicator3D();
        secondPanel.add((Component)this.iIndicator, "East");
        this.iImagePanel.add((Component)secondPanel, "South");
    }

    private void reportDispProps() {
        for (int i = 0; i < this.iDispProps2Z.length; ++i) {
            System.out.println("dispProp: " + i + CS + this.iDispProps2Z[i].iName + CS + this.iDispProps2Z[i].iLineageNum);
        }
    }

    public void updateDisplayedTab() {
        this.iTabbedPane.setSelectedIndex(0);
        this.insertContent(this.iTitle);
        System.out.println("updateDisplayedTab called");
    }

    private void applyTrans(double incr, char axis) {
        int angle = 0;
        Transform3D t3d = new Transform3D();
        switch (axis) {
            case 'x': {
                t3d.rotX(incr);
                this.iUndo.add(new Trans(t3d, incr, 'x'));
                angle = Integer.parseInt(this.iAngX.getText());
                angle = (int)((long)angle + Math.round(Math.toDegrees(incr)));
                this.iAngX.setText(String.valueOf(angle %= 360));
                break;
            }
            case 'y': {
                t3d.rotY(incr);
                this.iUndo.add(new Trans(t3d, incr, 'y'));
                angle = Integer.parseInt(this.iAngY.getText());
                angle = (int)((long)angle + Math.round(Math.toDegrees(incr)));
                this.iAngY.setText(String.valueOf(angle %= 360));
                break;
            }
            case 'z': {
                t3d.rotZ(incr);
                this.iUndo.add(new Trans(t3d, incr, 'z'));
                angle = Integer.parseInt(this.iAngZ.getText());
                angle = (int)((long)angle + Math.round(Math.toDegrees(incr)));
                this.iAngZ.setText(String.valueOf(angle %= 360));
            }
        }
        this.iRotate.mul(t3d);
        this.iIndicator.apply(t3d);
        this.iRotGroup.setTransform(this.iRotate);
    }

    private void handleRotatePanel(Object o) {
        Matrix4d m4d;
        int angle = 0;
        Transform3D t3d = new Transform3D();
        double incrDeg = 30.0;
        double incr = Math.toRadians(incrDeg);
        if (o == this.iXUp || o == this.iXDn) {
            incrDeg = Integer.parseInt(this.iAngXInc.getText());
            incr = Math.toRadians(incrDeg);
            if (o == this.iXDn) {
                incr *= -1.0;
            }
            this.applyTrans(incr, 'x');
            return;
        }
        if (o == this.iYUp || o == this.iYDn) {
            incrDeg = Integer.parseInt(this.iAngYInc.getText());
            incr = Math.toRadians(incrDeg);
            if (o == this.iYDn) {
                incr *= -1.0;
            }
            this.applyTrans(incr, 'y');
            return;
        }
        if (o == this.iZUp || o == this.iZDn) {
            incrDeg = Integer.parseInt(this.iAngZInc.getText());
            incr = Math.toRadians(incrDeg);
            if (o == this.iZDn) {
                incr *= -1.0;
            }
            this.applyTrans(incr, 'z');
            return;
        }
        if (o == this.iPIn || o == this.iPOut) {
            double pos = Double.parseDouble(this.iPos.getText());
            double posInc = Double.parseDouble(this.iPosIncr.getText());
            if (o == this.iPIn) {
                posInc *= -1.0;
            }
            this.iPos.setText(Image3D2Z.fmt1(pos += posInc));
            this.iTranslateGroup.getTransform(t3d);
            m4d = new Matrix4d();
            t3d.get(m4d);
            Matrix4d mincr = new Matrix4d();
            mincr.m23 = posInc;
            m4d.add(mincr);
            t3d.set(m4d);
            this.iTranslateGroup.setTransform(t3d);
            t3d.set(mincr);
            this.iUndo.add(new Trans(new Transform3D(), posInc, 'p'));
        }
        if (o == this.iRestore) {
            this.iRotate.mulInverse(this.iRotate);
            this.iRotGroup.setTransform(this.iRotate);
            this.iUndo.clear();
            this.iIndicator.restore();
            this.iAngX.setText("0");
            this.iAngY.setText("0");
            this.iAngZ.setText("0");
            t3d.set(this.iMatrix);
            this.iTranslateGroup.setTransform(t3d);
            this.iPos.setText(Image3D2Z.fmt1(this.iMatrix.m23));
            return;
        }
        if (o == this.iUndoButton && this.iUndo.size() > 0) {
            Trans t = (Trans)this.iUndo.remove(this.iUndo.size() - 1);
            Transform3D t3 = t.iT3d;
            if (t3 != null) {
                double angInc = Math.toDegrees(t.iAngInc);
                switch (t.iAxis) {
                    case 'x': {
                        angle = Integer.parseInt(this.iAngX.getText());
                        angle = (int)((double)angle - angInc);
                        this.iAngX.setText(String.valueOf(angle));
                        this.handleRotateUndo(t3);
                        break;
                    }
                    case 'y': {
                        angle = Integer.parseInt(this.iAngY.getText());
                        angle = (int)((double)angle - angInc);
                        this.iAngY.setText(String.valueOf(angle));
                        this.handleRotateUndo(t3);
                        break;
                    }
                    case 'z': {
                        angle = Integer.parseInt(this.iAngZ.getText());
                        angle = (int)((double)angle - angInc);
                        this.iAngZ.setText(String.valueOf(angle));
                        this.handleRotateUndo(t3);
                        break;
                    }
                    case 'p': {
                        this.iTranslateGroup.getTransform(t3d);
                        m4d = new Matrix4d();
                        t3d.get(m4d);
                        m4d.m23 -= t.iAngInc;
                        t3d.set(m4d);
                        this.iTranslateGroup.setTransform(t3d);
                        double pos = Double.parseDouble(this.iPos.getText());
                        this.iPos.setText(Image3D2Z.fmt1(pos -= t.iAngInc));
                    }
                }
            }
            this.iRotGroup.setTransform(this.iRotate);
        }
    }

    private void handleRotateUndo(Transform3D t3) {
        t3.invert();
        this.iRotate.mul(t3);
        this.iIndicator.apply(t3);
    }

    private void saveRotations() {
        File file = null;
        JFileChooser fileChooser = new JFileChooser(this.iCurrentRotDir);
        int returnVal = fileChooser.showSaveDialog(this.iAceTree);
        if (returnVal != 0) {
            System.out.println("Save command cancelled by user.");
            return;
        }
        file = fileChooser.getSelectedFile();
        this.iCurrentRotDir = file.getParent();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            pw = new PrintWriter(fos, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.println();
        pw.println("<rotations>");
        for (int i = 0; i < this.iUndo.size(); ++i) {
            Trans t = (Trans)this.iUndo.get(i);
            StringBuffer sb = new StringBuffer();
            sb.append("<rotation ");
            sb.append("radians=\"" + t.iAngInc + "\" ");
            sb.append("axis=\"" + t.iAxis + "\"/>");
            pw.println(sb.toString());
        }
        pw.println("</rotations>");
    }

    private void loadRotations() {
        File file = null;
        JFileChooser fileChooser = new JFileChooser(this.iCurrentRotDir);
        int returnVal = fileChooser.showOpenDialog(this.iAceTree);
        if (returnVal != 0) {
            System.out.println("Save command cancelled by user.");
            return;
        }
        file = fileChooser.getSelectedFile();
        this.iCurrentRotDir = file.getParent();
        try {
            FileReader fr = new FileReader(file);
            QDParser.parse(this, fr);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String tag, Hashtable h) throws Exception {
        if (tag.equals("rotation")) {
            String incrs = (String)h.get("radians");
            String axiss = (String)h.get("axis");
            double incr = Double.parseDouble(incrs);
            char axis = axiss.charAt(0);
            this.applyTrans(incr, axis);
        } else if (tag.equals("lineage")) {
            String name = (String)h.get("name");
            String color = (String)h.get("color");
            this.iDispProps2Z[this.iLineageCount].iName = name;
            this.iDispProps2Z[this.iLineageCount].iLineageNum = this.iPT3.getColorNumber(color);
            ++this.iLineageCount;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iXUp || o == this.iXDn || o == this.iYUp || o == this.iYDn || o == this.iZUp || o == this.iZDn || o == this.iPIn || o == this.iPOut || o == this.iRestore || o == this.iUndoButton) {
            this.handleRotatePanel(o);
            return;
        }
        if (o == this.iLoadButton) {
            this.loadRotations();
        } else if (o == this.iSaveButton) {
            this.saveRotations();
        } else if (o == this.iSaveImageButton) {
            this.saveImageAs();
        }
    }

    public void insertContent(String title) {
        while (this.iSaveInProcess) {
        }
        this.iTitle = title;
        this.iFrame.setTitle(this.iTitle);
        if (this.iBG != null) {
            this.iBG.detach();
        }
        this.iBG = this.createSceneGraph();
        this.iUniverse.addBranchGraph(this.iBG);
        this.iPickCanvas = new PickCanvas(this.iCanvas, this.iBG);
        this.iPickCanvas.setMode(512);
        if (iSaveImage) {
            this.iThread = new Thread(this);
            this.iThread.start();
        }
    }

    public BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        root.setCapability(17);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f lColor1 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        Vector3f lDirect1 = new Vector3f(lPos1);
        lDirect1.negate();
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDirect1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)lgt1);
        int m = this.iDispProps2Z[this.iDispProps2Z.length - 1].iLineageNum;
        switch (m) {
            case 0: {
                bgColor = new Color3f(0.7f, 0.7f, 0.7f);
                break;
            }
            case 1: {
                bgColor = new Color3f(0.3f, 0.3f, 0.3f);
                break;
            }
            default: {
                bgColor = new Color3f(0.1f, 0.1f, 0.1f);
            }
        }
        this.iBackground = new Background(bgColor);
        this.iBackground.setApplicationBounds((Bounds)bounds);
        root.addChild((Node)this.iBackground);
        TransformGroup objRotate = new TransformGroup();
        objRotate.setCapability(18);
        objRotate.setCapability(17);
        new Nuclei3D();
        this.iBG.compile();
        objRotate.addChild((Node)this.iBG);
        TransformGroup initRotGroup = new TransformGroup();
        Transform3D initRotate = new Transform3D();
        NucleiMgr nucMgr = this.iAceTree.getNucleiMgr();
        int ap = nucMgr.getParameters().apInit;
        int dv = nucMgr.getParameters().dvInit;
        int lr = nucMgr.getParameters().lrInit;
        if (ap == -1) {
            Transform3D apt = new Transform3D();
            apt.rotZ(Math.PI);
            initRotate.mul(apt);
            ap = -ap;
            dv = -dv;
        }
        if (dv == -1) {
            Transform3D dvt = new Transform3D();
            dvt.rotX(Math.PI);
            initRotate.mul(dvt);
            dv = -dv;
            lr = -lr;
        }
        initRotGroup.setTransform(initRotate);
        initRotGroup.addChild((Node)objRotate);
        if (this.iRotate == null) {
            this.iRotate = new Transform3D();
        }
        this.iRotGroup = new TransformGroup(this.iRotate);
        this.iRotGroup.setCapability(18);
        this.iRotGroup.addChild((Node)initRotGroup);
        root.addChild((Node)this.iRotGroup);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objRotate);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        root.addChild((Node)myMouseRotate);
        root.compile();
        return root;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.iPickCanvas.setShapeLocation(e);
        PickResult[] results = this.iPickCanvas.pickAll();
        String name = this.getPickedNucleusNames(results);
        this.iPick.setText("you picked: " + name);
    }

    private String getPickedNucleusNames(PickResult[] results) {
        String s = "none";
        Vector<String> v = new Vector<String>();
        if (results != null) {
            for (int i = results.length - 1; i >= 0; --i) {
                String pname;
                Primitive p = (Primitive)results[i].getNode(4);
                if (p == null || (pname = p.getClass().getName()).indexOf("NamedSphere") < 0) continue;
                s = ((NamedSphere)p).iName;
                v.add(0, s);
            }
        }
        if (v.size() == 0) {
            return "none";
        }
        Enumeration e = v.elements();
        s = "";
        while (e.hasMoreElements()) {
            if (s.length() > 0) {
                s = s + CS;
            }
            s = s + (String)e.nextElement();
        }
        return s;
    }

    private SublineageDisplayProperty[] getDisplayProps() {
        SublineageDisplayProperty[] dispProps = new SublineageDisplayProperty[]{new SublineageDisplayProperty("ABa", 0), new SublineageDisplayProperty("ABp", 1), new SublineageDisplayProperty("C", 5), new SublineageDisplayProperty("D", 6), new SublineageDisplayProperty("E", 2), new SublineageDisplayProperty("MS", 4), new SublineageDisplayProperty("P", 3), new SublineageDisplayProperty("polar", 7), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("", 2), new SublineageDisplayProperty("other", 2), new SublineageDisplayProperty("background", 1)};
        return dispProps;
    }

    private int getLineageNumber(String name) {
        if (name.indexOf("Z") >= 0) {
            name = "P";
        }
        int num = this.iDispProps2Z.length;
        for (int i = 0; i < this.iDispProps2Z.length; ++i) {
            if (name.indexOf(this.iDispProps2Z[i].iName) < 0) continue;
            num = this.iDispProps2Z[i].iLineageNum;
            break;
        }
        return num;
    }

    @Override
    public void run() {
        this.iSaveInProcess = true;
        int k = 1000;
        if (this.iNewConstruction) {
            k = 5000;
            this.iNewConstruction = false;
        }
        try {
            Thread.sleep(k);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.saveImage();
    }

    public static void setSaveImageState(boolean saveIt) {
        iSaveImage = saveIt;
    }

    public void saveImage() {
        String saveDir = this.iAceTree.iImgWin.getSaveImageDirectory();
        if (saveDir == null) {
            this.iAceTree.iImgWin.cancelSaveOperations();
            iSaveImage = false;
            return;
        }
        Rectangle screenRect = this.iFrame.getBounds();
        int topAdjust = 23;
        int y = screenRect.y;
        screenRect.y += topAdjust;
        int height = screenRect.height;
        screenRect.height -= topAdjust;
        String title = saveDir + "/";
        Robot robot = null;
        try {
            robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRect);
            title = title + this.iTitle + "." + IMAGETYPE;
            ImageIO.write((RenderedImage)image, IMAGETYPE, new File(title));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("file: " + title + " written");
        this.iSaveInProcess = false;
    }

    public void saveImageAs() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setPreferredSize(new Dimension(400, 300));
        fileChooser.setCurrentDirectory(new File(this.iSaveImageAsDir));
        fileChooser.setSelectedFile(new File(this.iLastSaveAsName));
        String path = "";
        int returnVal = fileChooser.showSaveDialog(this.iAceTree);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            path = file.getPath();
            this.iSaveImageAsDir = file.getParent();
            this.iLastSaveAsName = file.getName() + "x";
        } else {
            System.out.println("Save command cancelled by user.");
        }
        Rectangle screenRect = this.iFrame.getBounds();
        int topAdjust = 23;
        int y = screenRect.y;
        screenRect.y += topAdjust;
        int height = screenRect.height;
        screenRect.height -= topAdjust;
        Robot robot = null;
        try {
            robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRect);
            ImageIO.write((RenderedImage)image, IMAGETYPE, new File(path + "." + IMAGETYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("file: " + path + " written");
        this.iSaveInProcess = false;
    }

    public BufferedImage getBufferedImage() {
        int width = (int)this.iCanvas.getSize().getWidth();
        int height = (int)this.iCanvas.getSize().getHeight();
        int cursorType = this.iCanvas.getCursor().getType();
        this.iCanvas.setCursor(new Cursor(3));
        GraphicsContext3D ctx = this.iCanvas.getGraphicsContext3D();
        Raster ras = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, width, height, new ImageComponent2D(1, new BufferedImage(width, height, 1)), null);
        ctx.readRaster(ras);
        BufferedImage img = ras.getImage().getImage();
        this.iCanvas.setCursor(new Cursor(cursorType));
        return img;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static String fmt1(double x) {
        return DF1.format(x);
    }

    @Override
    public void startDocument() throws Exception {
    }

    @Override
    public void endDocument() throws Exception {
    }

    @Override
    public void text(String str) throws Exception {
    }

    @Override
    public void endElement(String tag) throws Exception {
    }

    static {
        DF1 = new DecimalFormat("####.##");
        DF4 = new DecimalFormat("####.####");
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Image3D2Z.this.iFrame.dispose();
            Image3D2Z.this.iAceTree.image3DOff();
        }
    }

    public class PropertiesTab3
    implements ActionListener {
        JPanel iPanel;
        SublineageUI[] iSubUI;
        JTextField iMinRedField;
        JTextField iMaxRedField;
        JCheckBox iUseExprBox;
        Image3D2Z iParent;
        private String[] COLORS = new String[]{"red", "blue", "green", "yellow", "cyan", "magenta", "pink", "gray", "white", "omit"};
        private String[] TRANSPROPS = new String[]{"omit", "transparent", "white"};
        private String[] GRAYDEPTH = new String[]{"white", "light gray    ", "dark gray"};
        private static final int WIDTH = 15;

        public PropertiesTab3(Image3D2Z parent) {
            this.iParent = parent;
            Border blackline = BorderFactory.createLineBorder(Color.black);
            this.iSubUI = new SublineageUI[Image3D2Z.this.iDispProps2Z.length];
            this.iPanel = new JPanel();
            this.iPanel.setLayout(new BorderLayout());
            this.iPanel.setBorder(blackline);
            JPanel lineagePanel = new JPanel();
            JPanel dummyPanel = new JPanel();
            JPanel topPart = new JPanel();
            topPart.setLayout(new GridLayout(1, 2));
            lineagePanel.setLayout(new GridLayout(0, 1));
            lineagePanel.setBorder(blackline);
            topPart.add(lineagePanel);
            topPart.add(dummyPanel);
            JPanel[] testPanel = new JPanel[Image3D2Z.this.iDispProps2Z.length];
            JPanel labelPanel = new JPanel();
            JLabel sublineage = new JLabel("sublineage");
            JLabel color = new JLabel("color");
            labelPanel.setLayout(new GridLayout(1, 2));
            labelPanel.add(sublineage);
            labelPanel.add(color);
            lineagePanel.add(labelPanel);
            for (int i = 0; i < Image3D2Z.this.iDispProps2Z.length; ++i) {
                this.iSubUI[i] = new SublineageUI(i);
                lineagePanel.add(this.iSubUI[i].iPanel);
            }
            lineagePanel.setMaximumSize(new Dimension(200, 200));
            this.iPanel.add((Component)topPart, "North");
            JPanel botPart = new JPanel();
            botPart.setLayout(new GridLayout(3, 1));
            this.iPanel.add((Component)botPart, "Center");
            JPanel filePanel = new JPanel();
            filePanel.setLayout(new GridLayout(1, 2));
            JButton load = new JButton("Load from file");
            JButton save = new JButton("Save to file");
            filePanel.add(load);
            filePanel.add(save);
            load.addActionListener(this);
            save.addActionListener(this);
            botPart.add(filePanel);
            JPanel jp = new JPanel(new FlowLayout());
            jp.setBorder(blackline);
            this.iMinRedField = new JTextField(String.valueOf(Image3D2Z.this.iMinRed), 7);
            this.iMaxRedField = new JTextField(String.valueOf(Image3D2Z.this.iMaxRed), 7);
            this.iUseExprBox = new JCheckBox("Use Expression", Image3D2Z.this.iUseExpression);
            jp.add(this.iUseExprBox);
            jp.add(new JLabel("minRed"));
            jp.add(this.iMinRedField);
            jp.add(new JLabel("maxRed"));
            jp.add(this.iMaxRedField);
            botPart.add(jp);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(1, 3));
            JButton reset = new JButton("Reset");
            JButton apply = new JButton("Apply");
            JButton cancel = new JButton("Cancel");
            buttonPanel.add(apply);
            reset.addActionListener(this);
            apply.addActionListener(this);
            cancel.addActionListener(this);
            buttonPanel.add(reset);
            buttonPanel.add(apply);
            buttonPanel.add(cancel);
            botPart.add(buttonPanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Cancel")) {
                Image3D2Z.this.updateDisplayedTab();
            } else if (command.equals("Reset")) {
                Image3D2Z.this.iDispProps2Z = Image3D2Z.this.getDisplayProps();
                for (int i = 0; i < Image3D2Z.this.iDispProps2Z.length; ++i) {
                    this.iSubUI[i].iTF.setText(Image3D2Z.this.iDispProps2Z[i].iName);
                    this.iSubUI[i].iCB.setSelectedIndex(Image3D2Z.this.iDispProps2Z[i].iLineageNum);
                }
                Image3D2Z.this.iMinRed = 25000;
                Image3D2Z.this.iMaxRed = 100000;
                Image3D2Z.this.iUseExpression = false;
            } else if (command.equals("Apply")) {
                for (int i = 0; i < Image3D2Z.this.iDispProps2Z.length; ++i) {
                    String name = this.iSubUI[i].iTF.getText();
                    if (name.length() == 0) {
                        name = "-";
                    }
                    int num = this.iSubUI[i].iCB.getSelectedIndex();
                    Image3D2Z.this.iDispProps2Z[i].iName = name;
                    Image3D2Z.this.iDispProps2Z[i].iLineageNum = num;
                }
                Image3D2Z.this.iMinRed = Integer.parseInt(this.iMinRedField.getText());
                Image3D2Z.this.iMaxRed = Integer.parseInt(this.iMaxRedField.getText());
                Image3D2Z.this.iUseExpression = this.iUseExprBox.isSelected();
                Image3D2Z.this.iAceTree.setDispProps3D2Z(Image3D2Z.this.iDispProps2Z);
                Image3D2Z.this.updateDisplayedTab();
            } else if (command.equals("Load from file")) {
                System.out.println("Load from file");
                this.loadFromFile();
            } else if (command.equals("Save to file")) {
                System.out.println("Save to file");
                this.saveToFile();
            }
        }

        private void saveToFile() {
            JFileChooser fileChooser = new JFileChooser(Image3D2Z.this.iCurrentRotDir);
            int returnVal = fileChooser.showSaveDialog(null);
            if (returnVal != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            Image3D2Z.this.iCurrentRotDir = file.getParent();
            System.out.println("saveToFile: " + file);
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(fileChooser.getSelectedFile()), true);
                pw.println("<?xml version='1.0' encoding='utf-8'?>");
                pw.println();
                pw.println("<lineages>");
                for (int i = 0; i < Image3D2Z.this.iDispProps2Z.length - 2; ++i) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<lineage ");
                    sb.append("name=\"" + Image3D2Z.this.iDispProps2Z[i].iName + "\" ");
                    sb.append("color=\"" + this.COLORS[Image3D2Z.this.iDispProps2Z[i].iLineageNum] + "\"/>");
                    pw.println(sb.toString());
                }
                pw.println("</lineages>");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }

        private void loadFromFile() {
            JFileChooser fileChooser = new JFileChooser(Image3D2Z.this.iCurrentRotDir);
            int returnVal = fileChooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            Image3D2Z.this.iCurrentRotDir = file.getParent();
            Image3D2Z.this.iLineageCount = 0;
            try {
                FileReader fr = new FileReader(file);
                QDParser.parse(this.iParent, fr);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = Image3D2Z.this.iLineageCount; i < Image3D2Z.this.iDispProps2Z.length - 2; ++i) {
                Image3D2Z.this.iDispProps2Z[i].iName = "";
                Image3D2Z.this.iDispProps2Z[i].iLineageNum = 0;
            }
            this.update();
        }

        public int getColorNumber(String colorName) {
            int k = 0;
            for (int i = 0; i < this.COLORS.length; ++i) {
                if (!colorName.equals(this.COLORS[i])) continue;
                return i;
            }
            return k;
        }

        public void update() {
            for (int i = 0; i < Image3D2Z.this.iDispProps2Z.length - 2; ++i) {
                this.iSubUI[i].iTF.setText(Image3D2Z.this.iDispProps2Z[i].iName);
                this.iSubUI[i].iCB.setSelectedIndex(Image3D2Z.this.iDispProps2Z[i].iLineageNum);
            }
        }

        public JPanel getPanel() {
            return this.iPanel;
        }

        public class SublineageUI {
            public JPanel iPanel = new JPanel();
            public JTextField iTF;
            public JComboBox iCB;

            public SublineageUI(int i) {
                this.iPanel.setLayout(new GridLayout(1, 2));
                this.iTF = new JTextField(Image3D2Z.this.iDispProps2Z[i].iName, 15);
                String[] list = PropertiesTab3.this.COLORS;
                if (i == Image3D2Z.this.iDispProps2Z.length - 2) {
                    list = PropertiesTab3.this.TRANSPROPS;
                } else if (i == Image3D2Z.this.iDispProps2Z.length - 1) {
                    list = PropertiesTab3.this.GRAYDEPTH;
                }
                this.iCB = new JComboBox<String>(list);
                this.iCB.setSelectedIndex(Image3D2Z.this.iDispProps2Z[i].iLineageNum);
                this.iPanel.add(this.iTF);
                this.iPanel.add(this.iCB);
                this.iPanel.setMaximumSize(new Dimension(200, 10));
            }
        }
    }

    public class SublineageDisplayProperty {
        public String iName;
        public int iLineageNum;

        public SublineageDisplayProperty(String name, int lineageNum) {
            this.iName = name;
            this.iLineageNum = lineageNum;
        }
    }

    public class NamedSphere
    extends Sphere {
        String iName;

        public NamedSphere(String name, float r, Appearance a) {
            super(r, a);
            this.iName = name;
        }
    }

    private class Trans {
        public Transform3D iT3d;
        public double iAngInc;
        public char iAxis;

        public Trans(Transform3D t, double a, char axis) {
            this.iT3d = t;
            this.iAngInc = a;
            this.iAxis = axis;
        }
    }

    public class Nuclei3D {
        private boolean iShowIt;
        private boolean iTransparent;
        private Vector iSisterList;
        private Hashtable iNucleiHash;
        private final String[] SISTERS = new String[]{"E", "MS", "AB", "P1", "EMS", "P2", "C", "P3", "D", "P4"};

        public Nuclei3D() {
            AceTree a = Image3D2Z.this.iAceTree;
            Image3D2Z.this.iBG = new BranchGroup();
            Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
            Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
            Material m = new Material(eColor, eColor, sColor, sColor, 100.0f);
            m.setLightingEnable(true);
            Appearance app = new Appearance();
            app.setMaterial(m);
            this.iSisterList = this.prepareSortedList();
            this.addNucleiViaSisterList();
        }

        private Appearance setColor(Color3f color) {
            Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
            Color3f sColor = color;
            Material m = new Material(eColor, eColor, sColor, sColor, 100.0f);
            m.setLightingEnable(true);
            Appearance app = new Appearance();
            app.setMaterial(m);
            return app;
        }

        private Appearance getLineageColor(int k) {
            Appearance app = null;
            switch (k) {
                case 0: {
                    app = this.setColor(ColorConstants.red);
                    break;
                }
                case 1: {
                    app = this.setColor(ColorConstants.blue);
                    break;
                }
                case 2: {
                    app = this.setColor(ColorConstants.green);
                    break;
                }
                case 3: {
                    app = this.setColor(ColorConstants.yellow);
                    break;
                }
                case 4: {
                    app = this.setColor(ColorConstants.cyan);
                    break;
                }
                case 5: {
                    app = this.setColor(ColorConstants.magenta);
                    break;
                }
                case 6: {
                    app = this.setColor(ColorConstants.pink);
                    break;
                }
                case 7: {
                    app = this.setColor(ColorConstants.gray);
                    break;
                }
                case 8: {
                    app = this.setColor(ColorConstants.white);
                    break;
                }
                default: {
                    app = null;
                }
            }
            return app;
        }

        private Appearance getExpressionColor(Nucleus n) {
            Cell.setMinRed(Image3D2Z.this.iMinRed);
            Cell.setMaxRed(Image3D2Z.this.iMaxRed);
            int k = Cell.getDiscrete(n.rweight);
            Color color = Cell.getTheColor(k);
            Color3f c3f = new Color3f(color);
            Appearance app = this.setColor(c3f);
            return app;
        }

        private Vector copyNuclei(Vector nuclei) {
            Vector<Nucleus> newNuclei = new Vector<Nucleus>();
            Enumeration e = nuclei.elements();
            Nucleus n = null;
            while (e.hasMoreElements()) {
                n = (Nucleus)e.nextElement();
                newNuclei.add(n.copy());
            }
            Collections.sort(newNuclei, n);
            return newNuclei;
        }

        private void showSisters() {
            Vector sorted;
            this.iSisterList = sorted = this.prepareSortedList();
            for (int i = 0; i < sorted.size() && i != sorted.size() - 1; ++i) {
                String second;
                String first = (String)sorted.get(i);
                if (!this.areSisters(first, second = (String)sorted.get(i + 1))) continue;
                Image3D2Z.println("sisters, " + first + Image3D2Z.CS + second);
                ++i;
            }
        }

        private Vector prepareSortedList() {
            this.iNucleiHash = new Hashtable();
            Vector<String> sortedList = new Vector<String>();
            Vector<String> catsAndDogs = new Vector<String>();
            NucleiMgr nucleiMgr = Image3D2Z.this.iAceTree.getNucleiMgr();
            int time = Image3D2Z.this.iAceTree.getImageTime() + Image3D2Z.this.iAceTree.getTimeInc();
            Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - 1);
            for (int i = 0; i < nuclei.size(); ++i) {
                Nucleus n = (Nucleus)nuclei.get(i);
                if (n.status == -1) continue;
                this.iNucleiHash.put(n.identity, n);
                if (this.inSISTERS(n.identity) >= 0) {
                    catsAndDogs.add(n.identity);
                    continue;
                }
                sortedList.add(n.identity);
            }
            Collections.sort(sortedList);
            this.addCatsAndDogs(sortedList, catsAndDogs);
            return sortedList;
        }

        private void addCatsAndDogs(Vector sortedList, Vector catsAndDogs) {
            while (catsAndDogs.size() > 0) {
                String name = (String)catsAndDogs.remove(0);
                sortedList.add(name);
                String sister = this.getSister(name);
                if (sister.length() <= 0 || !catsAndDogs.contains(sister)) continue;
                sortedList.add(sister);
                catsAndDogs.remove(sister);
            }
        }

        private boolean areSisters(String first, String second) {
            boolean rtn = false;
            boolean[] ans = new boolean[2];
            ans[1] = false;
            ans[0] = false;
            this.specialCaseSisters(first, second, ans);
            if (ans[0]) {
                return ans[1];
            }
            String s = "";
            s = first.substring(0, first.length() - 1);
            int k = second.indexOf(s);
            return k == 0 && first.length() == second.length();
        }

        private int inSISTERS(String name) {
            for (int i = 0; i < this.SISTERS.length; ++i) {
                if (!name.equals(this.SISTERS[i])) continue;
                return i;
            }
            return -1;
        }

        private String getSister(String name) {
            String sister = "";
            for (int i = 0; i < this.SISTERS.length; ++i) {
                if (!name.equals(this.SISTERS[i])) continue;
                if (i % 2 == 0) {
                    sister = this.SISTERS[i + 1];
                    break;
                }
                sister = this.SISTERS[i - 1];
                break;
            }
            return sister;
        }

        private void specialCaseSisters(String first, String second, boolean[] ans) {
            int firstLoc = this.inSISTERS(first);
            int secondLoc = this.inSISTERS(second);
            boolean bl = ans[0] = firstLoc >= 0 || secondLoc >= 0;
            ans[1] = firstLoc % 2 == 0 ? secondLoc == firstLoc + 1 : secondLoc == firstLoc - 1;
        }

        private void addNucleiViaSisterList() {
            this.iShowIt = true;
            this.iTransparent = false;
            NucleiMgr nucleiMgr = Image3D2Z.this.iAceTree.getNucleiMgr();
            int time = Image3D2Z.this.iAceTree.getImageTime() + Image3D2Z.this.iAceTree.getTimeInc();
            Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - 1);
            nuclei = this.copyNuclei(nuclei);
            this.getCenter(nuclei);
            int width = ImageWindow.cImageWidth;
            int height = ImageWindow.cImageHeight;
            float scale = width / 2;
            float xoff = Image3D2Z.this.iXA;
            float yoff = Image3D2Z.this.iYA;
            float zoff = Image3D2Z.this.iZA;
            while (this.iSisterList.size() > 0) {
                String name = (String)this.iSisterList.remove(0);
                if (this.iSisterList.size() == 0) {
                    this.addOne(name, false);
                    break;
                }
                String next = (String)this.iSisterList.get(0);
                if (this.areSisters(name, next)) {
                    this.iSisterList.remove(0);
                    this.addSisters(name, next, time);
                    continue;
                }
                this.addOne(name, false);
            }
        }

        private void addSisters(String first, String second, int time) {
            Nucleus n1 = this.addOne(first, true);
            boolean showing = this.iShowIt;
            Nucleus n2 = this.addOne(second, true);
            boolean bl = this.iShowIt = this.iShowIt && showing;
            if (this.iShowIt && !this.iTransparent) {
                this.addConnector(n1, n2, time);
            }
        }

        private void addConnector(Nucleus n1, Nucleus n2, int time) {
            if (!this.iShowIt) {
                return;
            }
            LineArray connector = new LineArray(2, 5);
            int width = ImageWindow.cImageWidth;
            int height = ImageWindow.cImageHeight;
            float scale = width / 2;
            float xoff = Image3D2Z.this.iXA;
            float yoff = Image3D2Z.this.iYA;
            float zoff = Image3D2Z.this.iZA;
            Nucleus n = n1;
            float xf = ((float)n.x - xoff) / scale;
            float yf = ((float)n.y - yoff) / scale;
            yf = -yf;
            double zpixres = Image3D2Z.this.iNucleiMgr.getZPixRes();
            float z = (float)Image3D2Z.this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
            z = -z;
            connector.setCoordinate(0, new Point3f(xf, yf, z));
            n = n2;
            xf = ((float)n.x - xoff) / scale;
            yf = ((float)n.y - yoff) / scale;
            yf = -yf;
            z = (float)Image3D2Z.this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
            z = -z;
            connector.setCoordinate(1, new Point3f(xf, yf, z));
            LineAttributes la = new LineAttributes();
            la.setLineWidth(5.0f);
            this.reportAngle(time, n1.identity, n2.identity, n1.x, n1.y, (double)n1.z * zpixres, n2.x, n2.y, (double)n2.z * zpixres);
            connector.setColor(0, ColorConstants.magenta);
            connector.setColor(1, ColorConstants.magenta);
            Appearance app = new Appearance();
            app.setLineAttributes(la);
            int k = Image3D2Z.this.getLineageNumber(n1.identity);
            if (k >= Image3D2Z.this.iDispProps2Z.length - 2) {
                connector.setColor(0, ColorConstants.white);
                connector.setColor(1, ColorConstants.white);
            }
            Image3D2Z.this.iBG.addChild((Node)new Shape3D((Geometry)connector, app));
        }

        private void reportAngle(int time, String name1, String name2, double x1, double y1, double z1, double x2, double y2, double z2) {
            double[] phiTheta = Angle3.angles(x1, y1, z1, x2, y2, z2);
            Image3D2Z.println("reportAngle, " + time + Image3D2Z.CS + name1 + Image3D2Z.CS + name2 + Image3D2Z.CS + Image3D2Z.fmt1(phiTheta[0]) + Image3D2Z.CS + Image3D2Z.fmt1(phiTheta[1]));
        }

        private Nucleus addOne(String name, boolean sister) {
            Nucleus n = (Nucleus)this.iNucleiHash.get(name);
            if (n == null) {
                Image3D2Z.println("addOne, " + name + Image3D2Z.CS + sister);
            }
            int width = ImageWindow.cImageWidth;
            int height = ImageWindow.cImageHeight;
            float scale = width / 2;
            float xoff = Image3D2Z.this.iXA;
            float yoff = Image3D2Z.this.iYA;
            float zoff = Image3D2Z.this.iZA;
            float xf = ((float)n.x - xoff) / scale;
            float yf = ((float)n.y - yoff) / scale;
            yf = -yf;
            float z = (float)Image3D2Z.this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
            z = -z;
            float rf = (float)(n.size / 2) / scale;
            Appearance app = new Appearance();
            TransparencyAttributes tran = new TransparencyAttributes(2, 1.0f);
            TransparencyAttributes tran2 = new TransparencyAttributes(2, 0.5f);
            int k = Image3D2Z.this.getLineageNumber(n.identity);
            this.iShowIt = true;
            this.iTransparent = false;
            if (k < Image3D2Z.this.iDispProps2Z.length - 2) {
                app = this.getLineageColor(k);
            } else {
                int m = Image3D2Z.this.iDispProps2Z[Image3D2Z.this.iDispProps2Z.length - 2].iLineageNum;
                switch (m) {
                    case 0: {
                        this.iShowIt = false;
                        break;
                    }
                    case 1: {
                        this.iTransparent = true;
                        app.setTransparencyAttributes(tran2);
                        break;
                    }
                    default: {
                        app = this.getLineageColor(8);
                        this.iShowIt = app != null;
                    }
                }
            }
            boolean bl = this.iShowIt = app != null;
            if (this.iShowIt && app != null) {
                if (sister) {
                    rf = (float)Math.min(n.size / 2, 10) / scale;
                }
                Image3D2Z.this.iBG.addChild((Node)this.makeNamedSphere(n.identity, xf, yf, z, rf, app));
            }
            return n;
        }

        private void addNuclei() {
            int count = 0;
            boolean falsePos = false;
            boolean falseNeg = false;
            NucleiMgr nucleiMgr = Image3D2Z.this.iAceTree.getNucleiMgr();
            int time = Image3D2Z.this.iAceTree.getImageTime() + Image3D2Z.this.iAceTree.getTimeInc();
            Vector nuclei = (Vector)nucleiMgr.getNucleiRecord().elementAt(time - 1);
            nuclei = this.copyNuclei(nuclei);
            this.getCenter(nuclei);
            Nucleus n = null;
            int width = ImageWindow.cImageWidth;
            int height = ImageWindow.cImageHeight;
            float scale = width / 2;
            float xoff = Image3D2Z.this.iXA;
            float yoff = Image3D2Z.this.iYA;
            float zoff = Image3D2Z.this.iZA;
            for (int j = 0; j < nuclei.size(); ++j) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.status < 0) continue;
                float xf = ((float)n.x - xoff) / scale;
                float yf = ((float)n.y - yoff) / scale;
                yf = -yf;
                float z = (float)Image3D2Z.this.iNucleiMgr.getZPixRes() * (n.z - zoff) / scale;
                z = -z;
                float rf = (float)(n.size / 2) / scale;
                Appearance app = new Appearance();
                TransparencyAttributes tran = new TransparencyAttributes(2, 1.0f);
                TransparencyAttributes tran2 = new TransparencyAttributes(2, 0.5f);
                tran.setTransparency(0.8f);
                int k = Image3D2Z.this.getLineageNumber(n.identity);
                this.iShowIt = true;
                if (k < Image3D2Z.this.iDispProps2Z.length - 2) {
                    app = this.getLineageColor(k);
                } else {
                    int m = Image3D2Z.this.iDispProps2Z[Image3D2Z.this.iDispProps2Z.length - 2].iLineageNum;
                    switch (m) {
                        case 0: {
                            this.iShowIt = false;
                            break;
                        }
                        case 1: {
                            app.setTransparencyAttributes(tran);
                            break;
                        }
                        default: {
                            app = this.getLineageColor(8);
                        }
                    }
                }
                if (Image3D2Z.this.iUseExpression) {
                    app = this.getExpressionColor(n);
                    if (n.rweight < Image3D2Z.this.iMinRed) {
                        app = this.setColor(ColorConstants.white);
                        app.setTransparencyAttributes(tran);
                        this.iShowIt = true;
                    }
                } else if (Image3D2Z.this.iDispProps2Z[Image3D2Z.this.iDispProps2Z.length - 3].iName.indexOf("Special") == 0) {
                    app = this.special(n);
                }
                if (!this.iShowIt || app == null) continue;
                Image3D2Z.this.iBG.addChild((Node)this.makeNamedSphere(n.identity, xf, yf, z, rf, app));
                if (app.getTransparencyAttributes() == tran) continue;
                ++count;
            }
        }

        private boolean inSCAList(Nucleus n) {
            String[] theList = new String[]{"ABaraaappaa", "ABalpaappa", "ABaraaappap", "ABaraaapaaa", "ABaraaappp", "MSaaaaaa", "ABalpaapppa", "ABprpapppp", "ABalpaapppp"};
            for (int i = 0; i < theList.length; ++i) {
                if (!n.identity.equals(theList[i])) continue;
                return true;
            }
            return false;
        }

        private Appearance special(Nucleus n) {
            Appearance appRest;
            TransparencyAttributes faint = new TransparencyAttributes(2, 0.8f);
            TransparencyAttributes invisible = new TransparencyAttributes(2, 1.0f);
            TransparencyAttributes solid = new TransparencyAttributes(2, 0.0f);
            Appearance app = null;
            String name = n.identity;
            app = appRest = null;
            this.iShowIt = true;
            if (name.indexOf("E") == 0) {
                app = this.setColor(ColorConstants.yellow);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("MSaa") == 0) {
                app = this.setColor(ColorConstants.magenta);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSaaaaaa") == 0 || name.indexOf("MSaappp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("MSpa") == 0) {
                app = this.setColor(ColorConstants.cyan);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSpapp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABalpaaa") == 0 || name.indexOf("ABalpaapa") == 0 || name.indexOf("ABalpapp") == 0) {
                app = this.setColor(ColorConstants.pink);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABaraaaa") == 0 || name.indexOf("ABaraaapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABaraaapaaa") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABaraap") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABarapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABarapapapa") == 0) {
                    app = appRest;
                }
            }
            if (app == appRest) {
                this.iShowIt = true;
                app = this.setColor(ColorConstants.white);
                app.setTransparencyAttributes(faint);
            }
            return app;
        }

        private Appearance special(Nucleus n, boolean bogus) {
            Appearance appRest;
            TransparencyAttributes faint = new TransparencyAttributes(2, 0.8f);
            TransparencyAttributes invisible = new TransparencyAttributes(2, 1.0f);
            TransparencyAttributes solid = new TransparencyAttributes(2, 0.0f);
            Appearance app = null;
            String name = n.identity;
            app = appRest = null;
            this.iShowIt = true;
            if (name.indexOf("E") == 0) {
                app = this.setColor(ColorConstants.green);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("MSaa") == 0) {
                app = this.setColor(ColorConstants.magenta);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSaaaaaa") == 0 || name.indexOf("MSaappp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("MSpa") == 0) {
                app = this.setColor(ColorConstants.cyan);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("MSpapp") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABalpaaa") == 0 || name.indexOf("ABalpaapa") == 0 || name.indexOf("ABalpapp") == 0) {
                app = this.setColor(ColorConstants.red);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABaraaaa") == 0 || name.indexOf("ABaraaapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABaraaapaaa") == 0) {
                    app = appRest;
                }
            }
            if (name.indexOf("ABaraap") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
            }
            if (name.indexOf("ABarapa") == 0) {
                app = this.setColor(ColorConstants.blue);
                app.setTransparencyAttributes(solid);
                if (name.indexOf("ABarapapapa") == 0) {
                    app = appRest;
                }
            }
            if (app == appRest) {
                this.iShowIt = true;
                app = this.setColor(ColorConstants.white);
                app.setTransparencyAttributes(faint);
            }
            return app;
        }

        private void getCenter(Vector nuclei) {
            Image3D2Z.this.iXA = 0;
            Image3D2Z.this.iYA = 0;
            Image3D2Z.this.iZA = 0.0f;
            int count = 0;
            Enumeration e = nuclei.elements();
            while (e.hasMoreElements()) {
                Nucleus n = (Nucleus)e.nextElement();
                if (n.status == -1) continue;
                Image3D2Z.this.iXA += n.x;
                Image3D2Z.this.iYA += n.y;
                Image3D2Z.this.iZA += n.z;
                ++count;
            }
            Image3D2Z.this.iXA /= count;
            Image3D2Z.this.iYA /= count;
            Image3D2Z.this.iZA /= count;
        }

        private TransformGroup makeNamedSphere(String name, float x, float y, float z, float r, Appearance a) {
            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(x, y, z));
            NamedSphere sph = new NamedSphere(name, r, a);
            TransformGroup tg = new TransformGroup(translate);
            tg.addChild((Node)sph);
            return tg;
        }

        private TransformGroup makeSphere(float x, float y, float z, float r, Appearance a) {
            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(x, y, z));
            Sphere sph = new Sphere(r, a);
            TransformGroup tg = new TransformGroup(translate);
            tg.addChild((Node)sph);
            return tg;
        }

        public BranchGroup getBG() {
            return Image3D2Z.this.iBG;
        }
    }
}

