/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color4f;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.Image3D2;
import org.rhwlab.image.Image3DGeometryManager;
import org.rhwlab.image.Image3DViewConfig;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.Cell;

public class Image3DOverlayGenerator
extends Thread {
    private AceTree aceTree;
    private Image3DViewConfig viewConfig;
    private ImageWindow imageWindow;
    private Image3DGeometryManager geoMgr;
    private NucleiMgr nucleiMgr;
    private boolean needReload;
    private Image3D2 parent;
    private Vector<BufferedImage> images;
    private Vector<double[]> coordinates;
    private Vector<Float> alphas;
    private Vector<Color> colors;
    private Shape3D overlay;
    private int time;
    private Cell overlayROICell;
    private int sliceCount;

    public Image3DOverlayGenerator(Image3D2 p) {
        this.parent = p;
        this.geoMgr = this.parent.getGeoManager();
        this.viewConfig = this.parent.getViewConfig();
        this.aceTree = this.parent.getAceTree();
        this.nucleiMgr = this.aceTree.getNucleiMgr();
        this.imageWindow = this.aceTree.iImgWin;
        this.sliceCount = 30;
        this.overlay = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.createOverlay();
                    this.geoMgr.setOverlayReady(true);
                    this.parent.insertContent("null");
                    Image3DOverlayGenerator image3DOverlayGenerator = this;
                    synchronized (image3DOverlayGenerator) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.geoMgr.setOverlayReady(false);
                continue;
            }
            break;
        }
    }

    public void loadImages() throws InterruptedException {
        this.images = new Vector();
        ImagePlus ip = null;
        String title = this.viewConfig.getTitle();
        String imageName = null;
        this.time = this.aceTree.getImageTime() + this.aceTree.getTimeInc();
        for (int i = 0; i < this.getSliceCount() && !Thread.currentThread().isInterrupted(); ++i) {
            imageName = "tif/" + title + "-p";
            if (i + 1 < 10) {
                imageName = imageName + "0";
            }
            imageName = imageName + (i + 1) + ".tif";
            ip = ImageWindow.makeImage(imageName);
            BufferedImage bf = ip.getBufferedImage();
            AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -bf.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            bf = op.filter(bf, null);
            this.images.add(bf);
            System.out.println("added image: " + imageName);
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        System.out.println("generator finished loading images.");
    }

    public Shape3D generateOverlay(float pointSize) throws InterruptedException {
        if (this.coordinates.size() > 0) {
            PointArray p = new PointArray(this.coordinates.size(), 13);
            Shape3D points = new Shape3D((Geometry)p);
            points.setAppearance(new Appearance());
            points.getAppearance().setPointAttributes(new PointAttributes(pointSize, true));
            for (int i = 0; i < this.coordinates.size(); ++i) {
                p.setCoordinate(i, this.coordinates.get(i));
                float[] col = this.colors.get(i).getColorComponents(null);
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                }
                if (!this.viewConfig.useOverlayRedChannel()) {
                    col[0] = 0.0f;
                }
                if (!this.viewConfig.useOverlayGreenChannel()) {
                    col[1] = 0.0f;
                }
                if (!this.viewConfig.useOverlayBlueChannel()) {
                    col[2] = 0.0f;
                }
                float alpha = (float)(1.0 - Math.pow(Math.sqrt(col[0] * col[0] + col[1] * col[1] + col[2] * col[2]) / Math.sqrt(3.0), 2.5));
                p.setColor(i, new Color4f(col[0], col[1], col[2], 1.0f - alpha));
            }
            System.out.println("Finished converting to Shape3D in generateOverlay().");
            return points;
        }
        return null;
    }

    public void generateOverlayInfo(double dx, double dy, double dz, int subSample, double colorScale) throws InterruptedException {
        this.coordinates = new Vector();
        this.colors = new Vector();
        this.alphas = new Vector();
        BufferedImage img = null;
        int width = ImageWindow.cImageWidth;
        if (width == 0) {
            width = 800;
        }
        float scale = width / 2;
        for (int z = 0; z < this.images.size(); ++z) {
            if (z <= this.viewConfig.getOverlayMinZ() || z >= this.viewConfig.getOverlayMaxZ()) continue;
            img = this.images.get(z);
            for (int x = 0; x < img.getWidth(); ++x) {
                if (x <= this.viewConfig.getOverlayMinX() || x >= this.viewConfig.getOverlayMaxX()) continue;
                for (int y = 0; y < img.getHeight(); ++y) {
                    if (y <= this.viewConfig.getOverlayMinY() || y >= this.viewConfig.getOverlayMaxY() || x % subSample != 0 || y % subSample != 0) continue;
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.currentThread();
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                    }
                    int colorAsInt = img.getRGB(x, img.getHeight() - y - 1);
                    this.colors.add(new Color(colorAsInt, true));
                    float[] col = new Color(colorAsInt).getColorComponents(null);
                    double alpha = 1.0 - Math.pow(Math.sqrt(col[0] * col[0] + col[1] * col[1] + col[2] * col[2]) / Math.sqrt(3.0), colorScale);
                    this.alphas.add(new Float((float)alpha));
                    float xf = (float)(x - this.geoMgr.iXA) / scale;
                    float yf = (float)(y - this.geoMgr.iYA) / scale;
                    float zf = (float)dz * ((float)z - this.geoMgr.iZA) / scale;
                    yf = -yf;
                    zf = -zf;
                    this.coordinates.add(new double[]{(double)xf * dx, (double)yf * dy, zf});
                }
            }
        }
        System.out.println("Finished generateOverlayInfo().");
    }

    public void addOverlayAutoROI() {
        Cell c = this.aceTree.getCurrentCell();
        if (c != this.overlayROICell) {
            this.overlayROICell = c;
            c = null;
        }
        int x = this.overlayROICell.getX();
        int y = this.overlayROICell.getY();
        double diameter = this.aceTree.getCurrentCell().getDiam();
        this.viewConfig.setOverlayMinX((int)((double)x - 2.0 * diameter));
        this.viewConfig.setOverlayMaxX((int)((double)x + 2.0 * diameter));
        this.viewConfig.setOverlayMinY((int)((double)y - 2.0 * diameter));
        this.viewConfig.setOverlayMaxY((int)((double)y + 2.0 * diameter));
        if (c != this.overlayROICell) {
            this.viewConfig.setOverlayXYZChanged(true);
        }
    }

    public void createOverlay() throws InterruptedException {
        if (this.viewConfig.useOverlayAutoROI()) {
            this.addOverlayAutoROI();
        }
        if (this.overlay == null || this.time != this.aceTree.getImageTime() + this.aceTree.getTimeInc()) {
            this.loadImages();
            this.viewConfig.setOverlayXYZChanged(true);
        }
        if (this.viewConfig.isOverlayXYZChanged()) {
            this.viewConfig.setOverlayXYZChanged(false);
            this.viewConfig.setChangeOverlayChannel(false);
            this.generateOverlayInfo(1.0, 1.0, this.nucleiMgr.getZPixRes(), this.viewConfig.getOverlaySubsample(), 2.5);
            this.overlay = this.generateOverlay(this.calculateOverlayPointSize());
        } else if (this.viewConfig.changeOverlayChannel()) {
            this.viewConfig.setChangeOverlayChannel(false);
            this.overlay = this.generateOverlay(this.calculateOverlayPointSize());
        }
        if (this.overlay != null) {
            this.geoMgr.setOverlay(this.overlay);
            return;
        }
    }

    public int getSliceCount() {
        return this.sliceCount;
    }

    public float calculateOverlayPointSize() {
        return (float)this.viewConfig.getOverlaySubsample() * 5.0f;
    }
}

