/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;

public class ImageAllCentroids
extends JPanel
implements ActionListener {
    private AceTree iAceTree;
    private NucleiMgr iNucleiMgr;
    private Frame iFrame;
    private String iTitle;
    private Canvas iCanvas;
    private Color[] iSpectrum;
    private JScrollPane iPane;
    private String iMenuItem;
    private boolean iInvertY;
    private boolean iUse200MinNames;
    private static final String[] sulstonNames = new String[]{"ABaraaaa", "ABalpaaa", "ABalpap", "ABaraapa", "ABarapaa", "ABaraapp", "ABarapap", "ABalpappa", "Capa", "Cppa", "Capp", "Cppp", "MSaaaa", "MSpaaa", "MSaaap", "MSaapa", "MSpaap", "MSpapa", "MSaapp", "Ealp", "Earp", "Epla", "Epra", "Eplp", "Eprp", "Da", "Dp", "Z"};
    private static final String ALL = "All";
    private static final String DIVIDING = "Dividing only";
    private static final String NONDIVIDING = "Nondividing";
    private static final String ATENDTIME = "At end time";
    private static final String STANDARD = "Standard view";
    private static final String INVERT_Y = "Invert y axis";
    private static final String USE200MIN_NAMES = "Use 200 minute names";

    public ImageAllCentroids(AceTree aceTree, String title) {
        this.iAceTree = aceTree;
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iFrame = new Frame(title);
        this.iFrame.setLayout(new BorderLayout());
        this.iTitle = title;
        this.iMenuItem = ALL;
        WinEventMgr wem = new WinEventMgr();
        this.iFrame.addWindowListener(wem);
        this.iCanvas = new CentroidsCanvas();
        this.iCanvas.setSize(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
        this.iFrame.add(this.iCanvas);
        this.iFrame.setSize(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
        this.iFrame.setMenuBar(this.createMenuBar());
        this.iFrame.show();
        int N = 35;
        int NUSE = 15;
        this.iSpectrum = new Color[N];
        for (int i = 0; i < N; ++i) {
            int j = i < 10 ? 0 : (i > 25 ? NUSE - 1 : i - 10);
            this.iSpectrum[i] = new Color((float)(NUSE - j) / (float)NUSE, (float)j / (float)NUSE, 0.0f);
        }
    }

    public void drawAllNuclei(Graphics2D g, int time) {
        Vector nuclei = this.iNucleiMgr.getNuclei(time);
        Nucleus n = null;
        int plane = 0;
        for (int i = 0; i < nuclei.size(); ++i) {
            n = (Nucleus)nuclei.elementAt(i);
            if (n.status == -1) continue;
            plane = (int)(n.z + 0.5f);
            g.setColor(this.iSpectrum[plane]);
            g.draw(EUtils.pCircle(n.x, n.y, n.size / 2));
            g.drawString(n.identity, n.x, n.y);
        }
    }

    public void drawNuclei(Graphics2D g, int time) {
        if (time == 1) {
            if (this.iMenuItem.equals(ALL)) {
                this.drawAllNuclei(g, time);
            }
            return;
        }
        Vector nuclei = this.iNucleiMgr.getNuclei(time);
        Vector prev = this.iNucleiMgr.getNuclei(time - 1);
        Nucleus n = null;
        Object p = null;
        boolean plane = false;
        for (int i = 0; i < nuclei.size(); ++i) {
            n = (Nucleus)nuclei.elementAt(i);
            if (n.status == -1) continue;
            this.drawIt(g, n);
        }
    }

    private boolean isAtEndTime(String cellName, int time) {
        Cell c = this.iAceTree.getCellByName(cellName);
        return c.getEndTime() == time;
    }

    private void drawIt(Graphics2D g, Nucleus n) {
        int ny = n.y;
        if (this.iInvertY) {
            ny = ImageWindow.cImageHeight - n.y;
        }
        int plane = (int)(n.z + 0.5f);
        g.setColor(this.iSpectrum[plane]);
        if (this.iUse200MinNames && !this.isInSet(n.identity)) {
            return;
        }
        g.draw(EUtils.pCircle(n.x, ny, n.size / 2));
        g.drawString(n.identity, n.x, ny);
    }

    private boolean isInSet(String name, int x) {
        boolean b = false;
        b = name.indexOf("MS") == 0;
        b = b || name.indexOf("E") == 0;
        b = b || name.indexOf("Z") == 0;
        b = b || name.indexOf("D") == 0;
        b = b || name.indexOf("C") == 0;
        return b;
    }

    private boolean isInSet(String name) {
        boolean b = false;
        for (int i = 0; i < sulstonNames.length; ++i) {
            boolean bl = b = b || name.indexOf(sulstonNames[i]) == 0;
            if (b) break;
        }
        return b;
    }

    public void drawTestCircles(Graphics2D g) {
        int x = 40;
        int y = 100;
        for (int i = 10; i <= 25; ++i) {
            g.setColor(this.iSpectrum[i]);
            g.draw(EUtils.pCircle(x, y, 20));
            g.drawString(String.valueOf(i), x + 10, y + 10);
            x += 45;
        }
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Show");
        MenuItem test = new MenuItem(STANDARD);
        menu.add(test);
        test.addActionListener(this);
        test = new MenuItem(INVERT_Y);
        menu.add(test);
        test.addActionListener(this);
        test = new MenuItem(USE200MIN_NAMES);
        test.addActionListener(this);
        menu.add(test);
        menuBar.add(menu);
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s;
        this.iMenuItem = s = e.getActionCommand();
        if (s.equals(STANDARD)) {
            this.iInvertY = false;
            this.iUse200MinNames = false;
        } else if (s.equals(INVERT_Y)) {
            this.iInvertY = !this.iInvertY;
        } else if (s.equals(USE200MIN_NAMES)) {
            this.iUse200MinNames = true;
        }
        this.iCanvas.repaint();
    }

    public static void main(String[] args) {
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ImageAllCentroids.this.iFrame.dispose();
        }
    }

    private class CentroidsCanvas
    extends Canvas {
        private CentroidsCanvas() {
        }

        @Override
        public void paint(Graphics g) {
            String s = ImageAllCentroids.this.iTitle;
            s = s.substring(s.indexOf("-t") + 2);
            int time = Integer.parseInt(s);
            Graphics2D g2d = (Graphics2D)g;
            this.setBackground(Color.white);
            g2d.setStroke(new BasicStroke(3.0f));
            ImageAllCentroids.this.drawNuclei(g2d, time);
        }
    }
}

