/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.io.Opener;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.rhwlab.acetree.AceTreeNoUI;
import org.rhwlab.acetree.AnnotInfo;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;
import org.rhwlab.utils.EUtils;

public class ImageWindowNoUI {
    AceTreeNoUI iAceTree;
    String iTitle;
    int iImageTime;
    int iTimeInc;
    int iImagePlane;
    int iPlaneInc;
    ImageCanvas iImgCanvas;
    static Object[] iSpecialEffect;
    public static ImagePlus iImgPlus;
    public static NucleiMgr cNucleiMgr;
    public static String cTifPrefix;
    public static int cUseZip;
    public static String cCurrentImageFile;
    public static int cImageWidth;
    public static int cImageHeight;
    public static String cCurrentImagePart;
    public static String cZipTifFilePath;
    public static String cTifPrefixR;
    public static int cLineWidth;
    static boolean cAcbTree;
    static byte[] iRpix;
    static byte[] iGpix;
    static byte[] iBpix;
    protected static final String RANDOMF = ".zip0";
    protected static final String RANDOMT = ".tif0";
    protected static final String DASHT = "-t";
    protected static final String DASHP = "-p";
    private static final String CS = ", ";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    public ImageWindowNoUI(String s, ImagePlus ip) {
        ImageCanvas ic;
        this.iTitle = s;
        iImgPlus = ip;
        this.iImgCanvas = ic = new ImageCanvas(iImgPlus);
    }

    public void test() {
        new ImageWindow(iImgPlus);
    }

    public ImagePlus refreshDisplay(String imageName) {
        int k;
        ImageWindowNoUI.println("refreshDisplay, " + imageName);
        if (imageName == null) {
            imageName = this.iTitle;
        } else {
            if (imageName.indexOf(cTifPrefix) == -1) {
                imageName = cTifPrefix + imageName;
            }
            this.iTitle = imageName;
        }
        this.iTimeInc = this.iAceTree.getTimeInc();
        this.iPlaneInc = this.iAceTree.getPlaneInc();
        this.iImageTime = this.iAceTree.getImageTime();
        this.iImagePlane = this.iAceTree.getImagePlane();
        String random = RANDOMT;
        if (cUseZip > 0) {
            random = RANDOMF;
        }
        if ((k = imageName.indexOf(random)) > -1) {
            imageName = imageName.substring(0, k + random.length() - 1);
        }
        ImagePlus ip = null;
        ip = ImageWindowNoUI.makeImage(imageName);
        switch (this.iAceTree.getColor()) {
            case 1: {
                ip = ImageWindowNoUI.makeGreenImagePlus(ip);
                break;
            }
            case 2: {
                ip = ImageWindowNoUI.makeRedImagePlus(ip);
                break;
            }
            case 3: {
                ip = ImageWindowNoUI.makePlainImagePlus(ip);
                break;
            }
        }
        if (ip != null) {
            iImgPlus.setProcessor(imageName, ip.getProcessor());
        }
        if (this.iAceTree.isTracking()) {
            this.iAceTree.addMainAnnotation();
        }
        if (iSpecialEffect != null) {
            this.showSpecialEffect();
        }
        this.iImgCanvas.repaint();
        return iImgPlus;
    }

    public static ImagePlus makeImage(String s) {
        cCurrentImageFile = s;
        ImagePlus ip = null;
        ip = ImageWindowNoUI.doMakeImageFromTif(s);
        if (ip != null) {
            cImageWidth = ip.getWidth();
            cImageHeight = ip.getHeight();
        }
        if (ip == null) {
            return iImgPlus;
        }
        return ip;
    }

    public static ImagePlus doMakeImageFromTif(String s) {
        cCurrentImagePart = s;
        ImagePlus ip = null;
        String ss = cZipTifFilePath + "/" + s;
        ip = new Opener().openImage(ss);
        if (ip != null) {
            cImageWidth = ip.getWidth();
            cImageHeight = ip.getHeight();
            ip = ImageWindowNoUI.convertToRGB(ip);
        } else {
            ip = new ImagePlus();
            ColorProcessor iproc = new ColorProcessor(cImageWidth, cImageHeight);
            ip.setProcessor(s, iproc);
        }
        return ip;
    }

    protected static ImagePlus makeRedImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, new byte[iRpix.length], new byte[iRpix.length]);
        ip.setProcessor("test", iproc3);
        return ip;
    }

    protected static ImagePlus makeGreenImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(new byte[iRpix.length], iGpix, new byte[iRpix.length]);
        ip.setProcessor("test", iproc3);
        return ip;
    }

    protected static ImagePlus makePlainImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        if (cAcbTree) {
            iproc3.setRGB(iRpix, iRpix, iRpix);
        } else {
            iproc3.setRGB(new byte[iRpix.length], new byte[iRpix.length], new byte[iRpix.length]);
        }
        ip.setProcessor("test", iproc3);
        return ip;
    }

    private static byte[] getRedChannel(byte[] R) {
        String fileName = ImageWindowNoUI.makeRedChannelName();
        File f = new File(fileName);
        if (f.exists()) {
            ImagePlus ip = null;
            ip = new Opener().openImage(fileName);
            if (ip != null) {
                ByteProcessor bproc = (ByteProcessor)ip.getProcessor();
                R = (byte[])bproc.getPixels();
            } else {
                System.out.println("getRedChannel, Opener returned null ip");
            }
        }
        return R;
    }

    private static String makeRedChannelName() {
        String s = cCurrentImageFile;
        String ss = cCurrentImagePart;
        ss = ss.substring(3);
        s = cZipTifFilePath + "/" + "/tifR/" + ss;
        return s;
    }

    private static ImagePlus convertToRGB(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        byte[] bpix = (byte[])iproc.getPixels();
        byte[] R = new byte[bpix.length];
        byte[] G = new byte[bpix.length];
        byte[] B = new byte[bpix.length];
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.getRGB(R, G, B);
        G = bpix;
        R = ImageWindowNoUI.getRedChannel(R);
        iRpix = R;
        iGpix = G;
        iBpix = B;
        return ImageWindowNoUI.buildImagePlus(ip);
    }

    private static ImagePlus buildImagePlus(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.setRGB(iRpix, iGpix, iBpix);
        ip.setProcessor("test", iproc3);
        return ip;
    }

    public ImagePlus getImagePlus() {
        return iImgPlus;
    }

    public void showCentroids() {
        Color nucColor = new Color(140, 70, 255);
        int time = this.iImageTime + this.iTimeInc;
        if (time < 0) {
            this.iImageTime = 1;
            this.iTimeInc = 0;
        }
        Vector v = (Vector)cNucleiMgr.getNucleiRecord().elementAt(this.iImageTime + this.iTimeInc - 1);
        ImageProcessor iproc = this.getImagePlus().getProcessor();
        iproc.setColor(Color.WHITE);
        iproc.setLineWidth(2);
        Object p = null;
        Enumeration e = v.elements();
        Cell currentCell = null;
        iproc.setColor(nucColor);
        while (e.hasMoreElements()) {
            double x;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0 || !((x = cNucleiMgr.nucDiameter(n, this.iImagePlane + this.iPlaneInc)) > 0.0)) continue;
            if (currentCell != null && n.hashKey != null && n.hashKey.equals(currentCell.getHashKey()) && this.iAceTree.isTracking()) {
                iproc.setColor(nucColor);
            }
            iproc.drawPolygon(EUtils.pCircle(n.x, n.y, (int)(x / 2.0)));
            iproc.setColor(nucColor);
        }
    }

    public void showSingleCentroid(Nucleus n) {
        ImageProcessor iproc = this.getImagePlus().getProcessor();
        iproc.setColor(Color.WHITE);
        iproc.setLineWidth(2);
        double x = cNucleiMgr.nucDiameter(n, this.iImagePlane + this.iPlaneInc);
        if (x > 0.0) {
            iproc.drawPolygon(EUtils.pCircle(n.x, n.y, (int)(x / 2.0)));
        }
    }

    public void showSingleAnnotation(Nucleus n, Graphics g) {
        Vector<AnnotInfo> annots = new Vector<AnnotInfo>();
        AnnotInfo ai = new AnnotInfo(n.identity, n.x, n.y);
        if (cNucleiMgr.hasCircle(n, this.iImagePlane + this.iPlaneInc)) {
            annots.add(ai);
        }
        g.setColor(Color.WHITE);
        g.drawString(n.identity, n.x, n.y);
    }

    public void showAnnotations(Graphics g) {
        Vector v = (Vector)cNucleiMgr.getNucleiRecord().elementAt(this.iImageTime + this.iTimeInc - 1);
        int size = v.size();
        int[] x = new int[size];
        int[] y = new int[size];
        Vector<AnnotInfo> annots = new Vector<AnnotInfo>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = null;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0) continue;
            ai = new AnnotInfo(n.identity, n.x, n.y);
            if (!cNucleiMgr.hasCircle(n, this.iImagePlane + this.iPlaneInc)) continue;
            annots.add(ai);
        }
        this.drawStrings(annots, g);
    }

    private void drawStrings(Vector annots, Graphics g) {
        g.setColor(Color.WHITE);
        Enumeration e = annots.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = (AnnotInfo)e.nextElement();
            g.drawString(ai.iName, ai.iX, ai.iY);
        }
    }

    public void showAnnotations() {
        Vector v = (Vector)cNucleiMgr.getNucleiRecord().elementAt(this.iImageTime + this.iTimeInc - 1);
        int size = v.size();
        int[] x = new int[size];
        int[] y = new int[size];
        Vector<AnnotInfo> annots = new Vector<AnnotInfo>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = null;
            Nucleus n = (Nucleus)e.nextElement();
            if (n.status < 0) continue;
            ai = new AnnotInfo(n.identity, n.x, n.y);
            if (!cNucleiMgr.hasCircle(n, this.iImagePlane + this.iPlaneInc)) continue;
            annots.add(ai);
        }
        this.drawStrings(annots, this);
    }

    private void drawStrings(Vector annots, ImageWindowNoUI imgWin) {
        ImagePlus imgPlus = imgWin.getImagePlus();
        ImageProcessor imgProc = imgPlus.getProcessor();
        ImageCanvas imgCan = imgWin.getCanvas();
        imgProc.setColor(Color.WHITE);
        imgProc.setFont(new Font("SansSerif", 1, 13));
        Enumeration e = annots.elements();
        while (e.hasMoreElements()) {
            AnnotInfo ai = (AnnotInfo)e.nextElement();
            imgProc.moveTo(imgCan.offScreenX(ai.iX), imgCan.offScreenY(ai.iY));
            imgProc.drawString(ai.iName);
        }
        imgPlus.updateAndDraw();
    }

    public ImageCanvas getCanvas() {
        return this.iImgCanvas;
    }

    protected void showSpecialEffect() {
    }

    public void addAnnotation(int mx, int my, boolean dontRemove) {
    }

    public static void setNucleiMgr(NucleiMgr nucleiMgr) {
        cNucleiMgr = nucleiMgr;
    }

    public static void setStaticParameters(String zipTifFilePath, String tifPrefix, int useZip) {
        cZipTifFilePath = zipTifFilePath;
        cTifPrefix = tifPrefix;
        cUseZip = useZip;
        cLineWidth = 2;
        String[] sa = cTifPrefix.split("/");
        if (sa.length > 1) {
            cTifPrefixR = sa[0] + "R" + "/" + sa[1];
        }
    }

    public void setAceTree(AceTreeNoUI aceTree) {
        this.iAceTree = aceTree;
    }

    public ImageWindowNoUI getImageWindow() {
        return this;
    }

    public BufferedImage createBufferedImage() {
        Image image = iImgPlus.getImage();
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }

    static {
        cAcbTree = false;
        DF0 = new DecimalFormat("####");
        DF1 = new DecimalFormat("####.#");
        DF4 = new DecimalFormat("####.####");
    }
}

