/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rhwlab.image.ImageWindow;

public class ImageZoomerFrame
extends JFrame
implements MouseListener,
ActionListener {
    private ImagePanel m_imagePanel;
    private JScrollPane m_srollPane;
    private JPanel m_imageContainer;
    private JLabel m_zoomedInfo;
    private JButton m_zoomInButton;
    private JButton m_zoomOutButton;
    private JButton m_originalButton;
    private Cursor m_zoomCursor;
    ImageWindow iImgWin;
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public ImageZoomerFrame(ImageWindow imgWin, Image image, double zoomPercentage, String imageName) {
        super("Image Zoomer [" + imageName + "]");
        this.iImgWin = imgWin;
        if (image == null) {
            this.add(new JLabel("Image " + imageName + " not Found"));
        } else {
            JPanel topPanel = new JPanel(new FlowLayout(1));
            this.m_zoomInButton = new JButton("Zoom In");
            this.m_zoomInButton.addActionListener(this);
            this.m_zoomOutButton = new JButton("Zoom Out");
            this.m_zoomOutButton.addActionListener(this);
            this.m_originalButton = new JButton("Original");
            this.m_originalButton.addActionListener(this);
            this.m_zoomedInfo = new JLabel("Zoomed to 100%");
            topPanel.add(new JLabel("Zoom Percentage is " + (int)zoomPercentage + "%"));
            topPanel.add(this.m_zoomInButton);
            topPanel.add(this.m_originalButton);
            topPanel.add(this.m_zoomOutButton);
            topPanel.add(this.m_zoomedInfo);
            this.m_imagePanel = new ImagePanel(image, zoomPercentage);
            this.m_imagePanel.addMouseListener(this);
            this.m_imagePanel.addKeyListener(this.iImgWin);
            this.m_imageContainer = new JPanel(new FlowLayout(1));
            this.m_imageContainer.setBackground(Color.BLACK);
            this.m_imageContainer.add(this.m_imagePanel);
            this.m_srollPane = new JScrollPane(this.m_imageContainer);
            this.m_srollPane.setAutoscrolls(true);
            this.getContentPane().add("North", topPanel);
            this.getContentPane().add("Center", this.m_srollPane);
            this.m_imagePanel.repaint();
        }
        this.pack();
        this.setVisible(true);
    }

    public void updateImage(Image img) {
        this.m_imagePanel.updateImage(img);
        this.m_imagePanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.m_zoomInButton)) {
            this.m_imagePanel.zoomIn();
            this.adjustLayout();
        } else if (ae.getSource().equals(this.m_zoomOutButton)) {
            this.m_imagePanel.zoomOut();
            this.adjustLayout();
        } else if (ae.getSource().equals(this.m_originalButton)) {
            this.m_imagePanel.originalSize();
            this.adjustLayout();
        }
    }

    public void setZoomCursorImage(Image zoomcursorImage) {
        this.m_zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(zoomcursorImage, new Point(0, 0), "ZoomCursor");
    }

    private void adjustLayout() {
        this.m_imageContainer.doLayout();
        this.m_srollPane.doLayout();
        this.m_zoomedInfo.setText("Zoomed to " + (int)this.m_imagePanel.getZoomedTo() + "%");
    }

    void getPositionData(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int x2 = (int)Math.round((double)x * 100.0 / this.m_imagePanel.getZoomedTo());
        int y2 = (int)Math.round((double)y * 100.0 / this.m_imagePanel.getZoomedTo());
        MouseEvent e2 = new MouseEvent(this.iImgWin, 0, 0L, 0, x2, y2, 0, false, e.getButton());
        this.iImgWin.getMouseHandler().mouseClicked(e2);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 || e.getButton() == 3) {
            // empty if block
        }
        this.getPositionData(e);
        this.adjustLayout();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }

    public class ImagePanel
    extends JPanel {
        private double m_zoom = 1.0;
        private double m_zoomPercentage;
        private Image m_image;

        public ImagePanel(Image image, double zoomPercentage) {
            this.m_image = image;
            this.m_zoomPercentage = zoomPercentage / 100.0;
        }

        public void updateImage(Image img) {
            this.m_image = img;
        }

        @Override
        public void paintComponent(Graphics grp) {
            Graphics2D g2D = (Graphics2D)grp;
            g2D.setColor(Color.WHITE);
            g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2D.scale(this.m_zoom, this.m_zoom);
            g2D.drawImage(this.m_image, 0, 0, this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((double)this.m_image.getWidth(this) + (double)this.m_image.getWidth(this) * (this.m_zoom - 1.0)), (int)((double)this.m_image.getHeight(this) + (double)this.m_image.getHeight(this) * (this.m_zoom - 1.0)));
        }

        public void setZoomPercentage(int zoomPercentage) {
            this.m_zoomPercentage = (double)zoomPercentage / 100.0;
        }

        public void originalSize() {
            this.m_zoom = 1.0;
        }

        public void zoomIn() {
            this.m_zoom += this.m_zoomPercentage;
        }

        public void zoomOut() {
            this.m_zoom -= this.m_zoomPercentage;
            if (this.m_zoom < this.m_zoomPercentage) {
                if (this.m_zoomPercentage > 1.0) {
                    this.m_zoom = 1.0;
                } else {
                    this.zoomIn();
                }
            }
        }

        public double getZoomedTo() {
            return this.m_zoom * 100.0;
        }
    }
}

