/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.text.DecimalFormat;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.rhwlab.image.Axis3D;
import org.rhwlab.image.ColorConstants;

public class Indicator3D
extends JPanel {
    private SimpleUniverse iUniverse;
    private Canvas3D iCanvas;
    BranchGroup iBGT;
    BranchGroup iBG;
    private Transform3D iRotate;
    private TransformGroup iRotGroup;
    private Transform3D iTranslate;
    private TransformGroup iTranslateGroup;
    private Vector3d iTranslateVec;
    private Matrix4d iMatrix;
    private double iZViewPos;
    private static final double SCALE = 4.0;
    private static final String CS = ", ";
    private static final DecimalFormat DF1 = new DecimalFormat("####.##");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public Indicator3D() {
        Dimension d = new Dimension(200, 200);
        this.setPreferredSize(d);
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.iCanvas = new Canvas3D(config);
        this.iCanvas.setSize(d.width, d.height);
        this.add((Component)this.iCanvas);
        this.iUniverse = new SimpleUniverse(this.iCanvas);
        this.iUniverse.getViewingPlatform().setNominalViewingTransform();
        ViewingPlatform viewingPlatform = this.iUniverse.getViewingPlatform();
        this.iTranslateGroup = viewingPlatform.getViewPlatformTransform();
        this.insertContent();
    }

    public static void main(String[] args) {
        Indicator3D.println("main, ");
        JFrame frame = new JFrame("Indicator3DTest");
        Indicator3D indicator = new Indicator3D();
        frame.getContentPane().add(indicator);
        frame.pack();
        frame.show();
    }

    public void insertContent() {
        if (this.iBG != null) {
            this.iBG.detach();
        }
        this.iBG = this.createSceneGraph();
        this.iUniverse.addBranchGraph(this.iBG);
    }

    private BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        root.setCapability(17);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f lColor1 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        Vector3f lDirect1 = new Vector3f(lPos1);
        lDirect1.negate();
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDirect1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        root.addChild((Node)lgt1);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        root.addChild((Node)bg);
        TransformGroup objRotate = new TransformGroup();
        objRotate.setCapability(18);
        objRotate.setCapability(17);
        this.iBGT = new Axis3D(0.0, 0.0, 0.0);
        this.iBGT.compile();
        objRotate.addChild((Node)this.iBGT);
        TransformGroup initRotGroup = new TransformGroup();
        Transform3D initRotate = new Transform3D();
        initRotate.setScale(0.5);
        initRotGroup.setTransform(initRotate);
        initRotGroup.addChild((Node)objRotate);
        if (this.iRotate == null) {
            this.iRotate = new Transform3D();
        }
        this.iRotate.setScale(4.0);
        this.iRotGroup = new TransformGroup(this.iRotate);
        this.iRotGroup.setCapability(18);
        this.iRotGroup.addChild((Node)initRotGroup);
        root.addChild((Node)this.iRotGroup);
        root.compile();
        return root;
    }

    public void apply(Transform3D t3d) {
        this.iRotate.mul(t3d);
        this.iRotGroup.setTransform(this.iRotate);
    }

    public void restore() {
        this.iRotate.setIdentity();
        this.iRotate.setScale(4.0);
        this.iRotGroup.setTransform(this.iRotate);
    }

    private static void println(String s) {
        System.out.println(s);
    }

    public class NamedSphere
    extends Sphere {
        String iName;

        public NamedSphere(String name, float r, Appearance a) {
            super(r, a);
            this.iName = name;
        }
    }

    public class Talisman {
        public Talisman() {
            Indicator3D.this.iBGT = new BranchGroup();
            float p = 0.1f;
            float q = 0.06f;
            float r = 0.04f;
            float z = 0.0f;
            float d = 0.02f;
            Indicator3D.this.iBGT.addChild((Node)this.makeNamedSphere("anterior", -p, z, z, d, this.setColor(ColorConstants.magenta)));
            Indicator3D.this.iBGT.addChild((Node)this.makeNamedSphere("posterior", p, z, z, d, this.setColor(ColorConstants.cyan)));
            Indicator3D.this.iBGT.addChild((Node)this.makeNamedSphere("dorsal", z, q, z, d, this.setColor(ColorConstants.red)));
            Indicator3D.this.iBGT.addChild((Node)this.makeNamedSphere("ventral", z, -q, z, d, this.setColor(ColorConstants.green)));
            Indicator3D.this.iBGT.addChild((Node)this.makeNamedSphere("left", z, z, r, d, this.setColor(ColorConstants.orange)));
            Indicator3D.this.iBGT.addChild((Node)this.makeNamedSphere("right", z, z, -r, d, this.setColor(ColorConstants.yellow)));
            LineArray axisXLines = new LineArray(2, 5);
            Indicator3D.this.iBGT.addChild((Node)new Shape3D((Geometry)axisXLines));
            axisXLines.setCoordinate(0, new Point3f(-p, z, z));
            axisXLines.setCoordinate(1, new Point3f(p, z, z));
            axisXLines.setColor(0, ColorConstants.magenta);
            axisXLines.setColor(1, ColorConstants.magenta);
            LineArray axisYLines = new LineArray(2, 5);
            Indicator3D.this.iBGT.addChild((Node)new Shape3D((Geometry)axisYLines));
            axisYLines.setCoordinate(0, new Point3f(z, -q, z));
            axisYLines.setCoordinate(1, new Point3f(z, q, z));
            axisYLines.setColor(0, ColorConstants.green);
            axisYLines.setColor(1, ColorConstants.green);
            LineArray axisZLines = new LineArray(2, 5);
            Indicator3D.this.iBGT.addChild((Node)new Shape3D((Geometry)axisZLines));
            axisZLines.setCoordinate(0, new Point3f(z, z, -r));
            axisZLines.setCoordinate(1, new Point3f(z, z, r));
            axisZLines.setColor(0, ColorConstants.yellow);
            axisZLines.setColor(1, ColorConstants.yellow);
        }

        private Appearance setColor(Color3f color) {
            Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
            Color3f sColor = color;
            Material m = new Material(eColor, eColor, sColor, sColor, 100.0f);
            m.setLightingEnable(true);
            Appearance app = new Appearance();
            app.setMaterial(m);
            return app;
        }

        private TransformGroup makeNamedSphere(String name, float x, float y, float z, float r, Appearance a) {
            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(x, y, z));
            NamedSphere sph = new NamedSphere(name, r, a);
            TransformGroup tg = new TransformGroup(translate);
            tg.addChild((Node)sph);
            return tg;
        }
    }
}

