/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.image;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.TiffDecoder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.rhwlab.image.ImageWindow;

public class ZipImage {
    ZipFile iZipFile;
    private static final int DATA_BLOCK_SIZE = 2048;

    public ZipImage(ZipFile zipFile) {
        this.iZipFile = zipFile;
    }

    public ZipImage(String zipTifFilePath) {
        if (this.iZipFile == null) {
            try {
                this.iZipFile = new ZipFile(zipTifFilePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ZipEntry getZipEntry(String entryName) {
        if (this.iZipFile == null) {
            return null;
        }
        Enumeration<? extends ZipEntry> entries = this.iZipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (!ze.getName().equals(entryName)) continue;
            return ze;
        }
        return null;
    }

    public ImagePlus readData(ZipEntry ze) {
        if (ze == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int byteCount;
            InputStream is = this.iZipFile.getInputStream(ze);
            byte[] data = new byte[2048];
            while ((byteCount = is.read(data, 0, 2048)) != -1) {
                out.write(data, 0, byteCount);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this.openTiff(new ByteArrayInputStream(out.toByteArray()));
    }

    public ImagePlus readData(ZipEntry ze, boolean asEightBit) {
        if (ze == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int byteCount;
            InputStream is = this.iZipFile.getInputStream(ze);
            byte[] data = new byte[2048];
            while ((byteCount = is.read(data, 0, 2048)) != -1) {
                out.write(data, 0, byteCount);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this.openTiff(new ByteArrayInputStream(out.toByteArray()), asEightBit);
    }

    private ImagePlus openTiff(InputStream in, boolean asEightBit) {
        if (in == null) {
            return null;
        }
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, null);
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.error("TiffDecoder", "File not found: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            IJ.error("TiffDecoder", "" + e);
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.log(info[0].info);
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        return imp;
    }

    private ImagePlus openTiff(InputStream in) {
        if (in == null) {
            return null;
        }
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, null);
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.error("TiffDecoder", "File not found: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            IJ.error("TiffDecoder", "" + e);
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.log(info[0].info);
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        if (info[0].getBytesPerPixel() == 1) {
            imp = this.convertToRGB(imp);
        }
        return imp;
    }

    private ImagePlus convertToRGB(ImagePlus ip) {
        ImageProcessor iproc = ip.getProcessor();
        byte[] bpix = (byte[])iproc.getPixels();
        byte[] R = new byte[bpix.length];
        byte[] G = new byte[bpix.length];
        byte[] B = new byte[bpix.length];
        ColorProcessor iproc3 = new ColorProcessor(iproc.getWidth(), iproc.getHeight());
        iproc3.getRGB(R, G, B);
        G = bpix;
        R = this.getRedChannel(R);
        iproc3.setRGB(R, G, B);
        ip.setProcessor("test", iproc3);
        return ip;
    }

    private byte[] getRedChannel(byte[] R) {
        String fileName = ZipImage.makeRedChannelName();
        File f = new File(fileName);
        ZipFile zipImage = null;
        if (f.exists()) {
            ImagePlus ip = null;
            try {
                zipImage = new ZipFile(fileName);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            int k1 = fileName.lastIndexOf("/") + 1;
            String ss = fileName.substring(k1);
            int k2 = ss.indexOf(".");
            ss = ss.substring(0, k2);
            ZipEntry ze = null;
            if (zipImage != null) {
                ze = zipImage.getEntry(ss + ".tif");
            }
            if (ze == null) {
                ip = new ImagePlus();
                ColorProcessor iproc = new ColorProcessor(ImageWindow.cImageWidth, ImageWindow.cImageHeight);
                ip.setProcessor(fileName, iproc);
            } else {
                ip = this.readRedData(zipImage, ze);
            }
            if (ip != null) {
                ByteProcessor bproc = (ByteProcessor)ip.getProcessor();
                R = (byte[])bproc.getPixels();
            }
        }
        return R;
    }

    public ImagePlus readRedData(ZipFile zipFile, ZipEntry ze) {
        if (ze == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        try {
            int byteCount;
            InputStream is = zipFile.getInputStream(ze);
            byte[] data = new byte[2048];
            while ((byteCount = is.read(data, 0, 2048)) != -1) {
                out.write(data, 0, byteCount);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this.openRedTiff(new ByteArrayInputStream(out.toByteArray()));
    }

    private ImagePlus openRedTiff(InputStream in) {
        if (in == null) {
            return null;
        }
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, null);
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.error("TiffDecoder", "File not found: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            IJ.error("TiffDecoder", "" + e);
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.log(info[0].info);
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        return imp;
    }

    private static String makeRedChannelName() {
        String s = ImageWindow.cCurrentImageFile;
        int k = s.indexOf(ImageWindow.cTifPrefix) + ImageWindow.cTifPrefix.length();
        s = ImageWindow.cZipTifFilePath + "/" + ImageWindow.cTifPrefixR + s.substring(k);
        return s;
    }

    protected void finalize() throws IOException {
        this.iZipFile.close();
    }

    public void xdelay(long delayTime) {
        long start = System.currentTimeMillis();
        long end = start + delayTime;
        while (System.currentTimeMillis() < end) {
        }
    }

    public static void main(String[] args) throws Exception {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

