/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.manifest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ManifestX {
    static JarFile cJarFile;
    static Manifest cManifest;
    static Hashtable cManifestHash;
    public static final String SRC_MANIFEST_FILE = "src/org/rhwlab/manifest/manifest.txt";
    private static final String CS = ", ";
    private static final String C = ",";

    public static void reportAndUpdateManifest() {
        String s = "Running from jar";
        if (!ManifestX.amRunningFromJar()) {
            s = "NOT " + s;
            ManifestX.updateManifest();
        }
        ManifestX.showManifest();
    }

    public static void showManifest() {
        if (cJarFile != null) {
            ManifestX.showManifestFromJar();
        } else {
            ManifestX.showManifestFromHash();
        }
    }

    public static void showManifestFromJar() {
        String jarFileName = System.getProperty("java.class.path").split(System.getProperty("path.separator"))[0];
        ManifestX.println("jarFileName, " + jarFileName);
        try {
            JarFile jar = new JarFile(jarFileName);
            Manifest manifest = jar.getManifest();
            Attributes entries = manifest.getMainAttributes();
            Iterator iter = entries.entrySet().iterator();
            for (int i = 0; i < entries.size(); ++i) {
                Map.Entry me = iter.next();
                Object key = me.getKey();
                String value = (String)me.getValue();
                ManifestX.println("" + i + CS + key + CS + value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showManifestFromHash() {
        Enumeration keys = cManifestHash.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)cManifestHash.get(key);
            ManifestX.println(key + CS + value);
        }
    }

    public static boolean amRunningFromJar() {
        if (cJarFile != null) {
            return true;
        }
        String pathToJar = System.getProperty("java.class.path");
        System.out.println("pathToJar: " + pathToJar);
        String ps = ":";
        int k = pathToJar.indexOf(ps);
        boolean b = k < 0;
        String s = "RUNNING FROM JAR";
        if (!b) {
            s = "NOT " + s;
        }
        ManifestX.println(s);
        if (b) {
            String jarFileName = System.getProperty("java.class.path").split(System.getProperty("path.separator"))[0];
            try {
                cJarFile = new JarFile(jarFileName);
                cManifest = cJarFile.getManifest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public static void updateManifest() {
        cManifestHash = new Hashtable();
        File f = new File(SRC_MANIFEST_FILE);
        Vector<String> v = new Vector<String>();
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String sr = br.readLine();
            while (sr != null && sr.length() > 2) {
                String[] sa = sr.split(": ");
                cManifestHash.put(sa[0], sa[1]);
                if (sr.indexOf("Manifest-Version") < 0) {
                    v.add(sr);
                }
                sr = br.readLine();
            }
            br.close();
            PrintStream ps = new PrintStream(new FileOutputStream(f));
            String version = ManifestX.makeVersion();
            cManifestHash.put("Manifest-Version", version);
            ps.println("Manifest-Version: " + version);
            ManifestX.println("updateManifest: " + version);
            for (int i = 0; i < v.size(); ++i) {
                String s = (String)v.get(i);
                ps.println(s);
            }
            ps.flush();
            ps.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static String makeVersion() {
        GregorianCalendar c = new GregorianCalendar();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hr = c.get(11);
        int min = c.get(12);
        String version = String.valueOf(year) + ManifestX.padInt(month) + ManifestX.padInt(day) + ManifestX.padInt(hr) + ManifestX.padInt(min);
        return version;
    }

    public static String getManifestValue(String property) {
        if (cJarFile != null) {
            Attributes attr = cManifest.getMainAttributes();
            return attr.getValue(property);
        }
        return (String)cManifestHash.get(property);
    }

    public static String padInt(int k) {
        String s = "00" + k;
        return s.substring(s.length() - 2);
    }

    public static void main(String[] args) {
        ManifestX.reportAndUpdateManifest();
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

