/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.Cell;

public class AddOneDialog
extends JDialog
implements ActionListener,
WindowFocusListener {
    ImageWindow iParent;
    private AceTree iAceTree;
    int iImageTime;
    int iTimeInc;
    int iImagePlane;
    int iPlaneInc;
    int iPrevTime;
    Cell iCurrentCell;
    Nucleus iNucleus;
    protected int iNucSize;
    private Cell iCurrentCellSave;
    private Nucleus iNucleusCopy;
    private Nucleus iNucleusActive;
    private boolean iTimeChanged;
    private int iTimeSave;
    private JButton iAddSeries;
    private JButton iRelink;
    private JButton iKillCells;
    private JButton iKillDeep;
    private JButton iRebuildAndRename;
    private JButton iRebuildOnly;
    private JButton iUp;
    private JButton iDown;
    private JButton iLeft;
    private JButton iRight;
    private JButton iBig;
    private JButton iSmall;
    private JButton iIncZ;
    private JButton iDecZ;
    private JButton iUndo;
    private JButton iTest;
    private JLabel iName;
    private JTextField iForceName;
    private JTextField iX;
    private JTextField iY;
    private JTextField iZ;
    private JTextField iD;
    private JButton iSetN;
    private JButton iForce;
    private JButton iSetX;
    private JButton iSetY;
    private JButton iSetZ;
    private JButton iSetD;
    private JButton iDefault;
    private JTextField iStartTime;
    private JTextField iEndTime;
    private JButton iPropX;
    private JButton iPropY;
    private JButton iPropZ;
    private JButton iPropD;
    public static final String UP = "UP";
    public static final String DOWN = "DOWN";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String TEST = "TEST";
    public static final String UNDO = "UNDO";
    public static final String BIG = "BIG";
    public static final String SMALL = "SMALL";
    public static final String INCZ = "INC Z";
    public static final String DECZ = "DEC Z";
    public static final String KILLDEEP = "Kill Deep Nuclei";
    public static final String KILLGROUP = "Kill Group";
    public static final String ADJUST = "Adjust Cell";
    public static final String ADD = "Add Cell";
    public static final String ADDSERIES = "Add Cell Series";
    public static final String REBUILDANDRENAME = "rebuildAndRename";
    public static final String RELINK = "Relink";
    public static final String KILLCELLS = "Kill Cell";
    public static final String REBUILDONLY = "rebuildOnly";
    public static final String NAME = "Name";
    public static final String FORCENAME = "ForceName";
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String Z = "Z";
    public static final String D = "D";
    public static final String FORCE = "Force";
    public static final String SETN = "Set N";
    public static final String SETX = "Set X";
    public static final String SETY = "Set Y";
    public static final String SETZ = "Set Z";
    public static final String SETD = "Set D";
    public static final String STARTTIME = "Start Time";
    public static final String ENDTIME = "End Time";
    public static final String PROPX = "Propogate X";
    public static final String PROPY = "Propogate Y";
    public static final String PROPZ = "Propogate Z";
    public static final String PROPD = "Propogate D";
    static final double ZINCREMENT = 0.5;
    protected static final String CS = ", ";

    public AddOneDialog(AceTree aceTree, Frame owner, boolean modal, Cell cell, int time) {
        super(owner, modal);
        this.addWindowListener(new WindowEventHandler());
        this.setTitle("Adjust or Delete Cells");
        this.iAceTree = aceTree;
        this.iNucSize = 50;
        AddOneDialog dialog = this;
        JPanel pWhole = new JPanel();
        this.iParent = (ImageWindow)owner;
        pWhole.setOpaque(true);
        pWhole.setLayout(new BoxLayout(pWhole, 3));
        this.fillControlPanel(pWhole);
        this.iTimeSave = -1;
        this.updateCurrentInfo(true);
        this.updateTextFields();
        if (this.iNucleus == null) {
            this.iNucleus = new Nucleus();
        }
        this.iNucleusCopy = this.iNucleus.copy();
        this.iNucleusActive = this.iNucleus;
        this.iTimeSave = this.iImageTime + this.iTimeInc;
        this.iCurrentCellSave = this.iCurrentCell;
        dialog.setContentPane(pWhole);
        dialog.setLocationRelativeTo(owner);
        dialog.setDefaultCloseOperation(0);
        dialog.setVisible(true);
        this.setKeyboardActions();
        this.addWindowFocusListener(this);
        dialog.setSize(new Dimension(300, 475));
    }

    private void setKeyboardActions() {
        AbstractAction home = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddOneDialog.println("setKeyboardActions");
                AddOneDialog.this.iAceTree.requestFocus();
            }
        };
        KeyStroke key = null;
        key = KeyStroke.getKeyStroke("F2");
        key = KeyStroke.getKeyStroke(32, 0, false);
        this.iDefault.getInputMap(2).put(key, "pressed");
        this.iDefault.getActionMap().put("pressed", home);
        this.iDefault.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        String cmd = e.getActionCommand();
        if (o == this.iRelink) {
            this.iAceTree.relinkNucleus();
            this.iParent.refreshDisplay(null);
        } else if (o == this.iKillCells) {
            this.iAceTree.killCells();
            this.iParent.refreshDisplay(null);
        } else if (o == this.iKillDeep) {
            this.iAceTree.killDeepNucs();
        } else if (cmd.equals(REBUILDANDRENAME)) {
            this.updateCurrentInfo(false);
            int time = this.iImageTime + this.iTimeInc;
            Cell c = this.iCurrentCell;
            this.iAceTree.clearTree();
            this.iAceTree.buildTree(true);
            if (c != null) {
                this.iAceTree.setStartingCell(c, time);
            }
        } else {
            this.updateCurrentInfo(false);
            this.setKeypadEnabled(true);
            Nucleus n = ImageWindow.cNucleiMgr.getNucleusFromHashkey(this.iCurrentCell.getHashKey(), this.iImageTime + this.iTimeInc);
            if (n == null) {
                return;
            }
            if (cmd.equals(UP)) {
                --n.y;
            } else if (cmd.equals(DOWN)) {
                ++n.y;
            } else if (cmd.equals(LEFT)) {
                --n.x;
            } else if (cmd.equals(RIGHT)) {
                ++n.x;
            } else if (cmd.equals(BIG)) {
                n.size += 2;
                this.iNucSize = n.size;
            } else if (cmd.equals(SMALL)) {
                n.size -= 2;
                this.iNucSize = n.size;
            } else if (cmd.equals(INCZ)) {
                n.z = (float)((double)n.z + 0.5);
                this.iZ.setText(String.valueOf(n.z));
            } else if (cmd.equals(DECZ)) {
                n.z = (float)((double)n.z - 0.5);
                this.iZ.setText(String.valueOf(n.z));
            } else if (o == this.iX || o == this.iSetX) {
                n.x = Integer.parseInt(this.iX.getText());
            } else if (o == this.iY || o == this.iSetY) {
                n.y = Integer.parseInt(this.iY.getText());
            } else if (o == this.iZ || o == this.iSetZ) {
                n.z = Float.parseFloat(this.iZ.getText());
            } else if (o == this.iD || o == this.iSetD) {
                n.size = Integer.parseInt(this.iD.getText());
            } else if (o == this.iName) {
                String oldName = n.identity;
                n.identity = this.iName.getText();
                this.iCurrentCell.setName(n.identity);
                this.iParent.updateCellAnnotation(this.iCurrentCell, oldName, this.iImageTime + this.iTimeInc);
            } else if (o == this.iForce) {
                n.identity = n.assignedID = this.iForceName.getText();
                this.iName.setText(n.assignedID);
                this.iForceName.setText("");
                int time = this.iImageTime + this.iTimeInc;
                String hashKey = NucUtils.makeHashKey(time, n);
                n.setHashKey(hashKey);
                this.iCurrentCell.setHashKey(hashKey);
                this.iCurrentCell.setName(n.identity);
            } else if (o == this.iPropX) {
                this.checkTimesAndPropogateValue(X);
            } else if (o == this.iPropY) {
                this.checkTimesAndPropogateValue(Y);
            } else if (o == this.iPropZ) {
                this.checkTimesAndPropogateValue(Z);
            } else if (o == this.iPropD) {
                this.checkTimesAndPropogateValue(D);
            }
            this.iParent.refreshDisplay(null);
        }
    }

    private void checkTimesAndPropogateValue(String field) {
        Nucleus n;
        int i;
        int endtime;
        System.out.println("Propogate " + field);
        try {
            int starttime = Integer.parseInt(this.iStartTime.getText());
            endtime = Integer.parseInt(this.iEndTime.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Non Number Entry");
            return;
        }
        boolean validrange = true;
        for (i = starttime; i <= endtime; ++i) {
            n = ImageWindow.cNucleiMgr.getNucleusFromHashkey(this.iCurrentCell.getHashKey(), i);
            if (n != null) continue;
            validrange = false;
        }
        if (validrange) {
            for (i = starttime; i <= endtime; ++i) {
                n = ImageWindow.cNucleiMgr.getNucleusFromHashkey(this.iCurrentCell.getHashKey(), i);
                if (field.equals(X)) {
                    n.x = Integer.parseInt(this.iX.getText());
                    continue;
                }
                if (field.equals(Y)) {
                    n.y = Integer.parseInt(this.iY.getText());
                    continue;
                }
                if (field.equals(Z)) {
                    n.z = Float.parseFloat(this.iZ.getText());
                    continue;
                }
                if (!field.equals(D)) continue;
                n.size = Integer.parseInt(this.iD.getText());
            }
        } else {
            System.out.println("Invalid Time Range for Cell " + this.iNucleus);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        int button = e.getButton();
        if (button == 3) {
            this.updateCurrentInfo(false);
            Nucleus n = ImageWindow.cNucleiMgr.findClosestNucleus(e.getX(), e.getY(), this.iImagePlane + this.iPlaneInc, this.iImageTime + this.iTimeInc);
            if (n == null) {
                System.out.println("cant find closest nucleus");
                return;
            }
            Cell c = (Cell)this.iAceTree.getAncesTree().getCells().get(n.hashKey);
            this.iAceTree.setCurrentCell(c, this.iImageTime + this.iTimeInc, 7);
            this.iNucleus = n;
            this.updateTextFields();
        }
    }

    protected void addCell(int x, int y, boolean continuation) {
        this.updateCurrentInfo(false);
        int time = this.iImageTime + this.iTimeInc;
        Vector nuclei = (Vector)ImageWindow.cNucleiMgr.getNucleiRecord().elementAt(time - 1);
        Nucleus n = new Nucleus();
        n.index = nuclei.size() + 1;
        String hashKey = NucUtils.makeHashKey(time, n);
        n.setHashKey(hashKey);
        n.status = 1;
        n.x = x;
        n.y = y;
        n.z = this.iImagePlane + this.iPlaneInc;
        n.size = this.iNucSize;
        n.identity = "_" + hashKey;
        n.predecessor = -1;
        n.successor1 = -1;
        n.successor2 = -1;
        nuclei.add(n);
        this.iNucleus = n;
        Cell c = new Cell(n.identity, time);
        c.setHashKey(hashKey);
        this.iAceTree.getAncesTree().getCells().put(hashKey, c);
        this.iAceTree.setShowCentroids(true);
        this.iAceTree.setShowAnnotations(true);
        c.setParameters(time, time, n);
        Cell root = this.iAceTree.getAncesTree().getRoot();
        c.setParent(root);
        this.iAceTree.setCurrentCell(c, time, 7);
        this.iParent.addAnnotation(x, y, true);
        this.setKeypadEnabled(true);
        this.iName.setText(n.identity);
        this.iParent.refreshDisplay(null);
    }

    public void updateCellInfo() {
        this.updateCurrentInfo(false);
        this.updateTextFields();
    }

    protected void updateCurrentInfo(boolean detectChange) {
        this.iImageTime = this.iAceTree.getImageTime();
        this.iImagePlane = this.iAceTree.getImagePlane();
        this.iTimeInc = this.iAceTree.getTimeInc();
        this.iPlaneInc = this.iAceTree.getPlaneInc();
        this.iCurrentCell = this.iAceTree.getCurrentCell();
        Vector nuclei = ImageWindow.cNucleiMgr.getNuclei(this.iImageTime + this.iTimeInc - 1);
        this.iNucleus = NucUtils.getCurrentCellNucleus(nuclei, this.iCurrentCell);
    }

    protected void updateTextFields() {
        this.updateCurrentInfo(false);
        if (this.iNucleus == null) {
            this.iName.setText("");
            this.iX.setText("");
            this.iY.setText("");
            this.iZ.setText("");
            this.iD.setText("");
            this.iStartTime.setText("");
        } else {
            this.iName.setText(this.iNucleus.identity);
            this.iX.setText(String.valueOf(this.iNucleus.x));
            this.iY.setText(String.valueOf(this.iNucleus.y));
            this.iZ.setText(String.valueOf(this.iNucleus.z));
            this.iD.setText(String.valueOf(this.iNucleus.size));
            this.iStartTime.setText(String.valueOf(this.iImageTime));
        }
    }

    protected void fillControlPanel(JPanel pp) {
        this.addChoices(pp);
        pp.add(new JSeparator(0));
        JLabel l = new JLabel("Adjust  Cell Position");
        l.setAlignmentX(0.5f);
        pp.add(l);
        this.iName = new JLabel(NAME);
        l = new JLabel("Name:");
        JPanel grouper = new JPanel();
        grouper.add(l);
        grouper.add(this.iName);
        pp.add(grouper);
        this.addKeypad(pp);
        pp.add(new JSeparator(0));
        pp.add(new JLabel(" "));
        this.addTextFields(pp);
    }

    protected void addKeypad(JPanel mp) {
        JPanel p = new JPanel();
        this.iLeft = new JButton(LEFT);
        this.iRight = new JButton(RIGHT);
        this.iUp = new JButton(UP);
        this.iDown = new JButton(DOWN);
        this.iTest = new JButton(TEST);
        this.iBig = new JButton(BIG);
        this.iSmall = new JButton(SMALL);
        this.iIncZ = new JButton(INCZ);
        this.iDecZ = new JButton(DECZ);
        this.iLeft.addActionListener(this);
        this.iRight.addActionListener(this);
        this.iUp.addActionListener(this);
        this.iDown.addActionListener(this);
        this.iTest.addActionListener(this);
        this.iBig.addActionListener(this);
        this.iSmall.addActionListener(this);
        this.iIncZ.addActionListener(this);
        this.iDecZ.addActionListener(this);
        p.setLayout(new GridLayout(3, 3));
        p.setBorder(BorderFactory.createLineBorder(Color.white));
        p.add(this.iBig);
        p.add(this.iUp);
        p.add(this.iSmall);
        p.add(this.iLeft);
        p.add(new JButton());
        p.add(this.iRight);
        p.add(this.iIncZ);
        p.add(this.iDown);
        p.add(this.iDecZ);
        mp.add(p);
        this.iDefault = this.iSmall;
    }

    protected void setKeypadEnabled(boolean b) {
        this.iUp.setEnabled(b);
        this.iDown.setEnabled(b);
        this.iLeft.setEnabled(b);
        this.iRight.setEnabled(b);
        this.iBig.setEnabled(b);
        this.iSmall.setEnabled(b);
        this.iName.setEnabled(b);
        this.iX.setEnabled(b);
        this.iY.setEnabled(b);
        this.iZ.setEnabled(b);
        this.iD.setEnabled(b);
    }

    protected void addChoices(JPanel mp) {
        Object rb = null;
        ButtonGroup bg = new ButtonGroup();
        JPanel rp = new JPanel();
        rp.setLayout(new BoxLayout(rp, 2));
        rp.setBorder(BorderFactory.createLineBorder(Color.white));
        JLabel l = new JLabel("Delete Tools");
        l.setAlignmentX(0.5f);
        mp.add(l);
        JPanel group = new JPanel();
        this.iKillDeep = new JButton(KILLGROUP);
        this.iKillDeep.addActionListener(this);
        bg.add(this.iKillDeep);
        group.add(this.iKillDeep);
        this.iKillCells = new JButton(KILLCELLS);
        this.iKillCells.addActionListener(this);
        group.add(this.iKillCells);
        rp.add(group);
        mp.add(rp);
    }

    protected void addTextFields(JPanel mp) {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, 3));
        this.iX = new JTextField(X, 5);
        this.iY = new JTextField(Y, 5);
        this.iZ = new JTextField(Z, 5);
        this.iD = new JTextField(D, 5);
        this.iX.addActionListener(this);
        this.iY.addActionListener(this);
        this.iZ.addActionListener(this);
        this.iD.addActionListener(this);
        JLabel l = new JLabel(X);
        JPanel grouper = new JPanel();
        grouper.add(l);
        grouper.add(this.iX);
        p.add(grouper);
        this.iSetX = new JButton(SETX);
        this.iSetX.addActionListener(this);
        p.add(this.iSetX);
        this.iPropX = new JButton(PROPX);
        this.iPropX.addActionListener(this);
        p.add(this.iPropX);
        l = new JLabel(Y);
        grouper = new JPanel();
        grouper.add(l);
        grouper.add(this.iY);
        p.add(grouper);
        this.iSetY = new JButton(SETY);
        this.iSetY.addActionListener(this);
        p.add(this.iSetY);
        this.iPropY = new JButton(PROPY);
        this.iPropY.addActionListener(this);
        p.add(this.iPropY);
        l = new JLabel(Z);
        grouper = new JPanel();
        grouper.add(l);
        grouper.add(this.iZ);
        p.add(grouper);
        this.iSetZ = new JButton(SETZ);
        this.iSetZ.addActionListener(this);
        p.add(this.iSetZ);
        this.iPropZ = new JButton(PROPZ);
        this.iPropZ.addActionListener(this);
        p.add(this.iPropZ);
        l = new JLabel(D);
        grouper = new JPanel();
        grouper.add(l);
        grouper.add(this.iD);
        p.add(grouper);
        this.iSetD = new JButton(SETD);
        this.iSetD.addActionListener(this);
        p.add(this.iSetD);
        this.iPropD = new JButton(PROPD);
        this.iPropD.addActionListener(this);
        p.add(this.iPropD);
        mp.add(p);
        this.iStartTime = new JTextField(" ", 4);
        this.iEndTime = new JTextField(" ", 4);
        l = new JLabel("Time Range For Propogation");
        l.setAlignmentX(0.5f);
        mp.add(l);
        grouper = new JPanel();
        grouper.add(new JLabel("Start Time:"));
        grouper.add(this.iStartTime);
        grouper.add(new JLabel("End Time:"));
        grouper.add(this.iEndTime);
        mp.add(grouper);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        int id = e.getID();
        if (id == 201) {
            this.iAceTree.iAddOneDialog = null;
            this.dispose();
        }
    }

    public static void main(String[] args) {
    }

    protected static void println(String s) {
        System.out.println(s);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.iParent.iDialog = this;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ((AddOneDialog)AddOneDialog.this).iAceTree.iAddOneDialog = null;
            AddOneDialog.println("AddOneDialog.windowclosing");
        }
    }
}

