/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class EIDialog1
extends JDialog
implements ActionListener,
WindowFocusListener {
    public ImageWindow iParent;
    public JTextField iName;
    public JTextField iTime;
    public JRadioButton iSetStart;
    public JRadioButton iLink;
    public JRadioButton iNothing;
    public JRadioButton iAddSeries;
    private JButton iUp;
    private JButton iDown;
    private JButton iLeft;
    private JButton iRight;
    private JButton iBig;
    private JButton iSmall;
    private JButton iUndo;
    private JButton iTest;
    private JButton iRebuildAndRename;
    private AceTree iAceTree;
    int iImageTime;
    int iTimeInc;
    int iImagePlane;
    int iPlaneInc;
    int iPrevTime;
    Cell iCurrentCell;
    Nucleus iNucleus;
    Nucleus iLinkNucleus;
    protected static final String UP = "UP";
    protected static final String DOWN = "DOWN";
    protected static final String LEFT = "LEFT";
    protected static final String RIGHT = "RIGHT";
    protected static final String TEST = "TEST";
    protected static final String UNDO = "UNDO";
    protected static final String BIG = "BIG";
    protected static final String SMALL = "SMALL";
    protected static final String ADD = "addCell";
    protected static final String REBUILDANDRENAME = "Apply Changes";
    protected static final String CS = ", ";

    public EIDialog1(AceTree aceTree, Frame owner, boolean modal, Cell cell, int time) {
        super(owner, modal);
        this.setTitle("Add series of nuclei");
        this.iAceTree = aceTree;
        EIDialog1 dialog = this;
        JPanel pWhole = new JPanel();
        this.iParent = (ImageWindow)owner;
        pWhole.setOpaque(true);
        this.addControls(pWhole);
        dialog.setContentPane(pWhole);
        dialog.setSize(new Dimension(310, 400));
        dialog.setLocationRelativeTo(owner);
        dialog.setDefaultCloseOperation(0);
        dialog.setVisible(true);
        this.addWindowFocusListener(this);
    }

    protected void addControls(JPanel pp) {
        pp.setLayout(new BoxLayout(pp, 3));
        pp.add(new JLabel("Starting cell"));
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("Name:"));
        this.iName = new JTextField("", 15);
        jp.add(this.iName);
        jp.setMaximumSize(new Dimension(300, 20));
        pp.add(jp);
        jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("Time: "));
        this.iTime = new JTextField("", 15);
        jp.add(this.iTime);
        jp.setMaximumSize(new Dimension(300, 20));
        pp.add(jp);
        JPanel ppx = new JPanel();
        Border blackline = BorderFactory.createLineBorder(Color.black);
        ppx.setLayout(new GridLayout(0, 1));
        ButtonGroup bg = new ButtonGroup();
        this.iSetStart = new JRadioButton("Set start (with right click)");
        ppx.add(this.iSetStart);
        this.iAddSeries = new JRadioButton("Add series (with left click)");
        ppx.add(this.iAddSeries);
        this.iLink = new JRadioButton("Link to existing cell (with right click)");
        ppx.add(this.iLink);
        this.iNothing = new JRadioButton("Nothing (safe haven for clicks)");
        ppx.add(this.iNothing);
        bg.add(this.iSetStart);
        bg.add(this.iAddSeries);
        bg.add(this.iLink);
        bg.add(this.iNothing);
        this.iSetStart.setSelected(true);
        ppx.setBorder(blackline);
        pp.add(ppx);
        ppx = new JPanel();
        this.addKeypad(ppx);
        pp.add(ppx);
        ppx = new JPanel();
        this.iRebuildAndRename = new JButton(REBUILDANDRENAME);
        this.iRebuildAndRename.addActionListener(this);
        ppx.add(this.iRebuildAndRename);
        pp.add(ppx);
    }

    protected void addKeypad(JPanel mp) {
        JPanel p = new JPanel();
        this.iLeft = new JButton(LEFT);
        this.iRight = new JButton(RIGHT);
        this.iUp = new JButton(UP);
        this.iDown = new JButton(DOWN);
        this.iTest = new JButton(TEST);
        this.iBig = new JButton(BIG);
        this.iSmall = new JButton(SMALL);
        this.iLeft.addActionListener(this);
        this.iRight.addActionListener(this);
        this.iUp.addActionListener(this);
        this.iDown.addActionListener(this);
        this.iTest.addActionListener(this);
        this.iBig.addActionListener(this);
        this.iSmall.addActionListener(this);
        p.setLayout(new GridLayout(3, 3));
        p.setBorder(BorderFactory.createLineBorder(Color.white));
        p.add(this.iBig);
        p.add(this.iUp);
        p.add(this.iSmall);
        p.add(this.iLeft);
        p.add(new JButton());
        p.add(this.iRight);
        p.add(new JButton());
        p.add(this.iDown);
        p.add(new JButton());
        mp.add(p);
    }

    protected void addCell(int x, int y, boolean continuation) {
        EIDialog1.println("EIDialog.addCell, " + x + CS + y + CS + continuation);
        if (continuation) {
            AncesTree ances = this.iAceTree.getAncesTree();
            Hashtable h = ances.getCellsByName();
            Cell c = (Cell)h.get(this.iNucleus.identity);
            Cell parent = (Cell)c.getParent();
            this.updateCurrentInfo(false);
            int time = this.iImageTime + this.iTimeInc;
            Vector nuclei_record = ImageWindow.cNucleiMgr.getNucleiRecord();
            Vector nucleiAdd = null;
            int deltaT = time - this.iPrevTime;
            int startx = this.iNucleus.x;
            int starty = this.iNucleus.y;
            float startz = this.iNucleus.z;
            float z = this.iImagePlane + this.iPlaneInc;
            int prevTime = this.iPrevTime;
            Nucleus n = null;
            int k = prevTime + 1;
            while (k <= time) {
                nucleiAdd = (Vector)nuclei_record.elementAt(k - 1);
                if (k < time || this.iLinkNucleus == null) {
                    n = this.iNucleus.copy();
                    int deltaM = k - prevTime;
                    n.x = (x - startx) * deltaM / deltaT + startx;
                    n.y = (y - starty) * deltaM / deltaT + starty;
                    n.z = (z - startz) * (float)deltaM / (float)deltaT + startz;
                    this.iNucleus.successor1 = n.index = nucleiAdd.size() + 1;
                    n.predecessor = this.iNucleus.index;
                    nucleiAdd.add(n);
                } else {
                    n = this.iLinkNucleus.copy();
                    n.identity = this.iNucleus.identity;
                    n.hashKey = this.iNucleus.hashKey;
                    this.iNucleus.successor1 = n.index;
                    n.predecessor = this.iNucleus.index;
                    nucleiAdd.setElementAt(n, this.iLinkNucleus.index - 1);
                    EIDialog1.println("linknucleuspath: " + n);
                }
                this.iNucleus = n;
                c = new Cell(n.identity, time);
                c.setHashKey(this.iNucleus.hashKey);
                c.setParameters(time, time, n);
                Cell root = this.iAceTree.getAncesTree().getRoot();
                c.setParent(parent);
                this.iAceTree.setCurrentCell(c, this.iImageTime + this.iTimeInc, 7);
                this.iParent.addAnnotation(x, y, true);
                this.iName.setText(this.iNucleus.identity);
                this.iTime.setText(String.valueOf(k));
                this.iPrevTime = k++;
            }
        }
    }

    protected void updateCurrentInfo(boolean detectChange) {
        this.iImageTime = this.iAceTree.getImageTime();
        this.iImagePlane = this.iAceTree.getImagePlane();
        this.iTimeInc = this.iAceTree.getTimeInc();
        this.iPlaneInc = this.iAceTree.getPlaneInc();
        this.iCurrentCell = this.iAceTree.getCurrentCell();
        if (!detectChange) {
            return;
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        int button = e.getButton();
        EIDialog1.println("processMouseEvent, " + button);
        if (button == 3) {
            this.updateCurrentInfo(false);
            Nucleus n = ImageWindow.cNucleiMgr.findClosestNucleus(e.getX(), e.getY(), this.iImagePlane + this.iPlaneInc, this.iImageTime + this.iTimeInc);
            if (n == null) {
                System.out.println("cant find closest nucleus");
                return;
            }
            Cell c = (Cell)this.iAceTree.getAncesTree().getCells().get(n.hashKey);
            this.iAceTree.setCurrentCell(c, this.iImageTime + this.iTimeInc, 7);
            if (this.iAddSeries.isSelected()) {
                EIDialog1.println("right click ignored with Add series selected");
            } else if (this.iSetStart.isSelected()) {
                this.iName.setText(n.identity);
                this.iPrevTime = this.iImageTime + this.iTimeInc;
                this.iTime.setText(String.valueOf(this.iPrevTime));
                this.iNucleus = n;
                this.iAddSeries.setSelected(true);
            } else if (this.iLink.isSelected()) {
                if (this.iNucleus.successor2 != -1) {
                    EIDialog1.println("Link error re: " + this.iNucleus.identity);
                    return;
                }
                this.iLinkNucleus = n;
                this.addCell(e.getX(), e.getY(), true);
                EIDialog1.println("recommending a rebuild:");
            }
            this.iParent.refreshDisplay(null);
        } else if (button == 1) {
            if (this.iSetStart.isSelected()) {
                this.iLinkNucleus = null;
                this.addCell(e.getX(), e.getY(), false);
            }
            if (this.iAddSeries.isSelected()) {
                this.iLinkNucleus = null;
                this.addCell(e.getX(), e.getY(), true);
            }
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        int id = e.getID();
        if (id == 201) {
            this.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.iRebuildAndRename) {
            this.updateCurrentInfo(false);
            int time = this.iImageTime + this.iTimeInc;
            Cell c = this.iCurrentCell;
            this.iAceTree.clearTree();
            this.iAceTree.buildTree(true);
            if (c != null) {
                this.iAceTree.setStartingCell(c, time);
            }
        }
        Nucleus n = ImageWindow.cNucleiMgr.getNucleusFromHashkey(this.iCurrentCell.getHashKey(), this.iImageTime + this.iTimeInc);
        if (o == this.iUp) {
            --n.y;
            this.iParent.refreshDisplay(null);
        } else if (o == this.iDown) {
            ++n.y;
            this.iParent.refreshDisplay(null);
        } else if (o == this.iLeft) {
            --n.x;
            this.iParent.refreshDisplay(null);
        } else if (o == this.iRight) {
            ++n.x;
            this.iParent.refreshDisplay(null);
        } else if (o == this.iBig) {
            n.size += 2;
            this.iParent.refreshDisplay(null);
        } else if (o == this.iSmall) {
            n.size -= 2;
            this.iParent.refreshDisplay(null);
        }
    }

    public static void main(String[] args) {
    }

    protected static void println(String s) {
        System.out.println(s);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        EIDialog1.println("EIDialog.windowGainedFocus, ");
        this.iParent.iDialog = this;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        EIDialog1.println("EIDialog.windowLostFocus, ");
    }
}

