/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.TreeNode;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class EditTraverse
implements ActionListener,
ListSelectionListener {
    private JFrame iFrame;
    private String iTitle;
    private JPanel iPanel;
    private JToolBar iToolBar;
    private JTextField iRootCell;
    private JList iCellList;
    private DefaultListModel iListModel;
    private JScrollPane iScrollPane;
    private JButton iTraverse;
    private JButton iSaveAs;
    private AceTree iAceTree;
    private NucleiMgr iNucleiMgr;
    private AncesTree iAncesTree;
    private Cell iRoot;
    private Hashtable iCellsByName;
    private Vector nuclei_record;
    private boolean iIgnoreEvents;
    private String iCurrentCellName;
    private boolean iLocalTest = false;

    public EditTraverse(Cell root) {
        if (!this.iLocalTest) {
            this.initialize();
        }
        if (root != null) {
            this.iRoot = root;
        }
        this.iTitle = "EditTraverse";
        this.iFrame = new JFrame(this.iTitle);
        this.buildToolBar();
        this.iIgnoreEvents = true;
        this.buildList();
        this.iPanel = new JPanel();
        this.iPanel.setLayout(new BoxLayout(this.iPanel, 1));
        this.iPanel.add(this.iToolBar);
        this.iPanel.add(this.iScrollPane);
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this.iPanel);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
        WinEventMgr wem = new WinEventMgr();
        this.iFrame.addWindowListener(wem);
        this.iFrame.addWindowFocusListener(wem);
        this.setKeyboardActions();
        this.iIgnoreEvents = true;
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setSelectedIndex(1);
        this.iCellList.requestFocus();
        this.traverseAction();
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
    }

    private void breadthFirstEnumeration() {
        String cellName;
        this.initialize();
        this.iCurrentCellName = cellName = this.iRootCell.getText();
        Cell root = null;
        root = !cellName.equals("ROOT") ? (Cell)this.iCellsByName.get(cellName) : this.iAncesTree.getRoot();
        this.iIgnoreEvents = true;
        this.iListModel.clear();
        this.putHeaders();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            Cell c = (Cell)e.nextElement();
            String name = c.getName();
            char[] ca = new char[60];
            Arrays.fill(ca, ' ');
            StringBuffer sb = new StringBuffer(new String(ca));
            sb.replace(0, name.length() - 1, name);
            String fate = c.getFate();
            sb.replace(15, 15 + fate.length() - 1, fate);
            String lifetime = String.valueOf(c.getLifeTime());
            sb.replace(25, 25 + lifetime.length() - 1, lifetime);
            int count = this.iAncesTree.getCellCount(c.getEndTime());
            String scount = String.valueOf(count);
            sb.replace(35, 35 + scount.length() - 1, scount);
            String sEndTime = String.valueOf(c.getEndTime());
            sb.replace(42, 42 + sEndTime.length() - 1, sEndTime);
            String lineage = this.lineage(name);
            sb.replace(50, 50 + lineage.length() - 1, lineage);
            this.iListModel.addElement(sb.toString());
        }
        this.iIgnoreEvents = false;
    }

    private String lineage(String name) {
        if (name.indexOf("ABa") == 0) {
            return "ABa";
        }
        if (name.indexOf("ABp") == 0) {
            return "ABp";
        }
        if (name.indexOf("E") == 0) {
            return "E";
        }
        if (name.indexOf("MS") == 0) {
            return "MS";
        }
        if (name.indexOf("C") == 0) {
            return "C";
        }
        if (name.indexOf("D") == 0) {
            return "D";
        }
        return "P";
    }

    private void putHeaders() {
        char[] ca = new char[60];
        Arrays.fill(ca, ' ');
        StringBuffer sb = new StringBuffer(new String(ca));
        String name = "cellName";
        sb.replace(0, name.length() - 1, name);
        String fate = "fate";
        sb.replace(15, 15 + fate.length() - 1, fate);
        String lifetime = "duration";
        sb.replace(25, 25 + lifetime.length() - 1, lifetime);
        String scount = "cells";
        sb.replace(35, 35 + scount.length() - 1, scount);
        String sEndTime = "endTime";
        sb.replace(42, 42 + sEndTime.length() - 1, sEndTime);
        String sLineage = "lineage";
        sb.replace(50, 50 + sLineage.length() - 1, sLineage);
        this.iListModel.addElement(sb.toString());
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.breadthFirstEnumeration();
        this.iCellList.setSelectionMode(0);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setVisibleRowCount(5);
        this.iScrollPane = new JScrollPane(this.iCellList);
    }

    private void buildToolBar() {
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 10));
        this.iToolBar.setMaximumSize(new Dimension(500, 20));
        this.iToolBar.add(new JLabel("cell:"));
        this.iRootCell = new JTextField();
        this.iRootCell.setColumns(15);
        if (this.iRoot != null) {
            this.iRootCell.setText(this.iRoot.getName());
        } else {
            this.iRootCell.setText("ABa");
        }
        this.iToolBar.add(this.iRootCell);
        this.iTraverse = new JButton("Traverse");
        this.iTraverse.addActionListener(this);
        this.iToolBar.add(this.iTraverse);
        this.iSaveAs = new JButton("SaveAs");
        this.iSaveAs.addActionListener(this);
        this.iToolBar.add(this.iSaveAs);
    }

    public static void main(String[] args) {
        EditTraverse et = new EditTraverse(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Traverse")) {
            this.traverseAction();
        } else if (s.equals("SaveAs")) {
            this.saveAs();
        }
    }

    private void traverseAction() {
        this.breadthFirstEnumeration();
        this.iCellList.setSelectedIndex(1);
        this.iCellList.ensureIndexIsVisible(0);
        this.iCellList.requestFocus();
    }

    private String extractNameFromListEntry(int k) {
        String name = (String)this.iListModel.elementAt(k);
        name = name.split("\\s+")[0];
        return name;
    }

    private String getTrulySelectedCellName() {
        int index = this.iCellList.getSelectedIndex();
        int k = Math.max(index, 1);
        String name = (String)this.iListModel.elementAt(index);
        if ((name = name.split("\\s+")[0]).equals("ROOT")) {
            this.iIgnoreEvents = true;
            this.iCellList.setSelectedIndex(++index);
            this.iIgnoreEvents = false;
            name = (String)this.iListModel.elementAt(index);
            name = name.split("\\s+")[0];
        }
        this.iCurrentCellName = index > 0 ? (String)this.iListModel.elementAt(index - 1) : name;
        this.iCurrentCellName = this.iCurrentCellName.split("\\s+")[0];
        return name;
    }

    private void bringUpImageWindow(String name) {
        Cell c = (Cell)this.iCellsByName.get(name);
        int time = c.getEndTime() - 1;
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(time));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.nextImage();
        this.iAceTree.setFocusHome();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.iIgnoreEvents) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            String s = this.getTrulySelectedCellName();
            this.bringUpImageWindow(s);
        }
    }

    private int getIndexOfName(String name) {
        return this.iCellList.getNextMatch(name, 0, Position.Bias.Forward);
    }

    public void buildNotification() {
        String saveName = this.iCurrentCellName;
        this.breadthFirstEnumeration();
        int j = this.getIndexOfName(saveName);
        this.iCellList.setSelectedIndex(j);
        this.iCellList.ensureIndexIsVisible(j);
    }

    private void setKeyboardActions() {
        Object s = null;
        String sl = "LEFT";
        AbstractAction left = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditTraverse.this.iLocalTest) {
                    EditTraverse.this.iAceTree.prevImage();
                }
            }
        };
        InputMap im = this.iCellList.getInputMap(0);
        KeyStroke ks = KeyStroke.getKeyStroke(37, 0);
        im.put(ks, sl);
        this.iCellList.getActionMap().put(sl, left);
        String sr = "RIGHT";
        AbstractAction right = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditTraverse.this.iLocalTest) {
                    EditTraverse.this.iAceTree.nextImage();
                }
            }
        };
        im = this.iCellList.getInputMap(0);
        ks = KeyStroke.getKeyStroke(39, 0);
        im.put(ks, sr);
        this.iCellList.getActionMap().put(sr, right);
        String sd = "DOWN";
        AbstractAction down = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTraverse.this.iAceTree.imageDown();
            }
        };
        im = this.iCellList.getInputMap(0);
        ks = KeyStroke.getKeyStroke(40, 2);
        im.put(ks, sd);
        this.iCellList.getActionMap().put(sd, down);
        String su = "UP";
        AbstractAction up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditTraverse.this.iAceTree.imageUp();
            }
        };
        im = this.iCellList.getInputMap(0);
        ks = KeyStroke.getKeyStroke(38, 2);
        im.put(ks, su);
        this.iCellList.getActionMap().put(su, up);
    }

    private void saveAs() {
        JFileChooser iFC = new JFileChooser();
        int returnVal = iFC.showSaveDialog(this.iFrame);
        if (returnVal == 0) {
            String dir = iFC.getCurrentDirectory().toString();
            String name = iFC.getName(iFC.getSelectedFile());
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(iFC.getSelectedFile()));
                Enumeration e = this.iListModel.elements();
                while (e.hasMoreElements()) {
                    String s = (String)e.nextElement();
                    String[] sa = s.split("\\s+");
                    StringBuffer sb = new StringBuffer(sa[0]);
                    String CS = ",";
                    for (int i = 1; i < sa.length; ++i) {
                        sb.append(CS);
                        sb.append(sa[i]);
                    }
                    ps.println(sb.toString());
                }
                ps.flush();
                ps.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private class WinEventMgr
    extends WindowAdapter {
        private WinEventMgr() {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            EditTraverse.this.iFrame.dispose();
            if (!EditTraverse.this.iLocalTest) {
                EditTraverse.this.iAceTree.setEditTraverseNull();
            }
        }
    }
}

