/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.image.ImageWindow;
import org.rhwlab.nucedit.NucRelinkDialog;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class Lazarus
extends JDialog
implements ActionListener,
ListSelectionListener,
Comparator {
    AceTree iAceTree;
    AncesTree iAncesTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Cell iRoot;
    Hashtable iCellsByName;
    private JFrame iFrame;
    protected JToolBar iToolBar;
    private String iTitle = "Lazarus";
    private JTextField iTextField;
    private Font iFont;
    private DefaultListModel iListModel;
    private JList iCellList;
    private boolean iNamesAvailable;
    private JScrollPane iScrollPane;
    private int iTime;
    Hashtable iLazers;
    int iDelT;
    int iDelD;
    int iDelJ;
    int iDelJD;
    String[] shelp = new String[]{"# maxTime field accepts forms like 200:ABalaa", "# if the colon and cell are there then output will be filtered to that", "# and its decendents", "# Deaths: makes a queryable list of cell deaths", "# Adjacent backward: makes two queryable lists showing nearby cells at this ane previous time.", "#A djacent forward: makes a queryable list of cells near current cell at next time"};
    private static final String CLEAR = "Clear";
    private static final String LINE = "                                        ";
    private static final String ANGLE = "Angle";
    private static final String TEST1 = "Deaths";
    private static final String TEST2 = "Adj back";
    private static final String TEST3 = "Adj forward";
    private static final String TEST4 = "Jumps";
    private static final String TEST5 = "Test5";
    private static final String HELP = "Help";
    private static final String CS = ", ";
    private static final DecimalFormat DF2 = new DecimalFormat("###.##");

    public Lazarus() {
        this.setTitle(this.iTitle);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        p.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList();
        this.iCellList.setVisibleRowCount(10);
        p.add(this.iScrollPane);
        this.initialize();
        this.setVisible(true);
        this.pack();
        this.help();
        this.iDelT = 4;
        this.iDelD = 30;
        this.iDelJ = 30;
        this.iDelJD = 20;
    }

    private void makeInitialList() {
        Lazarus.println("makeInitialList, " + this.iDelT + CS + this.iDelD + CS + this.iDelJ + CS + this.iDelJD);
        this.iLazers = new Hashtable();
        this.iNamesAvailable = false;
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        String filter = "";
        if (sa.length > 1) {
            filter = sa[1];
        }
        t2 = maxTime;
        ImageWindow imgWin = this.iAceTree.getImageWindow();
        this.iListModel.clear();
        this.iListModel.addElement("#list shows cells that died and the time");
        for (int i = t1; i < t2; ++i) {
            Vector nuclei = (Vector)this.nuclei_record.get(i - 1);
            for (int j = 0; j < nuclei.size(); ++j) {
                Nucleus n = (Nucleus)nuclei.get(j);
                if (n.status < 1 || n.successor1 >= 0 || n.successor2 >= 0) continue;
                Laz laz = new Laz(n, i);
                this.iLazers.put(n.identity, laz);
            }
        }
        this.iNamesAvailable = true;
        this.iListModel.clear();
        this.iListModel.addElement("####");
        Enumeration cells = this.iLazers.keys();
        while (cells.hasMoreElements()) {
            String name = (String)cells.nextElement();
            Laz laz = (Laz)this.iLazers.get(name);
            int tend = laz.iDTime + this.iDelT;
            Vector nuclei = null;
            for (int j = laz.iDTime + 1; j < tend; ++j) {
                nuclei = (Vector)this.nuclei_record.get(j - 1);
                boolean matchFound = false;
                for (int m = 0; m < nuclei.size(); ++m) {
                    int d;
                    Nucleus n = (Nucleus)nuclei.get(m);
                    if (n.status < 0 || (d = laz.distance(n)) >= this.iDelD) continue;
                    Laz lazx = this.getJump(j - 2, n);
                    if (!lazx.iMatch) continue;
                    laz.setMatch(n, j);
                    matchFound = true;
                    break;
                }
                if (matchFound) break;
            }
            Lazarus.println("" + laz);
            if (!laz.iMatch) continue;
            this.iListModel.addElement(laz.toString());
        }
    }

    private Laz getJump(int k, Nucleus n) {
        Laz laz = new Laz(n, k);
        Vector nuclei = (Vector)this.nuclei_record.get(k);
        int index = n.predecessor;
        if (index < 0) {
            laz.iMatch = true;
            return laz;
        }
        Nucleus np = (Nucleus)nuclei.get(index - 1);
        int dist = laz.distance(np);
        if (np.successor2 > 0) {
            if (dist > this.iDelJD) {
                laz.iMatch = true;
            }
        } else if (dist > this.iDelJ) {
            laz.iMatch = true;
        }
        return laz;
    }

    private void linkEm() {
        NucRelinkDialog.iNucleiMgr = this.iNucleiMgr;
        Enumeration cells = this.iLazers.keys();
        while (cells.hasMoreElements()) {
            String name = (String)cells.nextElement();
            Laz laz = (Laz)this.iLazers.get(name);
            if (!laz.iMatch) continue;
            NucRelinkDialog.createAndAddCells(laz.iLifer.identity, laz.iLTime, laz.iDyer.identity, laz.iDTime);
        }
    }

    private void rebuildAndRename() {
        this.iAceTree.clearTree();
        this.iAceTree.buildTree(true);
        this.makeInitialList();
    }

    private void setParms() {
        Parms myDialog = new Parms(this.iFrame, true);
    }

    private void remove() {
        int[] remove = this.iCellList.getSelectedIndices();
        for (int i = remove.length - 1; i >= 0; --i) {
            String s = (String)this.iListModel.elementAt(remove[i]);
            String[] sa = s.split(CS);
            this.iLazers.remove(sa[0]);
            Lazarus.println("remove, " + s);
            this.iListModel.remove(remove[i]);
        }
    }

    private void buildList() {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(2);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iScrollPane = new JScrollPane(this.iCellList);
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("maxTime:"));
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("200");
        this.iToolBar.add(this.iTextField);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton(TEST1);
        this.addToolBarButton(jb);
        jb = new JButton("linkEm");
        this.addToolBarButton(jb);
        jb = new JButton("rebuild");
        this.addToolBarButton(jb);
        jb = new JButton("setParms");
        this.addToolBarButton(jb);
        jb = new JButton("remove");
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    public void initialize() {
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAncesTree.getRoot();
    }

    private void help() {
        this.iListModel.addElement("####");
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals(TEST1)) {
            this.makeInitialList();
        } else if (s.equals(CLEAR)) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
            this.help();
        } else if (s.equals("linkEm")) {
            this.linkEm();
        } else if (s.equals("rebuild")) {
            this.rebuildAndRename();
        } else if (s.equals("setParms")) {
            this.setParms();
        } else if (s.equals("remove")) {
            this.remove();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 0);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            name = sa[0];
            this.iTime = Integer.parseInt(sa[1]);
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    public int compare(Object arg0, Object arg1) {
        return 0;
    }

    private class Parms
    extends JDialog
    implements ActionListener {
        private JPanel iPanel;
        private JButton iOKButton;
        private JButton iCancelButton;
        private JTextField iTime;
        private JTextField iDistance;
        private JTextField iJump;
        private JTextField iJumpD;

        public Parms(JFrame frame, boolean modal) {
            super((Frame)frame, modal);
            this.iPanel = null;
            this.iOKButton = null;
            this.iCancelButton = null;
            this.iPanel = new JPanel();
            this.getContentPane().add(this.iPanel);
            this.iPanel.setLayout(new GridLayout(0, 1));
            this.iTime = new JTextField(String.valueOf(Lazarus.this.iDelT));
            this.iDistance = new JTextField(String.valueOf(Lazarus.this.iDelD));
            this.iJump = new JTextField(String.valueOf(Lazarus.this.iDelJ));
            this.iJumpD = new JTextField(String.valueOf(Lazarus.this.iDelJD));
            this.iPanel.add(new JLabel("time"));
            this.iPanel.add(this.iTime);
            this.iPanel.add(new JLabel("distance"));
            this.iPanel.add(this.iDistance);
            this.iPanel.add(new JLabel("jump"));
            this.iPanel.add(this.iJump);
            this.iPanel.add(new JLabel("division"));
            this.iPanel.add(this.iJumpD);
            this.iOKButton = new JButton("OK");
            this.iOKButton.addActionListener(this);
            this.iPanel.add(this.iOKButton);
            this.iCancelButton = new JButton("Cancel");
            this.iCancelButton.addActionListener(this);
            this.iPanel.add(this.iCancelButton);
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.iOKButton == e.getSource()) {
                Lazarus.this.iDelT = Integer.parseInt(this.iTime.getText());
                Lazarus.this.iDelD = Integer.parseInt(this.iDistance.getText());
                Lazarus.this.iDelJ = Integer.parseInt(this.iJump.getText());
                Lazarus.this.iDelJD = Integer.parseInt(this.iJumpD.getText());
            }
            this.setVisible(false);
        }
    }

    private class Laz {
        boolean iMatch;
        Nucleus iDyer;
        int iDTime;
        Nucleus iLifer;
        int iLTime;
        int iDist;

        public Laz(Nucleus n, int time) {
            this.iDyer = n;
            this.iDTime = time;
        }

        public void setMatch(Nucleus n, int time) {
            this.iMatch = true;
            this.iLifer = n;
            this.iLTime = time;
        }

        public void linkIt() {
        }

        public int distance(Nucleus n) {
            double x = this.iDyer.x - n.x;
            double d = x * x;
            x = this.iDyer.y - n.y;
            d += x * x;
            x = 11.1 * (double)(this.iDyer.z - n.z);
            this.iDist = (int)Math.sqrt(d += x * x);
            return this.iDist;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.iDyer.identity);
            sb.append(Lazarus.CS + this.iDTime);
            sb.append(Lazarus.CS + this.iMatch);
            if (this.iMatch) {
                sb.append(Lazarus.CS + this.iLifer.identity);
                sb.append(Lazarus.CS + this.iLTime);
            }
            return sb.toString();
        }
    }
}

