/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.util.Vector;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.NucleiTableModel;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;

public class NucEditModel {
    NucleiMgr iNucleiMgr;
    NucleiTableModel[] iNucleiTableModel;

    public NucEditModel(AceTree nucEdit) {
        this.iNucleiMgr = nucEdit.getNucleiMgr();
        this.iNucleiTableModel = new NucleiTableModel[2];
        this.iNucleiTableModel[0] = new NucleiTableModel();
        this.iNucleiTableModel[1] = new NucleiTableModel();
    }

    public void commitAllChanges(int time) {
        this.commitChanges(0, time, true);
        this.commitChanges(1, time + 1, false);
    }

    private void commitChanges(int tableModel, int i, boolean doSuccessors) {
        Nucleus n;
        if (doSuccessors && this.setSuccessors(i)) {
            return;
        }
        NucleiTableModel nucleiTableModel = this.iNucleiTableModel[tableModel];
        Vector nuclei = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(i);
        int m = nuclei.size();
        for (int j = 0; j < m; ++j) {
            n = (Nucleus)nuclei.elementAt(j);
            this.updateNucleus(nucleiTableModel, n, j, i);
        }
        int k = nucleiTableModel.getRowCount();
        for (int j = m; j < k; ++j) {
            n = new Nucleus();
            System.out.println("new    : " + n);
            this.updateNucleus(nucleiTableModel, n, j, i);
            System.out.println("updated: " + n);
            nuclei.add(n);
        }
        nucleiTableModel.updateNucleiTableModel(this.iNucleiMgr, i);
    }

    private void updateNucleus(NucleiTableModel ntm, Nucleus n, int nucTableModelItem, int timeIndex) {
        int j = nucTableModelItem;
        String s = ntm.getValueAt(j, 0).toString();
        if (s.indexOf("ADD") == 0) {
            this.updateAddedNucleus(ntm, n, j, timeIndex);
            return;
        }
        n.identity = s;
        s = ntm.getValueAt(j, 1).toString();
        n.index = Integer.parseInt(s);
        s = ntm.getValueAt(j, 6).toString();
        n.x = Integer.parseInt(s);
        s = ntm.getValueAt(j, 7).toString();
        n.y = Integer.parseInt(s);
        s = ntm.getValueAt(j, 8).toString();
        n.z = Float.parseFloat(s);
        s = ntm.getValueAt(j, 9).toString();
        n.size = Integer.parseInt(s);
        s = ntm.getValueAt(j, 10).toString();
        n.weight = Integer.parseInt(s);
        s = ntm.getValueAt(j, 2).toString();
        n.status = Integer.parseInt(s);
        s = ntm.getValueAt(j, 3).toString();
        n.predecessor = Integer.parseInt(s);
        s = ntm.getValueAt(j, 4).toString();
        n.successor1 = Integer.parseInt(s);
        s = ntm.getValueAt(j, 5).toString();
        n.successor2 = Integer.parseInt(s);
    }

    private void updateAddedNucleus(NucleiTableModel ntm, Nucleus n, int nucTableModelItem, int timeIndex) {
        int j = nucTableModelItem;
        System.out.println("nucTableModelItem: " + j);
        String s = ntm.getValueAt(j, 1).toString();
        System.out.println("updateAddedNucleus1: " + s);
        n.index = Integer.parseInt(s);
        n.identity = s = ntm.getValueAt(j, 0).toString();
        System.out.println("updateAddedNucleus2: " + s);
        s = ntm.getValueAt(j, 3).toString();
        System.out.println("updateAddedNucleus pred: " + s);
        n.predecessor = Integer.parseInt(s);
        s = ntm.getValueAt(j, 4).toString();
        System.out.println("updateAddedNucleus succ1: " + s);
        n.successor1 = Integer.parseInt(s);
        s = ntm.getValueAt(j, 5).toString();
        System.out.println("updateAddedNucleus succ2: " + s);
        n.successor2 = Integer.parseInt(s);
        Nucleus m = null;
        int link = n.predecessor;
        int time = timeIndex - 1;
        if (link < 0) {
            link = n.successor1;
            time = timeIndex + 1;
        }
        if (link < 1) {
            return;
        }
        m = (Nucleus)((Vector)this.iNucleiMgr.getNucleiRecord().elementAt(time)).elementAt(link - 1);
        n.x = m.x;
        n.y = m.y;
        n.z = m.z;
        n.size = m.size;
        n.weight = m.weight;
        n.status = m.status;
    }

    private boolean setSuccessors(int i) {
        boolean rtn = false;
        NucleiTableModel ntm0 = this.iNucleiTableModel[0];
        String nil = String.valueOf(-1);
        for (int j = 0; j < ntm0.getRowCount(); ++j) {
            ntm0.setValueAt(nil, j, 4);
            ntm0.setValueAt(nil, j, 5);
        }
        NucleiTableModel ntm1 = this.iNucleiTableModel[1];
        for (int j = 0; j < ntm1.getRowCount(); ++j) {
            Object stat = ntm1.getValueAt(j, 2);
            int nstat = Integer.parseInt(stat.toString());
            if (nstat < 0) continue;
            Object m = ntm1.getValueAt(j, 1);
            Object ns = ntm1.getValueAt(j, 3);
            int n = Integer.parseInt(ns.toString()) - 1;
            if (n < 0) continue;
            Object s1 = ntm0.getValueAt(n, 4);
            Object s2 = ntm0.getValueAt(n, 5);
            if (s1.toString().equals(nil)) {
                ntm0.setValueAt(m, n, 4);
                continue;
            }
            if (s2.toString().equals(nil)) {
                ntm0.setValueAt(m, n, 5);
                continue;
            }
            System.out.println("ERROR CONDITION row " + j + ", i=" + i);
            System.out.println(s1 + "\n" + s2);
            rtn = true;
        }
        return rtn;
    }

    public NucleiTableModel getNucleiTableModel(int k) {
        return this.iNucleiTableModel[k];
    }

    public void updateNucleiTableModel(int j) {
        this.iNucleiTableModel[0].updateNucleiTableModel(this.iNucleiMgr, j);
        this.iNucleiTableModel[1].updateNucleiTableModel(this.iNucleiMgr, j + 1);
    }

    public NucleiMgr getNucleiMgr() {
        return this.iNucleiMgr;
    }

    public static void main(String[] args) {
    }
}

