/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.nucedit.EditLog;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class NucRelinkDialog
extends JDialog
implements ActionListener {
    protected AceTree iAceTree;
    protected static NucleiMgr iNucleiMgr;
    protected JLabel iRelinkTime;
    protected JLabel iRelinkNuc;
    protected JLabel iLinkTime;
    protected JLabel iLinkNuc;
    private JButton iApplyAndRebuild;
    private JButton iApplyOnly;
    private JButton iRelinkButton;
    private JButton iLinkButton;
    private JButton iLinkRootButton;
    protected EditLog iEditLog;
    protected boolean iStartArmed = false;
    public static final int WIDTH = 230;
    public static final int HEIGHT = 400;
    public static final String TITLE = "Edit Track";
    public static final String RELINKTIME = "Timepoint ";
    public static final String RELINKNUC = "Cell Name  ";
    public static final String LINKTIME = "Timepoint";
    public static final String LINKNUC = "Cell Name";
    public static final String DOIT = "Apply";
    public static final String CS = ", ";
    public static final String NL = "\n";
    public static final String APPLYANDREBUILD = "Apply";
    public static final String APPLYONLY = "old apply only";
    public static final String SETCURRENTCELL = "set current cell";
    public static final String SETEARLYCELL = "Use Active Cell";
    public static final String SETLATECELL = "Use Active Cell ";
    public static final String SETROOTCELL = "Use ROOT Cell";
    public static final String LATER = "Link Cell at Later Time";
    public static final String EARLIER = "to Cell at Earlier Time";
    public static final String FIVE = "     ";
    public static final String TWELVE = "            ";
    public static final String LATEHEADER = "Choose Cell as Late Timepoint";
    public static final String EARLYHEADER = "Choose Cell as Early Timepoint";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    protected NucRelinkDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public NucRelinkDialog(AceTree aceTree, Frame owner, boolean modal, Cell cell, int time) {
        super(owner, modal);
        this.iAceTree = aceTree;
        iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.iEditLog = this.iAceTree.getEditLog();
        this.setTitle(TITLE);
        NucRelinkDialog dialog = this;
        this.addWindowListener(new WindowEventHandler());
        JPanel pWhole = new JPanel();
        this.createEarlyPanel(pWhole);
        this.createLatePanel(pWhole, owner);
    }

    protected void createLatePanel(JPanel pWhole, Frame owner) {
        Border blackline = BorderFactory.createLineBorder(Color.black);
        Border bothBorder = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        JPanel pEnd = new JPanel();
        pEnd.setLayout(new BoxLayout(pEnd, 3));
        pEnd.setAlignmentX(0.5f);
        this.iRelinkButton = new JButton(SETLATECELL);
        this.iRelinkButton.setAlignmentX(0.5f);
        this.iRelinkButton.addActionListener(this);
        JLabel label = new JLabel(LATEHEADER, 0);
        label.setAlignmentX(0.5f);
        pEnd.add(label);
        pEnd.add(this.iRelinkButton);
        pEnd.add(Box.createVerticalGlue());
        JPanel bothl = new JPanel();
        bothl.setLayout(new BoxLayout(bothl, 2));
        bothl.setAlignmentX(0.5f);
        JPanel s = new JPanel();
        s.setLayout(new BoxLayout(s, 3));
        label = new JLabel(RELINKTIME);
        s.add(label);
        label = new JLabel(RELINKNUC);
        s.add(label);
        bothl.add(s);
        s = new JPanel();
        s.setLayout(new BoxLayout(s, 3));
        this.iRelinkTime = new JLabel(FIVE);
        s.add(this.iRelinkTime);
        this.iRelinkNuc = new JLabel(TWELVE);
        s.add(this.iRelinkNuc);
        bothl.add(s);
        pEnd.add(bothl);
        pEnd.add(Box.createVerticalGlue());
        pWhole.add(Box.createVerticalGlue());
        pWhole.add(pEnd);
        this.iApplyAndRebuild = new JButton("Apply");
        this.iApplyAndRebuild.setAlignmentX(0.5f);
        this.iApplyAndRebuild.addActionListener(this);
        pWhole.add(new JSeparator(0));
        pWhole.add(Box.createVerticalGlue());
        pWhole.add(this.iApplyAndRebuild);
        pWhole.setOpaque(true);
        this.setContentPane(pWhole);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
        this.setSize(new Dimension(230, 400));
    }

    protected void createEarlyPanel(JPanel pWhole) {
        pWhole.setLayout(new BoxLayout(pWhole, 3));
        Border blackline = BorderFactory.createLineBorder(Color.black);
        Border bothBorder = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        JPanel pStr = new JPanel();
        pStr.setLayout(new BoxLayout(pStr, 3));
        pStr.setAlignmentX(0.5f);
        this.iLinkButton = new JButton(SETEARLYCELL);
        this.iLinkButton.setAlignmentX(0.5f);
        this.iLinkButton.addActionListener(this);
        this.iLinkRootButton = new JButton(SETROOTCELL);
        this.iLinkRootButton.addActionListener(this);
        this.iLinkRootButton.setAlignmentX(0.5f);
        JLabel header = new JLabel(EARLYHEADER);
        header.setAlignmentX(0.5f);
        pStr.add(header);
        pStr.add(this.iLinkButton);
        pStr.add(new JLabel("or"));
        pStr.add(this.iLinkRootButton);
        pStr.add(new JLabel(""));
        pStr.add(Box.createVerticalGlue());
        JPanel bothl = new JPanel();
        bothl.setLayout(new BoxLayout(bothl, 2));
        bothl.setAlignmentX(0.5f);
        JPanel s = new JPanel();
        s.setLayout(new BoxLayout(s, 3));
        s.setBorder(bothBorder);
        JLabel label = new JLabel(LINKTIME);
        this.iLinkTime = new JLabel(FIVE);
        JLabel label2 = new JLabel(LINKNUC);
        this.iLinkNuc = new JLabel(TWELVE);
        s.add(label);
        s.add(label2);
        bothl.add(s);
        s = new JPanel();
        s.setLayout(new BoxLayout(s, 3));
        s.add(this.iLinkTime);
        s.add(this.iLinkNuc);
        bothl.add(s);
        pStr.add(bothl);
        pStr.add(Box.createVerticalGlue());
        pStr.add(new JLabel(""));
        pWhole.add(pStr);
        pWhole.add(Box.createVerticalGlue());
    }

    private void setFocusableFalse() {
        this.iLinkTime.setFocusable(false);
        this.iLinkNuc.setFocusable(false);
        this.iLinkButton.setFocusable(false);
        this.iLinkRootButton.setFocusable(false);
        this.iRelinkTime.setFocusable(false);
        this.iRelinkNuc.setFocusable(false);
        this.iRelinkButton.setFocusable(false);
        this.iApplyAndRebuild.setFocusable(false);
        this.iApplyOnly.setFocusable(false);
    }

    void setDefaultButtonBehavior(JButton jb, String key) {
        String s = key;
        AbstractAction home = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NucRelinkDialog.println("focus to AceTree");
                NucRelinkDialog.this.iAceTree.requestFocus();
            }
        };
        jb.getInputMap(2).put(KeyStroke.getKeyStroke(35, 0, false), "pressed");
        jb.getActionMap().put("pressed", home);
    }

    void setKeyBehavior(JButton[] jba, String key) {
        String s = key;
        AbstractAction home = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component compFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (compFocusOwner instanceof JButton) {
                    NucRelinkDialog.println("its a button");
                    ((JButton)compFocusOwner).doClick();
                }
            }
        };
        for (int i = 0; i < jba.length; ++i) {
            jba[i].getInputMap(2).put(KeyStroke.getKeyStroke(s), s);
            jba[i].getActionMap().put(s, home);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals(SETEARLYCELL)) {
            int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
            this.iLinkTime.setText(String.valueOf(time));
            this.iLinkNuc.setText(this.iAceTree.getCurrentCell().getName());
            this.iStartArmed = true;
        } else if (o == this.iLinkRootButton) {
            this.iLinkTime.setText(String.valueOf(this.iAceTree.getNucleiMgr().getStartingIndex()));
            this.iLinkNuc.setText("ROOT");
        } else if (cmd.equals(SETLATECELL)) {
            int time = this.iAceTree.getImageTime() + this.iAceTree.getTimeInc();
            this.iRelinkTime.setText(String.valueOf(time));
            this.iRelinkNuc.setText(this.iAceTree.getCurrentCell().getName());
        } else if (cmd.equals("Apply") || cmd.equals(APPLYONLY)) {
            this.relinkAndRebuild();
        }
        this.iAceTree.requestFocus();
    }

    protected void relinkAndRebuild() {
        String strCellName;
        int strTime;
        int endTime;
        try {
            endTime = Integer.parseInt(this.iRelinkTime.getText());
        }
        catch (NumberFormatException nfe) {
            this.showMessage("invalid relink time, aborting");
            return;
        }
        try {
            strTime = Integer.parseInt(this.iLinkTime.getText());
        }
        catch (NumberFormatException nfe) {
            this.showMessage("invalid link time, aborting");
            return;
        }
        if (strTime > 1 && endTime <= strTime) {
            this.showMessage("endTime is not greater than start time, aborting");
            return;
        }
        String endCellName = this.iRelinkNuc.getText();
        boolean b = this.checkCellValidities(endCellName, endTime, strCellName = this.iLinkNuc.getText(), strTime);
        if (!b) {
            return;
        }
        StringBuffer sb = new StringBuffer("RELINKING: ");
        sb.append(endTime);
        sb.append(CS + endCellName);
        sb.append(iNucleiMgr.getIndex(endCellName, endTime));
        sb.append(CS + strTime);
        sb.append(CS + strCellName);
        sb.append(iNucleiMgr.getIndex(strCellName, strTime));
        this.iEditLog.append(sb.toString());
        iNucleiMgr.makeBackupNucleiRecord();
        NucRelinkDialog.createAndAddCells(endCellName, endTime, strCellName, strTime);
        this.iAceTree.clearTree();
        this.iAceTree.buildTree(true);
        AncesTree ances = this.iAceTree.getAncesTree();
        Hashtable h = ances.getCellsByName();
        Cell c = (Cell)h.get(strCellName);
        if (c != null) {
            this.iAceTree.setStartingCell(c, strTime);
            System.out.println("Setting starting in relink " + c);
        }
        this.iEditLog.setModified(true);
        this.iRelinkNuc.setText(FIVE);
        this.iRelinkTime.setText(TWELVE);
        this.iLinkNuc.setText(strCellName);
        char x = endCellName.charAt(0);
        if (x != '_' && x != 'N') {
            this.iLinkNuc.setText(endCellName);
        }
        this.iLinkTime.setText(String.valueOf(endTime));
    }

    private boolean checkCellValidities(String endCellName, int endTime, String strCellName, int strTime) {
        if (strCellName.equals("ROOT")) {
            return true;
        }
        Nucleus nEnd = iNucleiMgr.getCurrentCellData(endCellName, endTime);
        Nucleus nStr = iNucleiMgr.getCurrentCellData(strCellName, strTime);
        if (nEnd == null || nStr == null) {
            String s = "";
            String s0 = "";
            String s1 = "";
            if (nEnd == null) {
                s0 = "invalid cell: " + endCellName + CS + endTime + NL;
            }
            if (nStr == null) {
                s1 = "invalid cell: " + strCellName + CS + strTime + NL;
            }
            this.showMessage(s0 + s1);
            return false;
        }
        if (nStr.successor2 > 0) {
            String s = "Cell " + strCellName + " already has 2 successors\n";
            s = s + "cannot complete relink.";
            this.showMessage(s);
            return false;
        }
        return true;
    }

    private void showMessage(String s) {
        JOptionPane pane = new JOptionPane(s);
        JDialog dialog = pane.createDialog(this.iAceTree, "About AceTree");
        dialog.setModal(true);
        dialog.show();
    }

    public static void createAndAddCells(String endCellName, int endTime, String strCellName, int strTime) {
        NucRelinkDialog.println("createAndAddCells, " + endCellName + CS + endTime + CS + strCellName + CS + strTime);
        Nucleus nEnd = NucRelinkDialog.getNucleus(endCellName, endTime);
        if (strCellName.equals("ROOT")) {
            nEnd.predecessor = -1;
            return;
        }
        Nucleus nStr = NucRelinkDialog.getNucleus(strCellName, strTime);
        Vector nuclei_record = iNucleiMgr.getNucleiRecord();
        Vector nucleiAdd = null;
        Nucleus n = nStr;
        int predecessor = nStr.index;
        for (int k = strTime + 1; k < endTime; ++k) {
            nucleiAdd = (Vector)nuclei_record.elementAt(k - 1);
            n = NucRelinkDialog.interpolateNucleus(nEnd, nStr, endTime, strTime, k);
            n.index = nucleiAdd.size() + 1;
            n.predecessor = predecessor;
            predecessor = n.index;
            nucleiAdd.add(n);
        }
        nEnd.predecessor = n.index;
    }

    private static Nucleus getNucleus(String name, int time) {
        System.out.println("getNucleus, seeming: " + name + CS + time);
        Nucleus nRtn = null;
        Nucleus n = null;
        Vector nuclei_record = iNucleiMgr.getNucleiRecord();
        Vector nuclei = (Vector)nuclei_record.elementAt(time - 1);
        for (int j = 0; j < nuclei.size(); ++j) {
            n = (Nucleus)nuclei.elementAt(j);
            if (n.status <= 0 || !n.identity.equals(name)) continue;
            nRtn = n;
            break;
        }
        return nRtn;
    }

    private static Nucleus interpolateNucleus(Nucleus nEnd, Nucleus nStr, int endTime, int strTime, int midTime) {
        Nucleus n = nStr.copy();
        int deltaT = endTime - strTime;
        int deltaM = midTime - strTime;
        n.x = (nEnd.x - nStr.x) * deltaM / deltaT + nStr.x;
        n.y = (nEnd.y - nStr.y) * deltaM / deltaT + nStr.y;
        n.z = (nEnd.z - nStr.z) * (float)deltaM / (float)deltaT + nStr.z;
        n.size = (nEnd.size - nStr.size) * deltaM / deltaT + nStr.size;
        return n;
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }

    static {
        DF0 = new DecimalFormat("####");
        DF1 = new DecimalFormat("####.#");
        DF4 = new DecimalFormat("####.####");
    }

    protected class WindowEventHandler
    extends WindowAdapter {
        protected WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NucRelinkDialog.this.iAceTree.iNucRelinkDialog = null;
            NucRelinkDialog.println("NucRelinkDialog.windowclosing");
        }
    }

    public class MyKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent ke) {
            char i = ke.getKeyChar();
            String str = Character.toString(i);
            NucRelinkDialog.println("MyKeyListener, " + str);
        }
    }
}

