/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.nucedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.AceTreeNoUI;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.dbaccess.EmbryoXML;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.DivisionCaller;
import org.rhwlab.snight.Identity3;
import org.rhwlab.snight.MeasureCSV;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.tree.AncesTree;
import org.rhwlab.tree.Cell;

public class Orientation
extends JDialog
implements ActionListener,
ListSelectionListener,
Comparator {
    String iTitle;
    JToolBar iToolBar;
    JFrame iFrame;
    JTextField iTextField;
    JTextField iTextField2;
    JTextField iTextField3;
    DefaultListModel iListModel;
    JList iCellList;
    JScrollPane iScrollPane;
    AceTree iAceTree;
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    AncesTree iAncesTree;
    Hashtable iCellsByName;
    Cell iRoot;
    int iLastTime;
    Vector iSortedCellNames;
    boolean iNamesAvailable;
    int iTest;
    int iTime;
    DivisionCaller iDivisionCaller;
    double iCutoff;
    String iSeries;
    private static final String CLEAR = "CLEAR";
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String SP = " ";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0 = new DecimalFormat("####");
    private static final DecimalFormat DF1 = new DecimalFormat("####.#");
    private static final DecimalFormat DF4 = new DecimalFormat("####.####");

    public Orientation(AceTreeNoUI acenui) {
        this.iNucleiMgr = acenui.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = acenui.getRoot();
        this.makeSortedCellNames();
        this.iLastTime = this.estimate350CellStage();
        Identity3 identity = this.iNucleiMgr.getIdentity();
        String axis = identity.getAxis();
        double zpixres = this.iNucleiMgr.getZPixRes();
        MeasureCSV measureCSV = this.iNucleiMgr.getMeasureCSV();
        this.iDivisionCaller = new DivisionCaller(axis, zpixres, measureCSV);
        this.iCutoff = 1.0;
    }

    public Orientation() {
        this.iTitle = "Orientation";
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.setContentPane(p);
        this.iToolBar = new JToolBar("");
        this.iToolBar.setLayout(new GridLayout(1, 0));
        p.add(this.iToolBar);
        this.buildOutToolBar();
        this.buildList(p);
        this.initialize();
        int k = 40;
        try {
            EmbryoXML exml = new EmbryoXML(this.iSeries);
            String editedTP = exml.iRecord[11];
            k = Integer.parseInt(editedTP);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.iTextField.setText(String.valueOf(k));
        this.setVisible(true);
        this.pack();
    }

    public DivisionCaller getDivisionCaller() {
        return this.iDivisionCaller;
    }

    void prepareAndFillList() {
        this.fillList();
    }

    void fillList() {
        int i;
        this.initialize();
        this.iNamesAvailable = false;
        this.iTest = 1;
        NucUtils.setZPixRes(this.iNucleiMgr.getZPixRes());
        int t1 = this.iNucleiMgr.getConfig().iStartingIndex;
        int t2 = this.iNucleiMgr.getConfig().iEndingIndex;
        String[] sa = this.iTextField.getText().split(":");
        int maxTime = Integer.parseInt(sa[0]);
        t1 = Integer.parseInt(this.iTextField2.getText());
        t2 = Integer.parseInt(this.iTextField.getText());
        this.iCutoff = Double.parseDouble(this.iTextField3.getText());
        this.iListModel.clear();
        this.iListModel.addElement(this.help());
        Vector v = new Vector();
        for (i = t1; i <= t2; ++i) {
            this.showDivisions(i, v);
        }
        Collections.sort(v, this);
        for (i = 0; i < v.size(); ++i) {
            this.iListModel.addElement((String)v.get(i));
        }
        if (!this.isShowing()) {
            this.showMe();
        }
        this.iNamesAvailable = true;
        this.iNamesAvailable = true;
    }

    public void showDivisions(int now, Vector v) {
        this.iNamesAvailable = false;
        this.iTest = 1;
        Vector nucleiNow = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now - 1);
        Nucleus nnow = null;
        for (int j = 0; j < nucleiNow.size(); ++j) {
            nnow = (Nucleus)nucleiNow.elementAt(j);
            if (nnow.status <= 0 || nnow.successor1 <= 0 || nnow.successor2 <= 0) continue;
            Vector nucleiNext = (Vector)this.iNucleiMgr.getNucleiRecord().elementAt(now);
            Nucleus a = (Nucleus)nucleiNext.elementAt(nnow.successor1 - 1);
            Nucleus p = (Nucleus)nucleiNext.elementAt(nnow.successor2 - 1);
            double score1 = this.evaluateDivision1(nnow, a, p, now);
            double score2 = Math.abs(score1);
            if (score1 == 999.0 && score1 == 999.0 || score2 > this.iCutoff) continue;
            v.add(this.division(nnow.identity, a.identity, p.identity, now, score1));
        }
    }

    public int compare(Object arg0, Object arg1) {
        String s0 = (String)arg0;
        String s1 = (String)arg1;
        String[] sa0 = s0.split(CS);
        String[] sa1 = s1.split(CS);
        double d0 = Double.parseDouble(sa0[4]);
        double d1 = Double.parseDouble(sa1[4]);
        int r = 0;
        r = Math.abs(d0) < Math.abs(d1) ? -1 : 1;
        return r;
    }

    public String division(String par, String dau, String dau2, int now, double score1) {
        StringBuffer sb = new StringBuffer(par);
        sb.append(CS + now);
        sb.append(CS + dau);
        sb.append(CS + dau2);
        sb.append(CS + DF4.format(score1));
        String r = this.iDivisionCaller.getRuleString(par);
        if (r.length() > 0) {
            sb.append(",            (" + r + ")");
        }
        return sb.toString();
    }

    double evaluateDivision1(Nucleus parent, Nucleus dau1, Nucleus dau2, int now) {
        return this.iDivisionCaller.getDotProduct(parent, dau1, dau2);
    }

    public void initialize() {
        String series;
        this.iAceTree = AceTree.getAceTree(null);
        this.iNucleiMgr = this.iAceTree.getNucleiMgr();
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iAncesTree = this.iNucleiMgr.getAncesTree();
        this.iCellsByName = this.iAncesTree.getCellsByName();
        this.iRoot = this.iAceTree.getRoot();
        this.makeSortedCellNames();
        this.iLastTime = this.estimate350CellStage();
        Identity3 identity = this.iNucleiMgr.getIdentity();
        String axis = identity.getAxis();
        double zpixres = this.iNucleiMgr.getZPixRes();
        MeasureCSV measureCSV = this.iNucleiMgr.getMeasureCSV();
        this.iDivisionCaller = new DivisionCaller(axis, zpixres, measureCSV);
        Config config = this.iNucleiMgr.getConfig();
        String shortName = config.getShortName();
        this.iSeries = series = shortName.substring(0, shortName.indexOf("."));
        Orientation.println("initialize, " + series + CS + shortName);
    }

    private void buildList(JPanel jp) {
        this.iListModel = new DefaultListModel();
        this.iCellList = new JList(this.iListModel);
        this.iCellList.setFont(new Font("courier", 0, 16));
        this.iCellList.setSelectionMode(2);
        this.iCellList.setSelectedIndex(0);
        this.iCellList.addListSelectionListener(this);
        this.iCellList.setVisibleRowCount(10);
        this.iScrollPane = new JScrollPane(this.iCellList);
        jp.add(this.iScrollPane);
        this.iListModel.addElement(this.help());
    }

    private void buildOutToolBar() {
        this.iToolBar.setMaximumSize(new Dimension(700, 20));
        this.iToolBar.add(new JLabel("start/end/cutoff"));
        this.iTextField2 = new JTextField();
        this.iTextField2.setColumns(5);
        this.iTextField2.setText("1");
        this.iToolBar.add(this.iTextField2);
        this.iTextField = new JTextField();
        this.iTextField.setColumns(5);
        this.iTextField.setText("40");
        this.iToolBar.add(this.iTextField);
        this.iTextField3 = new JTextField();
        this.iTextField3.setColumns(5);
        this.iTextField3.setText("0.5");
        this.iToolBar.add(this.iTextField3);
        JButton jb = null;
        jb = new JButton(CLEAR);
        this.addToolBarButton(jb);
        jb = new JButton("Divisions");
        this.addToolBarButton(jb);
    }

    protected void addToolBarButton(AbstractButton ab) {
        ab.addActionListener(this);
        this.iToolBar.add(ab);
    }

    public void showMe() {
        this.iFrame.setDefaultCloseOperation(2);
        this.iFrame.setContentPane(this);
        this.iFrame.pack();
        this.iFrame.setVisible(true);
    }

    private void makeSortedCellNames() {
        this.iSortedCellNames = new Vector();
        Enumeration e = this.iCellsByName.keys();
        boolean i = false;
        while (e.hasMoreElements()) {
            this.iSortedCellNames.add((String)e.nextElement());
        }
        Collections.sort(this.iSortedCellNames);
    }

    private int estimate350CellStage() {
        int stage = 355;
        boolean r = false;
        int size = 0;
        int time = 0;
        for (int i = 0; i < this.nuclei_record.size(); ++i) {
            Vector nuclei = (Vector)this.nuclei_record.get(i);
            int t = nuclei.size();
            if (t > size) {
                size = t;
                time = i;
            }
            int count = 0;
            if (size > stage) {
                count = 0;
                for (int j = 0; j < nuclei.size(); ++j) {
                    Nucleus n = (Nucleus)nuclei.get(j);
                    if (n.status <= 0 || n.identity.startsWith("N")) continue;
                    ++count;
                }
            }
            if (count > stage) break;
        }
        return time + 1;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.iNamesAvailable) {
            return;
        }
        if (!e.getValueIsAdjusting()) {
            int index = this.iCellList.getSelectedIndex();
            int k = Math.max(index, 1);
            String s = (String)this.iListModel.elementAt(k);
            if (s == null) {
                return;
            }
            if (s.charAt(0) == '#') {
                return;
            }
            String[] sa = s.split(CS);
            String name = "";
            name = sa[0];
            this.iTime = Integer.parseInt(sa[1]);
            this.bringUpImageWindow(name);
        }
    }

    private void bringUpImageWindow(String name) {
        Vector<String> v = new Vector<String>();
        v.add("InputCtrl1");
        v.add(String.valueOf(this.iTime));
        v.add(name);
        this.iAceTree.forceTrackingOn();
        this.iAceTree.controlCallback(v);
        this.iAceTree.setFocusHome();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Divisions")) {
            this.prepareAndFillList();
        } else if (!s.equals("Movements") && s.equals(CLEAR)) {
            this.iNamesAvailable = false;
            this.iListModel.clear();
            this.iListModel.addElement(this.help());
        }
    }

    private String help() {
        return "### DIVISIONS: dividing cell, time, dau1, dau2, dotProduct";
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }
}

