/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import org.rhwlab.snight.XMLConfig;

public class Config {
    public String iConfigFileName;
    public String iParent;
    public Hashtable iConfigHash;
    public String iZipFileName;
    public String iZipNucDir;
    public String iTypicalImage;
    public String iZipTifFilePath;
    public String iTifPrefix;
    public int iStartingIndex;
    public int iEndingIndex = 9999;
    public int iNamingMethod = 3;
    public int iUseZip;
    public int iUseStack;
    public String iAxisGiven = "";
    public float iXy_res = 0.09f;
    public float iZ_res = 1.0f;
    public int iPolar_size = 45;
    public int iPlaneStart;
    public int iPlaneEnd = 50;
    public double iZPixRes;
    public String iExprCorr = "none";
    public static final String SP = " ";
    public static final String EMBRYO = "<embryo>";
    public static final String ENDEMBRYO = "</embryo>";
    public static final String TYPICALIMAGENAME = "<image file=\"";
    public static final String NUCLEI = "<nuclei file=\"";
    public static final String NAMING = "<naming method=\"";
    public static final String STARTING = "<start index=\"";
    public static final String ENDING = "<end index=\"";
    public static final String AXIS = "<axis axis=\"";
    public static final String END = "\"/>";
    public static final String BEGIN = "<?xml version='1.0' encoding='utf-8'?>";
    public static final String POLAR = "<polar size=\"";
    public static final String RESOLUTION = "<resolution xyRes=\"";
    public static final String ZRESXML = "\" zRes=\"";
    public static final String PLANEENDXML = "\" planeEnd=\"";
    public static final String EXPR_CORR = "<exprCorr type=\"";
    public static final String USE_ZIP = "<useZip type=\"";
    public static final String USE_STACK = "<useStack type=\"";
    public static final String HELPMSG = "you must provide file: ";
    public static final String SEP = ", ";
    public static final String ROOTNAME = "P";
    public static final String[] configParams = new String[]{"zipFileName", "tif directory", "tifPrefix", "nuclei directory", "root name", "starting index", "ending index", "use zip", "namingMethod", "axis", "typical image", "polarSize", "xyRes", "zRes", "planeEnd", "exprCorr", "use stack", "angle", "center", "x", "y"};
    private static final int ZIPFILENAME = 0;
    private static final int TIFDIRECTORY = 1;
    private static final int TIFPREFIX = 2;
    private static final int NUCLEIDIRECTORY = 3;
    private static final int ROOTNAMEI = 4;
    private static final int STARTINGINDEX = 5;
    private static final int ENDINGINDEX = 6;
    private static final int USEZIP = 7;
    private static final int NAMINGMETHOD = 8;
    private static final int AXISGIVEN = 9;
    private static final int TYPICALIMAGE = 10;
    private static final int POLARSIZE = 11;
    private static final int XYRES = 12;
    private static final int ZRES = 13;
    private static final int PLANEEND = 14;
    private static final int EXPRCORR = 15;
    private static final int USESTACK = 16;
    public static final float XYRESNOMINAL = 0.09f;
    public static final float ZRESNOMINAL = 1.0f;
    public static final float MARGIN = 0.001f;
    public static final int POLARSIZENOMINAL = 45;
    public static final int PLANESTARTNOMINAL = 1;
    public static final int PLANEENDNOMINAL = 50;
    public static final String NONE = "none";
    public static final String GLOBAL = "global";
    public static final String LOCAL = "local";
    public static final String BLOT = "blot";
    public static final String CROSS = "cross";
    public static final int STANDARD = 2;
    public static final int MANUAL = 2;
    public static final int NEWCANONICAL = 3;
    public static int cDefaultNaming = 3;
    public static final String[] REDCHOICE = new String[]{"none", "global", "local", "blot", "cross"};
    private static final String CS = ", ";
    private static final String NL = "\n";

    public String toString() {
        StringBuffer sb = new StringBuffer("Config");
        sb.append("\niConfigFileName, " + this.iConfigFileName);
        sb.append("\niParent, " + this.iParent);
        sb.append("\niZipFileName, " + this.iZipFileName);
        sb.append("\niZipNucDir, " + this.iZipNucDir);
        sb.append("\niTypicalImage, " + this.iTypicalImage);
        sb.append("\niZipTifFilePath, " + this.iZipTifFilePath);
        sb.append("\niTifPrefix, " + this.iTifPrefix);
        sb.append("\niStartingIndex, " + this.iStartingIndex);
        sb.append("\niEndingIndex, " + this.iEndingIndex);
        sb.append("\niPlaneStart, " + this.iPlaneStart);
        sb.append("\niPlaneEnd, " + this.iPlaneEnd);
        sb.append("\niNamingMethod, " + this.iNamingMethod);
        sb.append("\niUseZip, " + this.iUseZip);
        sb.append("\niUseStack, " + this.iUseStack);
        sb.append("\niAxisGiven, " + this.iAxisGiven);
        return sb.toString();
    }

    public Config() {
    }

    public Config(String configFile) {
        this();
        this.iConfigFileName = configFile;
        int k = this.iConfigFileName.lastIndexOf(".");
        String s = this.iConfigFileName.substring(k + 1);
        this.iConfigFileName = configFile;
        this.iTypicalImage = "";
        this.iEndingIndex = 9999;
        this.iXy_res = 0.09f;
        this.iZ_res = 1.0f;
        this.iPolar_size = 45;
        this.iPlaneStart = 1;
        this.iPlaneEnd = 50;
        this.iZipNucDir = "nuclei/";
        this.iAxisGiven = "";
        this.iExprCorr = BLOT;
        if (!s.equals("xml")) {
            this.getStartingParms();
            this.setStartingParms();
        } else {
            new XMLConfig(configFile, this);
        }
    }

    public Config(String configFile, boolean xml) {
        this(configFile);
    }

    public static Config createConfigFromXMLFile(String configFileName) {
        return XMLConfig.createConfigFromXMLFile(configFileName);
    }

    public void setEndingIndex(int endingIndex) {
        this.iEndingIndex = endingIndex;
    }

    public boolean getStartingParms() {
        this.iConfigHash = new Hashtable();
        for (int i = 0; i < configParams.length; ++i) {
            this.iConfigHash.put(configParams[i], "");
        }
        File f = new File(this.iConfigFileName);
        String path = f.getPath();
        String name = f.getName();
        this.iParent = f.getParent();
        System.out.println("getStartingparams file is " + this.iConfigFileName + " parent " + this.iParent);
        if (this.iParent == null) {
            this.iParent = "./";
        }
        boolean isabsolute = f.isAbsolute();
        String s = null;
        String s1 = null;
        String s2 = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while (br.ready()) {
                s = br.readLine();
                if ((s = s.trim()).length() == 0 || s.charAt(0) == '#') continue;
                s1 = s.substring(0, s.indexOf(", "));
                s2 = s.substring(s.indexOf(", ") + 2);
                if (!this.iConfigHash.containsKey(s1)) continue;
                this.iConfigHash.put(s1, s2);
            }
        }
        catch (IOException ioe) {
            System.out.println(HELPMSG + this.iConfigFileName);
            return false;
        }
        Enumeration e = this.iConfigHash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.iConfigHash.get(key);
        }
        return true;
    }

    public void setStartingParms() {
        this.iZipFileName = (String)this.iConfigHash.get(configParams[0]);
        File f = new File(this.iZipFileName);
        if (!f.isAbsolute() & this.iParent != null) {
            this.iZipFileName = this.iParent + System.getProperty("file.separator") + this.iZipFileName;
            System.out.println("if case");
        } else if (!f.isAbsolute()) {
            System.out.println("else   case");
            File fxml = new File(this.iConfigFileName);
            String xmllocation = fxml.getParent();
            xmllocation = xmllocation + System.getProperty("file.separator");
            this.iZipFileName = xmllocation + this.iZipFileName;
        }
        System.out.println("trying to open zip file at " + this.iZipFileName);
        String s = (String)this.iConfigHash.get(configParams[10]);
        if (s.length() > 0 & new File(s).isFile()) {
            this.decodeTypicalImage(s);
            this.iTypicalImage = s;
        } else {
            s = "";
        }
        this.setOptionalParms();
        if (this.iTifPrefix == null) {
            this.setOldStyleParms();
        }
    }

    private void decodeTypicalImage(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char x = s.charAt(i);
            if (x != '\\') {
                sb.append(x);
                continue;
            }
            sb.append('/');
        }
        s = sb.toString();
        File f = new File(s);
        boolean b = f.exists();
        String name = f.getName();
        String parent = f.getParent();
        s = parent;
        if (s != null) {
            sb = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                char x = s.charAt(i);
                if (x != '\\') {
                    sb.append(x);
                    continue;
                }
                sb.append('/');
            }
            parent = s = sb.toString();
        }
        int k1 = name.lastIndexOf(46);
        int k2 = -1;
        s = (String)this.iConfigHash.get(configParams[16]);
        this.iUseStack = s.length() > 0 ? Integer.parseInt(s) : 0;
        if (name.lastIndexOf(45) > name.lastIndexOf(95)) {
            k2 = this.iUseStack == 0 ? k1 - 8 : k1 - 4;
        } else if (this.iUseStack != 0) {
            k2 = name.lastIndexOf(95) + 1;
        }
        int k3 = parent.lastIndexOf("/");
        String forepath = parent.substring(k3 + 1);
        Config.println("setStartingParms: forepath: " + forepath);
        String forename = name.substring(0, k2);
        Config.println("setStartingParms: forename: " + forename);
        String prefix = forepath + "/" + forename;
        String tifDir = parent.substring(0, k3);
        Config.println("setStartingParms: " + k1 + ", " + k2 + ", " + k3);
        Config.println("setStartingParms: tif directory=" + tifDir);
        Config.println("setStartingParms: prefix=" + prefix);
        String ext = name.substring(k1 + 1);
        int useZip = 0;
        if (ext.equals("zip")) {
            useZip = 2;
        }
        this.iUseZip = useZip;
        this.iTifPrefix = prefix;
        this.iZipTifFilePath = tifDir;
    }

    private void setOptionalParms() {
        this.iStartingIndex = 1;
        this.iEndingIndex = 1;
        String s = (String)this.iConfigHash.get(configParams[6]);
        if (s.length() > 0) {
            this.iEndingIndex = Integer.parseInt(s);
        }
        if ((s = (String)this.iConfigHash.get(configParams[5])).length() > 0) {
            this.iStartingIndex = Integer.parseInt(s);
        }
        this.iAxisGiven = (String)this.iConfigHash.get(configParams[9]);
        s = (String)this.iConfigHash.get(configParams[7]);
        if (s.length() > 0) {
            this.iUseZip = Integer.parseInt(s);
        }
        this.iUseStack = (s = (String)this.iConfigHash.get(configParams[16])).length() > 0 ? Integer.parseInt(s) : 0;
        this.iNamingMethod = cDefaultNaming;
        s = (String)this.iConfigHash.get(configParams[8]);
        if (s.length() > 0) {
            if (s.equals("STANDARD")) {
                this.iNamingMethod = 1;
            } else if (s.equals("MANUAL")) {
                this.iNamingMethod = 2;
            } else if (s.equals("NEWCANONICAL")) {
                this.iNamingMethod = 3;
            }
        }
        if ((s = (String)this.iConfigHash.get(configParams[11])).length() > 0) {
            this.iPolar_size = Integer.parseInt(s);
        }
        if ((s = (String)this.iConfigHash.get(configParams[12])).length() > 0) {
            this.iXy_res = Float.parseFloat(s);
        }
        if ((s = (String)this.iConfigHash.get(configParams[13])).length() > 0) {
            this.iZ_res = Float.parseFloat(s);
        }
        if ((s = (String)this.iConfigHash.get(configParams[14])).length() > 0) {
            this.iPlaneEnd = Integer.parseInt(s);
        }
        if ((s = (String)this.iConfigHash.get(configParams[15])).length() > 0) {
            this.iExprCorr = s;
        }
    }

    private void setOldStyleParms() {
        this.iZipTifFilePath = (String)this.iConfigHash.get(configParams[1]);
        File f = new File(this.iZipTifFilePath);
        if (!f.isAbsolute()) {
            this.iZipTifFilePath = this.iParent + "/" + this.iZipTifFilePath;
        }
        this.iTifPrefix = (String)this.iConfigHash.get(configParams[2]);
        if (this.iTypicalImage.length() == 0) {
            String s = this.iZipTifFilePath + "/" + this.iTifPrefix + "t001-p01.";
            if (this.iUseZip <= 1) {
                s = s + "tif";
            } else if (this.iUseZip == 2) {
                s = s + "zip";
            }
            this.iTypicalImage = s;
        }
    }

    public void saveConfigXMLFile() {
        JFileChooser fileChooser = new JFileChooser();
        String s = this.iConfigFileName;
        String ss = new File(s).getParent();
        fileChooser.setCurrentDirectory(new File(ss));
        fileChooser.setSelectedFile(new File(""));
        int returnVal = fileChooser.showSaveDialog(null);
        if (returnVal != 0) {
            System.out.println("Save command cancelled by user.");
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.writeXMLConfig(file);
    }

    public void writeXMLConfig(File file) {
        try {
            boolean needPlaneEnd;
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(BEGIN);
            pw.println("");
            pw.println(EMBRYO);
            pw.println(TYPICALIMAGENAME + this.iTypicalImage + END);
            pw.println(NUCLEI + this.iZipFileName + END);
            if (this.iNamingMethod != 3) {
                String namex = "";
                if (this.iNamingMethod == 2) {
                    namex = "MANUAL";
                } else if (this.iNamingMethod == 1) {
                    namex = "STANDARD";
                }
                pw.println(NAMING + namex + END);
            }
            if (this.iEndingIndex != 9999) {
                pw.println(ENDING + this.iEndingIndex + END);
            }
            if (this.iAxisGiven.length() > 0 && this.iNamingMethod == 3) {
                pw.println(AXIS + this.iAxisGiven + END);
            }
            if (Math.abs(this.iPolar_size - 45) > 0) {
                pw.println(POLAR + this.iPolar_size + END);
            }
            boolean needXyres = Math.abs(this.iXy_res - 0.09f) > 0.001f;
            boolean needZres = Math.abs(this.iZ_res - 1.0f) > 0.001f;
            boolean bl = needPlaneEnd = this.iPlaneEnd - 50 != 0;
            if (needXyres || needZres || needPlaneEnd) {
                pw.println(RESOLUTION + this.iXy_res + ZRESXML + this.iZ_res + PLANEENDXML + this.iPlaneEnd + END);
            }
            if (!this.iExprCorr.equals(NONE)) {
                pw.println(EXPR_CORR + this.iExprCorr + END);
            }
            pw.println(ENDEMBRYO);
            pw.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    private void showStartingParms() {
        System.out.println("showStartingParms start");
        System.out.println("iZipFileName: " + this.iZipFileName);
        System.out.println("iZipTifFilePath: " + this.iZipTifFilePath);
        System.out.println("iTifPrefix: " + this.iTifPrefix);
        System.out.println("iStartingIndex: " + this.iStartingIndex);
        System.out.println("iEndingIndex: " + this.iEndingIndex);
        System.out.println("iNamingMethod: " + this.iNamingMethod);
        System.out.println("iUseZip: " + this.iUseZip);
        System.out.println("iUseStack: " + this.iUseStack);
        System.out.println("showStartingParms end");
    }

    public String getShortName() {
        String s = this.iConfigFileName;
        return Config.getShortName(s);
    }

    public static String getShortName(String longName) {
        int k = longName.lastIndexOf("/");
        return longName.substring(k + 1);
    }

    public int getRedChoiceNumber() {
        int i = 0;
        for (i = 0; i < REDCHOICE.length && !this.iExprCorr.equals(REDCHOICE[i]); ++i) {
        }
        return i;
    }

    public static void main(String[] args) {
        String s = "/nfs/waterston/murray/20090425_ceh-34_4_L1/dats/20090425_ceh-34_4_L1.dat";
        s = "/nfs/waterston1/annots/zhao/20090317PHA-4_AF16_L1/dats/20090317PHA-4_AF16_L1.xml";
        s = "C:/biowolp/0tmp/acewintest/20090826/AceTreeDemo/081505/dats/081505.xml";
        Config c = new Config(s);
        Config.println("main, " + c);
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

