/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.rhwlab.acetree.AceTree;
import org.rhwlab.acetree.NucUtils;
import org.rhwlab.snight.Config;
import org.rhwlab.snight.Loc;
import org.rhwlab.snight.Movie;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.Parameters;
import org.rhwlab.utils.Line;

public class Identity {
    public static Identity iIdentity;
    private static NucleiMgr iNucleiMgr;
    private AceTree iAceTree;
    private boolean iDebug;
    private int iNamingMethod;
    private static Vector nuclei_record;
    private static int iEndingIndex;
    private int iStartingIndex;
    private char tag1;
    private Hashtable iRelativePositionHash;
    private int iDivisor;
    private int iMinCutoff;
    private int iNucCount;
    private Hashtable iNamingHash;
    private char iTag;
    Line iLine;
    private Parameters iParameters;
    private Movie iMovie;
    private boolean iOverrideMissingRule;
    private boolean iOverrideNoRuleFor;
    private double iTheta;
    private double iXCenter;
    private double iYCenter;
    private static final int XCENTER = 350;
    private static final int YCENTER = 250;
    private static final char E = 'e';
    private static final char W = 'w';
    private static final char V = 'v';
    private static final char D = 'd';
    private static final char B = 'b';
    private static final char T = 't';
    private static final char A = 'a';
    private static final char P = 'p';
    private static final char L = 'l';
    private static final char R = 'r';
    private static final char X = 'X';
    private static final char N = 'n';
    private static final char S = 's';
    private static final char IGNORESULSTON = 'i';
    public static final int EARLY = 50;
    public static final int MID = 450;
    public static final int DEAD = -1;
    public static final int DEADZERO = 0;
    public static final int DIVISOR = 8;
    public static final int MINCUTOFF = 5;
    public static final int STANDARD = 1;
    public static final int MANUAL = 2;
    public static final int NEWCANONICAL = 3;
    public static final String[] NAMING_METHOD;
    private static final String POLAR = "polar";
    private static final String NUC = "Nuc";
    private static final String AB = "AB";
    private static final String MS = "MS";
    private static final String CS = ", ";

    public Identity(NucleiMgr nucleiMgr) {
        iNucleiMgr = nucleiMgr;
        this.iParameters = iNucleiMgr.getParameters();
        this.iMovie = iNucleiMgr.getMovie();
        nuclei_record = iNucleiMgr.getNucleiRecord();
        iEndingIndex = iNucleiMgr.getEndingIndex();
        this.iNamingMethod = Identity.iNucleiMgr.getConfig().iNamingMethod;
        this.iRelativePositionHash = new Hashtable();
        this.iDivisor = 8;
        this.iMinCutoff = 5;
        this.iOverrideMissingRule = true;
        this.iOverrideNoRuleFor = true;
        this.iTheta = this.getAngle();
    }

    private double getAngle() {
        double ang = 0.0;
        Config config = iNucleiMgr.getConfig();
        Hashtable configHash = config.iConfigHash;
        String sang = (String)configHash.get("angle");
        if (sang.length() > 0) {
            ang = Double.parseDouble(sang);
        }
        this.iXCenter = 350.0;
        this.iYCenter = 250.0;
        String x = (String)configHash.get("x");
        String y = (String)configHash.get("y");
        if (x.length() > 0) {
            this.iXCenter = Double.parseDouble(x);
        }
        if (y.length() > 0) {
            this.iYCenter = Double.parseDouble(y);
        }
        return Math.toRadians(ang);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int getNamingMethod() {
        return this.iNamingMethod;
    }

    public void setNamingMethod(int method) {
        System.out.println("Identity.setNamingMethod called with: " + method + CS + NAMING_METHOD[method]);
        this.iNamingMethod = method;
    }

    public Hashtable getRelativePositionHash() {
        return this.iRelativePositionHash;
    }

    public void useCanonicalRules(int[] start, int[] lineage_ct_p) {
        this.iNamingHash = Identity.getNamingHashtable();
        int rotate_axis = 1;
        int nuc_ct = 0;
        Vector nuclei = null;
        int breakout = 0;
        this.iParameters.ap = this.iParameters.apInit;
        this.iParameters.dv = this.iParameters.dvInit;
        this.iParameters.lr = this.iParameters.lrInit;
        Identity.println("useCanonicalRules: " + this.iParameters.ap + CS + this.iParameters.dv + CS + this.iParameters.lr);
        int iEndingIndex = iNucleiMgr.getEndingIndex();
        int k = iNucleiMgr.getNucleiRecord().size();
        int m = Math.min(k, iEndingIndex);
        System.out.println("useCanonicalRules starting at: " + start[0] + CS + iEndingIndex);
        for (int i = start[0]; i < m; ++i) {
            if (breakout > 0) {
                System.out.println("Identity.useCanonicalRules exiting, breakout=" + breakout);
                System.exit(0);
                break;
            }
            nuclei = (Vector)nuclei_record.elementAt(i - 1);
            nuc_ct = nuclei.size();
            if (rotate_axis > 0 && nuc_ct > 50) {
                this.rotateAxis();
                Identity.println("useCanonicalRules: after rotateAxis, " + this.iParameters.ap + CS + this.iParameters.dv + CS + this.iParameters.lr);
                rotate_axis = 0;
            }
            Nucleus parent = null;
            Vector nextNuclei = (Vector)nuclei_record.elementAt(i);
            parent = null;
            for (int j = 0; j < nuc_ct; ++j) {
                boolean good;
                parent = (Nucleus)nuclei.elementAt(j);
                if (parent.status == -1) continue;
                String pname = parent.identity;
                if (pname == null || pname.length() == 0) {
                    parent.identity = pname = NUC + this.iNucCount++;
                }
                boolean bl = good = parent.successor1 > 0 && parent.successor2 > 0;
                if (!good) {
                    if (parent.successor1 <= 0) continue;
                    Nucleus n = (Nucleus)nextNuclei.elementAt(parent.successor1 - 1);
                    if (n.assignedID.length() > 0) continue;
                    n.identity = pname;
                    continue;
                }
                if (!this.parentRelevant(pname)) {
                    System.out.println("not relevantParent: " + pname);
                    continue;
                }
                Nucleus dau1 = (Nucleus)nextNuclei.elementAt(parent.successor1 - 1);
                Nucleus dau2 = (Nucleus)nextNuclei.elementAt(parent.successor2 - 1);
                boolean test = this.newCanonicalSisterID(parent, dau1, dau2, nuc_ct, i);
                this.usePreassignedID(dau1, dau2);
            }
        }
        System.out.println("useCanonicalRules exiting");
    }

    private void usePreassignedID(Nucleus dau1, Nucleus dau2) {
        if (dau1.assignedID.length() == 0 && dau2.assignedID.length() == 0) {
            return;
        }
        if (dau1.assignedID.length() > 0) {
            dau1.identity = dau1.assignedID;
        }
        if (dau2.assignedID.length() > 0) {
            dau2.identity = dau2.assignedID;
        }
        if (dau1.identity.equals(dau2.identity)) {
            String s = dau2.identity;
            s = s.substring(0, s.length() - 1);
            dau2.identity = s = s + "X";
        }
    }

    private boolean parentRelevant(String pname) {
        boolean rtn = true;
        return rtn;
    }

    public static Hashtable getNamingHashtable() {
        Hashtable<String, String> namingHash = new Hashtable<String, String>();
        URL url = AceTree.class.getResource("/org/rhwlab/snight/namesHash.txt");
        InputStream istream = null;
        try {
            istream = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istream));
            while (br.ready()) {
                String s = br.readLine();
                if (s.length() == 0) continue;
                String[] sa = s.split(",");
                namingHash.put(sa[0], sa[1]);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return namingHash;
    }

    private boolean newCanonicalSisterID(Nucleus parent, Nucleus dau1, Nucleus dau2, int cellCount, int index) {
        String prule;
        String pname = parent.identity;
        if (pname.equals("Cppp")) {
            int uuu = 8;
        }
        if ((prule = (String)this.iNamingHash.get(pname)) == null) {
            if (this.iOverrideNoRuleFor) {
                prule = "a0xa";
            } else {
                System.out.println("PROCESSING CANNOT CONTINUE DUE TO NO RULE FOR PARENT");
                System.exit(2);
            }
        }
        boolean canonicalTry = false;
        boolean ruleTry = false;
        char caxis = prule.charAt(0);
        canonicalTry = caxis != 'i' ? this.makeAxisDetermination(0, prule, cellCount, dau1, dau2) : false;
        if (!canonicalTry) {
            String x;
            System.out.println("need a rule for: " + pname + " ;available rule: " + prule);
            if (pname.equals("Cpp")) {
                Identity.println("newCanonicalSister, debug stop");
            }
            if (prule.length() < 3) {
                x = "*** RULE MISSING *** " + pname + CS + prule;
                System.out.println(x);
                if (this.iOverrideMissingRule) {
                    char u = prule.charAt(0);
                    char add = 'x';
                    switch (u) {
                        case 'a': {
                            break;
                        }
                        case 'd': {
                            add = 'y';
                            break;
                        }
                        default: {
                            add = 'z';
                        }
                    }
                    prule = prule + add;
                    prule = prule + u;
                    x = "*** USING FORCED RULE *** " + pname + CS + prule;
                    System.out.println(x);
                } else {
                    System.out.println("PROCESSING CANNOT PROCEED DUE TO MISSING RULE");
                    System.exit(1);
                }
            }
            if (!(ruleTry = this.makeAlternateDetermination(prule, cellCount, dau1, dau2))) {
                x = "*** RULE FAILURE *** " + pname + CS + prule;
                System.out.println(x);
            }
        }
        this.nameDaughters(parent, dau1, dau2);
        return canonicalTry;
    }

    private void nameDaughters(Nucleus parent, Nucleus dau1, Nucleus dau2) {
        this.tag1 = this.iTag;
        if (this.specialCases(parent, dau1, dau2)) {
            return;
        }
        dau1.identity = parent.identity + this.iTag;
        dau2.identity = this.replaceLastChar(dau1.identity);
    }

    private void angleAdjustXY(Loc u) {
        double x1 = u.x;
        double y1 = u.y;
        double x2 = x1 - this.iXCenter;
        double y2 = y1 - this.iYCenter;
        double r = Math.sqrt(x2 * x2 + y2 * y2);
        double a = Math.atan2(y2, x2);
        double aa = a + this.iTheta;
        double x3 = Math.round(r * Math.cos(aa));
        double y3 = Math.round(r * Math.sin(aa));
        u.x = (int)Math.round(x3 + this.iXCenter);
        u.y = (int)Math.round(y3 + this.iYCenter);
    }

    private boolean makeAxisDetermination(int k, String rule, int cellCount, Nucleus dau1, Nucleus dau2) {
        char caxis = rule.charAt(k);
        int divisor = (dau1.size + dau2.size) / 8;
        Loc dau1L = new Loc(dau1, iNucleiMgr);
        Loc dau2L = new Loc(dau2, iNucleiMgr);
        int value = 0;
        this.iTag = (char)88;
        this.angleAdjustXY(dau1L);
        this.angleAdjustXY(dau2L);
        if (caxis == 'a') {
            value = (dau1L.x - dau2L.x) * 100 / divisor;
            this.iTag = (value *= this.iParameters.ap) > 0 ? (char)112 : (char)97;
        } else if (caxis == 'd') {
            value = (dau1L.y - dau2L.y) * 100 / divisor;
            this.iTag = value > 0 ? (char)118 : (char)100;
        } else {
            value = (dau1L.z - dau2L.z) * 100 / divisor;
            this.iTag = (value *= this.iParameters.ap) < 0 ? (char)108 : (char)114;
        }
        return Math.abs(value) > 100;
    }

    private boolean makeAlternateDetermination(String rule, int cellCount, Nucleus dau1, Nucleus dau2) {
        char caxis = rule.charAt(2);
        char ruleChar = rule.charAt(3);
        int divisor = (dau1.size + dau2.size) / 8;
        Loc dau1L = new Loc(dau1, iNucleiMgr);
        Loc dau2L = new Loc(dau2, iNucleiMgr);
        this.angleAdjustXY(dau1L);
        this.angleAdjustXY(dau2L);
        int value = 0;
        this.iTag = (char)88;
        value = caxis == 'x' ? (dau1L.x - dau2L.x) * 100 / divisor : (caxis == 'y' ? (dau1L.y - dau2L.y) * 100 / divisor : (dau1L.z - dau2L.z) * 100 / divisor);
        this.iTag = value < 0 ? ruleChar : this.complement(ruleChar);
        return Math.abs(value) > 100;
    }

    private char complement(char x) {
        switch (x) {
            case 'a': {
                return 'p';
            }
            case 'p': {
                return 'a';
            }
            case 'd': {
                return 'v';
            }
            case 'v': {
                return 'd';
            }
            case 'l': {
                return 'r';
            }
            case 'r': {
                return 'l';
            }
        }
        return 'g';
    }

    public void identityAssignment() {
        System.out.println("\n\nidentityAssignment: " + this.iParameters.axis + CS + this.iParameters.ap + CS + this.iParameters.dv + CS + this.iParameters.lr);
        this.iMovie = iNucleiMgr.getMovie();
        this.iNucCount = 1;
        System.out.println("NamingMethod: " + NAMING_METHOD[this.iNamingMethod]);
        if (this.iNamingMethod == 2) {
            return;
        }
        int[] lineage_ct_p = new int[]{1};
        int lin_ct = lineage_ct_p[0];
        int[] start = new int[]{1};
        int rotate_axis = 1;
        int nuc_ct = 0;
        Vector nuclei = null;
        Vector nuclei_prev = null;
        this.iRelativePositionHash.clear();
        this.iStartingIndex = Identity.iNucleiMgr.getConfig().iStartingIndex;
        this.clearAllNames();
        System.out.println("identityAssignment iStartingIndex: " + this.iStartingIndex);
        this.iParameters.axis = 0;
        start[0] = this.iStartingIndex;
        this.tryForAxis();
        if (this.iParameters.axis == 1 && this.iNamingMethod == 3) {
            this.useCanonicalRules(start, lineage_ct_p);
            return;
        }
        if (this.iStartingIndex == 1) {
            int mm = this.initialID(start, lineage_ct_p);
            System.out.println("initialID returned: " + mm);
            if (mm > 0) {
                System.out.println("detected backtrace failure, lineage from start");
                start[0] = 0;
            }
            lin_ct = lineage_ct_p[0];
            System.out.println("identityAssignment starting at: " + start[0]);
            if (this.iNamingMethod == 3 && start[0] > 0) {
                this.useCanonicalRules(start, lineage_ct_p);
                return;
            }
        } else {
            Nucleus n;
            int j;
            nuclei = (Vector)nuclei_record.elementAt(this.iStartingIndex - 1);
            for (j = 0; j < nuclei.size(); ++j) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.status == -1 || n.identity.length() <= 0 || n.identity.indexOf(NUC) != 0) continue;
                int k = this.getNumber(n.identity.substring(3));
                this.iNucCount = Math.max(k, this.iNucCount);
            }
            ++this.iNucCount;
            for (j = 0; j < nuclei.size(); ++j) {
                n = (Nucleus)nuclei.elementAt(j);
                if (n.status == -1 || n.identity.length() > 0) continue;
                n.identity = NUC + this.iNucCount++;
                System.out.println("founder: " + n.identity);
            }
            this.tryForAxis();
        }
        System.out.println("identityAssignment, iEndingIndex=" + iEndingIndex);
        for (int i = start[0]; i < iEndingIndex; ++i) {
            this.iDebug = false;
            nuclei = (Vector)nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            if (i > 0) {
                nuclei_prev = (Vector)nuclei_record.elementAt(i - 1);
            }
            if (rotate_axis > 0 && nuc_ct > 50) {
                this.rotateAxis();
                rotate_axis = 0;
            }
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.status == -1 || nucleij.status == 0) continue;
                String s = nucleij.identity;
                if (s == null) {
                    System.out.println("Flaw in nuclei files at indices i, j: " + i + CS + j);
                    System.out.println("Identity cannot continue -- shutting down");
                    System.exit(11);
                }
                if (s.length() > 0) continue;
                nucleij.identity = "";
                if (nucleij.identity.length() != 0) continue;
                Nucleus pred = null;
                if (nucleij.predecessor != -1) {
                    pred = (Nucleus)nuclei_prev.elementAt(nucleij.predecessor - 1);
                }
                if (nucleij.predecessor == -1 || pred.status == -1) {
                    nucleij.identity = NUC + this.iNucCount++ + s;
                    continue;
                }
                if (pred.successor2 == -1) {
                    nucleij.identity = pred.identity;
                    continue;
                }
                Nucleus dau1 = (Nucleus)nuclei.elementAt(pred.successor1 - 1);
                Nucleus dau2 = (Nucleus)nuclei.elementAt(pred.successor2 - 1);
                boolean r = true;
                if (!r) continue;
                if (this.iNamingMethod != 1) {
                    this.sisterID(dau1, dau2, nuc_ct);
                    dau1.identity = pred.identity + dau1.id_tag;
                    dau2.identity = pred.identity + dau2.id_tag;
                    continue;
                }
                this.newSisterID(pred, dau1, dau2, nuc_ct);
            }
        }
        lineage_ct_p[0] = lin_ct;
        Identity.println("identity_assignment, ending normally");
    }

    private int getNumber(String sin) {
        String s = "";
        for (int i = 0; i < sin.length(); ++i) {
            char c = sin.charAt(i);
            if (!Character.isDigit(c)) continue;
            s = s + c;
        }
        int k = Integer.parseInt(s);
        return k;
    }

    private void tryForAxis() {
        String axis = Identity.iNucleiMgr.getConfig().iAxisGiven;
        Identity.println("tryForAxis: " + axis);
        if (axis == null || axis.length() < 3) {
            this.iParameters.axis = 0;
            return;
        }
        this.iParameters.ap = 1;
        this.iParameters.dv = 1;
        this.iParameters.lr = 1;
        if (axis.charAt(0) == 'p') {
            this.iParameters.ap = -1;
        }
        if (axis.charAt(1) == 'v') {
            this.iParameters.dv = -1;
        }
        if (axis.charAt(2) == 'r') {
            this.iParameters.lr = -1;
        }
        this.iParameters.axis = 1;
        this.iParameters.apInit = this.iParameters.ap;
        this.iParameters.dvInit = this.iParameters.dv;
        this.iParameters.lrInit = this.iParameters.lr;
        Identity.println("tryForAxis:2 " + this.iParameters.ap + CS + this.iParameters.dv + CS + this.iParameters.lr);
    }

    private boolean specialCases(Nucleus parent, Nucleus nuc1, Nucleus nuc2) {
        boolean rtn = true;
        if (parent.identity.equals("EMS")) {
            switch (this.tag1) {
                case 'a': 
                case 'd': 
                case 'l': {
                    nuc1.identity = MS;
                    nuc2.identity = "E";
                    break;
                }
                default: {
                    nuc1.identity = "E";
                    nuc2.identity = MS;
                    break;
                }
            }
        } else if (parent.identity.equals("P1")) {
            switch (this.tag1) {
                case 'a': 
                case 'd': 
                case 'l': {
                    nuc1.identity = "EMS";
                    nuc2.identity = "P2";
                    break;
                }
                default: {
                    nuc1.identity = "P2";
                    nuc2.identity = "EMS";
                    break;
                }
            }
        } else if (parent.identity.equals("P2")) {
            switch (this.tag1) {
                case 'a': 
                case 'd': 
                case 'l': {
                    nuc1.identity = "C";
                    nuc2.identity = "P3";
                    break;
                }
                default: {
                    nuc1.identity = "P3";
                    nuc2.identity = "C";
                    break;
                }
            }
        } else if (parent.identity.equals("P4")) {
            switch (this.tag1) {
                case 'a': 
                case 'd': 
                case 'l': {
                    nuc1.identity = "Z3";
                    nuc2.identity = "Z2";
                    break;
                }
                default: {
                    nuc1.identity = "Z2";
                    nuc2.identity = "Z3";
                    break;
                }
            }
        } else if (parent.identity.equals("P3")) {
            int tag2 = 32;
            int difi = (nuc1.y - nuc2.y) * this.iParameters.dv;
            if (difi < -nuc1.size / 2) {
                this.tag1 = (char)100;
                tag2 = 118;
            } else {
                this.tag1 = (char)118;
                tag2 = 100;
            }
            if (this.tag1 == 'd') {
                nuc1.identity = "D";
                nuc2.identity = "P4";
            } else if (this.tag1 == 'v') {
                nuc1.identity = "P4";
                nuc2.identity = "D";
            }
        } else if (parent.identity.equals("P0")) {
            switch (this.tag1) {
                case 'a': 
                case 'd': 
                case 'l': {
                    nuc1.identity = AB;
                    nuc2.identity = "P1";
                    break;
                }
                default: {
                    nuc1.identity = "P1";
                    nuc2.identity = AB;
                    break;
                }
            }
        } else {
            rtn = false;
        }
        return rtn;
    }

    public void newSisterID(Nucleus parent, Nucleus nuc1, Nucleus nuc2, int cellCount) {
        String newName;
        boolean b = false;
        if (this.iParameters.axis == 0) {
            this.sisterNucs(parent, nuc1, nuc2);
            System.out.println("newSisterID: " + nuc1.identity + CS + nuc2.identity);
            return;
        }
        int k = this.relativePosition(nuc1, nuc2);
        this.iRelativePositionHash.put(nuc1.identity, new Integer(k));
        this.tag1 = cellCount < 50 ? this.earlyFirstCellTag(k) : this.midFirstCellTag(k);
        if (this.specialCases(parent, nuc1, nuc2)) {
            return;
        }
        nuc1.identity = newName = new StringBuffer(parent.identity).append(this.tag1).toString();
        nuc2.identity = this.makeSisterName(newName);
    }

    private int relativePosition(Nucleus cd1, Nucleus cd2) {
        int cutoff = (cd1.size + cd2.size) / this.iDivisor;
        cutoff = Math.max(cutoff, this.iMinCutoff);
        int xdiff = cd1.x - cd2.x;
        int ydiff = cd1.y - cd2.y;
        int zdiff = (int)((double)(cd1.z - cd2.z) * iNucleiMgr.getZPixRes());
        if (Math.abs(xdiff) > cutoff) {
            if (xdiff < 0) {
                return -1;
            }
            return 1;
        }
        if (Math.abs(ydiff) > cutoff) {
            if (ydiff < 0) {
                return -2;
            }
            return 2;
        }
        if (Math.abs(zdiff) > cutoff) {
            if (zdiff < 0) {
                return -3;
            }
            return 3;
        }
        int maxThing = 1;
        int maxValue = xdiff;
        int testValue = ydiff;
        if (Math.abs(testValue) > Math.abs(maxValue)) {
            maxValue = testValue;
            maxThing = 2;
        }
        if (Math.abs(testValue = zdiff) > Math.abs(maxValue)) {
            maxValue = testValue;
            maxThing = 3;
        }
        if (maxValue < 0) {
            return -maxThing;
        }
        return maxThing;
    }

    private char earlyFirstCellTag(int k) {
        int parameterslr = this.iParameters.lr;
        int parametersdv = this.iParameters.dv;
        int ka = Math.abs(k);
        int m = 1;
        switch (ka) {
            case 1: {
                m = k * this.iParameters.ap;
                if (m < 0) {
                    return 'a';
                }
                return 'p';
            }
            case 2: {
                m = k * parametersdv;
                if (m < 0) {
                    return 'd';
                }
                return 'v';
            }
        }
        m = k * parameterslr;
        if (m < 0) {
            return 'l';
        }
        return 'r';
    }

    private char midFirstCellTag(int k) {
        int parameterslr = this.iParameters.lr;
        int parametersdv = this.iParameters.dv;
        int ka = Math.abs(k);
        int m = 1;
        switch (ka) {
            case 1: {
                m = k * this.iParameters.ap;
                if (m < 0) {
                    return 'a';
                }
                return 'p';
            }
            case 2: {
                m = k * parameterslr;
                if (m < 0) {
                    return 'l';
                }
                return 'r';
            }
        }
        m = k * parametersdv;
        if (m < 0) {
            return 'd';
        }
        return 'v';
    }

    public String makeSisterName(String s) {
        String sis = null;
        char x = s.charAt(0);
        int n = s.length();
        boolean b = n == 1;
        switch (x) {
            case 'C': {
                if (b) {
                    return "P3";
                }
            }
            case 'D': {
                if (b) {
                    return "P4";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'E': {
                if (b) {
                    return MS;
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'M': {
                if (n == 2) {
                    return "E";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'A': {
                if (s.equals("ABal")) {
                    return "ABar";
                }
                if (s.equals("ABpl")) {
                    return "ABpr";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'R': {
                if (s.equals("Z2")) {
                    sis = "Z3";
                    break;
                }
                sis = "Z2";
                break;
            }
            case 'P': {
                if (s.equals("P2")) {
                    sis = "EMS";
                    break;
                }
                if (s.equals("P3")) {
                    sis = "C";
                    break;
                }
                if (!s.equals("P4")) break;
                sis = "D";
                break;
            }
            default: {
                sis = this.replaceLastChar(s);
            }
        }
        return sis;
    }

    public String replaceLastChar(String s) {
        StringBuffer sb = new StringBuffer(s);
        int n = sb.length() - 1;
        char x = sb.charAt(n);
        switch (x) {
            case 'a': {
                sb.setCharAt(n, 'p');
                break;
            }
            case 'l': {
                sb.setCharAt(n, 'r');
                break;
            }
            case 'd': {
                sb.setCharAt(n, 'v');
                break;
            }
            case 'p': {
                sb.setCharAt(n, 'a');
                break;
            }
            case 'r': {
                sb.setCharAt(n, 'l');
                break;
            }
            case 'v': {
                sb.setCharAt(n, 'd');
            }
        }
        return sb.toString();
    }

    private void sisterNucs(Nucleus parent, Nucleus nuc1, Nucleus nuc2) {
        int xdiff = nuc1.x - nuc2.x;
        int ydiff = nuc1.y - nuc2.y;
        int cutoff = (nuc1.size + nuc2.size) / this.iDivisor;
        cutoff = Math.max(cutoff, this.iMinCutoff);
        int tag1 = 32;
        char tag2 = ' ';
        if (xdiff < 0 - cutoff) {
            tag1 = 119;
            tag2 = 'e';
        } else if (xdiff > cutoff) {
            tag1 = 101;
            tag2 = 'w';
        } else if (ydiff < 0 - cutoff) {
            tag1 = 110;
            tag2 = 's';
        } else if (ydiff > cutoff) {
            tag1 = 115;
            tag2 = 'n';
        } else if (nuc1.z < nuc2.z) {
            tag1 = 116;
            tag2 = 'b';
        } else {
            tag1 = 98;
            tag2 = 't';
        }
        nuc1.identity = parent.identity + (char)tag1;
        nuc2.identity = parent.identity + tag2;
    }

    private void earlyAxis(Nucleus nuc1, Nucleus nuc2) {
        int tag2;
        int tag1;
        char left = 't';
        char right = 'b';
        char dorsal = 'd';
        int ventral = 118;
        if (this.iParameters.lr == 1) {
            left = 't';
            right = 'b';
        } else {
            left = 'b';
            right = 't';
        }
        if (this.iParameters.dv == 1) {
            dorsal = 'v';
            ventral = 100;
        } else {
            dorsal = 'd';
            ventral = 118;
        }
        char tag = nuc1.id_tag;
        if (tag == left) {
            tag1 = 108;
            tag2 = 114;
        } else if (tag == right) {
            tag1 = 114;
            tag2 = 108;
        } else if (tag == dorsal) {
            tag1 = 100;
            tag2 = 118;
        } else {
            tag1 = 118;
            tag2 = 100;
        }
        nuc1.id_tag = (char)tag1;
        nuc2.id_tag = (char)tag2;
    }

    private void midAxis(Nucleus nuc1, Nucleus nuc2) {
        int tag2;
        int tag1;
        char left = 't';
        char right = 'b';
        char dorsal = 'd';
        int ventral = 118;
        if (this.iParameters.lr == 1) {
            left = 'v';
            right = 'd';
        } else {
            left = 'd';
            right = 'v';
        }
        if (this.iParameters.dv == 1) {
            dorsal = 't';
            ventral = 98;
        } else {
            dorsal = 'b';
            ventral = 116;
        }
        char tag = nuc1.id_tag;
        if (tag == left) {
            tag1 = 108;
            tag2 = 114;
        } else if (tag == right) {
            tag1 = 114;
            tag2 = 108;
        } else if (tag == dorsal) {
            tag1 = 100;
            tag2 = 118;
        } else {
            tag1 = 118;
            tag2 = 100;
        }
        nuc1.id_tag = (char)tag1;
        nuc2.id_tag = (char)tag2;
    }

    private void sisterID(Nucleus nuc1, Nucleus nuc2, int nuc_ct) {
        int xdiff = nuc1.x - nuc2.x;
        int ydiff = nuc1.y - nuc2.y;
        int cutoff = (nuc1.size + nuc2.size) / this.iDivisor;
        cutoff = Math.max(cutoff, this.iMinCutoff);
        int tag1 = 32;
        int tag2 = 32;
        Integer one = new Integer(1);
        Integer two = new Integer(2);
        Integer three = new Integer(3);
        if (this.iParameters.axis == 0) {
            if (xdiff < 0 - cutoff) {
                tag1 = 119;
                tag2 = 101;
                this.iRelativePositionHash.put(nuc1.identity, one);
            } else if (xdiff > cutoff) {
                tag1 = 101;
                tag2 = 119;
                this.iRelativePositionHash.put(nuc1.identity, one);
            } else if (ydiff < 0 - cutoff) {
                tag1 = 110;
                tag2 = 115;
                this.iRelativePositionHash.put(nuc1.identity, two);
            } else if (ydiff > cutoff) {
                tag1 = 115;
                tag2 = 110;
                this.iRelativePositionHash.put(nuc1.identity, two);
            } else if (nuc1.z < nuc2.z) {
                tag1 = 116;
                tag2 = 98;
                this.iRelativePositionHash.put(nuc1.identity, three);
            } else {
                tag1 = 98;
                tag2 = 116;
                this.iRelativePositionHash.put(nuc1.identity, three);
            }
            nuc1.id_tag = (char)tag1;
            nuc2.id_tag = (char)tag2;
            return;
        }
        if (xdiff * this.iParameters.ap < 0 - cutoff) {
            tag1 = 97;
            tag2 = 112;
            this.iRelativePositionHash.put(nuc1.identity, one);
        } else if (xdiff * this.iParameters.ap > cutoff) {
            tag1 = 112;
            tag2 = 97;
            this.iRelativePositionHash.put(nuc1.identity, one);
        } else if (ydiff * this.iParameters.ap < 0 - cutoff) {
            tag1 = 118;
            tag2 = 100;
            this.iRelativePositionHash.put(nuc1.identity, two);
        } else if (ydiff * this.iParameters.ap > cutoff) {
            tag1 = 100;
            tag2 = 118;
            this.iRelativePositionHash.put(nuc1.identity, two);
        } else if (nuc1.z < nuc2.z) {
            tag1 = 116;
            tag2 = 98;
            this.iRelativePositionHash.put(nuc1.identity, three);
        } else {
            tag1 = 98;
            tag2 = 116;
            this.iRelativePositionHash.put(nuc1.identity, three);
        }
        nuc1.id_tag = (char)tag1;
        nuc2.id_tag = (char)tag2;
        if (tag1 == 97 || tag1 == 112) {
            return;
        }
        if (nuc_ct < 50) {
            this.earlyAxis(nuc1, nuc2);
        } else if (nuc_ct < 450) {
            this.midAxis(nuc1, nuc2);
        }
    }

    public void rotateAxis() {
        this.iParameters.lr *= this.iParameters.ap * -1;
        this.iParameters.dv *= this.iParameters.ap;
    }

    public int newBornID(Nucleus mother, Nucleus dau1, Nucleus dau2) {
        Identity.println("newBornID: " + mother.identity + CS + dau1.identity + CS + dau2.identity);
        int rtn = 0;
        int tag1 = 88;
        int tag2 = 88;
        if (mother.identity.indexOf(POLAR) > -1) {
            System.out.println("Dividing polar body");
        } else {
            if (mother.identity.equals("ABa")) {
                float diff = (dau1.z - dau2.z) * (float)this.iParameters.lr;
                if (diff < 0.0f) {
                    tag1 = 108;
                    tag2 = 114;
                } else {
                    tag1 = 114;
                    tag2 = 108;
                }
                dau1.identity = mother.identity + (char)tag1;
                dau2.identity = mother.identity + (char)tag2;
                return 0;
            }
            if (mother.identity.equals("ABp")) {
                float diff = (dau1.z - dau2.z) * (float)this.iParameters.lr;
                if (diff < 0.0f) {
                    tag1 = 108;
                    tag2 = 114;
                } else {
                    tag1 = 114;
                    tag2 = 108;
                }
                dau1.identity = mother.identity + (char)tag1;
                dau2.identity = mother.identity + (char)tag2;
                return 0;
            }
            if (mother.identity.equals("EMS")) {
                int k = this.relativePosition(dau1, dau2);
                dau1.id_tag = this.earlyFirstCellTag(k);
                if (dau1.id_tag == 'a') {
                    dau1.identity = MS;
                    dau2.identity = "E";
                    return 0;
                }
                if (dau1.id_tag == 'p') {
                    dau1.identity = "E";
                    dau2.identity = MS;
                    return 0;
                }
            } else if (mother.identity.equals("P2")) {
                int difi = (dau1.y - dau2.y) * this.iParameters.dv;
                if (difi < -dau1.size / 2) {
                    tag1 = 100;
                    tag2 = 118;
                } else if (difi > dau1.size / 2) {
                    tag1 = 118;
                    tag2 = 100;
                }
                if (tag1 == 100) {
                    dau1.identity = "C";
                    dau2.identity = "P3";
                    return 0;
                }
                if (tag1 == 118) {
                    dau1.identity = "P3";
                    dau2.identity = "C";
                    return 0;
                }
            } else if (mother.identity.equals("P3")) {
                int difi = (dau1.y - dau2.y) * this.iParameters.dv;
                if (difi < -dau1.size / 2) {
                    tag1 = 100;
                    tag2 = 118;
                } else if (difi > dau1.size / 2) {
                    tag1 = 118;
                    tag2 = 100;
                }
                if (tag1 == 100) {
                    dau1.identity = "D";
                    dau2.identity = "P4";
                    return 0;
                }
                if (tag1 == 118) {
                    dau1.identity = "P4";
                    dau2.identity = "D";
                    return 0;
                }
                System.out.println("P3 NOT RESOLVED IN newBornID");
            } else if (mother.identity.equals("P4")) {
                int k = this.relativePosition(dau1, dau2);
                dau1.id_tag = this.midFirstCellTag(k);
                if (dau1.id_tag == 'a' || dau1.id_tag == 'l') {
                    dau1.identity = "Z3";
                    dau2.identity = "Z2";
                    return 0;
                }
                if (dau1.id_tag == 'p' || dau1.id_tag == 'r') {
                    dau1.identity = "Z2";
                    dau2.identity = "Z3";
                    return 0;
                }
            }
        }
        if (tag1 != 88) {
            dau1.id_tag = (char)tag1;
            dau2.id_tag = (char)tag2;
            dau1.identity = mother.identity + (char)tag1;
            dau2.identity = mother.identity + (char)tag2;
        } else {
            rtn = -1;
        }
        return rtn;
    }

    private int initialID(int[] start_p, int[] lineage_ct_p) {
        Identity.println("initialID called: " + start_p[0] + CS + lineage_ct_p[0]);
        int rtn = 0;
        int lin_ct = lineage_ct_p[0];
        int first_four = -1;
        int last_four = -1;
        Vector nuclei = (Vector)nuclei_record.elementAt(0);
        int nuc_ct = nuclei.size();
        int cell_ct = this.countCells(nuclei);
        if (cell_ct <= 6) {
            this.polarBodies();
            cell_ct = this.countCells(nuclei);
        }
        if (cell_ct > 4) {
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.status == -1 || nucleij.identity.indexOf(POLAR) > -1) continue;
                nucleij.identity = NUC + this.iNucCount++;
            }
            this.iParameters.axis = 0;
            start_p[0] = 0;
            lineage_ct_p[0] = lin_ct;
            System.out.println("Starting with more than 4 cells.  No canonical ID assigned.");
            return 0;
        }
        this.iParameters.axis = 1;
        if (cell_ct == 4) {
            first_four = 0;
        }
        for (int i = 0; i < iEndingIndex - 1; ++i) {
            nuclei = (Vector)nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            cell_ct = this.countCells(nuclei);
            if (cell_ct > 4) break;
            if (cell_ct != 4) continue;
            if (first_four < 0) {
                first_four = i;
            }
            last_four = i;
        }
        if (first_four == -1) {
            nuclei = (Vector)nuclei_record.elementAt(0);
            nuc_ct = nuclei.size();
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.status == -1 || nucleij.identity.indexOf(POLAR) > -1) continue;
                ++lin_ct;
                nucleij.identity = NUC + this.iNucCount++;
            }
            this.iParameters.axis = 0;
            start_p[0] = 0;
            lineage_ct_p[0] = lin_ct;
            System.out.println("Movie too short to see four cells");
            return 0;
        }
        int four_cells = (first_four + last_four) / 2;
        start_p[0] = four_cells + 1;
        rtn = this.fourCellID(four_cells, lineage_ct_p);
        if (rtn != 0) {
            rtn = this.backAssignment(four_cells, lineage_ct_p);
        }
        if (rtn == 0) {
            this.iParameters.axis = 0;
            return 1;
        }
        return 0;
    }

    private int fourCellID(int four_cells, int[] lineage_ct_p) {
        Vector nuclei = null;
        Vector nuclei_next = null;
        Nucleus nucleii = null;
        int lin_ct = lineage_ct_p[0];
        nuclei = (Vector)nuclei_record.elementAt(four_cells);
        int nuc_ct = nuclei.size();
        int r = this.alignDiamond(nuclei);
        if (r == 0) {
            return 0;
        }
        r = this.fourCellIDAssignment(four_cells);
        if (r == 0) {
            return 0;
        }
        if (four_cells < iEndingIndex) {
            nuclei_next = (Vector)nuclei_record.elementAt(four_cells + 1);
        }
        for (int i = 0; i < nuc_ct; ++i) {
            nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.identity.indexOf(POLAR) > -1) continue;
            if (nucleii.predecessor == -1) {
                ++lin_ct;
            }
            if (nucleii.successor2 == -1) continue;
            Nucleus d1 = (Nucleus)nuclei_next.elementAt(nucleii.successor1 - 1);
            Nucleus d2 = (Nucleus)nuclei_next.elementAt(nucleii.successor2 - 1);
            this.sisterID(d1, d2, nuc_ct);
        }
        lineage_ct_p[0] = lin_ct;
        return 1;
    }

    private int fourCellIDAssignment(int four_cells) {
        Nucleus P2 = null;
        Nucleus EMS = null;
        Nucleus ABp = null;
        Nucleus ABa = null;
        Nucleus east = null;
        Nucleus west = null;
        Nucleus south = null;
        Nucleus north = null;
        Vector nuclei = (Vector)nuclei_record.elementAt(four_cells);
        int nuc_ct = nuclei.size();
        for (int i = 0; i < nuc_ct; ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.id_tag == 'n') {
                north = nucleii;
                continue;
            }
            if (nucleii.id_tag == 's') {
                south = nucleii;
                continue;
            }
            if (nucleii.id_tag == 'e') {
                east = nucleii;
                continue;
            }
            if (nucleii.id_tag != 'w') continue;
            west = nucleii;
        }
        int ntime = this.timeToDivide(four_cells, north);
        if (ntime < 0) {
            return 0;
        }
        int stime = this.timeToDivide(four_cells, south);
        if (stime < 0) {
            return 0;
        }
        int etime = this.timeToDivide(four_cells, east);
        if (etime < 0) {
            return 0;
        }
        int wtime = this.timeToDivide(four_cells, west);
        if (wtime < 0) {
            return 0;
        }
        if (wtime < etime) {
            ABa = west;
            P2 = east;
            this.iParameters.ap = 1;
        } else if (wtime > etime) {
            ABa = east;
            P2 = west;
            this.iParameters.ap = -1;
            this.iParameters.apInit = -1;
        } else {
            System.out.println("putative ABa and P2 divide simutaneously.");
            return 0;
        }
        if (ntime < stime) {
            ABp = north;
            EMS = south;
            this.iParameters.dv = 1;
            this.iParameters.dvInit = 1;
        } else if (ntime > stime) {
            ABp = south;
            EMS = north;
            this.iParameters.dv = -1;
            this.iParameters.dvInit = -1;
        } else {
            System.out.println("putative ABp and EMS divide simutaneously.");
            return 0;
        }
        this.iParameters.lrInit = this.iParameters.lr = this.iParameters.ap * this.iParameters.dv;
        ABa.identity = "ABa";
        ABp.identity = "ABp";
        EMS.identity = "EMS";
        P2.identity = "P2";
        String o = iNucleiMgr.getOrientation();
        System.out.println("axis xyz = " + o + CS + this.iParameters.dvInit + CS + this.iParameters.dv);
        return 1;
    }

    private int timeToDivide(int current_time, Nucleus nuc) {
        while (current_time < iEndingIndex) {
            if (nuc.successor1 == -1) {
                return -1;
            }
            if (nuc.successor2 != -1) break;
            nuc = (Nucleus)((Vector)nuclei_record.elementAt(++current_time)).elementAt(nuc.successor1 - 1);
        }
        return current_time;
    }

    private int alignDiamond(Vector nuclei) {
        int rtn = 1;
        Nucleus north = null;
        Nucleus south = null;
        Nucleus west = null;
        Nucleus east = null;
        int xmin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymin = Integer.MAX_VALUE;
        int ymax = 0;
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.status < 0 || nucleii.identity.indexOf(POLAR) > -1) continue;
            if (nucleii.x < xmin) {
                xmin = nucleii.x;
                west = nucleii;
            }
            if (nucleii.x > xmax) {
                xmax = nucleii.x;
                east = nucleii;
            }
            if (nucleii.y < ymin) {
                ymin = nucleii.y;
                north = nucleii;
            }
            if (nucleii.y <= ymax) continue;
            ymax = nucleii.y;
            south = nucleii;
        }
        if (north == null || south == null || west == null || east == null) {
            System.out.println("No diamond four cell stage at time:1 " + this.iParameters.t);
            return 0;
        }
        if (north == south || north == west || north == east || south == west || south == east || west == east) {
            System.out.println("No diamond four cell stage at time:2 " + this.iParameters.t);
            return 0;
        }
        north.id_tag = (char)110;
        south.id_tag = (char)115;
        east.id_tag = (char)101;
        west.id_tag = (char)119;
        return rtn;
    }

    private void polarBodies() {
        int i;
        Vector nuclei = (Vector)nuclei_record.elementAt(0);
        Vector nuclei_next = null;
        int nuc_ct = nuclei.size();
        int p_ct = 0;
        for (i = 0; i < nuc_ct; ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.status < 0 || nucleii.size >= this.iParameters.polar_size) continue;
            nucleii.identity = POLAR + (p_ct + 1);
            ++p_ct;
        }
        if (p_ct == 0) {
            return;
        }
        block3: for (i = 0; i < iEndingIndex; ++i) {
            nuclei = (Vector)nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            try {
                nuclei_next = (Vector)nuclei_record.elementAt(i + 1);
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                break;
            }
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.identity.indexOf(POLAR) == -1) continue;
                if (nucleij.successor1 == -1) {
                    --p_ct;
                }
                if (p_ct == 0) continue block3;
                if (nucleij.successor2 != -1) {
                    System.out.println("Polar body divided: " + i + 1 + ":" + j + 1 + "->" + i + 2 + ":" + nucleij.successor1 + " and " + i + 2 + ":" + nucleij.successor2);
                    continue;
                }
                if (nucleij.successor1 == -1) continue;
                Nucleus suc = (Nucleus)nuclei_next.elementAt(nucleij.successor1 - 1);
                suc.identity = nucleij.identity;
            }
        }
    }

    private int countCells(Vector nuclei) {
        int cell_ct = 0;
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus n = (Nucleus)nuclei.elementAt(i);
            if (n.status <= -1 || n.identity.indexOf(POLAR) != -1) continue;
            ++cell_ct;
        }
        return cell_ct;
    }

    private void clearNames(Vector nuclei) {
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus n = (Nucleus)nuclei.elementAt(i);
            String id = n.identity;
            if (n.assignedID.length() > 0) continue;
            n.identity = "";
        }
    }

    private void clearAllNames() {
        int k = iNucleiMgr.getNucleiRecord().size();
        int endingIndex = iEndingIndex;
        for (int i = this.iStartingIndex - 1; i < iEndingIndex && i < k; ++i) {
            if (this.iStartingIndex > 1 && i == this.iStartingIndex - 1) continue;
            this.clearNames((Vector)iNucleiMgr.getNucleiRecord().elementAt(i));
        }
    }

    private int backAssignment(int four_cells, int[] lineage_ct_p) {
        int j;
        int nuc_ct;
        int i;
        System.out.println("backAssignment: " + four_cells);
        Vector nuclei = null;
        Vector nuclei_next = null;
        Vector nuclei_prev = null;
        Nucleus nucleij = null;
        Object nucleijn = null;
        Nucleus suc1 = null;
        Nucleus suc2 = null;
        Nucleus pred = null;
        int lin_ct = lineage_ct_p[0];
        int successor1 = -1;
        int successor2 = -1;
        int badExit = 0;
        for (i = four_cells - 1; i >= 0; --i) {
            Identity.println("backAssignment: " + i);
            nuclei = (Vector)nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            nuclei_next = (Vector)nuclei_record.elementAt(i + 1);
            successor1 = -1;
            successor2 = -1;
            for (j = 0; j < nuc_ct; ++j) {
                suc1 = null;
                suc2 = null;
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.identity.indexOf(POLAR) > -1 || nucleij.status == -1) continue;
                successor1 = nucleij.successor1;
                successor2 = nucleij.successor2;
                if (successor1 != -1) {
                    suc1 = (Nucleus)nuclei_next.elementAt(successor1 - 1);
                }
                if (successor2 == -1) {
                    if (suc1 != null) {
                        nucleij.identity = suc1.identity;
                        continue;
                    }
                    nucleij.identity = NUC + this.iNucCount++;
                    continue;
                }
                suc2 = (Nucleus)nuclei_next.elementAt(successor2 - 1);
                String s1 = suc1.identity;
                String s2 = suc2.identity;
                if (s1.equals("P2") || s1.equals("EMS")) {
                    if (s2.equals("P2") || s2.equals("EMS")) {
                        nucleij.identity = "P1";
                        continue;
                    }
                    System.out.println("bad sister names: " + s1 + CS + s2);
                    badExit = 1;
                    break;
                }
                if (s1.equals("ABa") || s1.equals("ABp")) {
                    if (s2.equals("ABa") || s2.equals("ABp")) {
                        nucleij.identity = AB;
                        continue;
                    }
                    System.out.println("bad sister names: " + s1 + CS + s2);
                    badExit = 1;
                    break;
                }
                if (s1.equals(AB) || s1.equals("P1")) {
                    if (s2.equals(AB) || s2.equals("P1")) {
                        nucleij.identity = "P0";
                        continue;
                    }
                    System.out.println("bad sister names: " + s1 + CS + s2);
                    badExit = 1;
                    break;
                }
                System.out.println("bad sister names: " + s1 + CS + s2);
                badExit = 1;
                break;
            }
            if (badExit <= 0) continue;
            System.out.println("backtrace failure: " + i + CS + j + CS + nuc_ct);
            return 0;
        }
        nuclei = (Vector)nuclei_record.elementAt(0);
        nuc_ct = nuclei.size();
        for (j = 0; j < nuc_ct; ++j) {
            nucleij = (Nucleus)nuclei.elementAt(j);
            if (nucleij.identity.indexOf(POLAR) > -1 || nucleij.identity != null) continue;
            nucleij.identity = NUC + this.iNucCount++;
        }
        for (i = 1; i < four_cells; ++i) {
            nuclei = (Vector)nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            nuclei_next = (Vector)nuclei_record.elementAt(i + 1);
            nuclei_prev = (Vector)nuclei_record.elementAt(i - 1);
            for (j = 0; j < nuc_ct; ++j) {
                boolean validId;
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.identity.indexOf(POLAR) > -1) continue;
                boolean bl = validId = nucleij.identity != null && !nucleij.identity.equals("");
                if (!validId && nucleij.predecessor == -1) {
                    ++lin_ct;
                    nucleij.identity = NUC + this.iNucCount++;
                } else if (nucleij.identity == null) {
                    pred = (Nucleus)nuclei_prev.elementAt(nucleij.predecessor - 1);
                    successor2 = pred.successor2;
                    if (successor2 == -1) {
                        pred.identity = nucleij.identity;
                    } else {
                        this.newBornID(pred, (Nucleus)nuclei.elementAt(pred.successor1 - 1), (Nucleus)nuclei.elementAt(successor2 - 1));
                    }
                }
                if (((Nucleus)nuclei.elementAt((int)j)).successor2 == -1) continue;
                this.sisterID((Nucleus)nuclei_next.elementAt(nucleij.successor1 - 1), (Nucleus)nuclei_next.elementAt(nucleij.successor2 - 1), nuc_ct);
            }
        }
        lineage_ct_p[0] = lin_ct;
        return 1;
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    public void setDivisor(int divisor) {
        this.iDivisor = divisor;
    }

    public int getMinCutoff() {
        return this.iMinCutoff;
    }

    public void setMinCutoff(int minCutoff) {
        this.iMinCutoff = minCutoff;
    }

    public Vector[] getIdentities() {
        int rows = nuclei_record.size();
        Vector[] ida = new Vector[nuclei_record.size()];
        Vector<String> names = null;
        Vector nuclei = null;
        Nucleus n = null;
        for (int i = 0; i < rows; ++i) {
            nuclei = (Vector)nuclei_record.elementAt(i);
            names = new Vector<String>();
            Enumeration e = nuclei.elements();
            while (e.hasMoreElements()) {
                n = (Nucleus)e.nextElement();
                names.add(n.identity);
            }
            ida[i] = names;
        }
        return ida;
    }

    public void putIdentities(Vector[] ida) {
        Vector names = null;
        Vector nuclei = null;
        Nucleus n = null;
        for (int i = 0; i < ida.length; ++i) {
            nuclei = (Vector)nuclei_record.elementAt(i);
            names = ida[i];
            for (int j = 0; j < names.size(); ++j) {
                n = (Nucleus)nuclei.elementAt(j);
                n.identity = (String)names.elementAt(j);
            }
        }
    }

    private void reportDividingCell(int time, Nucleus n) {
        this.iLine = new Line();
        this.iLine.add(this.getConfigFileInfo(iNucleiMgr.getConfigFileName()));
        int liveCells = NucUtils.countLiveCells((Vector)nuclei_record.elementAt(time));
        this.iLine.add(liveCells);
        int kd1 = n.successor1 - 1;
        int kd2 = n.successor2 - 1;
        Nucleus nd1 = null;
        Nucleus nd2 = null;
        for (int i = time + 1; i <= time + 5 && i < iNucleiMgr.getEndingIndex(); ++i) {
            Vector nuclei = (Vector)nuclei_record.elementAt(i);
            try {
                nd1 = (Nucleus)nuclei.elementAt(kd1);
                nd2 = (Nucleus)nuclei.elementAt(kd2);
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                System.out.println("ArrayIndexOutOfBounds: " + time + CS + i + CS + kd1 + CS + kd2);
                System.out.println(n);
                System.out.println(nd1);
                System.out.println(nd2);
                return;
            }
            this.processPair(nd1, nd2);
            kd1 = nd1.successor1 - 1;
            kd2 = nd2.successor1 - 1;
        }
        this.iLine.add(n.identity);
        this.iLine.add(time);
        try {
            if (nd1 != null) {
                this.iLine.add(nd1.identity);
            }
            if (nd2 != null) {
                this.iLine.add(nd2.identity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(nd1);
            System.out.println(nd2);
        }
        System.out.println(this.iLine.iBuf.toString());
    }

    private void processPair(Nucleus nd1, Nucleus nd2) {
        int avg = (nd1.size + nd2.size) / 8;
        Loc nd1L = new Loc(nd1, iNucleiMgr);
        Loc nd2L = new Loc(nd2, iNucleiMgr);
        int x = 100 * (nd1L.x - nd2L.x) / avg;
        int y = 100 * (nd1L.y - nd2L.y) / avg;
        int z = 100 * (nd1L.z - nd2L.z) / avg;
        this.iLine.add(x);
        this.iLine.add(y);
        this.iLine.add(z);
    }

    private String getConfigFileInfo(String longName) {
        System.out.println("getConfigFileInfo: " + longName);
        String s = longName.substring(longName.lastIndexOf(47) + 1);
        s = s.substring(0, s.indexOf(46));
        return s;
    }

    public Parameters getParameters() {
        return this.iParameters;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    static {
        NAMING_METHOD = new String[]{"NONE", "STANDARD", "MANUAL", "NEWCANONICAL"};
    }
}

