/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Vector;
import org.rhwlab.snight.DivisionCaller;
import org.rhwlab.snight.Identity;
import org.rhwlab.snight.InitialID;
import org.rhwlab.snight.MeasureCSV;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.Parameters;
import org.rhwlab.utils.EUtils;

public class Identity3 {
    public static Identity iIdentity;
    private static NucleiMgr iNucleiMgr;
    private static Vector nuclei_record;
    int iNamingMethod;
    int iStartingIndex;
    int iNucCount;
    DivisionCaller iDivisionCaller;
    Parameters iParameters;
    String iAxis;
    int iEndingIndex;
    MeasureCSV iMeasureCSV;
    PrintWriter iPrintWriter;
    public static final String[] NAMING_METHOD;
    public static final int STANDARD = 1;
    public static final int MANUAL = 2;
    public static final int NEWCANONICAL = 3;
    private static final String NUC = "Nuc";
    private static final String CS = ", ";
    private static final String C = ",";
    private static final String TAB = "\t";
    private static final DecimalFormat DF0;
    private static final DecimalFormat DF1;
    private static final DecimalFormat DF4;

    public Identity3(NucleiMgr nucleiMgr) {
        iNucleiMgr = nucleiMgr;
        this.iNamingMethod = Identity3.iNucleiMgr.getConfig().iNamingMethod;
        nuclei_record = iNucleiMgr.getNucleiRecord();
        this.iParameters = iNucleiMgr.getParameters();
        this.iEndingIndex = iNucleiMgr.getEndingIndex();
        this.iMeasureCSV = iNucleiMgr.getMeasureCSV();
    }

    public void setPrintWriter(PrintWriter pw) {
        this.iPrintWriter = pw;
    }

    public void identityAssignment() {
        Identity3.println("Identity3.identityAssighment, entered");
        if (this.iNamingMethod == 2) {
            Identity3.println("identityAssignment, skip naming due to MANUAL naming method");
            return;
        }
        this.iStartingIndex = Identity3.iNucleiMgr.getConfig().iStartingIndex;
        this.clearAllNames();
        this.iParameters.axis = 0;
        int[] start = new int[]{this.iStartingIndex};
        int[] lineage_ct_p = new int[]{1};
        int lin_ct = lineage_ct_p[0];
        this.iAxis = this.tryForAxis();
        if (this.iParameters.axis == 1 && this.iNamingMethod == 3) {
            Identity3.println("identityAssignment, using specified axis, " + this.iAxis);
            this.useCanonicalRules(start, lineage_ct_p);
            return;
        }
        if (this.iStartingIndex >= 1) {
            InitialID initID = new InitialID(iNucleiMgr, this.iParameters);
            int mm = initID.initialID(start, lineage_ct_p);
            if (mm > 0) {
                System.out.println("detected backtrace failure, lineage from start");
                start[0] = 0;
                this.iNucCount = 1;
            }
            if (this.iParameters.axis > 0) {
                this.iParameters.ap = this.iParameters.apInit;
                this.iParameters.dv = this.iParameters.dvInit;
                this.iParameters.lr = this.iParameters.lrInit;
                this.iAxis = this.getOrientation();
                lin_ct = lineage_ct_p[0];
                this.iNucCount = initID.getNucCount();
                if (this.iNamingMethod == 3 && start[0] > 0) {
                    this.useCanonicalRules(start, lineage_ct_p);
                    return;
                }
            }
        }
        Identity3.println("identityAssignment, reached code end, " + this.iStartingIndex + CS + start[0]);
        for (int i = start[0]; i < this.iEndingIndex; ++i) {
            Vector nuclei = (Vector)nuclei_record.elementAt(i);
            Vector nuclei_prev = null;
            int nuc_ct = nuclei.size();
            if (i > 0) {
                nuclei_prev = (Vector)nuclei_record.elementAt(i - 1);
            }
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.status == -1) continue;
                if (nuclei_prev != null && nucleij.predecessor != -1) {
                    Nucleus pred = (Nucleus)nuclei_prev.elementAt(nucleij.predecessor - 1);
                    if (pred.successor2 == -1) {
                        nucleij.identity = pred.identity;
                        continue;
                    }
                    Nucleus sister = (Nucleus)nuclei.get(pred.successor2 - 1);
                    nucleij.identity = pred.identity + "a";
                    sister.identity = pred.identity + "p";
                    continue;
                }
                int z = Math.round(nucleij.z);
                nucleij.identity = NUC + EUtils.makePaddedInt(i + 1) + "_" + z + "_" + nucleij.x + "_" + nucleij.y;
            }
        }
    }

    private void clearAllNames() {
        int k = iNucleiMgr.getNucleiRecord().size();
        int endingIndex = this.iEndingIndex;
        for (int i = this.iStartingIndex - 1; i < this.iEndingIndex && i < k; ++i) {
            if (this.iStartingIndex > 1 && i == this.iStartingIndex - 1) continue;
            this.clearNames((Vector)iNucleiMgr.getNucleiRecord().elementAt(i));
        }
    }

    private void clearNames(Vector nuclei) {
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus n = (Nucleus)nuclei.elementAt(i);
            String id = n.identity;
            if (n.assignedID.length() > 0) continue;
            n.identity = "";
        }
    }

    public void useCanonicalRules(int[] start, int[] lineage_ct_p) {
        Vector<String> report = new Vector<String>();
        String series = iNucleiMgr.getConfig().getShortName();
        double zPixRes = iNucleiMgr.getZPixRes();
        this.iDivisionCaller = new DivisionCaller(this.iAxis, zPixRes, this.iMeasureCSV);
        int iEndingIndex = iNucleiMgr.getEndingIndex();
        int k = iNucleiMgr.getNucleiRecord().size();
        int m = Math.min(k, iEndingIndex);
        int nuc_ct = 0;
        Vector nuclei = null;
        int breakout = 0;
        for (int i = start[0]; i < m; ++i) {
            if (breakout > 0) {
                System.out.println("Identity.useCanonicalRules exiting, breakout=" + breakout);
                System.exit(0);
                break;
            }
            nuclei = (Vector)nuclei_record.elementAt(i - 1);
            nuc_ct = nuclei.size();
            Nucleus parent = null;
            Vector nextNuclei = (Vector)nuclei_record.elementAt(i);
            parent = null;
            for (int j = 0; j < nuc_ct; ++j) {
                Nucleus dau2;
                boolean good;
                parent = (Nucleus)nuclei.elementAt(j);
                if (parent.status == -1) continue;
                String pname = parent.identity;
                if (pname == null || pname.length() == 0) {
                    int z = Math.round(parent.z);
                    parent.identity = pname = NUC + EUtils.makePaddedInt(i + 1) + "_" + z + "_" + parent.x + "_" + parent.y;
                }
                if (pname.equals("ABplr") || parent.assignedID.equals("ABplr")) {
                    boolean kkkk = false;
                }
                boolean bl = good = parent.successor1 > 0 && parent.successor2 > 0;
                if (!good) {
                    if (parent.successor1 <= 0) continue;
                    Nucleus n = (Nucleus)nextNuclei.elementAt(parent.successor1 - 1);
                    if (n.assignedID.length() <= 0) {
                        n.identity = pname;
                        continue;
                    }
                    boolean kkk = false;
                    continue;
                }
                Nucleus dau1 = (Nucleus)nextNuclei.elementAt(parent.successor1 - 1);
                StringBuffer sb = this.iDivisionCaller.assignNames(parent, dau1, dau2 = (Nucleus)nextNuclei.elementAt(parent.successor2 - 1));
                if (sb != null) {
                    report.add(sb.toString());
                }
                this.usePreassignedID(dau1, dau2);
            }
        }
        Collections.sort(report);
        for (int ii = 0; ii < report.size(); ++ii) {
        }
    }

    private void usePreassignedID(Nucleus dau1, Nucleus dau2) {
        if (dau1.assignedID.length() == 0 && dau2.assignedID.length() == 0) {
            return;
        }
        if (dau1.assignedID.length() > 0) {
            dau1.identity = dau1.assignedID;
        }
        if (dau2.assignedID.length() > 0) {
            dau2.identity = dau2.assignedID;
        }
        if (dau1.identity.equals(dau2.identity)) {
            String s = dau2.identity;
            s = s.substring(0, s.length() - 1);
            dau2.identity = s = s + "X";
        }
    }

    String tryForAxis() {
        String axis = Identity3.iNucleiMgr.getConfig().iAxisGiven;
        if (axis.length() > 0) {
            this.iParameters.axis = 1;
        }
        return axis;
    }

    public String getOrientation() {
        String orientation = "A";
        String late = "A";
        if (this.iParameters.ap < 0) {
            orientation = "P";
        }
        orientation = this.iParameters.dv > 0 ? orientation + "D" : orientation + "V";
        orientation = this.iParameters.lr > 0 ? orientation + "L" : orientation + "R";
        if (orientation.equals("ADL")) {
            late = "ARD";
        } else if (orientation.equals("AVR")) {
            late = "ALV";
        } else if (orientation.equals("PDR")) {
            late = "PLD";
        } else if (orientation.equals("PVL")) {
            late = "PRV";
        }
        return orientation;
    }

    public String getAxis() {
        return this.iAxis;
    }

    public int getNamingMethod() {
        return this.iNamingMethod;
    }

    public void setNamingMethod(int method) {
        this.iNamingMethod = method;
    }

    public String makeSisterName(String s) {
        String sis = null;
        char x = s.charAt(0);
        int n = s.length();
        boolean b = n == 1;
        switch (x) {
            case 'C': {
                if (b) {
                    return "P3";
                }
            }
            case 'D': {
                if (b) {
                    return "P4";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'E': {
                if (b) {
                    return "MS";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'M': {
                if (n == 2) {
                    return "E";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'A': {
                if (s.equals("ABal")) {
                    return "ABar";
                }
                if (s.equals("ABpl")) {
                    return "ABpr";
                }
                sis = this.replaceLastChar(s);
                break;
            }
            case 'R': {
                if (s.equals("Z2")) {
                    sis = "Z3";
                    break;
                }
                sis = "Z2";
                break;
            }
            case 'P': {
                if (s.equals("P2")) {
                    sis = "EMS";
                    break;
                }
                if (s.equals("P3")) {
                    sis = "C";
                    break;
                }
                if (!s.equals("P4")) break;
                sis = "D";
                break;
            }
            default: {
                sis = this.replaceLastChar(s);
            }
        }
        return sis;
    }

    public String replaceLastChar(String s) {
        StringBuffer sb = new StringBuffer(s);
        int n = sb.length() - 1;
        char x = sb.charAt(n);
        switch (x) {
            case 'a': {
                sb.setCharAt(n, 'p');
                break;
            }
            case 'l': {
                sb.setCharAt(n, 'r');
                break;
            }
            case 'd': {
                sb.setCharAt(n, 'v');
                break;
            }
            case 'p': {
                sb.setCharAt(n, 'a');
                break;
            }
            case 'r': {
                sb.setCharAt(n, 'l');
                break;
            }
            case 'v': {
                sb.setCharAt(n, 'd');
            }
        }
        return sb.toString();
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static String fmt4(double d) {
        return DF4.format(d);
    }

    private static String fmt1(double d) {
        return DF1.format(d);
    }

    private static String fmt0(double d) {
        return DF0.format(d);
    }

    static {
        NAMING_METHOD = new String[]{"NONE", "STANDARD", "MANUAL", "NEWCANONICAL"};
        DF0 = new DecimalFormat("####");
        DF1 = new DecimalFormat("####.#");
        DF4 = new DecimalFormat("####.####");
    }
}

