/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.util.Vector;
import org.rhwlab.snight.DivisionCaller;
import org.rhwlab.snight.MeasureCSV;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.Parameters;

public class InitialID {
    NucleiMgr iNucleiMgr;
    Vector nuclei_record;
    Parameters iParameters;
    int iNucCount;
    int iEndingIndex;
    int iDivisor;
    int iMinCutoff;
    String iAxis;
    MeasureCSV iMeasureCSV;
    double iAng;
    int iXC;
    int iYC;
    int iX;
    int iY;
    private static final String NUC = "Nuc";
    private static final String POLAR = "polar";
    public static final int DIVISOR = 8;
    public static final int MINCUTOFF = 5;
    public static final int XCENTER = 350;
    public static final int YCENTER = 250;
    public static final int EARLY = 50;
    public static final int MID = 450;
    public static final int DEAD = -1;
    public static final int DEADZERO = 0;
    private static final char IGNORESULSTON = 'i';
    private static final char A = 'a';
    private static final char D = 'd';
    private static final char L = 'l';
    private static final char V = 'v';
    private static final char E = 'e';
    private static final char W = 'w';
    private static final char N = 'n';
    private static final char S = 's';
    private static final char B = 'b';
    private static final char T = 't';
    private static final char P = 'p';
    private static final char R = 'r';
    private static final char X = 'X';
    public static final String[] NAMING_METHOD = new String[]{"NONE", "STANDARD", "MANUAL", "NEWCANONICAL"};
    public static final int STANDARD = 1;
    public static final int MANUAL = 2;
    public static final int NEWCANONICAL = 3;
    private static final String CS = ", ";

    public InitialID(NucleiMgr nucMgr, Parameters parameters) {
        this.iNucleiMgr = nucMgr;
        this.nuclei_record = this.iNucleiMgr.getNucleiRecord();
        this.iParameters = parameters;
        this.iNucCount = 1;
        this.iEndingIndex = this.iNucleiMgr.iEndingIndex;
        this.iMeasureCSV = this.iNucleiMgr.getMeasureCSV();
        this.getCoordinateParms();
        InitialID.println("InitialID, measureCSV,");
        InitialID.println("" + this.iMeasureCSV);
    }

    void getCoordinateParms() {
        String sang = (String)this.iMeasureCSV.iMeasureHash.get("ang");
        this.iAng = sang.length() > 0 ? Math.toRadians(-Double.parseDouble(sang)) : Math.toRadians(-Double.parseDouble(MeasureCSV.defaultAtt[7]));
        String x = (String)this.iMeasureCSV.iMeasureHash.get("xc");
        this.iXC = x.length() > 0 ? Integer.parseInt(x) : Integer.parseInt(MeasureCSV.defaultAtt[3]);
        String y = (String)this.iMeasureCSV.iMeasureHash.get("yc");
        this.iYC = y.length() > 0 ? Integer.parseInt(x) : Integer.parseInt(MeasureCSV.defaultAtt[4]);
    }

    void applyTransformation(int[] ia) {
        int x = ia[0] - this.iXC;
        int y = ia[1] - this.iYC;
        double[] da = DivisionCaller.handleRotation(x, y, this.iAng);
        ia[0] = this.iXC + (int)Math.round(da[0]);
        ia[1] = this.iYC + (int)Math.round(da[1]);
    }

    int getNucCount() {
        return this.iNucCount;
    }

    int initialID(int[] start_p, int[] lineage_ct_p) {
        InitialID.println("initialID called: " + start_p[0] + CS + lineage_ct_p[0]);
        int startingIndex = start_p[0];
        int rtn = 0;
        int lin_ct = lineage_ct_p[0];
        int first_four = -1;
        int last_four = -1;
        Vector nuclei = (Vector)this.nuclei_record.elementAt(startingIndex - 1);
        int nuc_ct = nuclei.size();
        int cell_ct = this.countCells(nuclei);
        if (cell_ct <= 6) {
            this.polarBodies();
            cell_ct = this.countCells(nuclei);
        }
        if (cell_ct > 4) {
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.status == -1 || nucleij.identity.indexOf(POLAR) > -1) continue;
                nucleij.identity = NUC + this.iNucCount++;
            }
            this.iParameters.axis = 0;
            start_p[0] = 0;
            lineage_ct_p[0] = lin_ct;
            System.out.println("Starting with more than 4 cells.  No canonical ID assigned.");
            return 0;
        }
        this.iParameters.axis = 1;
        if (cell_ct == 4) {
            first_four = 0;
        }
        for (int i = startingIndex - 1; i < this.iEndingIndex - 1; ++i) {
            nuclei = (Vector)this.nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            cell_ct = this.countCells(nuclei);
            if (cell_ct > 4) break;
            if (cell_ct != 4) continue;
            if (first_four < 0) {
                first_four = i;
            }
            last_four = i;
        }
        if (first_four == -1) {
            nuclei = (Vector)this.nuclei_record.elementAt(0);
            nuc_ct = nuclei.size();
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.status == -1 || nucleij.identity.indexOf(POLAR) > -1) continue;
                ++lin_ct;
                nucleij.identity = NUC + this.iNucCount++;
            }
            this.iParameters.axis = 0;
            start_p[0] = 0;
            lineage_ct_p[0] = lin_ct;
            System.out.println("Movie too short to see four cells");
            return 0;
        }
        int four_cells = (first_four + last_four) / 2;
        start_p[0] = four_cells + 1;
        rtn = this.fourCellID(four_cells, lineage_ct_p);
        if (rtn != 0) {
            rtn = this.backAssignment(four_cells, lineage_ct_p);
        }
        if (rtn == 0) {
            this.iParameters.axis = 0;
            return 1;
        }
        return 0;
    }

    private int countCells(Vector nuclei) {
        int cell_ct = 0;
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus n = (Nucleus)nuclei.elementAt(i);
            if (n.status <= -1 || n.identity.indexOf(POLAR) != -1) continue;
            ++cell_ct;
        }
        return cell_ct;
    }

    private void polarBodies() {
        int i;
        Vector nuclei = (Vector)this.nuclei_record.elementAt(0);
        Vector nuclei_next = null;
        int nuc_ct = nuclei.size();
        int p_ct = 0;
        for (i = 0; i < nuc_ct; ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.status < 0 || nucleii.size >= this.iParameters.polar_size) continue;
            nucleii.identity = POLAR + (p_ct + 1);
            ++p_ct;
        }
        if (p_ct == 0) {
            return;
        }
        block3: for (i = 0; i < this.iEndingIndex; ++i) {
            nuclei = (Vector)this.nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            try {
                nuclei_next = (Vector)this.nuclei_record.elementAt(i + 1);
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                break;
            }
            Nucleus nucleij = null;
            for (int j = 0; j < nuc_ct; ++j) {
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.identity.indexOf(POLAR) == -1) continue;
                if (nucleij.successor1 == -1) {
                    --p_ct;
                }
                if (p_ct == 0) continue block3;
                if (nucleij.successor2 != -1) {
                    System.out.println("Polar body divided: " + i + 1 + ":" + j + 1 + "->" + i + 2 + ":" + nucleij.successor1 + " and " + i + 2 + ":" + nucleij.successor2);
                    continue;
                }
                if (nucleij.successor1 == -1) continue;
                Nucleus suc = (Nucleus)nuclei_next.elementAt(nucleij.successor1 - 1);
                suc.identity = nucleij.identity;
            }
        }
    }

    private int fourCellID(int four_cells, int[] lineage_ct_p) {
        Vector nuclei = null;
        Vector nuclei_next = null;
        Nucleus nucleii = null;
        int lin_ct = lineage_ct_p[0];
        nuclei = (Vector)this.nuclei_record.elementAt(four_cells);
        int nuc_ct = nuclei.size();
        int r = this.alignDiamond(nuclei);
        if (r == 0) {
            return 0;
        }
        r = this.fourCellIDAssignment(four_cells);
        if (r == 0) {
            return 0;
        }
        if (four_cells < this.iEndingIndex) {
            nuclei_next = (Vector)this.nuclei_record.elementAt(four_cells + 1);
        }
        for (int i = 0; i < nuc_ct; ++i) {
            nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.identity.indexOf(POLAR) > -1) continue;
            if (nucleii.predecessor == -1) {
                ++lin_ct;
            }
            if (nucleii.successor2 == -1) continue;
            Nucleus d1 = (Nucleus)nuclei_next.elementAt(nucleii.successor1 - 1);
            Nucleus d2 = (Nucleus)nuclei_next.elementAt(nucleii.successor2 - 1);
            this.sisterID(d1, d2, nuc_ct);
        }
        lineage_ct_p[0] = lin_ct;
        return 1;
    }

    private int alignDiamond(Vector nuclei) {
        int rtn = 1;
        Nucleus north = null;
        Nucleus south = null;
        Nucleus west = null;
        Nucleus east = null;
        int xmin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymin = Integer.MAX_VALUE;
        int ymax = 0;
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.status < 0 || nucleii.identity.indexOf(POLAR) > -1) continue;
            int[] ia = new int[]{nucleii.x, nucleii.y};
            this.applyTransformation(ia);
            if (ia[0] < xmin) {
                xmin = ia[0];
                west = nucleii;
            }
            if (ia[0] > xmax) {
                xmax = ia[0];
                east = nucleii;
            }
            if (ia[1] < ymin) {
                ymin = ia[1];
                north = nucleii;
            }
            if (ia[1] <= ymax) continue;
            ymax = ia[1];
            south = nucleii;
        }
        if (north == null || south == null || west == null || east == null) {
            System.out.println("No diamond four cell stage at time:1 " + this.iParameters.t);
            return 0;
        }
        if (north == south || north == west || north == east || south == west || south == east || west == east) {
            System.out.println("No diamond four cell stage at time:2 " + this.iParameters.t);
            return 0;
        }
        north.id_tag = (char)110;
        south.id_tag = (char)115;
        east.id_tag = (char)101;
        west.id_tag = (char)119;
        return rtn;
    }

    private int alignDiamond(Vector nuclei, boolean old) {
        int rtn = 1;
        Nucleus north = null;
        Nucleus south = null;
        Nucleus west = null;
        Nucleus east = null;
        int xmin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymin = Integer.MAX_VALUE;
        int ymax = 0;
        for (int i = 0; i < nuclei.size(); ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.status < 0 || nucleii.identity.indexOf(POLAR) > -1) continue;
            if (nucleii.x < xmin) {
                xmin = nucleii.x;
                west = nucleii;
            }
            if (nucleii.x > xmax) {
                xmax = nucleii.x;
                east = nucleii;
            }
            if (nucleii.y < ymin) {
                ymin = nucleii.y;
                north = nucleii;
            }
            if (nucleii.y <= ymax) continue;
            ymax = nucleii.y;
            south = nucleii;
        }
        if (north == null || south == null || west == null || east == null) {
            System.out.println("No diamond four cell stage at time:1 " + this.iParameters.t);
            return 0;
        }
        if (north == south || north == west || north == east || south == west || south == east || west == east) {
            System.out.println("No diamond four cell stage at time:2 " + this.iParameters.t);
            return 0;
        }
        north.id_tag = (char)110;
        south.id_tag = (char)115;
        east.id_tag = (char)101;
        west.id_tag = (char)119;
        return rtn;
    }

    private int backAssignment(int four_cells, int[] lineage_ct_p) {
        int j;
        int nuc_ct;
        int i;
        Vector nuclei = null;
        Vector nuclei_next = null;
        Vector nuclei_prev = null;
        Nucleus nucleij = null;
        Object nucleijn = null;
        Nucleus suc1 = null;
        Nucleus suc2 = null;
        Nucleus pred = null;
        int lin_ct = lineage_ct_p[0];
        int successor1 = -1;
        int successor2 = -1;
        int badExit = 0;
        for (i = four_cells - 1; i >= 0; --i) {
            nuclei = (Vector)this.nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            nuclei_next = (Vector)this.nuclei_record.elementAt(i + 1);
            successor1 = -1;
            successor2 = -1;
            for (j = 0; j < nuc_ct; ++j) {
                suc1 = null;
                suc2 = null;
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.identity.indexOf(POLAR) > -1 || nucleij.status == -1) continue;
                successor1 = nucleij.successor1;
                successor2 = nucleij.successor2;
                if (successor1 != -1) {
                    suc1 = (Nucleus)nuclei_next.elementAt(successor1 - 1);
                }
                if (successor2 == -1) {
                    if (suc1 != null) {
                        nucleij.identity = suc1.identity;
                        continue;
                    }
                    nucleij.identity = NUC + this.iNucCount++;
                    continue;
                }
                suc2 = (Nucleus)nuclei_next.elementAt(successor2 - 1);
                String s1 = suc1.identity;
                String s2 = suc2.identity;
                if (s1.equals("P2") || s1.equals("EMS")) {
                    if (s2.equals("P2") || s2.equals("EMS")) {
                        nucleij.identity = "P1";
                        continue;
                    }
                    System.out.println("bad sister names: " + s1 + CS + s2);
                    badExit = 1;
                    break;
                }
                if (s1.equals("ABa") || s1.equals("ABp")) {
                    if (s2.equals("ABa") || s2.equals("ABp")) {
                        nucleij.identity = "AB";
                        continue;
                    }
                    System.out.println("bad sister names: " + s1 + CS + s2);
                    badExit = 1;
                    break;
                }
                if (s1.equals("AB") || s1.equals("P1")) {
                    if (s2.equals("AB") || s2.equals("P1")) {
                        nucleij.identity = "P0";
                        continue;
                    }
                    System.out.println("bad sister names: " + s1 + CS + s2);
                    badExit = 1;
                    break;
                }
                System.out.println("bad sister names: " + s1 + CS + s2);
                badExit = 1;
                break;
            }
            if (badExit <= 0) continue;
            System.out.println("backtrace failure: " + i + CS + j + CS + nuc_ct);
            return 0;
        }
        nuclei = (Vector)this.nuclei_record.elementAt(0);
        nuc_ct = nuclei.size();
        for (j = 0; j < nuc_ct; ++j) {
            nucleij = (Nucleus)nuclei.elementAt(j);
            if (nucleij.identity.indexOf(POLAR) > -1 || nucleij.identity != null) continue;
            nucleij.identity = NUC + this.iNucCount++;
        }
        for (i = 1; i < four_cells; ++i) {
            nuclei = (Vector)this.nuclei_record.elementAt(i);
            nuc_ct = nuclei.size();
            nuclei_next = (Vector)this.nuclei_record.elementAt(i + 1);
            nuclei_prev = (Vector)this.nuclei_record.elementAt(i - 1);
            for (j = 0; j < nuc_ct; ++j) {
                boolean validId;
                nucleij = (Nucleus)nuclei.elementAt(j);
                if (nucleij.identity.indexOf(POLAR) > -1) continue;
                boolean bl = validId = nucleij.identity != null && !nucleij.identity.equals("");
                if (!validId && nucleij.predecessor == -1) {
                    ++lin_ct;
                    nucleij.identity = NUC + this.iNucCount++;
                } else if (nucleij.identity == null) {
                    pred = (Nucleus)nuclei_prev.elementAt(nucleij.predecessor - 1);
                    successor2 = pred.successor2;
                    if (successor2 == -1) {
                        pred.identity = nucleij.identity;
                    } else {
                        this.newBornID(pred, (Nucleus)nuclei.elementAt(pred.successor1 - 1), (Nucleus)nuclei.elementAt(successor2 - 1));
                    }
                }
                if (((Nucleus)nuclei.elementAt((int)j)).successor2 == -1) continue;
                this.sisterID((Nucleus)nuclei_next.elementAt(nucleij.successor1 - 1), (Nucleus)nuclei_next.elementAt(nucleij.successor2 - 1), nuc_ct);
            }
        }
        lineage_ct_p[0] = lin_ct;
        return 1;
    }

    private int fourCellIDAssignment(int four_cells) {
        Nucleus P2 = null;
        Nucleus EMS = null;
        Nucleus ABp = null;
        Nucleus ABa = null;
        Nucleus east = null;
        Nucleus west = null;
        Nucleus south = null;
        Nucleus north = null;
        Vector nuclei = (Vector)this.nuclei_record.elementAt(four_cells);
        int nuc_ct = nuclei.size();
        for (int i = 0; i < nuc_ct; ++i) {
            Nucleus nucleii = (Nucleus)nuclei.elementAt(i);
            if (nucleii.id_tag == 'n') {
                north = nucleii;
                continue;
            }
            if (nucleii.id_tag == 's') {
                south = nucleii;
                continue;
            }
            if (nucleii.id_tag == 'e') {
                east = nucleii;
                continue;
            }
            if (nucleii.id_tag != 'w') continue;
            west = nucleii;
        }
        int ntime = this.timeToDivide(four_cells, north);
        if (ntime < 0) {
            return 0;
        }
        int stime = this.timeToDivide(four_cells, south);
        if (stime < 0) {
            return 0;
        }
        int etime = this.timeToDivide(four_cells, east);
        if (etime < 0) {
            return 0;
        }
        int wtime = this.timeToDivide(four_cells, west);
        if (wtime < 0) {
            return 0;
        }
        if (wtime < etime) {
            ABa = west;
            P2 = east;
            this.iParameters.ap = 1;
        } else if (wtime > etime) {
            ABa = east;
            P2 = west;
            this.iParameters.ap = -1;
            this.iParameters.apInit = -1;
        } else {
            System.out.println("putative ABa and P2 divide simutaneously.");
            return 0;
        }
        if (ntime < stime) {
            ABp = north;
            EMS = south;
            this.iParameters.dv = 1;
            this.iParameters.dvInit = 1;
        } else if (ntime > stime) {
            ABp = south;
            EMS = north;
            this.iParameters.dv = -1;
            this.iParameters.dvInit = -1;
        } else {
            System.out.println("putative ABp and EMS divide simutaneously.");
            return 0;
        }
        this.iParameters.lrInit = this.iParameters.lr = this.iParameters.ap * this.iParameters.dv;
        ABa.identity = "ABa";
        ABp.identity = "ABp";
        EMS.identity = "EMS";
        P2.identity = "P2";
        String o = this.iNucleiMgr.getOrientation();
        System.out.println("axis xyz = " + o + CS + this.iParameters.dvInit + CS + this.iParameters.dv);
        return 1;
    }

    public int newBornID(Nucleus mother, Nucleus dau1, Nucleus dau2) {
        int rtn = 0;
        int tag1 = 88;
        int tag2 = 88;
        if (mother.identity.indexOf(POLAR) > -1) {
            System.out.println("Dividing polar body");
        } else {
            if (mother.identity.equals("ABa")) {
                float diff = (dau1.z - dau2.z) * (float)this.iParameters.lr;
                if (diff < 0.0f) {
                    tag1 = 108;
                    tag2 = 114;
                } else {
                    tag1 = 114;
                    tag2 = 108;
                }
                dau1.identity = mother.identity + (char)tag1;
                dau2.identity = mother.identity + (char)tag2;
                return 0;
            }
            if (mother.identity.equals("ABp")) {
                float diff = (dau1.z - dau2.z) * (float)this.iParameters.lr;
                if (diff < 0.0f) {
                    tag1 = 108;
                    tag2 = 114;
                } else {
                    tag1 = 114;
                    tag2 = 108;
                }
                dau1.identity = mother.identity + (char)tag1;
                dau2.identity = mother.identity + (char)tag2;
                return 0;
            }
            if (mother.identity.equals("EMS")) {
                int k = this.relativePosition(dau1, dau2);
                dau1.id_tag = this.earlyFirstCellTag(k);
                if (dau1.id_tag == 'a') {
                    dau1.identity = "MS";
                    dau2.identity = "E";
                    return 0;
                }
                if (dau1.id_tag == 'p') {
                    dau1.identity = "E";
                    dau2.identity = "MS";
                    return 0;
                }
            } else if (mother.identity.equals("P2")) {
                int difi = (dau1.y - dau2.y) * this.iParameters.dv;
                if (difi < -dau1.size / 2) {
                    tag1 = 100;
                    tag2 = 118;
                } else if (difi > dau1.size / 2) {
                    tag1 = 118;
                    tag2 = 100;
                }
                if (tag1 == 100) {
                    dau1.identity = "C";
                    dau2.identity = "P3";
                    return 0;
                }
                if (tag1 == 118) {
                    dau1.identity = "P3";
                    dau2.identity = "C";
                    return 0;
                }
            } else if (mother.identity.equals("P3")) {
                int difi = (dau1.y - dau2.y) * this.iParameters.dv;
                if (difi < -dau1.size / 2) {
                    tag1 = 100;
                    tag2 = 118;
                } else if (difi > dau1.size / 2) {
                    tag1 = 118;
                    tag2 = 100;
                }
                if (tag1 == 100) {
                    dau1.identity = "D";
                    dau2.identity = "P4";
                    return 0;
                }
                if (tag1 == 118) {
                    dau1.identity = "P4";
                    dau2.identity = "D";
                    return 0;
                }
                System.out.println("P3 NOT RESOLVED IN newBornID");
            } else if (mother.identity.equals("P4")) {
                int k = this.relativePosition(dau1, dau2);
                dau1.id_tag = this.midFirstCellTag(k);
                if (dau1.id_tag == 'a' || dau1.id_tag == 'l') {
                    dau1.identity = "Z3";
                    dau2.identity = "Z2";
                    return 0;
                }
                if (dau1.id_tag == 'p' || dau1.id_tag == 'r') {
                    dau1.identity = "Z2";
                    dau2.identity = "Z3";
                    return 0;
                }
            }
        }
        if (tag1 != 88) {
            dau1.id_tag = (char)tag1;
            dau2.id_tag = (char)tag2;
            dau1.identity = mother.identity + (char)tag1;
            dau2.identity = mother.identity + (char)tag2;
        } else {
            rtn = -1;
        }
        return rtn;
    }

    private int timeToDivide(int current_time, Nucleus nuc) {
        while (current_time < this.iEndingIndex) {
            if (nuc.successor1 == -1) {
                return -1;
            }
            if (nuc.successor2 != -1) break;
            nuc = (Nucleus)((Vector)this.nuclei_record.elementAt(++current_time)).elementAt(nuc.successor1 - 1);
        }
        return current_time;
    }

    private char earlyFirstCellTag(int k) {
        int parameterslr = this.iParameters.lr;
        int parametersdv = this.iParameters.dv;
        int ka = Math.abs(k);
        int m = 1;
        switch (ka) {
            case 1: {
                m = k * this.iParameters.ap;
                if (m < 0) {
                    return 'a';
                }
                return 'p';
            }
            case 2: {
                m = k * parametersdv;
                if (m < 0) {
                    return 'd';
                }
                return 'v';
            }
        }
        m = k * parameterslr;
        if (m < 0) {
            return 'l';
        }
        return 'r';
    }

    private int relativePosition(Nucleus cd1, Nucleus cd2) {
        int cutoff = (cd1.size + cd2.size) / this.iDivisor;
        cutoff = Math.max(cutoff, this.iMinCutoff);
        int xdiff = cd1.x - cd2.x;
        int ydiff = cd1.y - cd2.y;
        int zdiff = (int)((double)(cd1.z - cd2.z) * this.iNucleiMgr.getZPixRes());
        if (Math.abs(xdiff) > cutoff) {
            if (xdiff < 0) {
                return -1;
            }
            return 1;
        }
        if (Math.abs(ydiff) > cutoff) {
            if (ydiff < 0) {
                return -2;
            }
            return 2;
        }
        if (Math.abs(zdiff) > cutoff) {
            if (zdiff < 0) {
                return -3;
            }
            return 3;
        }
        int maxThing = 1;
        int maxValue = xdiff;
        int testValue = ydiff;
        if (Math.abs(testValue) > Math.abs(maxValue)) {
            maxValue = testValue;
            maxThing = 2;
        }
        if (Math.abs(testValue = zdiff) > Math.abs(maxValue)) {
            maxValue = testValue;
            maxThing = 3;
        }
        if (maxValue < 0) {
            return -maxThing;
        }
        return maxThing;
    }

    private char midFirstCellTag(int k) {
        int parameterslr = this.iParameters.lr;
        int parametersdv = this.iParameters.dv;
        int ka = Math.abs(k);
        int m = 1;
        switch (ka) {
            case 1: {
                m = k * this.iParameters.ap;
                if (m < 0) {
                    return 'a';
                }
                return 'p';
            }
            case 2: {
                m = k * parameterslr;
                if (m < 0) {
                    return 'l';
                }
                return 'r';
            }
        }
        m = k * parametersdv;
        if (m < 0) {
            return 'd';
        }
        return 'v';
    }

    private void sisterID(Nucleus nuc1, Nucleus nuc2, int nuc_ct) {
        nuc1.id_tag = (char)97;
        nuc2.id_tag = (char)112;
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

