/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import org.rhwlab.image.ImageWindow;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;

public class Loc {
    public int x;
    public int y;
    public int z;

    public Loc(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Loc(Nucleus n, NucleiMgr nucMgr) {
        int orientation = nucMgr.getParameters().dvInit;
        if (orientation > 0) {
            this.x = n.x;
            this.y = n.y;
            this.z = (int)((double)n.z * nucMgr.getZPixRes());
        } else {
            this.x = n.x;
            this.y = ImageWindow.cImageHeight - n.y;
            int plane_end = nucMgr.getMovie().plane_end;
            this.z = (int)(nucMgr.getZPixRes() * (double)(plane_end - 1) - nucMgr.getZPixRes() * (double)n.z);
        }
    }

    public Loc(Loc copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Loc sub(Loc subtrahend) {
        Loc difference = new Loc(this);
        difference.x -= subtrahend.x;
        difference.y -= subtrahend.y;
        difference.z -= subtrahend.z;
        return difference;
    }

    public Loc add(Loc addend) {
        Loc sum = new Loc(this);
        sum.x += addend.x;
        sum.y += addend.y;
        sum.z += addend.z;
        return sum;
    }

    public Loc div(int k) {
        this.x /= k;
        this.y /= k;
        this.z /= k;
        return this;
    }

    public String toString() {
        String s = this.x + ", " + this.y + ", " + this.z;
        return s;
    }

    public static void main(String[] args) {
        Loc a = new Loc(1, 2, 3);
        System.out.println("a=" + a);
        a = a.add(new Loc(3, 2, 1));
        System.out.println("a=" + a);
        a = a.div(2);
        System.out.println("a=" + a);
        a = a.sub(new Loc(5, 4, 3));
        System.out.println("a=" + a);
        Loc b = new Loc(a);
        System.out.println("b=" + b);
        b = b.div(2);
        System.out.println("b=" + b);
        System.out.println("a=" + a);
    }
}

