/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.rhwlab.help.AceTreeHelp;
import org.rhwlab.snight.ChannelCopy;
import org.rhwlab.snight.NucleiMgr;
import org.rhwlab.snight.Nucleus;
import org.rhwlab.snight.ZipNuclei;
import org.rhwlab.utils.EUtils;

public class NucZipper {
    private static final String CS = ", ";
    private static final String C = ",";

    public NucZipper(File file, NucleiMgr nucleiMgr) {
        File targetFile = file;
        String parent = file.getParent();
        File tempFile = new File(parent + "/temp.zip");
        String nucDir = nucleiMgr.getConfig().iZipNucDir;
        try {
            FileOutputStream fos = new FileOutputStream(tempFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Vector nuclei = nucleiMgr.getNucleiRecord();
            for (int i = 0; i <= nucleiMgr.getiLastNucleiFile(); ++i) {
                String ename = nucDir + "t" + EUtils.makePaddedInt(i + 1) + "-nuclei";
                zos.putNextEntry(new ZipEntry(ename));
                for (int j = 0; j < ((Vector)nuclei.elementAt(i)).size(); ++j) {
                    Nucleus n = (Nucleus)((Vector)nuclei.elementAt(i)).elementAt(j);
                    String s = this.formatNucleus(j, n);
                    byte[] b = s.getBytes();
                    zos.write(b, 0, b.length);
                }
                zos.closeEntry();
            }
            this.addParameters(zos, nucleiMgr);
            zos.close();
            ChannelCopy.transferCopy(tempFile, targetFile);
        }
        catch (IOException ioe) {
            System.out.println("NucZipper exception: " + ioe);
            new AceTreeHelp("/org/rhwlab/help/messages/PermissionError.html", 200, 200);
        }
    }

    private void addParameters(ZipOutputStream zos, NucleiMgr nucleiMgr) throws IOException {
        ZipNuclei zn = nucleiMgr.getZipNuclei();
        String ename = nucleiMgr.getParameterEntry();
        zos.putNextEntry(new ZipEntry(ename));
        Vector parameterFileInfo = nucleiMgr.getParameterFileInfo();
        String s = null;
        if (parameterFileInfo != null) {
            for (int i = 0; i < parameterFileInfo.size(); ++i) {
                s = (String)parameterFileInfo.elementAt(i);
                s = s + "\n";
                byte[] b = s.getBytes();
                zos.write(b, 0, b.length);
            }
        }
        zos.closeEntry();
    }

    private String formatNucleus(int j, Nucleus n) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(j + 1) + CS);
        int status = 0;
        if (n.status > 0) {
            status = 1;
        }
        sb.append(String.valueOf(status) + CS);
        sb.append(String.valueOf(n.predecessor) + CS);
        sb.append(String.valueOf(n.successor1) + CS);
        sb.append(String.valueOf(n.successor2) + CS);
        sb.append(String.valueOf(n.x) + CS);
        sb.append(String.valueOf(n.y) + CS);
        sb.append(String.valueOf(n.z) + CS);
        sb.append(String.valueOf(n.size) + CS);
        sb.append(n.identity + CS);
        sb.append(String.valueOf(n.weight) + CS);
        sb.append(String.valueOf(n.rweight) + CS);
        sb.append(String.valueOf(n.rsum) + CS);
        sb.append(String.valueOf(n.rcount) + CS);
        sb.append(n.assignedID + CS);
        sb.append(String.valueOf(n.rwraw) + CS);
        sb.append(String.valueOf(n.rwcorr1) + CS);
        sb.append(String.valueOf(n.rwcorr2) + CS);
        sb.append(String.valueOf(n.rwcorr3) + CS);
        sb.append(String.valueOf(n.rwcorr4) + CS);
        sb.append("\n");
        return sb.toString();
    }

    public static void main(String[] args) {
    }

    private static void println(String s) {
        System.out.println(s);
    }

    private static void print(String s) {
        System.out.print(s);
    }
}

