/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.snight;

import java.text.DecimalFormat;
import java.util.Comparator;
import org.rhwlab.snight.Config;

public class Nucleus
implements Comparator {
    public String identity;
    public int index;
    public int status;
    public int predecessor;
    public int successor1;
    public int successor2;
    public int x;
    public int y;
    public float z;
    public int size;
    public int weight;
    public int rweight;
    public int rsum;
    public int rcount;
    public String assignedID;
    public String hashKey;
    public char id_tag;
    public int rwraw;
    public int rwcorr1;
    public int rwcorr2;
    public int rwcorr3;
    public int rwcorr4;
    public static final int INDEX = 0;
    public static final int X = 5;
    public static final int Y = 6;
    public static final int Z = 7;
    public static final int IDENTITY = 9;
    public static final int SIZE = 8;
    public static final int WT = 10;
    public static final int STATUS = 1;
    public static final int PRED = 2;
    public static final int SUCC1 = 3;
    public static final int SUCC2 = 4;
    public static final int RWT = 11;
    public static final int RSUM = 12;
    public static final int RCOUNT = 13;
    public static final int ASSIGNEDID = 14;
    public static final int RWRAW = 15;
    public static final int RWCORR1 = 16;
    public static final int RWCORR2 = 17;
    public static final int RWCORR3 = 18;
    public static final int RWCORR4 = 19;
    public static final int OINDEX = 0;
    public static final int OX = 1;
    public static final int OY = 2;
    public static final int OZ = 3;
    public static final int OIDENTITY = 4;
    public static final int OSIZE = 5;
    public static final int OWT = 6;
    public static final int OSTATUS = 7;
    public static final int OSPONG1 = 8;
    public static final int OSPONG2 = 9;
    public static final int OPIECE1 = 10;
    public static final int OPIECE2 = 11;
    public static final int OPRED = 12;
    public static final int OSUCC1 = 13;
    public static final int OSUCC2 = 14;
    private static final String NILL = "nill";
    private static final String SPACE14 = "              ";
    public static final int NILLI = -1;
    private static final String CS = ", ";

    public Nucleus copy() {
        Nucleus nc = new Nucleus();
        this.copyData(nc);
        return nc;
    }

    public void copyData(Nucleus nc) {
        nc.identity = this.identity;
        nc.index = this.index;
        nc.status = this.status;
        nc.x = this.x;
        nc.y = this.y;
        nc.z = this.z;
        nc.size = this.size;
        nc.weight = this.weight;
        nc.rweight = this.rweight;
        nc.rsum = this.rsum;
        nc.rcount = this.rcount;
        nc.predecessor = this.predecessor;
        nc.successor1 = this.successor1;
        nc.successor2 = this.successor2;
        nc.hashKey = this.hashKey;
        nc.id_tag = this.id_tag;
        nc.assignedID = this.assignedID;
        nc.rwraw = this.rwraw;
        nc.rwcorr1 = this.rwcorr1;
        nc.rwcorr2 = this.rwcorr2;
        nc.rwcorr3 = this.rwcorr3;
        nc.rwcorr4 = this.rwcorr4;
    }

    public Nucleus() {
        this.successor2 = -1;
        this.successor1 = -1;
        this.predecessor = -1;
        this.assignedID = "";
    }

    public Nucleus(String[] sa) {
        this();
        this.index = Integer.parseInt(sa[0]);
        this.x = Integer.parseInt(sa[5]);
        this.y = Integer.parseInt(sa[6]);
        this.z = Float.parseFloat(sa[7]);
        this.identity = sa[9];
        this.size = Integer.parseInt(sa[8]);
        this.weight = Integer.parseInt(sa[10]);
        int i = 0;
        try {
            block13: for (i = 11; i < 20; ++i) {
                if (sa.length <= i || sa[i].length() <= 0) continue;
                switch (i) {
                    case 11: {
                        this.rweight = Integer.parseInt(sa[11]);
                        continue block13;
                    }
                    case 12: {
                        this.rsum = Integer.parseInt(sa[12]);
                        continue block13;
                    }
                    case 13: {
                        this.rcount = Integer.parseInt(sa[13]);
                        continue block13;
                    }
                    case 14: {
                        this.assignedID = sa[14];
                        continue block13;
                    }
                    case 15: {
                        this.rwraw = Integer.parseInt(sa[15]);
                        continue block13;
                    }
                    case 16: {
                        this.rwcorr1 = Integer.parseInt(sa[16]);
                        continue block13;
                    }
                    case 17: {
                        this.rwcorr2 = Integer.parseInt(sa[17]);
                        continue block13;
                    }
                    case 18: {
                        this.rwcorr3 = Integer.parseInt(sa[18]);
                        continue block13;
                    }
                    case 19: {
                        this.rwcorr4 = Integer.parseInt(sa[19]);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.status = -1;
        int xstat = Integer.parseInt(sa[1]);
        if (xstat > 0) {
            this.status = xstat;
        }
        this.predecessor = sa[2].equals(NILL) || Integer.parseInt(sa[2]) == -1 ? -1 : Integer.parseInt(sa[2]);
        this.successor1 = sa[3].equals(NILL) ? -1 : Integer.parseInt(sa[3]);
        this.successor2 = sa[4] == null ? -1 : Integer.parseInt(sa[4]);
    }

    public Nucleus(boolean fake) {
        this.index = 1;
        this.x = 2;
        this.y = 2;
        this.z = 15.0f;
        this.assignedID = this.identity = "Px";
        this.size = 2;
        this.weight = 50;
        this.status = 0;
        this.predecessor = 1;
        this.successor1 = 1;
        this.successor2 = -1;
    }

    public Nucleus(String[] sa, boolean oldFormat) {
        this.successor2 = -1;
        this.successor1 = -1;
        this.predecessor = -1;
        this.index = Integer.parseInt(sa[0]);
        this.x = Integer.parseInt(sa[1]);
        this.y = Integer.parseInt(sa[2]);
        this.z = Float.parseFloat(sa[3]);
        this.identity = sa[4];
        this.size = Integer.parseInt(sa[5]);
        this.weight = Integer.parseInt(sa[6]);
        this.status = -1;
        int xstat = Integer.parseInt(sa[7]);
        if (xstat >= 0) {
            this.status = xstat;
        }
        this.predecessor = sa[12].equals(NILL) || Integer.parseInt(sa[12]) == -1 ? -1 : Integer.parseInt(sa[12]);
        this.successor1 = sa[13].equals(NILL) ? -1 : Integer.parseInt(sa[13]);
        this.successor2 = sa[14] == null ? -1 : Integer.parseInt(sa[14]);
    }

    public void setHashKey(String key) {
        this.hashKey = key;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public int getCorrectedRed(String type) {
        int choice = this.getRedChoiceNumber(type);
        return this.computeRed(choice);
    }

    private int getRedChoiceNumber(String type) {
        int i = 0;
        for (i = 0; i < Config.REDCHOICE.length && !type.equals(Config.REDCHOICE[i]); ++i) {
        }
        return i;
    }

    private int computeRed(int k) {
        int red = this.rwraw;
        switch (k) {
            case 1: {
                red -= this.rwcorr1;
                break;
            }
            case 2: {
                red -= this.rwcorr2;
                break;
            }
            case 3: {
                red -= this.rwcorr3;
                break;
            }
            case 4: {
                red -= this.rwcorr4;
            }
        }
        return red;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.index) + CS);
        sb.append(String.valueOf(this.status) + CS);
        sb.append(String.valueOf(this.predecessor) + CS);
        sb.append(String.valueOf(this.successor1) + CS);
        sb.append(String.valueOf(this.successor2) + CS);
        sb.append(String.valueOf(this.x) + CS);
        sb.append(String.valueOf(this.y) + CS);
        sb.append(String.valueOf(this.z) + CS);
        sb.append(String.valueOf(this.size) + CS);
        sb.append(this.identity + CS);
        sb.append(this.assignedID + CS);
        sb.append(String.valueOf(this.weight) + CS);
        sb.append(String.valueOf(this.rweight) + CS);
        sb.append(String.valueOf(this.rwraw) + CS);
        sb.append(String.valueOf(this.rwcorr1) + CS);
        sb.append(String.valueOf(this.rwcorr2) + CS);
        sb.append(String.valueOf(this.rwcorr3) + CS);
        sb.append(String.valueOf(this.rwcorr4) + CS);
        return sb.toString();
    }

    public String toString(int x) {
        String s = "";
        s = new DecimalFormat("000   ").format(this.index);
        s = s + new DecimalFormat("000  ").format(x);
        s = s + new DecimalFormat("000  ").format(this.y);
        s = s + new DecimalFormat("00.0  ").format(this.z);
        s = s + (this.identity + SPACE14).substring(0, 14);
        s = s + new DecimalFormat("00  ").format(this.size);
        s = s + new DecimalFormat("000000  ").format(this.weight);
        s = s + new DecimalFormat("00  ").format(this.status);
        s = this.predecessor == -1 ? s + "nill  " : s + new DecimalFormat(" 000 ").format(this.predecessor);
        s = this.successor1 == -1 ? s + "nill  " : s + new DecimalFormat("000  ").format(this.successor1);
        s = this.successor2 == -1 ? s + "" : s + new DecimalFormat("000  ").format(this.successor2);
        return s;
    }

    public int compare(Object n1, Object n2) {
        String s1 = ((Nucleus)n1).identity;
        String s2 = ((Nucleus)n2).identity;
        return s1.compareTo(s2);
    }

    public static void main(String[] args) {
    }
}

